/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.CalleeSavedRegisters;
import com.oracle.svm.core.ReservedRegisters;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoEncoder;
import com.oracle.svm.core.code.CodeInfoQueryResult;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoDecoder;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.code.FrameInfoVerifier;
import com.oracle.svm.core.code.ReusableTypeReader;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.meta.SharedField;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.meta.SharedType;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.util.ByteArrayReader;
import com.oracle.svm.core.util.HostedStringDeduplication;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.code.DebugInfo;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.StackLockValue;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.code.VirtualObject;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaValue;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Value;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.util.FrequencyEncoder;
import org.graalvm.compiler.core.common.util.TypeConversion;
import org.graalvm.compiler.core.common.util.TypeReader;
import org.graalvm.compiler.core.common.util.UnsafeArrayTypeWriter;
import org.graalvm.nativeimage.ImageSingletons;

public class FrameInfoEncoder {
    private static final int UNCOMPRESSED_FRAME_SLICE_INDEX = -1;
    private final Customization customization;
    private final List<FrameData> allDebugInfos;
    private final CodeInfoEncoder.Encoders encoders;
    private final CompressedFrameInfoEncodingMetadata frameMetadata;
    private static final FrameInfoQueryResult.ValueInfo[] MARKER = new FrameInfoQueryResult.ValueInfo[0];

    protected FrameInfoEncoder(Customization customization, CodeInfoEncoder.Encoders encoders) {
        this.customization = customization;
        this.encoders = encoders;
        this.allDebugInfos = new ArrayList<FrameData>();
        this.frameMetadata = new CompressedFrameInfoEncodingMetadata();
    }

    protected FrameData addDebugInfo(ResolvedJavaMethod method, Infopoint infopoint, int totalFrameSize) {
        boolean useCompressedEncoding;
        boolean includeLocalValues = this.customization.includeLocalValues(method, infopoint);
        boolean encodeSourceReferences = FrameInfoDecoder.encodeSourceReferences();
        boolean bl = useCompressedEncoding = SubstrateOptions.UseCompressedFrameEncodings.getValue() != false && !includeLocalValues;
        if (!includeLocalValues && !encodeSourceReferences) {
            return null;
        }
        DebugInfo debugInfo = infopoint.debugInfo;
        FrameData data = new FrameData();
        data.debugInfo = debugInfo;
        data.totalFrameSize = totalFrameSize;
        data.virtualObjects = new FrameInfoQueryResult.ValueInfo[FrameInfoEncoder.countVirtualObjects(debugInfo)][];
        data.frame = this.addFrame(data, debugInfo.frame(), this.customization.isDeoptEntry(method, infopoint), includeLocalValues);
        if (encodeSourceReferences) {
            ArrayList<CompressedFrameData> frameSlice = useCompressedEncoding ? new ArrayList<CompressedFrameData>() : null;
            BytecodeFrame bytecodeFrame = data.debugInfo.frame();
            FrameInfoQueryResult resultFrame = data.frame;
            while (resultFrame != null) {
                assert (bytecodeFrame != null);
                this.customization.fillSourceFields(bytecodeFrame, resultFrame);
                Class<?> sourceClass = resultFrame.sourceClass;
                String sourceMethodName = resultFrame.sourceMethodName;
                this.encoders.sourceClasses.addObject(sourceClass);
                this.encoders.sourceMethodNames.addObject((Object)sourceMethodName);
                if (useCompressedEncoding) {
                    assert (!resultFrame.hasLocalValueInfo());
                    boolean isSliceEnd = resultFrame.caller == null;
                    int sourceLineNumber = resultFrame.sourceLineNumber;
                    CompressedFrameData frame = new CompressedFrameData(sourceClass, sourceMethodName, sourceLineNumber, isSliceEnd);
                    frameSlice.add(frame);
                }
                bytecodeFrame = bytecodeFrame.caller();
                resultFrame = resultFrame.caller;
            }
            if (useCompressedEncoding) {
                this.frameMetadata.addFrameSlice(data, frameSlice);
            }
        }
        this.allDebugInfos.add(data);
        return data;
    }

    private static int countVirtualObjects(DebugInfo debugInfo) {
        BitSet visitedVirtualObjects = new BitSet();
        for (BytecodeFrame frame = debugInfo.frame(); frame != null; frame = frame.caller()) {
            FrameInfoEncoder.countVirtualObjects(frame.values, visitedVirtualObjects);
        }
        return visitedVirtualObjects.length();
    }

    private static void countVirtualObjects(JavaValue[] values, BitSet visitedVirtualObjects) {
        for (JavaValue value : values) {
            VirtualObject virtualObject;
            if (!(value instanceof VirtualObject) || visitedVirtualObjects.get((virtualObject = (VirtualObject)value).getId())) continue;
            visitedVirtualObjects.set(virtualObject.getId());
            FrameInfoEncoder.countVirtualObjects(virtualObject.getValues(), visitedVirtualObjects);
        }
    }

    private FrameInfoQueryResult addFrame(FrameData data, BytecodeFrame frame, boolean isDeoptEntry, boolean needLocalValues) {
        FrameInfoQueryResult result = new FrameInfoQueryResult();
        if (frame.caller() != null) {
            assert (!isDeoptEntry) : "Deoptimization entry point information for caller frames is not encoded";
            result.caller = this.addFrame(data, frame.caller(), false, needLocalValues);
        }
        result.virtualObjects = data.virtualObjects;
        result.encodedBci = FrameInfoEncoder.encodeBci(frame.getBCI(), frame.duringCall, frame.rethrowException);
        result.isDeoptEntry = isDeoptEntry;
        FrameInfoQueryResult.ValueInfo[] valueInfos = null;
        if (needLocalValues) {
            SharedMethod method = (SharedMethod)frame.getMethod();
            if (this.customization.storeDeoptTargetMethod()) {
                result.deoptMethod = method;
                this.encoders.objectConstants.addObject((Object)SubstrateObjectConstant.forObject(method));
            }
            result.deoptMethodOffset = method.getDeoptOffsetInImage();
            result.numLocals = frame.numLocals;
            result.numStack = frame.numStack;
            result.numLocks = frame.numLocks;
            JavaValue[] values = frame.values;
            int numValues = 0;
            int i = values.length;
            while (--i >= 0) {
                if (ValueUtil.isIllegalJavaValue((JavaValue)values[i])) continue;
                numValues = i + 1;
                break;
            }
            valueInfos = new FrameInfoQueryResult.ValueInfo[numValues];
            for (i = 0; i < numValues; ++i) {
                valueInfos[i] = this.makeValueInfo(data, FrameInfoEncoder.getFrameValueKind(frame, i), values[i], isDeoptEntry);
            }
        }
        result.valueInfos = valueInfos;
        ((CodeInfoEncoder.Counters)ImageSingletons.lookup(CodeInfoEncoder.Counters.class)).frameCount.inc();
        return result;
    }

    public static JavaKind getFrameValueKind(BytecodeFrame frame, int valueIndex) {
        if (valueIndex < frame.numLocals) {
            return frame.getLocalValueKind(valueIndex);
        }
        if (valueIndex - frame.numLocals < frame.numStack) {
            return frame.getStackValueKind(valueIndex - frame.numLocals);
        }
        assert (valueIndex - frame.numLocals - frame.numStack < frame.numLocks);
        return JavaKind.Object;
    }

    private FrameInfoQueryResult.ValueInfo makeValueInfo(FrameData data, JavaKind kind, JavaValue v, boolean isDeoptEntry) {
        RegisterValue register;
        JavaValue value = v;
        FrameInfoQueryResult.ValueInfo result = new FrameInfoQueryResult.ValueInfo();
        result.kind = kind;
        if (value instanceof StackLockValue) {
            StackLockValue lock = (StackLockValue)value;
            assert (ValueUtil.isIllegal((Value)lock.getSlot()));
            if (isDeoptEntry && lock.isEliminated()) {
                throw VMError.shouldNotReachHere("Cannot have an eliminated monitor in a deoptimization entry point: value " + value + " in method " + data.debugInfo.getBytecodePosition().getMethod().format("%H.%n(%p)"));
            }
            result.isEliminatedMonitor = lock.isEliminated();
            value = lock.getOwner();
        }
        if (ValueUtil.isIllegalJavaValue((JavaValue)value)) {
            result.type = FrameInfoQueryResult.ValueType.Illegal;
            assert (result.kind == JavaKind.Illegal);
        } else if (value instanceof StackSlot) {
            StackSlot stackSlot = (StackSlot)value;
            result.type = FrameInfoQueryResult.ValueType.StackSlot;
            result.data = stackSlot.getOffset(data.totalFrameSize);
            result.isCompressedReference = FrameInfoEncoder.isCompressedReference((AllocatableValue)stackSlot);
            ((CodeInfoEncoder.Counters)ImageSingletons.lookup(CodeInfoEncoder.Counters.class)).stackValueCount.inc();
        } else if (ReservedRegisters.singleton().isAllowedInFrameState(value)) {
            register = (RegisterValue)value;
            result.type = FrameInfoQueryResult.ValueType.ReservedRegister;
            result.data = ValueUtil.asRegister((Value)register).number;
            result.isCompressedReference = FrameInfoEncoder.isCompressedReference((AllocatableValue)register);
            ((CodeInfoEncoder.Counters)ImageSingletons.lookup(CodeInfoEncoder.Counters.class)).registerValueCount.inc();
        } else if (CalleeSavedRegisters.supportedByPlatform() && value instanceof RegisterValue) {
            if (isDeoptEntry) {
                throw VMError.shouldNotReachHere("Cannot encode registers in deoptimization entry point: value " + value + " in method " + data.debugInfo.getBytecodePosition().getMethod().format("%H.%n(%p)"));
            }
            register = (RegisterValue)value;
            result.type = FrameInfoQueryResult.ValueType.Register;
            result.data = CalleeSavedRegisters.singleton().getOffsetInFrame(ValueUtil.asRegister((Value)register));
            result.isCompressedReference = FrameInfoEncoder.isCompressedReference((AllocatableValue)register);
            ((CodeInfoEncoder.Counters)ImageSingletons.lookup(CodeInfoEncoder.Counters.class)).registerValueCount.inc();
        } else if (value instanceof JavaConstant) {
            JavaConstant constant;
            result.value = constant = (JavaConstant)value;
            if (constant.isDefaultForKind()) {
                result.type = FrameInfoQueryResult.ValueType.DefaultConstant;
            } else {
                result.type = FrameInfoQueryResult.ValueType.Constant;
                if (constant.getJavaKind() == JavaKind.Object) {
                    this.encoders.objectConstants.addObject((Object)constant);
                }
            }
            ((CodeInfoEncoder.Counters)ImageSingletons.lookup(CodeInfoEncoder.Counters.class)).constantValueCount.inc();
        } else if (ValueUtil.isVirtualObject((JavaValue)value)) {
            VirtualObject virtualObject = (VirtualObject)value;
            result.type = FrameInfoQueryResult.ValueType.VirtualObject;
            result.data = virtualObject.getId();
            this.makeVirtualObject(data, virtualObject, isDeoptEntry);
        } else {
            throw VMError.shouldNotReachHere();
        }
        return result;
    }

    private static boolean isCompressedReference(AllocatableValue value) {
        assert (value.getPlatformKind().getVectorLength() == 1) : "Only scalar types supported";
        return ((LIRKind)value.getValueKind(LIRKind.class)).isCompressedReference(0);
    }

    private void makeVirtualObject(FrameData data, VirtualObject virtualObject, boolean isDeoptEntry) {
        int id = virtualObject.getId();
        if (data.virtualObjects[id] != null) {
            return;
        }
        data.virtualObjects[id] = MARKER;
        ArrayList<FrameInfoQueryResult.ValueInfo> valueList = new ArrayList<FrameInfoQueryResult.ValueInfo>(virtualObject.getValues().length + 4);
        SharedType type = (SharedType)virtualObject.getType();
        valueList.add(this.makeValueInfo(data, JavaKind.Object, (JavaValue)SubstrateObjectConstant.forObject(type.getHub()), isDeoptEntry));
        ObjectLayout objectLayout = ConfigurationValues.getObjectLayout();
        assert (type.isArray() == LayoutEncoding.isArray(type.getHub().getLayoutEncoding())) : "deoptimization code uses layout encoding to determine if type is an array";
        if (type.isArray()) {
            valueList.add(null);
            int length = 0;
            JavaKind kind = ((SharedType)type.getComponentType()).getStorageKind();
            for (int i = 0; i < virtualObject.getValues().length; ++i) {
                JavaValue value = virtualObject.getValues()[i];
                JavaKind valueKind = virtualObject.getSlotKind(i);
                if (objectLayout.sizeInBytes(kind) == 4 && objectLayout.sizeInBytes(valueKind) == 8) {
                    valueList.add(this.makeValueInfo(data, valueKind, value, isDeoptEntry));
                    length += 2;
                    continue;
                }
                if (kind == JavaKind.Byte) {
                    int byteCount = FrameInfoEncoder.restoreByteArrayEntryByteCount(virtualObject, i);
                    valueKind = FrameInfoEncoder.restoreByteArrayEntryValueKind(valueKind, byteCount);
                    valueList.add(this.makeValueInfo(data, valueKind, value, isDeoptEntry));
                    length += byteCount;
                    i += byteCount - 1;
                    continue;
                }
                assert (objectLayout.sizeInBytes(valueKind.getStackKind()) <= objectLayout.sizeInBytes(kind.getStackKind()));
                valueList.add(this.makeValueInfo(data, kind, value, isDeoptEntry));
                ++length;
                assert (objectLayout.getArrayElementOffset(kind, length) == (long)(objectLayout.getArrayBaseOffset(kind) + FrameInfoEncoder.computeOffset(valueList, 2)));
            }
            assert (valueList.get(1) == null);
            valueList.set(1, this.makeValueInfo(data, JavaKind.Int, (JavaValue)JavaConstant.forInt((int)length), isDeoptEntry));
        } else {
            SharedField[] fields = (SharedField[])type.getInstanceFields(true);
            long curOffset = objectLayout.getFirstFieldOffset();
            int fieldIdx = 0;
            int valueIdx = 0;
            while (valueIdx < virtualObject.getValues().length) {
                SharedField field = fields[fieldIdx];
                ++fieldIdx;
                JavaValue value = virtualObject.getValues()[valueIdx];
                JavaKind valueKind = virtualObject.getSlotKind(valueIdx);
                ++valueIdx;
                JavaKind kind = field.getStorageKind();
                if (objectLayout.sizeInBytes(kind) == 4 && objectLayout.sizeInBytes(valueKind) == 8) {
                    kind = valueKind;
                    assert (fields[fieldIdx].getJavaKind() == field.getJavaKind());
                    ++fieldIdx;
                }
                if (field.getLocation() < 0) continue;
                assert (curOffset <= (long)field.getLocation());
                while (curOffset + 7L < (long)field.getLocation()) {
                    valueList.add(this.makeValueInfo(data, JavaKind.Long, (JavaValue)JavaConstant.LONG_0, isDeoptEntry));
                    curOffset += 8L;
                }
                if (curOffset + 3L < (long)field.getLocation()) {
                    valueList.add(this.makeValueInfo(data, JavaKind.Int, (JavaValue)JavaConstant.INT_0, isDeoptEntry));
                    curOffset += 4L;
                }
                if (curOffset + 1L < (long)field.getLocation()) {
                    valueList.add(this.makeValueInfo(data, JavaKind.Short, (JavaValue)JavaConstant.forShort((short)0), isDeoptEntry));
                    curOffset += 2L;
                }
                if (curOffset < (long)field.getLocation()) {
                    valueList.add(this.makeValueInfo(data, JavaKind.Byte, (JavaValue)JavaConstant.forByte((byte)0), isDeoptEntry));
                    ++curOffset;
                }
                assert (curOffset == (long)field.getLocation());
                assert (curOffset - (long)objectLayout.getFirstFieldOffset() == (long)FrameInfoEncoder.computeOffset(valueList, 1));
                valueList.add(this.makeValueInfo(data, kind, value, isDeoptEntry));
                curOffset += (long)objectLayout.sizeInBytes(kind);
            }
        }
        data.virtualObjects[id] = valueList.toArray(new FrameInfoQueryResult.ValueInfo[valueList.size()]);
        ((CodeInfoEncoder.Counters)ImageSingletons.lookup(CodeInfoEncoder.Counters.class)).virtualObjectsCount.inc();
    }

    private static int restoreByteArrayEntryByteCount(VirtualObject vObject, int curIdx) {
        int pos;
        for (pos = curIdx + 1; pos < vObject.getValues().length && vObject.getSlotKind(pos) == JavaKind.Illegal; ++pos) {
        }
        return pos - curIdx;
    }

    private static JavaKind restoreByteArrayEntryValueKind(JavaKind kind, int byteCount) {
        switch (byteCount) {
            case 1: {
                return JavaKind.Byte;
            }
            case 2: {
                return JavaKind.Short;
            }
            case 4: {
                if (kind.isNumericFloat()) {
                    return JavaKind.Float;
                }
                return JavaKind.Int;
            }
            case 8: {
                if (kind.isNumericFloat()) {
                    return JavaKind.Double;
                }
                return JavaKind.Long;
            }
        }
        throw VMError.shouldNotReachHere();
    }

    private static int computeOffset(ArrayList<FrameInfoQueryResult.ValueInfo> valueInfos, int startIndex) {
        int result = 0;
        for (int i = startIndex; i < valueInfos.size(); ++i) {
            result += ConfigurationValues.getObjectLayout().sizeInBytes(valueInfos.get((int)i).kind);
        }
        return result;
    }

    protected void encodeAllAndInstall(CodeInfo target) {
        NonmovableArray<Byte> frameInfoEncodings = this.encodeFrameDatas();
        FrameInfoEncoder.install(target, frameInfoEncodings);
    }

    @Uninterruptible(reason="Nonmovable object arrays are not visible to GC until installed in target.")
    private static void install(CodeInfo target, NonmovableArray<Byte> frameInfoEncodings) {
        CodeInfoAccess.setFrameInfo(target, frameInfoEncodings);
        FrameInfoEncoder.afterInstallation(target);
    }

    @Uninterruptible(reason="Safe for GC, but called from uninterruptible code.", calleeMustBe=false)
    private static void afterInstallation(CodeInfo info) {
        ((CodeInfoEncoder.Counters)ImageSingletons.lookup(CodeInfoEncoder.Counters.class)).frameInfoSize.add(ConfigurationValues.getObjectLayout().getArrayElementOffset(JavaKind.Byte, NonmovableArrays.lengthOf(CodeInfoAccess.getFrameInfoEncodings(info))) + ConfigurationValues.getObjectLayout().getArrayElementOffset(JavaKind.Object, NonmovableArrays.lengthOf(CodeInfoAccess.getFrameInfoObjectConstants(info))));
    }

    private NonmovableArray<Byte> encodeFrameDatas() {
        UnsafeArrayTypeWriter encodingBuffer = UnsafeArrayTypeWriter.create((boolean)ByteArrayReader.supportsUnalignedMemoryAccess());
        this.frameMetadata.encodeCompressedData(encodingBuffer, this.encoders);
        for (FrameData data : this.allDebugInfos) {
            if (data.frameSliceIndex == -1) {
                data.encodedFrameInfoIndex = encodingBuffer.getBytesWritten();
                this.encodeUncompressedFrameData(data, encodingBuffer);
                continue;
            }
            data.encodedFrameInfoIndex = this.frameMetadata.getEncodingOffset(data.frameSliceIndex);
            assert (this.frameMetadata.writeFrameVerificationInfo(data, this.encoders));
        }
        NonmovableArray<Byte> frameInfoEncodings = NonmovableArrays.createByteArray(TypeConversion.asS4((long)encodingBuffer.getBytesWritten()));
        encodingBuffer.toByteBuffer(NonmovableArrays.asByteBuffer(frameInfoEncodings));
        return frameInfoEncodings;
    }

    private void encodeUncompressedFrameData(FrameData data, UnsafeArrayTypeWriter encodingBuffer) {
        encodingBuffer.putSV(-1L);
        FrameInfoQueryResult cur = data.frame;
        while (cur != null) {
            assert (cur.encodedBci != -1L) : "used as the end marker during decoding";
            boolean needLocalValues = cur.hasLocalValueInfo();
            if (!needLocalValues) {
                cur.encodedBci = -2L;
            }
            encodingBuffer.putSV(cur.encodedBci);
            assert (cur == data.frame || !cur.isDeoptEntry) : "Deoptimization entry information for caller frames is not persisted";
            if (needLocalValues) {
                int deoptMethodIndex;
                encodingBuffer.putUV((long)cur.numLocks);
                encodingBuffer.putUV((long)cur.numLocals);
                encodingBuffer.putUV((long)cur.numStack);
                if (cur.deoptMethod != null) {
                    deoptMethodIndex = -1 - this.encoders.objectConstants.getIndex((Object)SubstrateObjectConstant.forObject(cur.deoptMethod));
                    assert (deoptMethodIndex < 0);
                    assert (cur.deoptMethodOffset == cur.deoptMethod.getDeoptOffsetInImage());
                } else {
                    deoptMethodIndex = cur.deoptMethodOffset;
                    assert (deoptMethodIndex >= 0);
                }
                encodingBuffer.putSV((long)deoptMethodIndex);
                this.encodeValues(cur.valueInfos, encodingBuffer);
                if (cur == data.frame) {
                    encodingBuffer.putUV((long)cur.virtualObjects.length);
                    for (FrameInfoQueryResult.ValueInfo[] virtualObject : cur.virtualObjects) {
                        this.encodeValues(virtualObject, encodingBuffer);
                    }
                }
            }
            if (FrameInfoDecoder.encodeSourceReferences()) {
                int classIndex = this.encoders.sourceClasses.getIndex(cur.sourceClass);
                int methodIndex = this.encoders.sourceMethodNames.getIndex((Object)cur.sourceMethodName);
                cur.sourceClassIndex = classIndex;
                cur.sourceMethodNameIndex = methodIndex;
                encodingBuffer.putSV((long)classIndex);
                encodingBuffer.putSV((long)methodIndex);
                encodingBuffer.putSV((long)cur.sourceLineNumber);
            }
            cur = cur.caller;
        }
        encodingBuffer.putSV(-1L);
    }

    private void encodeValues(FrameInfoQueryResult.ValueInfo[] valueInfos, UnsafeArrayTypeWriter encodingBuffer) {
        encodingBuffer.putUV((long)valueInfos.length);
        for (FrameInfoQueryResult.ValueInfo valueInfo : valueInfos) {
            if (valueInfo.type == FrameInfoQueryResult.ValueType.Constant) {
                valueInfo.data = valueInfo.kind == JavaKind.Object ? (long)this.encoders.objectConstants.getIndex((Object)valueInfo.value) : FrameInfoEncoder.encodePrimitiveConstant(valueInfo.value);
            }
            encodingBuffer.putU1((long)FrameInfoEncoder.encodeFlags(valueInfo.type, valueInfo.kind, valueInfo.isCompressedReference, valueInfo.isEliminatedMonitor));
            if (!valueInfo.type.hasData) continue;
            encodingBuffer.putSV(valueInfo.data);
        }
    }

    protected static long encodePrimitiveConstant(JavaConstant constant) {
        switch (constant.getJavaKind()) {
            case Float: {
                return Float.floatToRawIntBits(constant.asFloat());
            }
            case Double: {
                return Double.doubleToRawLongBits(constant.asDouble());
            }
        }
        return constant.asLong();
    }

    private static int encodeFlags(FrameInfoQueryResult.ValueType type, JavaKind kind, boolean isCompressedReference, boolean isEliminatedMonitor) {
        int kindIndex;
        int n = kindIndex = isEliminatedMonitor ? 15 : kind.ordinal();
        assert (FrameInfoDecoder.KIND_VALUES[kindIndex] == kind);
        return type.ordinal() << 0 | kindIndex << 3 | (isCompressedReference ? 1 : 0) << 7;
    }

    public static long encodeBci(int bci, boolean duringCall, boolean rethrowException) {
        return (long)bci << 2 | (long)(duringCall ? 2 : 0) | (long)(rethrowException ? 1 : 0);
    }

    private static int encodeCompressedFirstEntry(int value, boolean isClassIndex) {
        VMError.guarantee(value >= 0);
        int encodedValue = isClassIndex ? value : -(value + 2);
        VMError.guarantee(encodedValue != -1);
        return encodedValue;
    }

    private static int encodeCompressedMethodIndex(int methodIndex, boolean hasUniqueSharedFrameSuccessor) {
        VMError.guarantee(methodIndex >= 0);
        if (!hasUniqueSharedFrameSuccessor) {
            return methodIndex;
        }
        return -(methodIndex + 1);
    }

    private static int encodeCompressedSourceLineNumber(int sourceLineNumber, boolean isSliceEnd) {
        int lineNumberWithAddend = sourceLineNumber + 2;
        VMError.guarantee(lineNumberWithAddend > 0);
        return isSliceEnd ? -lineNumberWithAddend : lineNumberWithAddend;
    }

    void verifyEncoding(CodeInfo info) {
        for (FrameData expectedData : this.allDebugInfos) {
            FrameInfoQueryResult actualFrame = FrameInfoDecoder.decodeFrameInfo(expectedData.frame.isDeoptEntry, (TypeReader)new ReusableTypeReader(CodeInfoAccess.getFrameInfoEncodings(info), expectedData.encodedFrameInfoIndex), info, FrameInfoDecoder.HeapBasedFrameInfoQueryResultAllocator, FrameInfoDecoder.HeapBasedValueInfoAllocator);
            FrameInfoVerifier.verifyFrames(expectedData, expectedData.frame, actualFrame);
        }
    }

    private static class CompressedFrameInfoEncodingMetadata {
        final List<CompressedFrameData> framesToEncode = new ArrayList<CompressedFrameData>();
        final EconomicMap<CompressedFrameData, Integer> framesToEncodeIndexMap = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
        final List<List<CompressedFrameData>> frameSlices = new ArrayList<List<CompressedFrameData>>();
        final EconomicMap<List<CompressedFrameData>, Integer> frameSliceIndexMap = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
        final FrequencyEncoder<Integer> sliceFrequency = FrequencyEncoder.createEqualityEncoder();
        final Map<CompressedFrameData, Integer> frameSliceFrequency = new HashMap<CompressedFrameData, Integer>();
        final Map<CompressedFrameData, Set<CompressedFrameData>> frameSuccessorMap = new HashMap<CompressedFrameData, Set<CompressedFrameData>>();
        final Map<CompressedFrameData, Integer> frameMaxHeight = new HashMap<CompressedFrameData, Integer>();
        boolean sealed = false;
        EconomicMap<Integer, Long> encodedSliceIndexMap = EconomicMap.create((Equivalence)Equivalence.DEFAULT);

        private CompressedFrameInfoEncodingMetadata() {
        }

        void addFrameSlice(FrameData data, List<CompressedFrameData> slice) {
            assert (!this.sealed);
            ArrayList<CompressedFrameData> frameSliceToEncode = new ArrayList<CompressedFrameData>();
            for (CompressedFrameData curFrame : slice) {
                if (!this.framesToEncodeIndexMap.containsKey((Object)curFrame)) {
                    int frameIndex = this.framesToEncode.size();
                    this.framesToEncode.add(curFrame);
                    this.framesToEncodeIndexMap.put((Object)curFrame, (Object)frameIndex);
                }
                CompressedFrameData frame = this.framesToEncode.get((Integer)this.framesToEncodeIndexMap.get((Object)curFrame));
                frameSliceToEncode.add(frame);
            }
            if (!this.frameSliceIndexMap.containsKey(frameSliceToEncode)) {
                int frameSliceIndex = this.frameSlices.size();
                this.frameSlices.add(frameSliceToEncode);
                this.frameSliceIndexMap.put(frameSliceToEncode, (Object)frameSliceIndex);
                CompressedFrameData prevFrame = null;
                int height = 0;
                for (CompressedFrameData frame : frameSliceToEncode) {
                    this.frameSliceFrequency.merge(frame, 1, Integer::sum);
                    if (prevFrame != null) {
                        this.frameSuccessorMap.compute(prevFrame, (k, v) -> {
                            HashSet<CompressedFrameData> callers = v == null ? new HashSet<CompressedFrameData>() : v;
                            callers.add(frame);
                            return callers;
                        });
                    }
                    prevFrame = frame;
                    this.frameMaxHeight.put(frame, Integer.max(height, this.frameMaxHeight.getOrDefault(frame, 0)));
                    ++height;
                }
            }
            Integer frameSliceIndex = (Integer)this.frameSliceIndexMap.get(frameSliceToEncode);
            data.frameSliceIndex = frameSliceIndex;
            this.sliceFrequency.addObject((Object)frameSliceIndex);
        }

        void encodeCompressedData(UnsafeArrayTypeWriter encodingBuffer, CodeInfoEncoder.Encoders encoders) {
            Integer[] sliceOrder;
            assert (!this.sealed);
            this.sealed = true;
            EconomicMap sharedEncodedFrameIndexMap = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
            List sharedFrames = this.framesToEncode.stream().filter(f -> this.frameSliceFrequency.get(f) > 1).sorted((f1, f2) -> {
                int result = -Integer.compare(this.frameSliceFrequency.get(f1), this.frameSliceFrequency.get(f2));
                if (result == 0) {
                    result = -Integer.compare(this.frameMaxHeight.get(f1), this.frameMaxHeight.get(f2));
                }
                return result;
            }).collect(Collectors.toList());
            for (CompressedFrameData frame2 : sharedFrames) {
                int uniqueSuccessorIndex;
                assert (!sharedEncodedFrameIndexMap.containsKey((Object)frame2));
                sharedEncodedFrameIndexMap.put((Object)frame2, (Object)encodingBuffer.getBytesWritten());
                CompressedFrameData uniqueSuccessor = this.getUniqueSuccessor(frame2);
                if (uniqueSuccessor != null) {
                    assert (sharedEncodedFrameIndexMap.containsKey((Object)uniqueSuccessor));
                    uniqueSuccessorIndex = NumUtil.safeToInt((long)((Long)sharedEncodedFrameIndexMap.get((Object)uniqueSuccessor)));
                } else {
                    uniqueSuccessorIndex = -1;
                }
                CompressedFrameInfoEncodingMetadata.encodeCompressedFrame(encodingBuffer, encoders, frame2, uniqueSuccessorIndex);
            }
            for (Integer sliceIdx : sliceOrder = (Integer[])this.sliceFrequency.encodeAll((Object[])new Integer[this.sliceFrequency.getLength()])) {
                assert (!this.encodedSliceIndexMap.containsKey((Object)sliceIdx));
                List<CompressedFrameData> slice = this.frameSlices.get(sliceIdx);
                assert (slice.size() > 0);
                boolean directlyPointToSharedFrame = slice.stream().allMatch(frame -> {
                    Set<CompressedFrameData> frameSuccessors = this.frameSuccessorMap.get(frame);
                    return sharedEncodedFrameIndexMap.containsKey(frame) && (frameSuccessors == null || frameSuccessors.size() == 1);
                });
                if (directlyPointToSharedFrame) {
                    CompressedFrameData frame3 = slice.get(0);
                    assert (sharedEncodedFrameIndexMap.containsKey((Object)frame3));
                    this.encodedSliceIndexMap.put((Object)sliceIdx, sharedEncodedFrameIndexMap.get((Object)frame3));
                    continue;
                }
                this.encodedSliceIndexMap.put((Object)sliceIdx, (Object)encodingBuffer.getBytesWritten());
                CompressedFrameData prevFrame = null;
                boolean prevShared = false;
                for (CompressedFrameData frame4 : slice) {
                    boolean sharedFrame = sharedEncodedFrameIndexMap.containsKey((Object)frame4);
                    if (!prevShared || this.getUniqueSuccessor(prevFrame) == null) {
                        if (sharedFrame) {
                            int framePointer = NumUtil.safeToInt((long)((Long)sharedEncodedFrameIndexMap.get((Object)frame4)));
                            encodingBuffer.putSV((long)FrameInfoEncoder.encodeCompressedFirstEntry(framePointer, false));
                        } else {
                            CompressedFrameInfoEncodingMetadata.encodeCompressedFrame(encodingBuffer, encoders, frame4, -1);
                        }
                    }
                    prevShared = sharedFrame;
                    prevFrame = frame4;
                }
            }
        }

        private CompressedFrameData getUniqueSuccessor(CompressedFrameData frame) {
            Set<CompressedFrameData> frameSuccessors = this.frameSuccessorMap.get(frame);
            if (frameSuccessors != null && frameSuccessors.size() == 1) {
                return frameSuccessors.iterator().next();
            }
            return null;
        }

        private static void encodeCompressedFrame(UnsafeArrayTypeWriter encodingBuffer, CodeInfoEncoder.Encoders encoders, CompressedFrameData frame, int uniqueSuccessorIndex) {
            int classIndex = encoders.sourceClasses.getIndex(frame.sourceClass);
            int methodIndex = encoders.sourceMethodNames.getIndex((Object)frame.sourceMethodName);
            encodingBuffer.putSV((long)FrameInfoEncoder.encodeCompressedFirstEntry(classIndex, true));
            boolean encodeUniqueSuccessor = uniqueSuccessorIndex != -1;
            encodingBuffer.putSV((long)FrameInfoEncoder.encodeCompressedMethodIndex(methodIndex, encodeUniqueSuccessor));
            encodingBuffer.putSV((long)FrameInfoEncoder.encodeCompressedSourceLineNumber(frame.sourceLineNumber, frame.isSliceEnd));
            if (encodeUniqueSuccessor) {
                encodingBuffer.putSV((long)uniqueSuccessorIndex);
            }
        }

        long getEncodingOffset(int sliceIndex) {
            assert (this.sealed);
            Long encodedSliceIndex = (Long)this.encodedSliceIndexMap.get((Object)sliceIndex);
            assert (encodedSliceIndex != null);
            return encodedSliceIndex;
        }

        boolean writeFrameVerificationInfo(FrameData data, CodeInfoEncoder.Encoders encoders) {
            int curIdx = 0;
            List<CompressedFrameData> slice = this.frameSlices.get(data.frameSliceIndex);
            FrameInfoQueryResult cur = data.frame;
            while (cur != null) {
                cur.encodedBci = -2L;
                assert (cur == data.frame || !cur.isDeoptEntry) : "Deoptimization entry information for caller frames is not persisted";
                cur.sourceClassIndex = encoders.sourceClasses.getIndex(cur.sourceClass);
                cur.sourceMethodNameIndex = encoders.sourceMethodNames.getIndex((Object)cur.sourceMethodName);
                boolean isSliceEnd = cur.caller == null;
                CompressedFrameData frame = new CompressedFrameData(cur.sourceClass, cur.sourceMethodName, cur.sourceLineNumber, isSliceEnd);
                assert (frame.equals(slice.get(curIdx)));
                ++curIdx;
                cur = cur.caller;
            }
            assert (this.frameSlices.get(data.frameSliceIndex).size() == curIdx);
            return true;
        }
    }

    private static class CompressedFrameData {
        final Class<?> sourceClass;
        final String sourceMethodName;
        final int sourceLineNumber;
        final boolean isSliceEnd;

        CompressedFrameData(Class<?> sourceClass, String sourceMethodName, int sourceLineNumber, boolean isSliceEnd) {
            this.sourceClass = sourceClass;
            this.sourceMethodName = sourceMethodName;
            this.sourceLineNumber = sourceLineNumber;
            this.isSliceEnd = isSliceEnd;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompressedFrameData that = (CompressedFrameData)o;
            return this.sourceLineNumber == that.sourceLineNumber && this.isSliceEnd == that.isSliceEnd && this.sourceClass.equals(that.sourceClass) && this.sourceMethodName.equals(that.sourceMethodName);
        }

        public int hashCode() {
            return Objects.hash(this.sourceClass, this.sourceMethodName, this.sourceLineNumber, this.isSliceEnd);
        }
    }

    static class FrameData {
        protected DebugInfo debugInfo;
        protected int totalFrameSize;
        protected FrameInfoQueryResult.ValueInfo[][] virtualObjects;
        protected FrameInfoQueryResult frame;
        protected long encodedFrameInfoIndex;
        protected int frameSliceIndex = -1;

        FrameData() {
        }
    }

    public static abstract class SourceFieldsFromImage
    extends Customization {
        @Override
        protected void fillSourceFields(BytecodeFrame bytecodeFrame, FrameInfoQueryResult resultFrameInfo) {
            CodeInfoQueryResult targetCodeInfo;
            int deoptOffsetInImage = ((SharedMethod)bytecodeFrame.getMethod()).getDeoptOffsetInImage();
            if (deoptOffsetInImage != 0 && (targetCodeInfo = CodeInfoTable.lookupDeoptimizationEntrypoint(deoptOffsetInImage, resultFrameInfo.encodedBci)) != null) {
                FrameInfoQueryResult targetFrameInfo = targetCodeInfo.getFrameInfo();
                assert (targetFrameInfo != null);
                resultFrameInfo.sourceClass = targetFrameInfo.sourceClass;
                resultFrameInfo.sourceMethodName = targetFrameInfo.sourceMethodName;
                resultFrameInfo.sourceLineNumber = targetFrameInfo.sourceLineNumber;
            }
        }
    }

    public static abstract class SourceFieldsFromMethod
    extends Customization {
        private final HostedStringDeduplication stringTable = HostedStringDeduplication.singleton();

        @Override
        protected void fillSourceFields(BytecodeFrame bytecodeFrame, FrameInfoQueryResult resultFrameInfo) {
            ResolvedJavaMethod method = bytecodeFrame.getMethod();
            StackTraceElement source = method.asStackTraceElement(bytecodeFrame.getBCI());
            resultFrameInfo.sourceClass = this.getDeclaringJavaClass(method);
            resultFrameInfo.sourceMethodName = this.stringTable.deduplicate(source.getMethodName(), true);
            resultFrameInfo.sourceLineNumber = source.getLineNumber();
        }

        protected abstract Class<?> getDeclaringJavaClass(ResolvedJavaMethod var1);
    }

    public static abstract class Customization {
        protected abstract boolean storeDeoptTargetMethod();

        protected abstract boolean includeLocalValues(ResolvedJavaMethod var1, Infopoint var2);

        protected abstract boolean isDeoptEntry(ResolvedJavaMethod var1, Infopoint var2);

        protected abstract void fillSourceFields(BytecodeFrame var1, FrameInfoQueryResult var2);
    }
}

