/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.darwin;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.posix.darwin.Util_java_lang_System;
import com.oracle.svm.core.posix.headers.Time;
import com.oracle.svm.core.posix.headers.darwin.DarwinTime;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.word.WordFactory;

@TargetClass(value=System.class)
final class Target_java_lang_System_Darwin {
    Target_java_lang_System_Darwin() {
    }

    @Substitute
    @Uninterruptible(reason="Does basic math after a few simple system calls")
    private static long nanoTime() {
        Util_java_lang_System utilJavaLangSystem = (Util_java_lang_System)ImageSingletons.lookup(Util_java_lang_System.class);
        if (utilJavaLangSystem.fastTime) {
            return DarwinTime.mach_absolute_time();
        }
        if (!utilJavaLangSystem.timeBaseValid) {
            DarwinTime.MachTimebaseInfo timeBaseInfo = (DarwinTime.MachTimebaseInfo)StackValue.get(DarwinTime.MachTimebaseInfo.class);
            if (DarwinTime.mach_timebase_info(timeBaseInfo) == 0) {
                if (timeBaseInfo.getdenom() == 1 && timeBaseInfo.getnumer() == 1) {
                    utilJavaLangSystem.fastTime = true;
                    return DarwinTime.mach_absolute_time();
                }
                utilJavaLangSystem.factor = (double)timeBaseInfo.getnumer() / (double)timeBaseInfo.getdenom();
            }
            utilJavaLangSystem.timeBaseValid = true;
        }
        if (utilJavaLangSystem.factor != 0.0) {
            return (long)((double)DarwinTime.mach_absolute_time() * utilJavaLangSystem.factor);
        }
        Time.timeval timeval2 = (Time.timeval)StackValue.get(Time.timeval.class);
        Time.timezone timezone2 = (Time.timezone)WordFactory.nullPointer();
        Time.gettimeofday(timeval2, timezone2);
        return timeval2.tv_sec() * 1000000000L + timeval2.tv_usec() * 1000L;
    }

    @Substitute
    public static String mapLibraryName(String libname) {
        return "lib" + libname + ".dylib";
    }
}

