/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapVerifier;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.ThreadLocalAllocation;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.log.Log;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

final class SpaceVerifier {
    private Space space;

    SpaceVerifier() {
    }

    public void initialize(Space s) {
        this.space = s;
    }

    public boolean verify() {
        Log trace = HeapVerifier.getTraceLog();
        trace.string("[SpaceVerifier.verify:").string("  ").string(this.space.getName()).newline();
        boolean isTLASpace = ThreadLocalAllocation.isThreadLocalAllocationSpace(this.space);
        if (isTLASpace) {
            ThreadLocalAllocation.disableAndFlushForAllThreads();
        }
        boolean result = true;
        if (!this.verifyChunkLists()) {
            HeapImpl.getHeapImpl().getHeapVerifier().getWitnessLog().string("verifyChunkLists() returns false").string("]").newline();
            result = false;
        }
        if (result && !this.verifyChunks()) {
            HeapImpl.getHeapImpl().getHeapVerifier().getWitnessLog().string("[SpaceVerifier.verify:").string("  verifyChunks fails").string("]").newline();
            result = false;
        }
        trace.string("  returns: ").bool(result).string("]").newline();
        return result;
    }

    boolean containsChunks() {
        AlignedHeapChunk.AlignedHeader aChunk = this.space.getFirstAlignedHeapChunk();
        UnalignedHeapChunk.UnalignedHeader uChunk = this.space.getFirstUnalignedHeapChunk();
        return aChunk.isNonNull() || uChunk.isNonNull();
    }

    private boolean verifyChunkLists() {
        Log trace = HeapVerifier.getTraceLog();
        trace.string("[SpaceVerifier.verifyChunkLists:");
        boolean result = this.verifyAlignedChunkList() && this.verifyUnalignedChunkList();
        trace.string("  returns: ").bool(result);
        trace.string("]").newline();
        return result;
    }

    private boolean verifyAlignedChunkList() {
        Log trace = HeapVerifier.getTraceLog().string("[SpaceVerifier.verifyAlignedChunkList:");
        trace.string("  Space: ").string(this.space.getName()).newline();
        boolean result = true;
        AlignedHeapChunk.AlignedHeader current = this.space.getFirstAlignedHeapChunk();
        AlignedHeapChunk.AlignedHeader previous = (AlignedHeapChunk.AlignedHeader)WordFactory.nullPointer();
        while (current.isNonNull()) {
            AlignedHeapChunk.AlignedHeader previousOfCurrent = HeapChunk.getPrevious(current);
            if (!(result &= previousOfCurrent.equal((ComparableWord)previous))) {
                Log failure = HeapImpl.getHeapImpl().getHeapVerifier().getWitnessLog().string("[SpaceVerifier.verifyAlignedChunkList:");
                failure.string("  space: ").string(this.space.getName()).string("  doubly-linked list failure").newline();
                failure.string("  current: ").hex((WordBase)current);
                failure.string("  current.previous: ").hex((WordBase)previousOfCurrent);
                failure.string("  previous: ").hex((WordBase)previous);
                failure.string("]").newline();
                break;
            }
            previous = current;
            current = HeapChunk.getNext(current);
        }
        if (!(result &= previous.equal((ComparableWord)this.space.getLastAlignedHeapChunk()))) {
            Log failure = HeapImpl.getHeapImpl().getHeapVerifier().getWitnessLog().string("[SpaceVerifier.verifyAlignedChunkList:");
            failure.string("  space: ").string(this.space.getName()).string("  lastAlignedHeapChunk failure").string("]").newline();
            failure.string("  previous: ").hex((WordBase)previous);
            failure.string("  lastAlignedHeapChunk: ").hex((WordBase)this.space.getLastAlignedHeapChunk());
            failure.string("]").newline();
            result = false;
        }
        trace.string("  returns: ").bool(result).string("]").newline();
        return result;
    }

    private boolean verifyUnalignedChunkList() {
        Log failure;
        Log trace = HeapVerifier.getTraceLog().string("[SpaceVerifier.verifyUnalignedChunkList:");
        boolean result = true;
        UnalignedHeapChunk.UnalignedHeader current = this.space.getFirstUnalignedHeapChunk();
        UnalignedHeapChunk.UnalignedHeader previous = (UnalignedHeapChunk.UnalignedHeader)WordFactory.nullPointer();
        while (current.isNonNull()) {
            if (!(result &= HeapChunk.getPrevious(current).equal((ComparableWord)previous))) {
                failure = HeapImpl.getHeapImpl().getHeapVerifier().getWitnessLog().string("[SpaceVerifier.verifyUnalignedChunkList:");
                failure.string("  space: ").string(this.space.getName()).string("  doubly-linked list failure").string("]").newline();
                break;
            }
            previous = current;
            current = HeapChunk.getNext(current);
        }
        if (!(result &= previous.equal((ComparableWord)this.space.getLastUnalignedHeapChunk()))) {
            failure = HeapImpl.getHeapImpl().getHeapVerifier().getWitnessLog().string("[SpaceVerifier.verifyUnalignedChunkList:");
            failure.string("  space: ").string(this.space.getName()).string("  lastUnalignedHeapChunk failure").string("]").newline();
            result = false;
        }
        trace.string("  returns: ").bool(result).string("]").newline();
        return result;
    }

    private boolean verifyChunks() {
        Log trace = HeapVerifier.getTraceLog().string("[SpaceVerifier.verifyChunks:");
        boolean result = this.verifyAlignedChunks() && this.verifyUnalignedChunks();
        trace.string("  returns: ").bool(result).string("]").newline();
        return result;
    }

    private boolean verifyAlignedChunks() {
        Log trace = HeapVerifier.getTraceLog().string("[SpaceVerifier.verifyAlignedChunks:");
        boolean result = true;
        AlignedHeapChunk.AlignedHeader chunk = this.space.getFirstAlignedHeapChunk();
        while (chunk.isNonNull()) {
            result &= AlignedHeapChunk.verify(chunk);
            chunk = HeapChunk.getNext(chunk);
        }
        trace.string("  returns: ").bool(result).string("]").newline();
        return result;
    }

    private boolean verifyUnalignedChunks() {
        Log trace = HeapVerifier.getTraceLog().string("[SpaceVerifier.verifyUnalignedChunks:");
        boolean result = true;
        UnalignedHeapChunk.UnalignedHeader chunk = this.space.getFirstUnalignedHeapChunk();
        while (chunk.isNonNull()) {
            result &= UnalignedHeapChunk.verify(chunk);
            chunk = HeapChunk.getNext(chunk);
        }
        trace.string("  returns: ").bool(result).string("]").newline();
        return result;
    }

    boolean verifyOnlyCleanCards() {
        Log trace = HeapVerifier.getTraceLog().string("[SpaceVerifier.verifyOnlyCleanCards:");
        trace.string("  space: ").string(this.space.getName()).newline();
        boolean result = this.verifyOnlyCleanAlignedChunks() && this.verifyOnlyCleanUnalignedChunks();
        trace.string("  returns: ").bool(result).string("]").newline();
        return result;
    }

    private boolean verifyOnlyCleanAlignedChunks() {
        Log trace = HeapVerifier.getTraceLog().string("[SpaceVerifier.verifyOnlyCleanAlignedChunks:").newline();
        boolean result = true;
        AlignedHeapChunk.AlignedHeader chunk = this.space.getFirstAlignedHeapChunk();
        while (chunk.isNonNull()) {
            result &= AlignedHeapChunk.verifyOnlyCleanCards(chunk);
            chunk = HeapChunk.getNext(chunk);
        }
        trace.string("  returns: ").bool(result).string("]").newline();
        return result;
    }

    private boolean verifyOnlyCleanUnalignedChunks() {
        Log trace = HeapVerifier.getTraceLog().string("[SpaceVerifier.verifyOnlyCleanUnalignedChunks:").newline();
        boolean result = true;
        UnalignedHeapChunk.UnalignedHeader chunk = this.space.getFirstUnalignedHeapChunk();
        while (chunk.isNonNull()) {
            result &= UnalignedHeapChunk.verifyOnlyCleanCards(chunk);
            chunk = HeapChunk.getNext(chunk);
        }
        trace.string("  returns: ").bool(result).string("]").newline();
        return result;
    }
}

