/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.log.Log;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.PinnedObjectSupport;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;

final class PinnedObjectImpl
implements PinnedObject {
    private final Object referent;
    private volatile boolean open = true;
    private PinnedObjectImpl next;

    static void pushPinnedObject(PinnedObjectImpl newHead) {
        PinnedObjectImpl sampleHead;
        Log trace = Log.noopLog().string("[PinnedObject.pushPinnedObject:").string("  newHead: ").object(newHead);
        HeapImpl heap = HeapImpl.getHeapImpl();
        UninterruptibleUtils.AtomicReference<PinnedObjectImpl> pinHead = heap.getPinHead();
        do {
            newHead.next = sampleHead = pinHead.get();
        } while (!pinHead.compareAndSet(sampleHead, newHead));
        trace.string("  returns: ").object(newHead).string("]").newline();
    }

    static PinnedObjectImpl claimPinnedObjectList() {
        Log trace = Log.noopLog().string("[PinnedObject.claimPinnedObjectList:").newline();
        HeapImpl heap = HeapImpl.getHeapImpl();
        UninterruptibleUtils.AtomicReference<PinnedObjectImpl> pinHead = heap.getPinHead();
        PinnedObjectImpl result = pinHead.getAndSet(null);
        trace.string("  returns: ").object(result);
        return result;
    }

    PinnedObjectImpl(Object object) {
        this.referent = object;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void close() {
        assert (this.open) : "Should not call close() on a closed PinnedObject.";
        this.open = false;
    }

    public Object getObject() {
        assert (this.open) : "Should not call getObject() on a closed PinnedObject.";
        return this.referent;
    }

    public Pointer addressOfObject() {
        assert (this.open) : "Should not call addressOfObject() on a closed PinnedObject.";
        return Word.objectToUntrackedPointer((Object)this.referent);
    }

    public <T extends PointerBase> T addressOfArrayElement(int index) {
        if (this.referent == null) {
            throw new NullPointerException("null PinnedObject");
        }
        DynamicHub hub = ObjectHeader.readDynamicHubFromObject(this.referent);
        UnsignedWord offsetOfArrayElement = LayoutEncoding.getArrayElementOffset(hub.getLayoutEncoding(), index);
        return (T)this.addressOfObject().add(offsetOfArrayElement);
    }

    public boolean isOpen() {
        return this.open;
    }

    public PinnedObjectImpl getNext() {
        return this.next;
    }

    @AutomaticFeature
    static class PinnedObjectFeature
    implements Feature {
        PinnedObjectFeature() {
        }

        public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
            return SubstrateOptions.UseCardRememberedSetHeap.getValue();
        }

        public void afterRegistration(Feature.AfterRegistrationAccess access) {
            ImageSingletons.add(PinnedObjectSupport.class, (Object)new PinnedObjectSupportImpl());
        }
    }

    static class PinnedObjectSupportImpl
    implements PinnedObjectSupport {
        PinnedObjectSupportImpl() {
        }

        public PinnedObject create(Object object) {
            Log trace = Log.noopLog().string("[PinnedObject.open:").string(" object: ").object(object).newline();
            PinnedObjectImpl result = new PinnedObjectImpl(object);
            PinnedObjectImpl.pushPinnedObject(result);
            trace.string("  returns: ]").object(result).newline();
            return result;
        }

        public boolean isPinned(Object object) {
            PinnedObjectImpl pin = HeapImpl.getHeapImpl().getPinHead().get();
            while (pin != null) {
                if (pin.open && pin.referent == object) {
                    return true;
                }
                pin = pin.next;
            }
            return false;
        }
    }
}

