/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.configure;

import com.oracle.svm.core.configure.ConfigurationParser;
import com.oracle.svm.core.util.json.JSONParser;
import com.oracle.svm.core.util.json.JSONParserException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SerializationConfigurationParser
extends ConfigurationParser {
    private final SerializationParserFunction consumer;

    public SerializationConfigurationParser(SerializationParserFunction consumer) {
        this.consumer = consumer;
    }

    @Override
    public void parseAndRegister(Reader reader) throws IOException {
        JSONParser parser = new JSONParser(reader);
        Object json = parser.parse();
        for (Object serializationKey : SerializationConfigurationParser.asList(json, "first level of document must be an array of serialization lists")) {
            Map<String, Object> data = SerializationConfigurationParser.asMap(serializationKey, "second level of document must be serialization descriptor objects ");
            String targetSerializationClass = SerializationConfigurationParser.asString(data.get("name"));
            Object checksumValue = data.get("checksum");
            ArrayList<String> checksums = new ArrayList<String>();
            if (checksumValue != null) {
                List<Object> jsonChecksums;
                try {
                    jsonChecksums = SerializationConfigurationParser.asList(checksumValue, "list of checksums");
                }
                catch (JSONParserException e) {
                    jsonChecksums = Collections.singletonList(SerializationConfigurationParser.asString(checksumValue, "checksum"));
                }
                for (Object jsonChecksum : jsonChecksums) {
                    checksums.add(SerializationConfigurationParser.asString(jsonChecksum, "checksum"));
                }
            }
            this.consumer.accept(targetSerializationClass, checksums);
        }
    }

    @FunctionalInterface
    public static interface SerializationParserFunction {
        public void accept(String var1, List<String> var2);
    }
}

