/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.classinitialization;

import com.oracle.svm.core.annotate.InvokeJavaFunctionPointer;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.graalvm.compiler.serviceprovider.GraalUnsafeAccess;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import sun.misc.Unsafe;

public final class ClassInitializationInfo {
    private static final Unsafe UNSAFE = GraalUnsafeAccess.getUnsafe();
    public static final ClassInitializationInfo INITIALIZED_INFO_SINGLETON = new ClassInitializationInfo(InitState.FullyInitialized, true);
    public static final ClassInitializationInfo NO_INITIALIZER_INFO_SINGLETON = new ClassInitializationInfo(InitState.FullyInitialized, false);
    public static final ClassInitializationInfo FAILED_INFO_SINGLETON = new ClassInitializationInfo(InitState.InitializationError);
    private final ClassInitializerFunctionPointerHolder classInitializer;
    private InitState initState;
    private Thread initThread;
    private final ReentrantLock initLock;
    private Condition initCondition;
    private boolean hasInitializer;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private ClassInitializationInfo(InitState initState, boolean hasInitializer) {
        this(initState);
        this.hasInitializer = hasInitializer;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private ClassInitializationInfo(InitState initState) {
        this.classInitializer = null;
        this.initState = initState;
        this.initLock = initState == InitState.FullyInitialized ? null : new ReentrantLock();
        this.hasInitializer = true;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public ClassInitializationInfo(CFunctionPointer classInitializer) {
        this.classInitializer = classInitializer == null || classInitializer.isNull() ? null : new ClassInitializerFunctionPointerHolder(classInitializer);
        this.initState = InitState.Linked;
        this.initLock = new ReentrantLock();
        this.hasInitializer = classInitializer != null;
    }

    public boolean hasInitializer() {
        return this.hasInitializer;
    }

    public boolean isInitialized() {
        return this.initState == InitState.FullyInitialized;
    }

    private boolean isBeingInitialized() {
        return this.initState == InitState.BeingInitialized;
    }

    private boolean isInErrorState() {
        return this.initState == InitState.InitializationError;
    }

    private boolean isReentrantInitialization(Thread thread) {
        return thread == this.initThread;
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void initialize(ClassInitializationInfo info, DynamicHub hub) {
        Thread self = Thread.currentThread();
        info.initLock.lock();
        try {
            while (info.isBeingInitialized() && !info.isReentrantInitialization(self)) {
                if (info.initCondition == null) {
                    info.initCondition = info.initLock.newCondition();
                }
                info.initCondition.awaitUninterruptibly();
            }
            if (info.isBeingInitialized() && info.isReentrantInitialization(self)) {
                return;
            }
            if (info.isInitialized()) {
                return;
            }
            if (info.isInErrorState()) {
                throw new NoClassDefFoundError("Could not initialize class " + hub.getName());
            }
            info.initState = InitState.BeingInitialized;
            info.initThread = self;
        }
        finally {
            info.initLock.unlock();
        }
        if (!hub.isInterface()) {
            try {
                if (hub.getSuperHub() != null) {
                    hub.getSuperHub().ensureInitialized();
                }
                if (hub.hasDefaultMethods()) {
                    ClassInitializationInfo.initializeSuperInterfaces(hub);
                }
            }
            catch (Throwable ex) {
                info.setInitializationStateAndNotify(InitState.InitializationError);
                throw ex;
            }
        }
        Throwable exception = null;
        try {
            info.invokeClassInitializer();
        }
        catch (Throwable ex) {
            exception = ex;
        }
        if (exception != null) {
            if (!(exception instanceof Error)) {
                exception = new ExceptionInInitializerError(exception);
            }
            info.setInitializationStateAndNotify(InitState.InitializationError);
            throw (Error)exception;
        }
        info.setInitializationStateAndNotify(InitState.FullyInitialized);
    }

    private static void initializeSuperInterfaces(DynamicHub hub) {
        assert (hub.hasDefaultMethods()) : "caller should have checked this";
        for (DynamicHub iface : hub.getInterfaces()) {
            if (iface.hasDefaultMethods()) {
                ClassInitializationInfo.initializeSuperInterfaces(iface);
            }
            if (!iface.declaresDefaultMethods()) continue;
            iface.ensureInitialized();
        }
    }

    private void setInitializationStateAndNotify(InitState state) {
        this.initLock.lock();
        try {
            this.initState = state;
            this.initThread = null;
            UNSAFE.storeFence();
            if (this.initCondition != null) {
                this.initCondition.signalAll();
                this.initCondition = null;
            }
        }
        finally {
            this.initLock.unlock();
        }
    }

    private void invokeClassInitializer() {
        if (this.classInitializer != null) {
            ((ClassInitializerFunctionPointer)this.classInitializer.functionPointer).invoke();
        }
    }

    public static class ClassInitializerFunctionPointerHolder {
        final CFunctionPointer functionPointer;

        ClassInitializerFunctionPointerHolder(CFunctionPointer functionPointer) {
            this.functionPointer = functionPointer;
        }
    }

    static interface ClassInitializerFunctionPointer
    extends CFunctionPointer {
        @InvokeJavaFunctionPointer
        public void invoke();
    }

    static enum InitState {
        Linked,
        BeingInitialized,
        FullyInitialized,
        InitializationError;

    }
}

