/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;

public class SubstrateServerMessage {
    final ServerCommand command;
    final byte[] payload;
    final int offset;
    final int length;

    SubstrateServerMessage(ServerCommand command, byte[] payload) {
        this(command, payload, 0, payload.length);
    }

    SubstrateServerMessage(ServerCommand command, byte[] payload, int offset, int length) {
        this.command = command;
        this.payload = payload;
        this.offset = offset;
        this.length = length;
    }

    static void send(SubstrateServerMessage message, DataOutputStream os) throws IOException {
        os.writeInt(message.command.ordinal());
        os.writeInt(message.length);
        os.write(message.payload, message.offset, message.length);
        os.flush();
    }

    static SubstrateServerMessage receive(DataInputStream is) throws IOException {
        try {
            ServerCommand command = ServerCommand.values()[is.readInt()];
            int length = is.readInt();
            byte[] payload = new byte[length];
            is.readFully(payload);
            return new SubstrateServerMessage(command, payload);
        }
        catch (EOFException ex) {
            return null;
        }
    }

    public String payloadString() {
        return new String(this.payload);
    }

    public static enum ServerCommand {
        GET_VERSION,
        STOP_SERVER,
        BUILD_IMAGE,
        ABORT_BUILD,
        SEND_STATUS,
        WRITE_ERR,
        WRITE_OUT;

    }
}

