/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image.sources;

import com.oracle.svm.hosted.image.sources.SourceCache;
import com.oracle.svm.hosted.image.sources.SourceCacheType;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;

public class ApplicationSourceCache
extends SourceCache {
    protected ApplicationSourceCache() {
        this.initSrcRoots();
    }

    @Override
    protected final SourceCacheType getType() {
        return SourceCacheType.APPLICATION;
    }

    private void initSrcRoots() {
        for (String classPathEntry : classPathEntries) {
            this.tryClassPathRoot(classPathEntry);
        }
        for (String sourcePathEntry : sourcePathEntries) {
            this.trySourceRoot(sourcePathEntry);
        }
    }

    private void tryClassPathRoot(String classPathEntry) {
        this.trySourceRoot(classPathEntry, true);
    }

    private void trySourceRoot(String sourcePathEntry) {
        this.trySourceRoot(sourcePathEntry, false);
    }

    private void trySourceRoot(String sourceRoot, boolean fromClassPath) {
        block13: {
            try {
                File file;
                Path sourcePath = Paths.get(sourceRoot, new String[0]);
                String fileNameString = sourcePath.getFileName().toString();
                if (fileNameString.endsWith(".jar") || fileNameString.endsWith(".zip")) {
                    if (fromClassPath && fileNameString.endsWith(".jar")) {
                        int length = fileNameString.length();
                        fileNameString = fileNameString.substring(0, length - 4) + "-sources.jar";
                    }
                    if (!(sourcePath = sourcePath.getParent().resolve(fileNameString)).toFile().exists()) break block13;
                    try {
                        FileSystem fileSystem = FileSystems.newFileSystem(sourcePath, (ClassLoader)null);
                        for (Path root : fileSystem.getRootDirectories()) {
                            this.srcRoots.add(root);
                        }
                        break block13;
                    }
                    catch (IOException | FileSystemNotFoundException fileSystem) {
                        break block13;
                    }
                }
                if (fromClassPath && sourcePath.endsWith("classes")) {
                    Path parent = sourcePath.getParent();
                    if (parent.endsWith("target")) {
                        parent = parent.getParent();
                    }
                    sourcePath = parent.resolve("src");
                }
                if ((file = sourcePath.toFile()).exists() && file.isDirectory()) {
                    Path subPath = sourcePath.resolve("main").resolve("java");
                    file = subPath.toFile();
                    if (file.exists() && file.isDirectory()) {
                        sourcePath = subPath;
                    } else {
                        subPath = sourcePath.resolve("java");
                        file = subPath.toFile();
                        if (file.exists() && file.isDirectory()) {
                            sourcePath = subPath;
                        }
                    }
                    this.srcRoots.add(sourcePath);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }
}

