/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.dashboard;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.ActualParameterTypeFlow;
import com.oracle.graal.pointsto.flow.ActualReturnTypeFlow;
import com.oracle.graal.pointsto.flow.AllInstantiatedTypeFlow;
import com.oracle.graal.pointsto.flow.AllSynchronizedTypeFlow;
import com.oracle.graal.pointsto.flow.ArrayCopyTypeFlow;
import com.oracle.graal.pointsto.flow.ArrayElementsTypeFlow;
import com.oracle.graal.pointsto.flow.BoxTypeFlow;
import com.oracle.graal.pointsto.flow.CloneTypeFlow;
import com.oracle.graal.pointsto.flow.DynamicNewInstanceTypeFlow;
import com.oracle.graal.pointsto.flow.FieldFilterTypeFlow;
import com.oracle.graal.pointsto.flow.FieldSinkTypeFlow;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.flow.FilterTypeFlow;
import com.oracle.graal.pointsto.flow.FormalParamTypeFlow;
import com.oracle.graal.pointsto.flow.FormalReceiverTypeFlow;
import com.oracle.graal.pointsto.flow.FormalReturnTypeFlow;
import com.oracle.graal.pointsto.flow.InitialParamTypeFlow;
import com.oracle.graal.pointsto.flow.InitialReceiverTypeFlow;
import com.oracle.graal.pointsto.flow.InstanceOfTypeFlow;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.flow.LoadFieldTypeFlow;
import com.oracle.graal.pointsto.flow.MergeTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MonitorEnterTypeFlow;
import com.oracle.graal.pointsto.flow.NewInstanceTypeFlow;
import com.oracle.graal.pointsto.flow.NullCheckTypeFlow;
import com.oracle.graal.pointsto.flow.OffsetLoadTypeFlow;
import com.oracle.graal.pointsto.flow.OffsetStoreTypeFlow;
import com.oracle.graal.pointsto.flow.ProxyTypeFlow;
import com.oracle.graal.pointsto.flow.SourceTypeFlow;
import com.oracle.graal.pointsto.flow.StoreFieldTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.UnknownTypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.dashboard.DashboardDumpFeature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import jdk.vm.ci.code.BytecodePosition;
import org.graalvm.nativeimage.hosted.Feature;

class PointsToDumper {
    PointsToDumper() {
    }

    DashboardDumpFeature.Dict dump(Feature.OnAnalysisExitAccess access) {
        try {
            FeatureImpl.OnAnalysisExitAccessImpl config = (FeatureImpl.OnAnalysisExitAccessImpl)access;
            BigBang bigbang = config.getBigBang();
            SerializedTypeFlowGraph serializedGraph = new SerializedTypeFlowGraph(bigbang);
            serializedGraph.build();
            return serializedGraph.toSection();
        }
        catch (Exception e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    public static class SerializedTypeFlowGraph {
        private static final Collection<String> REQUIRE_ENCLOSING_METHOD_INPUT = new ArrayList<String>(Arrays.asList("callsite", "alloc"));
        private static final Collection<String> REQUIRE_ENCLOSING_METHOD_ID = new ArrayList<String>(Arrays.asList("formalParam", "formalReturn", "callsite"));
        private HashMap<Integer, DashboardDumpFeature.Dict> nodeIndex;
        private BigBang bb;
        private boolean isBuilt;

        SerializedTypeFlowGraph(BigBang bb) {
            this.bb = bb;
            this.nodeIndex = new LinkedHashMap<Integer, DashboardDumpFeature.Dict>();
        }

        public void build() {
            if (this.isBuilt) {
                return;
            }
            this.serializeMethods();
            this.connectFlowsToEnclosingMethods();
            this.matchInputsAndUses();
            this.isBuilt = true;
        }

        private void serializeMethods() {
            for (AnalysisMethod method : this.bb.getUniverse().getMethods()) {
                this.serializeMethod(new AnalysisMethodWrapper(method));
            }
        }

        private void serializeMethod(AnalysisMethodWrapper methodWrapper) {
            DashboardDumpFeature.Dict methodNode = new DashboardDumpFeature.Dict();
            methodNode.insert("id", methodWrapper.getMethodId());
            methodNode.insert("flowType", "method");
            this.nodeIndex.put((Integer)methodNode.get("id"), methodNode);
            DashboardDumpFeature.Dict info = new DashboardDumpFeature.Dict();
            info.insert("qualifiedName", methodWrapper.getQualifiedName());
            info.insert("qualifiedNameSimpleParams", methodWrapper.getQualifiedNameSimpleParams());
            info.insert("inputs", new ArrayList());
            info.insert("uses", new ArrayList());
            methodNode.insert("info", info);
            if (methodWrapper.getFlowsGraph() == null) {
                return;
            }
            for (TypeFlow node : methodWrapper.getFlowsGraph().linearizedGraph) {
                if (node == null) continue;
                this.serializeTypeFlow(node);
            }
        }

        private void serializeTypeFlow(TypeFlow<?> flow) {
            int flowId = flow.id();
            if (this.nodeIndex.containsKey(flowId)) {
                return;
            }
            DashboardDumpFeature.Dict newFlowNode = new DashboardDumpFeature.Dict();
            newFlowNode.insert("id", flowId);
            this.nodeIndex.put(flowId, newFlowNode);
            newFlowNode.insert("flowType", SerializedTypeFlowGraph.serializeTypeFlowName(flow));
            DashboardDumpFeature.Dict info = new DashboardDumpFeature.Dict();
            newFlowNode.insert("info", info);
            ArrayList<Object> inputs = new ArrayList<Object>();
            ArrayList<Object> uses = new ArrayList<Object>();
            info.insert("inputs", inputs);
            info.insert("uses", uses);
            info.insert("codeLocation", SerializedTypeFlowGraph.getCodeLocation(flow));
            TypeState typeState = flow.getState();
            if (flow instanceof InvokeTypeFlow) {
                Collection callees = ((InvokeTypeFlow)flow).getCallees();
                ArrayList<String> calleeNames = new ArrayList<String>();
                for (AnalysisMethod callee : callees) {
                    int calleeId = callee.getTypeFlow().id();
                    SerializedTypeFlowGraph.addIntUnique(uses, calleeId);
                    calleeNames.add(callee.getQualifiedName());
                }
                info.insert("calleeNames", calleeNames);
            } else if (flow instanceof NewInstanceTypeFlow || flow instanceof DynamicNewInstanceTypeFlow) {
                ArrayList<Object> types = SerializedTypeFlowGraph.serializeTypeState(flow.getState());
                info.insert("types", types);
            } else if (flow instanceof LoadFieldTypeFlow.LoadInstanceFieldTypeFlow || flow instanceof LoadFieldTypeFlow.LoadStaticFieldTypeFlow) {
                LoadFieldTypeFlow loadFlow = (LoadFieldTypeFlow)flow;
                String qualifiedName = SerializedTypeFlowGraph.fieldName(loadFlow.field());
                info.insert("qualifiedName", qualifiedName);
            } else if (flow instanceof StoreFieldTypeFlow.StoreInstanceFieldTypeFlow || flow instanceof StoreFieldTypeFlow.StoreStaticFieldTypeFlow) {
                info.insert("types", SerializedTypeFlowGraph.serializeTypeState(typeState));
                StoreFieldTypeFlow storeFlow = (StoreFieldTypeFlow)flow;
                String qualifiedName = SerializedTypeFlowGraph.fieldName(storeFlow.field());
                info.insert("qualifiedName", qualifiedName);
            } else if (flow instanceof FieldTypeFlow) {
                FieldTypeFlow fieldFlow = (FieldTypeFlow)flow;
                String qualifiedName = SerializedTypeFlowGraph.fieldName((AnalysisField)fieldFlow.getSource());
                info.insert("qualifiedName", qualifiedName);
            } else if (flow instanceof FormalReceiverTypeFlow) {
                String receiverType = flow.getDeclaredType().toJavaName();
                info.insert("qualifiedName", receiverType);
            }
            this.collectInputs(flow, inputs);
            this.collectUses(flow, uses);
        }

        private static String serializeTypeFlowName(TypeFlow<?> flow) {
            String name = DashboardTypeFlowNames.get(flow);
            if (name == null) {
                throw new IllegalArgumentException("Unknown flow type: " + flow.getClass().getSimpleName());
            }
            return name;
        }

        private void connectFlowsToEnclosingMethods() {
            for (AnalysisMethod method : this.bb.getUniverse().getMethods()) {
                AnalysisMethodWrapper methodWrapper = new AnalysisMethodWrapper(method);
                if (methodWrapper.getFlowsGraph() == null) continue;
                for (TypeFlow flow : methodWrapper.getFlowsGraph().linearizedGraph) {
                    this.connectFlowToEnclosingMethod(flow, methodWrapper.getMethodId());
                }
            }
        }

        private void connectFlowToEnclosingMethod(TypeFlow<?> flow, int enclosingMethodId) {
            if (flow == null) {
                return;
            }
            DashboardDumpFeature.Dict flowDict = this.nodeIndex.get(flow.id());
            assert (flowDict != null);
            String flowType = flowDict.getString("flowType");
            if (REQUIRE_ENCLOSING_METHOD_INPUT.contains(flowType)) {
                ArrayList<Object> inputsOfNode = flowDict.getDict("info").getList("inputs");
                DashboardDumpFeature.Dict parentMethodJson = this.nodeIndex.get(enclosingMethodId);
                assert (parentMethodJson != null);
                SerializedTypeFlowGraph.addIntUnique(inputsOfNode, parentMethodJson.getInt("id"));
                parentMethodJson.getDict("info").getList("uses").add(flowDict.getInt("id"));
            }
            if (REQUIRE_ENCLOSING_METHOD_ID.contains(flowType) && !flowDict.getDict("info").hasKey("enclosingMethod")) {
                flowDict.getDict("info").insert("enclosingMethod", enclosingMethodId);
            }
        }

        private static String getCodeLocation(TypeFlow<?> flow) {
            if (flow.getSource() instanceof BytecodePosition) {
                return flow.getSource().toString();
            }
            return null;
        }

        private void collectInputs(TypeFlow<?> flow, ArrayList<Object> targetList) {
            for (Object input : flow.getInputs()) {
                TypeFlow inputFlow = (TypeFlow)input;
                SerializedTypeFlowGraph.addIntUnique(targetList, inputFlow.id());
                this.serializeTypeFlow(inputFlow);
            }
            for (Object observee : flow.getObservees()) {
                TypeFlow observeeFlow = (TypeFlow)observee;
                SerializedTypeFlowGraph.addIntUnique(targetList, observeeFlow.id());
                this.serializeTypeFlow(observeeFlow);
            }
        }

        private void collectUses(TypeFlow<?> flow, ArrayList<Object> targetList) {
            for (Object use : flow.getUses()) {
                TypeFlow useFlow = (TypeFlow)use;
                SerializedTypeFlowGraph.addIntUnique(targetList, useFlow.id());
                this.serializeTypeFlow(useFlow);
            }
            for (Object observer : flow.getObservers()) {
                TypeFlow observerFlow = (TypeFlow)observer;
                SerializedTypeFlowGraph.addIntUnique(targetList, observerFlow.id());
                this.serializeTypeFlow(observerFlow);
            }
        }

        private static void addIntUnique(ArrayList<Object> list, int element) {
            if (!list.contains(element)) {
                list.add(element);
            }
        }

        private static ArrayList<Object> serializeTypeState(TypeState typeState) {
            ArrayList<Object> types = new ArrayList<Object>();
            if (typeState.getClass().getSimpleName().equals("UnknownTypeState")) {
                return types;
            }
            for (AnalysisType type : typeState.types()) {
                types.add(type.toJavaName());
            }
            return types;
        }

        private static String fieldName(AnalysisField field) {
            return field.format("%H.%n");
        }

        private void matchInputsAndUses() {
            Collection<DashboardDumpFeature.Dict> nodes = this.nodeIndex.values();
            for (DashboardDumpFeature.Dict node : nodes) {
                this.matchFromTo(node, "inputs");
                this.matchFromTo(node, "uses");
            }
        }

        private void matchFromTo(DashboardDumpFeature.Dict fromNode, String from) {
            assert (from.equals("inputs") || from.equals("uses"));
            String to = from.equals("inputs") ? "uses" : "inputs";
            int nodeId = fromNode.getInt("id");
            ArrayList<Object> fromIds = fromNode.getDict("info").getList(from);
            for (Object fromIdObject : fromIds) {
                Integer fromId = (Integer)fromIdObject;
                DashboardDumpFeature.Dict referencedNode = this.nodeIndex.get(fromId);
                if (referencedNode == null) continue;
                ArrayList<Object> usesList = referencedNode.getDict("info").getList(to);
                SerializedTypeFlowGraph.addIntUnique(usesList, nodeId);
            }
        }

        DashboardDumpFeature.Dict toSection() {
            if (!this.isBuilt) {
                throw new IllegalStateException("Tried exporting to JSON before building.");
            }
            ArrayList<DashboardDumpFeature.Dict> nodes = new ArrayList<DashboardDumpFeature.Dict>();
            for (DashboardDumpFeature.Dict node : this.nodeIndex.values()) {
                nodes.add(node);
            }
            DashboardDumpFeature.Dict root = new DashboardDumpFeature.Dict();
            root.sections.put("type-flows", nodes);
            return root;
        }

        private static class AnalysisMethodWrapper {
            private int methodId;
            private String qualifiedName;
            private String qualifiedNameSimpleParams;
            private MethodFlowsGraph flowsGraph;

            AnalysisMethodWrapper(AnalysisMethod method) {
                this.methodId = method.getTypeFlow().id();
                this.qualifiedName = method.getQualifiedName();
                this.qualifiedNameSimpleParams = method.format("%H.%n(%p)");
                this.flowsGraph = null;
                Collection flows = method.getTypeFlow().getFlows();
                if (flows.size() != 0) {
                    VMError.guarantee(flows.size() == 1, "Expect to have a single type flow graph.");
                    this.flowsGraph = (MethodFlowsGraph)flows.iterator().next();
                }
            }

            int getMethodId() {
                return this.methodId;
            }

            String getQualifiedName() {
                return this.qualifiedName;
            }

            String getQualifiedNameSimpleParams() {
                return this.qualifiedNameSimpleParams;
            }

            MethodFlowsGraph getFlowsGraph() {
                return this.flowsGraph;
            }
        }
    }

    public static class DashboardTypeFlowNames {
        private static final HashMap<String, String> names = new HashMap();

        public static String get(TypeFlow<?> flow) {
            String className = flow.getClass().getSimpleName();
            if (flow instanceof InvokeTypeFlow) {
                className = InvokeTypeFlow.class.getSimpleName();
            }
            return names.get(className);
        }

        static {
            names.put(FormalReturnTypeFlow.class.getSimpleName(), "formalReturn");
            names.put(ActualReturnTypeFlow.class.getSimpleName(), "actualReturn");
            names.put(FormalParamTypeFlow.class.getSimpleName(), "formalParam");
            names.put(ActualParameterTypeFlow.class.getSimpleName(), "actualParameter");
            names.put(InvokeTypeFlow.class.getSimpleName(), "callsite");
            names.put(NewInstanceTypeFlow.class.getSimpleName(), "alloc");
            names.put(DynamicNewInstanceTypeFlow.class.getSimpleName(), "dynamicAlloc");
            names.put(LoadFieldTypeFlow.LoadInstanceFieldTypeFlow.class.getSimpleName(), "instanceFieldLoad");
            names.put(LoadFieldTypeFlow.LoadStaticFieldTypeFlow.class.getSimpleName(), "staticFieldLoad");
            names.put(StoreFieldTypeFlow.StoreInstanceFieldTypeFlow.class.getSimpleName(), "instanceFieldStore");
            names.put(StoreFieldTypeFlow.StoreStaticFieldTypeFlow.class.getSimpleName(), "staticFieldStore");
            names.put(FieldTypeFlow.class.getSimpleName(), "field");
            names.put(OffsetLoadTypeFlow.AtomicReadTypeFlow.class.getSimpleName(), "atomicRead");
            names.put(OffsetStoreTypeFlow.AtomicWriteTypeFlow.class.getSimpleName(), "atomicWrite");
            names.put(NullCheckTypeFlow.class.getSimpleName(), "nullCheck");
            names.put(ArrayCopyTypeFlow.class.getSimpleName(), "arrayCopy");
            names.put(BoxTypeFlow.class.getSimpleName(), "box");
            names.put(CloneTypeFlow.class.getSimpleName(), "clone");
            names.put(OffsetStoreTypeFlow.CompareAndSwapTypeFlow.class.getSimpleName(), "compareAndSwap");
            names.put(FilterTypeFlow.class.getSimpleName(), "filter");
            names.put(FormalReceiverTypeFlow.class.getSimpleName(), "formalReceiver");
            names.put(InstanceOfTypeFlow.class.getSimpleName(), "instanceOf");
            names.put(OffsetLoadTypeFlow.LoadIndexedTypeFlow.class.getSimpleName(), "loadIndexed");
            names.put(MergeTypeFlow.class.getSimpleName(), "merge");
            names.put(MonitorEnterTypeFlow.class.getSimpleName(), "monitorEnter");
            names.put(ProxyTypeFlow.class.getSimpleName(), "proxy");
            names.put(SourceTypeFlow.class.getSimpleName(), "source");
            names.put(OffsetStoreTypeFlow.StoreIndexedTypeFlow.class.getSimpleName(), "storeIndexed");
            names.put(OffsetLoadTypeFlow.UnsafeLoadTypeFlow.class.getSimpleName(), "unsafeLoad");
            names.put(OffsetStoreTypeFlow.UnsafeStoreTypeFlow.class.getSimpleName(), "unsafeStore");
            names.put(AllInstantiatedTypeFlow.class.getSimpleName(), "allInstantiated");
            names.put(AllSynchronizedTypeFlow.class.getSimpleName(), "allSynchronized");
            names.put(ArrayElementsTypeFlow.class.getSimpleName(), "arrayElements");
            names.put(FieldFilterTypeFlow.class.getSimpleName(), "fieldFilter");
            names.put(FieldSinkTypeFlow.class.getSimpleName(), "fieldSink");
            names.put(InitialParamTypeFlow.class.getSimpleName(), "initialParam");
            names.put(InitialReceiverTypeFlow.class.getSimpleName(), "initialReceiver");
            names.put(UnknownTypeFlow.class.getSimpleName(), "unknown");
        }
    }
}

