/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.config;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.configure.ResourcesRegistry;
import com.oracle.svm.core.jdk.JNIRegistrationUtil;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.classinitialization.ConfigurableClassInitialization;
import java.lang.reflect.Executable;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport;

@AutomaticFeature
public class JavaxXmlClassAndResourcesLoaderFeature
extends JNIRegistrationUtil
implements Feature {
    private static String[] xmlClasses = new String[]{"com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl", "com.sun.org.apache.xerces.internal.dom.DOMXSImplementationSourceImpl", "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl", "com.sun.org.apache.xerces.internal.jaxp.datatype.DatatypeFactoryImpl", "com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl", "com.sun.xml.internal.stream.events.XMLEventFactoryImpl", "com.sun.xml.internal.stream.XMLInputFactoryImpl", "com.sun.xml.internal.stream.XMLOutputFactoryImpl"};
    private static String[] bundles = new String[]{"com.sun.org.apache.xml.internal.serializer.utils.SerializerMessages"};
    private static String[] resources = new String[]{"com.sun.*.properties"};

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        Object[] xmlMethods = new Object[]{JavaxXmlClassAndResourcesLoaderFeature.method((Feature.FeatureAccess)access, "javax.xml.parsers.FactoryFinder", "find", Class.class, String.class), JavaxXmlClassAndResourcesLoaderFeature.method((Feature.FeatureAccess)access, "javax.xml.transform.FactoryFinder", "find", Class.class, String.class), JavaxXmlClassAndResourcesLoaderFeature.method((Feature.FeatureAccess)access, "javax.xml.stream.FactoryFinder", "find", Class.class, String.class)};
        access.registerReachabilityHandler(JavaxXmlClassAndResourcesLoaderFeature::registerJavaxXmlConfigs, xmlMethods);
    }

    private static void registerJavaxXmlConfigs(Feature.DuringAnalysisAccess a) {
        JavaxXmlClassAndResourcesLoaderFeature.registerReflectionClasses((FeatureImpl.DuringAnalysisAccessImpl)a);
        JavaxXmlClassAndResourcesLoaderFeature.registerResources();
        a.requireAnalysisIteration();
    }

    private static void registerResources() {
        ConfigurableClassInitialization classInitializationSupport = (ConfigurableClassInitialization)ImageSingletons.lookup(RuntimeClassInitializationSupport.class);
        classInitializationSupport.setConfigurationSealed(false);
        ResourcesRegistry resourcesRegistry = (ResourcesRegistry)ImageSingletons.lookup(ResourcesRegistry.class);
        for (String resourceBundle : bundles) {
            resourcesRegistry.addResourceBundles(resourceBundle);
        }
        for (String resource : resources) {
            resourcesRegistry.addResources(resource);
        }
        classInitializationSupport.setConfigurationSealed(true);
    }

    private static void registerReflectionClasses(FeatureImpl.DuringAnalysisAccessImpl access) {
        for (String className : xmlClasses) {
            RuntimeReflection.register((Class[])new Class[]{JavaxXmlClassAndResourcesLoaderFeature.clazz(access, className)});
            RuntimeReflection.register((Executable[])new Executable[]{JavaxXmlClassAndResourcesLoaderFeature.constructor(access, className, new Class[0])});
        }
    }
}

