/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.linux;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.PhysicalMemory;
import com.oracle.svm.core.posix.headers.Unistd;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import java.io.FileInputStream;
import java.io.IOException;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

class LinuxPhysicalMemory
extends PhysicalMemory {
    LinuxPhysicalMemory() {
    }

    @AutomaticFeature
    static class PhysicalMemoryFeature
    implements Feature {
        PhysicalMemoryFeature() {
        }

        public void afterRegistration(Feature.AfterRegistrationAccess access) {
            ImageSingletons.add(PhysicalMemory.PhysicalMemorySupport.class, (Object)new PhysicalMemorySupportImpl());
        }
    }

    static class PhysicalMemorySupportImpl
    implements PhysicalMemory.PhysicalMemorySupport {
        private static final String cgroupMemoryFileName = "/sys/fs/cgroup/memory/memory.limit_in_bytes";

        PhysicalMemorySupportImpl() {
        }

        @Override
        public UnsignedWord size() {
            return UnsignedUtils.min(PhysicalMemorySupportImpl.sizeFromCGroup(), PhysicalMemorySupportImpl.sizeFromSysconf());
        }

        private static UnsignedWord sizeFromSysconf() {
            long numberOfPhysicalMemoryPages = Unistd.sysconf(Unistd._SC_PHYS_PAGES());
            long sizeOfAPhysicalMemoryPage = Unistd.sysconf(Unistd._SC_PAGESIZE());
            if (numberOfPhysicalMemoryPages == -1L || sizeOfAPhysicalMemoryPage == -1L) {
                throw VMError.shouldNotReachHere("Physical memory size (number of pages or page size) not available");
            }
            return WordFactory.unsigned((long)numberOfPhysicalMemoryPages).multiply(WordFactory.unsigned((long)sizeOfAPhysicalMemoryPage));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static UnsignedWord sizeFromCGroup() {
            assert (!Heap.getHeap().isAllocationDisallowed()) : "LinuxPhysicalMemory.PhysicalMemorySupportImpl.sizeFromCGroup: Allocation disallowed.";
            try (FileInputStream stream = new FileInputStream(cgroupMemoryFileName);){
                StringBuilder sb = new StringBuilder(32);
                int read = stream.read();
                while (read >= 48 && read <= 57) {
                    sb.append((char)read);
                    read = stream.read();
                }
                UnsignedWord unsignedWord = WordFactory.unsigned((long)Long.parseLong(sb.toString()));
                return unsignedWord;
            }
            catch (IOException | NumberFormatException e) {
                return UnsignedUtils.MAX_VALUE;
            }
        }
    }
}

