/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.monitor;

import com.oracle.svm.core.annotate.Uninterruptible;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;

public abstract class MonitorSupport {
    @Fold
    public static MonitorSupport singleton() {
        return (MonitorSupport)ImageSingletons.lookup(MonitorSupport.class);
    }

    public abstract void monitorEnter(Object var1);

    public abstract void monitorExit(Object var1);

    public abstract Object prepareRelockObject(Object var1);

    @Uninterruptible(reason="called during deoptimization")
    public abstract void doRelockObject(Object var1, Object var2);

    public abstract boolean holdsLock(Object var1);

    public final void wait(Object obj, long timeoutMillis) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (timeoutMillis < 0L) {
            throw new IllegalArgumentException("Timeout is negative.");
        }
        this.doWait(obj, timeoutMillis);
    }

    protected abstract void doWait(Object var1, long var2) throws InterruptedException;

    public abstract void notify(Object var1, boolean var2);

    public abstract int maybeAdjustNewParkStatus(int var1);
}

