/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.annotate.UnknownObjectField;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public class ImageHeapInfo {
    @UnknownObjectField(types={Object.class})
    public Object firstReadOnlyPrimitiveObject;
    @UnknownObjectField(types={Object.class})
    public Object lastReadOnlyPrimitiveObject;
    @UnknownObjectField(types={Object.class})
    public Object firstReadOnlyReferenceObject;
    @UnknownObjectField(types={Object.class})
    public Object lastReadOnlyReferenceObject;
    @UnknownObjectField(types={Object.class})
    public Object firstWritablePrimitiveObject;
    @UnknownObjectField(types={Object.class})
    public Object lastWritablePrimitiveObject;
    @UnknownObjectField(types={Object.class})
    public Object firstWritableReferenceObject;
    @UnknownObjectField(types={Object.class})
    public Object lastWritableReferenceObject;
    @UnknownObjectField(types={Object.class})
    public Object firstReadOnlyObject;
    @UnknownObjectField(types={Object.class})
    public Object lastReadOnlyObject;
    @UnknownObjectField(types={Object.class})
    public Object firstWritableObject;
    @UnknownObjectField(types={Object.class})
    public Object lastWritableObject;
    @UnknownObjectField(types={Object.class})
    public Object firstObject;
    @UnknownObjectField(types={Object.class})
    public Object lastObject;

    public void initialize(Object firstReadOnlyPrimitiveObject, Object lastReadOnlyPrimitiveObject, Object firstReadOnlyReferenceObject, Object lastReadOnlyReferenceObject, Object firstWritablePrimitiveObject, Object lastWritablePrimitiveObject, Object firstWritableReferenceObject, Object lastWritableReferenceObject) {
        this.firstReadOnlyPrimitiveObject = firstReadOnlyPrimitiveObject;
        this.lastReadOnlyPrimitiveObject = lastReadOnlyPrimitiveObject;
        this.firstReadOnlyReferenceObject = firstReadOnlyReferenceObject;
        this.lastReadOnlyReferenceObject = lastReadOnlyReferenceObject;
        this.firstWritablePrimitiveObject = firstWritablePrimitiveObject;
        this.lastWritablePrimitiveObject = lastWritablePrimitiveObject;
        this.firstWritableReferenceObject = firstWritableReferenceObject;
        this.lastWritableReferenceObject = lastWritableReferenceObject;
        this.firstReadOnlyObject = firstReadOnlyPrimitiveObject != null ? firstReadOnlyPrimitiveObject : firstReadOnlyReferenceObject;
        this.lastReadOnlyObject = lastReadOnlyReferenceObject != null ? lastReadOnlyReferenceObject : lastReadOnlyPrimitiveObject;
        this.firstWritableObject = firstWritablePrimitiveObject != null ? firstWritablePrimitiveObject : firstWritableReferenceObject;
        this.lastWritableObject = lastWritableReferenceObject != null ? lastWritableReferenceObject : lastWritablePrimitiveObject;
        this.firstObject = this.firstReadOnlyObject != null ? this.firstReadOnlyObject : this.firstWritableObject;
        this.lastObject = this.lastWritableObject != null ? this.lastWritableObject : this.lastReadOnlyObject;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInReadOnlyPrimitivePartition(Pointer ptr) {
        assert (ptr.isNonNull());
        return Word.objectToUntrackedPointer((Object)this.firstReadOnlyPrimitiveObject).belowOrEqual((UnsignedWord)ptr) && ptr.belowOrEqual((UnsignedWord)Word.objectToUntrackedPointer((Object)this.lastReadOnlyPrimitiveObject));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInWritablePrimitivePartition(Pointer ptr) {
        assert (ptr.isNonNull());
        return Word.objectToUntrackedPointer((Object)this.firstWritablePrimitiveObject).belowOrEqual((UnsignedWord)ptr) && ptr.belowOrEqual((UnsignedWord)Word.objectToUntrackedPointer((Object)this.lastWritablePrimitiveObject));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInReadOnlyReferencePartition(Pointer ptr) {
        assert (ptr.isNonNull());
        return Word.objectToUntrackedPointer((Object)this.firstReadOnlyReferenceObject).belowOrEqual((UnsignedWord)ptr) && ptr.belowOrEqual((UnsignedWord)Word.objectToUntrackedPointer((Object)this.lastReadOnlyReferenceObject));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInWritableReferencePartition(Pointer ptr) {
        assert (ptr.isNonNull());
        return Word.objectToUntrackedPointer((Object)this.firstWritableReferenceObject).belowOrEqual((UnsignedWord)ptr) && ptr.belowOrEqual((UnsignedWord)Word.objectToUntrackedPointer((Object)this.lastWritableReferenceObject));
    }

    public boolean isObjectInReadOnlyPrimitivePartition(Object obj) {
        return this.isInReadOnlyPrimitivePartition((Pointer)Word.objectToUntrackedPointer((Object)obj));
    }

    public boolean isObjectInWritablePrimitivePartition(Object obj) {
        return this.isInWritablePrimitivePartition((Pointer)Word.objectToUntrackedPointer((Object)obj));
    }

    public boolean isObjectInReadOnlyReferencePartition(Object obj) {
        return this.isInReadOnlyReferencePartition((Pointer)Word.objectToUntrackedPointer((Object)obj));
    }

    public boolean isObjectInWritableReferencePartition(Object obj) {
        return this.isInWritableReferencePartition((Pointer)Word.objectToUntrackedPointer((Object)obj));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInImageHeap(Pointer objectPointer) {
        boolean result;
        if (objectPointer.isNull()) {
            result = false;
        } else if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            result = objectPointer.aboveOrEqual((UnsignedWord)Word.objectToUntrackedPointer((Object)this.firstObject)) && objectPointer.belowOrEqual((UnsignedWord)Word.objectToUntrackedPointer((Object)this.lastObject));
        } else {
            boolean bl = result = objectPointer.aboveOrEqual((UnsignedWord)Word.objectToUntrackedPointer((Object)this.firstReadOnlyObject)) && objectPointer.belowOrEqual((UnsignedWord)Word.objectToUntrackedPointer((Object)this.lastReadOnlyObject)) || objectPointer.aboveOrEqual((UnsignedWord)Word.objectToUntrackedPointer((Object)this.firstWritableObject)) && objectPointer.belowOrEqual((UnsignedWord)Word.objectToUntrackedPointer((Object)this.lastWritableObject));
        }
        assert (result == this.isInImageHeapSlow(objectPointer));
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInImageHeapSlow(Pointer objectPointer) {
        boolean result = false;
        if (objectPointer.isNonNull()) {
            result |= this.isInReadOnlyPrimitivePartition(objectPointer);
            result |= this.isInReadOnlyReferencePartition(objectPointer);
            result |= this.isInWritablePrimitivePartition(objectPointer);
            result |= this.isInWritableReferencePartition(objectPointer);
        }
        return result;
    }
}

