/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.MemoryUtil;
import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.RuntimeCodeInfoMemory;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.CollectionPolicy;
import com.oracle.svm.core.genscavenge.FramePointerMapWalker;
import com.oracle.svm.core.genscavenge.GarbageCollectorManagementFactory;
import com.oracle.svm.core.genscavenge.GreyToBlackObjRefVisitor;
import com.oracle.svm.core.genscavenge.GreyToBlackObjectVisitor;
import com.oracle.svm.core.genscavenge.HeapChunkProvider;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapOptions;
import com.oracle.svm.core.genscavenge.HeapPolicy;
import com.oracle.svm.core.genscavenge.ImageHeapInfo;
import com.oracle.svm.core.genscavenge.Latch;
import com.oracle.svm.core.genscavenge.OldGeneration;
import com.oracle.svm.core.genscavenge.PinnedObjectImpl;
import com.oracle.svm.core.genscavenge.ReferenceObjectProcessing;
import com.oracle.svm.core.genscavenge.RuntimeCodeCacheCleaner;
import com.oracle.svm.core.genscavenge.RuntimeCodeCacheWalker;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.ThreadLocalAllocation;
import com.oracle.svm.core.genscavenge.ThreadLocalMTWalker;
import com.oracle.svm.core.genscavenge.YoungGeneration;
import com.oracle.svm.core.heap.AllocationFreeList;
import com.oracle.svm.core.heap.CollectionWatcher;
import com.oracle.svm.core.heap.GC;
import com.oracle.svm.core.heap.GCCause;
import com.oracle.svm.core.heap.NoAllocationVerifier;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.heap.ReferenceHandler;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.os.CommittedMemoryProvider;
import com.oracle.svm.core.snippets.ImplicitExceptions;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.JavaStackWalker;
import com.oracle.svm.core.stack.ThreadStackPrinter;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.JavaVMOperation;
import com.oracle.svm.core.thread.NativeVMOperation;
import com.oracle.svm.core.thread.NativeVMOperationData;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.TimeUtils;
import com.oracle.svm.core.util.VMError;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.ref.Reference;
import java.util.List;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class GCImpl
implements GC {
    private static final int DECIMALS_IN_TIME_PRINTING = 7;
    private final RememberedSetConstructor rememberedSetConstructor;
    private final GreyToBlackObjRefVisitor greyToBlackObjRefVisitor;
    private final FramePointerMapWalker frameWalker;
    private final GreyToBlackObjectVisitor greyToBlackObjectVisitor;
    private final CollectionPolicy collectOnlyCompletelyPolicy;
    private final Accounting accounting;
    private final CollectionVMOperation collectOperation;
    private final OutOfMemoryError oldGenerationSizeExceeded;
    private final AllocationFreeList<CollectionWatcher> collectionWatcherList;
    private final NoAllocationVerifier noAllocationVerifier;
    private final GarbageCollectorManagementFactory gcManagementFactory;
    private final ThreadLocalMTWalker threadLocalsWalker;
    private final RuntimeCodeCacheWalker runtimeCodeCacheWalker;
    private final RuntimeCodeCacheCleaner runtimeCodeCacheCleaner;
    private CollectionPolicy policy;
    private boolean completeCollection = false;
    private UnsignedWord sizeBefore;
    private final BlackenImageHeapRootsVisitor blackenImageHeapRootsVisitor = new BlackenImageHeapRootsVisitor();
    final Latch collectionInProgress;
    private UnsignedWord collectionEpoch;
    private final Timer blackenImageHeapRootsTimer;
    private final Timer blackenDirtyCardRootsTimer;
    private final Timer blackenStackRootsTimer;
    private final Timer cheneyScanFromRootsTimer;
    private final Timer cheneyScanFromDirtyRootsTimer;
    private final Timer collectionTimer;
    private final Timer referenceObjectsTimer;
    private final Timer promotePinnedObjectsTimer;
    private final Timer rootScanTimer;
    private final Timer scanGreyObjectsTimer;
    private final Timer releaseSpacesTimer;
    private final Timer verifyAfterTimer;
    private final Timer verifyBeforeTimer;
    private final Timer walkThreadLocalsTimer;
    private final Timer walkRuntimeCodeCacheTimer;
    private final Timer cleanRuntimeCodeCacheTimer;
    private final Timer watchersBeforeTimer;
    private final Timer watchersAfterTimer;
    private final Timer mutatorTimer;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected GCImpl(Feature.FeatureAccess access) {
        this.rememberedSetConstructor = new RememberedSetConstructor();
        this.accounting = Accounting.factory();
        this.collectOperation = new CollectionVMOperation();
        this.collectionEpoch = (UnsignedWord)WordFactory.zero();
        this.collectionWatcherList = AllocationFreeList.factory();
        this.noAllocationVerifier = NoAllocationVerifier.factory("GCImpl.GCImpl()", false);
        this.sizeBefore = (UnsignedWord)WordFactory.zero();
        this.policy = CollectionPolicy.getInitialPolicy(access);
        this.greyToBlackObjRefVisitor = new GreyToBlackObjRefVisitor();
        this.frameWalker = new FramePointerMapWalker(this.greyToBlackObjRefVisitor);
        this.greyToBlackObjectVisitor = new GreyToBlackObjectVisitor(this.greyToBlackObjRefVisitor);
        this.collectOnlyCompletelyPolicy = new CollectionPolicy.OnlyCompletely();
        this.collectionInProgress = Latch.factory("Collection in progress");
        this.oldGenerationSizeExceeded = new OutOfMemoryError("Garbage-collected heap size exceeded.");
        this.gcManagementFactory = new GarbageCollectorManagementFactory();
        this.threadLocalsWalker = GCImpl.createThreadLocalsWalker();
        this.runtimeCodeCacheWalker = new RuntimeCodeCacheWalker(this.greyToBlackObjRefVisitor);
        this.runtimeCodeCacheCleaner = new RuntimeCodeCacheCleaner();
        this.blackenImageHeapRootsTimer = new Timer("blackenImageHeapRootsTimer");
        this.blackenDirtyCardRootsTimer = new Timer("blackenDirtyCardRoots");
        this.blackenStackRootsTimer = new Timer("blackenStackRoots");
        this.cheneyScanFromRootsTimer = new Timer("cheneyScanFromRoots");
        this.cheneyScanFromDirtyRootsTimer = new Timer("cheneyScanFromDirtyRoots");
        this.collectionTimer = new Timer("collection");
        this.referenceObjectsTimer = new Timer("referenceObjects");
        this.releaseSpacesTimer = new Timer("releaseSpaces");
        this.promotePinnedObjectsTimer = new Timer("promotePinnedObjects");
        this.rootScanTimer = new Timer("rootScan");
        this.scanGreyObjectsTimer = new Timer("scanGreyObject");
        this.verifyAfterTimer = new Timer("verifyAfter");
        this.verifyBeforeTimer = new Timer("verifyBefore");
        this.watchersBeforeTimer = new Timer("watchersBefore");
        this.watchersAfterTimer = new Timer("watchersAfter");
        this.mutatorTimer = new Timer("Mutator");
        this.walkThreadLocalsTimer = new Timer("walkThreadLocals");
        this.walkRuntimeCodeCacheTimer = new Timer("walkRuntimeCodeCacheTimer");
        this.cleanRuntimeCodeCacheTimer = new Timer("cleanRuntimeCodeCacheTimer");
        RuntimeSupport.getRuntimeSupport().addShutdownHook(this::printGCSummary);
    }

    private static ThreadLocalMTWalker createThreadLocalsWalker() {
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            return new ThreadLocalMTWalker();
        }
        return null;
    }

    @Override
    public void collect(GCCause cause) {
        UnsignedWord requestingEpoch = this.possibleCollectionPrologue();
        this.collectWithoutAllocating(cause);
        this.possibleCollectionEpilogue(requestingEpoch);
    }

    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in the implementation of garbage collection.")
    void collectWithoutAllocating(GCCause cause) {
        int size = SizeOf.get(CollectionVMOperationData.class);
        CollectionVMOperationData data = (CollectionVMOperationData)StackValue.get((int)size);
        MemoryUtil.fillToMemoryAtomic((Pointer)data, WordFactory.unsigned((int)size), (byte)0);
        data.setNativeVMOperation(this.collectOperation);
        data.setCauseId(cause.getId());
        data.setRequestingEpoch(this.getCollectionEpoch());
        this.collectOperation.enqueue(data);
        if (data.getOutOfMemory()) {
            throw this.oldGenerationSizeExceeded;
        }
    }

    private boolean collectOperation(GCCause cause, UnsignedWord requestingEpoch) {
        Log trace = Log.noopLog().string("[GCImpl.collectOperation:").newline().string("  epoch: ").unsigned((WordBase)this.getCollectionEpoch()).string("  cause: ").string(cause.getName()).string("  requestingEpoch: ").unsigned((WordBase)requestingEpoch).newline();
        assert (VMOperation.isGCInProgress()) : "Collection should be a VMOperation.";
        assert (this.getCollectionEpoch().equal(requestingEpoch));
        this.mutatorTimer.close();
        this.startCollectionOrExit();
        this.resetTimers();
        this.incrementCollectionEpoch();
        ThreadLocalAllocation.disableThreadLocalAllocation();
        this.printGCBefore(cause.getName());
        this.scrubLists();
        this.visitWatchersBefore();
        boolean outOfMemory = this.collectImpl(cause.getName());
        this.visitWatchersAfter();
        HeapPolicy.youngUsedBytes.set(this.getAccounting().getYoungChunkBytesAfter());
        this.printGCAfter(cause.getName());
        this.finishCollection();
        this.mutatorTimer.open();
        trace.string("]").newline();
        return outOfMemory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean collectImpl(String cause) {
        boolean outOfMemory;
        Throwable throwable;
        Log trace;
        block40: {
            trace = Log.noopLog().string("[GCImpl.collectImpl:").newline().string("  epoch: ").unsigned((WordBase)this.getCollectionEpoch()).string("  cause: ").string(cause).newline();
            GCImpl.precondition();
            trace.string("  Begin collection: ");
            throwable = null;
            try (NoAllocationVerifier nav = this.noAllocationVerifier.open();){
                trace.string("  Verify before: ");
                try (Timer vbt = this.verifyBeforeTimer.open();){
                    HeapImpl.getHeapImpl().verifyBeforeGC(cause, this.getCollectionEpoch());
                }
                outOfMemory = this.doCollectImpl(this.getPolicy());
                if (!outOfMemory) break block40;
                ReferenceObjectProcessing.setSoftReferencesAreWeak(true);
                try {
                    outOfMemory = this.doCollectImpl(this.collectOnlyCompletelyPolicy);
                }
                finally {
                    ReferenceObjectProcessing.setSoftReferencesAreWeak(false);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        trace.string("  Verify after: ");
        throwable = null;
        try (Timer vat = this.verifyAfterTimer.open();){
            HeapImpl.getHeapImpl().verifyAfterGC(cause, this.getCollectionEpoch());
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        this.postcondition();
        trace.string("]").newline();
        return outOfMemory;
    }

    private boolean doCollectImpl(CollectionPolicy appliedPolicy) {
        CommittedMemoryProvider.get().beforeGarbageCollection();
        this.getAccounting().beforeCollection();
        try (Timer ct = this.collectionTimer.open();){
            if (appliedPolicy.collectIncrementally()) {
                this.scavenge(true);
            }
            this.completeCollection = appliedPolicy.collectCompletely();
            if (this.completeCollection) {
                this.scavenge(false);
            }
        }
        CommittedMemoryProvider.get().afterGarbageCollection(this.completeCollection);
        this.getAccounting().afterCollection(this.completeCollection, this.collectionTimer);
        UnsignedWord maxBytes = HeapPolicy.getMaximumHeapSize();
        UnsignedWord usedBytes = this.getChunkUsedBytesAfterCollection();
        boolean outOfMemory = usedBytes.aboveThan(maxBytes);
        ReferenceObjectProcessing.afterCollection(usedBytes, maxBytes);
        return outOfMemory;
    }

    private void printGCBefore(String cause) {
        Log verboseGCLog = Log.log();
        HeapImpl heap = HeapImpl.getHeapImpl();
        UnsignedWord unsignedWord = this.sizeBefore = SubstrateOptions.PrintGC.getValue() != false || HeapOptions.PrintHeapShape.getValue() != false ? heap.getUsedChunkBytes() : (UnsignedWord)WordFactory.zero();
        if (SubstrateOptions.VerboseGC.getValue().booleanValue() && this.getCollectionEpoch().equal(1)) {
            verboseGCLog.string("[Heap policy parameters: ").newline();
            verboseGCLog.string("  YoungGenerationSize: ").unsigned((WordBase)HeapPolicy.getMaximumYoungGenerationSize()).newline();
            verboseGCLog.string("      MaximumHeapSize: ").unsigned((WordBase)HeapPolicy.getMaximumHeapSize()).newline();
            verboseGCLog.string("      MinimumHeapSize: ").unsigned((WordBase)HeapPolicy.getMinimumHeapSize()).newline();
            verboseGCLog.string("     AlignedChunkSize: ").unsigned((WordBase)HeapPolicy.getAlignedHeapChunkSize()).newline();
            verboseGCLog.string("  LargeArrayThreshold: ").unsigned((WordBase)HeapPolicy.getLargeArrayThreshold()).string("]").newline();
            if (HeapOptions.PrintHeapShape.getValue().booleanValue()) {
                HeapImpl.getHeapImpl().logImageHeapPartitionBoundaries(verboseGCLog).newline();
            }
        }
        if (SubstrateOptions.VerboseGC.getValue().booleanValue()) {
            verboseGCLog.string("[");
            verboseGCLog.string("[");
            long startTime = System.nanoTime();
            if (HeapOptions.PrintGCTimeStamps.getValue().booleanValue()) {
                verboseGCLog.unsigned(TimeUtils.roundNanosToMillis(Timer.getTimeSinceFirstAllocation(startTime))).string(" msec: ");
            } else {
                verboseGCLog.unsigned(startTime);
            }
            verboseGCLog.string(" GC:").string(" before").string("  epoch: ").unsigned((WordBase)this.getCollectionEpoch()).string("  cause: ").string(cause);
            if (HeapOptions.PrintHeapShape.getValue().booleanValue()) {
                heap.report(verboseGCLog);
            }
            verboseGCLog.string("]").newline();
        }
    }

    private void printGCAfter(String cause) {
        Log verboseGCLog = Log.log();
        HeapImpl heap = HeapImpl.getHeapImpl();
        if (SubstrateOptions.PrintGC.getValue().booleanValue() || SubstrateOptions.VerboseGC.getValue().booleanValue()) {
            if (SubstrateOptions.PrintGC.getValue().booleanValue()) {
                Log printGCLog = Log.log();
                UnsignedWord sizeAfter = heap.getUsedChunkBytes();
                printGCLog.string("[");
                if (HeapOptions.PrintGCTimeStamps.getValue().booleanValue()) {
                    long finishNanos = this.collectionTimer.getFinish();
                    printGCLog.unsigned(TimeUtils.roundNanosToMillis(Timer.getTimeSinceFirstAllocation(finishNanos))).string(" msec: ");
                }
                printGCLog.string(this.completeCollection ? "Full GC" : "Incremental GC");
                printGCLog.string(" (").string(cause).string(") ");
                printGCLog.unsigned((WordBase)this.sizeBefore.unsignedDivide(1024));
                printGCLog.string("K->");
                printGCLog.unsigned((WordBase)sizeAfter.unsignedDivide(1024)).string("K, ");
                printGCLog.rational(this.collectionTimer.getCollectedNanos(), 1000000000L, 7L).string(" secs");
                printGCLog.string("]").newline();
            }
            if (SubstrateOptions.VerboseGC.getValue().booleanValue()) {
                verboseGCLog.string(" [");
                long finishNanos = this.collectionTimer.getFinish();
                if (HeapOptions.PrintGCTimeStamps.getValue().booleanValue()) {
                    verboseGCLog.unsigned(TimeUtils.roundNanosToMillis(Timer.getTimeSinceFirstAllocation(finishNanos))).string(" msec: ");
                } else {
                    verboseGCLog.unsigned(finishNanos);
                }
                verboseGCLog.string(" GC:").string(" after ").string("  epoch: ").unsigned((WordBase)this.getCollectionEpoch()).string("  cause: ").string(cause);
                verboseGCLog.string("  policy: ");
                this.getPolicy().nameToLog(verboseGCLog);
                verboseGCLog.string("  type: ").string(this.completeCollection ? "complete" : "incremental");
                if (HeapOptions.PrintHeapShape.getValue().booleanValue()) {
                    heap.report(verboseGCLog);
                }
                if (!HeapOptions.PrintGCTimes.getValue().booleanValue()) {
                    verboseGCLog.newline();
                    verboseGCLog.string("  collection time: ").unsigned(this.collectionTimer.getCollectedNanos()).string(" nanoSeconds");
                } else {
                    this.logGCTimers(verboseGCLog);
                }
                verboseGCLog.string("]");
                verboseGCLog.string("]").newline();
            }
        }
    }

    private static void precondition() {
        HeapImpl heap = HeapImpl.getHeapImpl();
        OldGeneration oldGen = heap.getOldGeneration();
        assert (oldGen.getToSpace().isEmpty()) : "oldGen.getToSpace() should be empty before a collection.";
    }

    private void postcondition() {
        HeapImpl heap = HeapImpl.getHeapImpl();
        YoungGeneration youngGen = heap.getYoungGeneration();
        OldGeneration oldGen = heap.getOldGeneration();
        this.verbosePostCondition();
        assert (youngGen.getEden().isEmpty()) : "youngGen.getEden() should be empty after a collection.";
        assert (oldGen.getToSpace().isEmpty()) : "oldGen.getToSpace() should be empty after a collection.";
    }

    private void verbosePostCondition() {
        HeapImpl heap = HeapImpl.getHeapImpl();
        YoungGeneration youngGen = heap.getYoungGeneration();
        OldGeneration oldGen = heap.getOldGeneration();
        boolean forceForTesting = false;
        if (GCImpl.runtimeAssertions()) {
            Log witness = Log.log();
            if (!youngGen.getEden().isEmpty()) {
                witness.string("[GCImpl.postcondition: Eden space should be empty after a collection.").newline();
                witness.string("  These should all be 0:").newline();
                witness.string("    Eden space first AlignedChunk:   ").hex((WordBase)youngGen.getEden().getFirstAlignedHeapChunk()).newline();
                witness.string("    Eden space last  AlignedChunk:   ").hex((WordBase)youngGen.getEden().getLastAlignedHeapChunk()).newline();
                witness.string("    Eden space first UnalignedChunk: ").hex((WordBase)youngGen.getEden().getFirstUnalignedHeapChunk()).newline();
                witness.string("    Eden space last  UnalignedChunk: ").hex((WordBase)youngGen.getEden().getLastUnalignedHeapChunk()).newline();
                youngGen.getEden().report(witness, true).newline();
                witness.string("  verifying the heap:");
                heap.verifyAfterGC("because Eden space is not empty", this.getCollectionEpoch());
                witness.string("]").newline();
            }
            for (int i = 0; i < HeapPolicy.getMaxSurvivorSpaces(); ++i) {
                if (youngGen.getSurvivorToSpaceAt(i).isEmpty()) continue;
                witness.string("[GCImpl.postcondition: Survivor toSpace should be empty after a collection.").newline();
                witness.string("  These should all be 0:").newline();
                witness.string("    Survivor space ").signed(i).string(" first AlignedChunk:   ").hex((WordBase)youngGen.getSurvivorToSpaceAt(i).getFirstAlignedHeapChunk()).newline();
                witness.string("    Survivor space ").signed(i).string(" last  AlignedChunk:   ").hex((WordBase)youngGen.getSurvivorToSpaceAt(i).getLastAlignedHeapChunk()).newline();
                witness.string("    Survivor space ").signed(i).string(" first UnalignedChunk: ").hex((WordBase)youngGen.getSurvivorToSpaceAt(i).getFirstUnalignedHeapChunk()).newline();
                witness.string("    Survivor space ").signed(i).string(" last  UnalignedChunk: ").hex((WordBase)youngGen.getSurvivorToSpaceAt(i).getLastUnalignedHeapChunk()).newline();
                youngGen.getSurvivorToSpaceAt(i).report(witness, true).newline();
                witness.string("  verifying the heap:");
                heap.verifyAfterGC("because Survivor toSpace is not empty", this.getCollectionEpoch());
                witness.string("]").newline();
            }
            if (!oldGen.getToSpace().isEmpty()) {
                witness.string("[GCImpl.postcondition: oldGen toSpace should be empty after a collection.").newline();
                witness.string("  These should all be 0:").newline();
                witness.string("    oldGen toSpace first AlignedChunk:   ").hex((WordBase)oldGen.getToSpace().getFirstAlignedHeapChunk()).newline();
                witness.string("    oldGen toSpace last  AlignedChunk:   ").hex((WordBase)oldGen.getToSpace().getLastAlignedHeapChunk()).newline();
                witness.string("    oldGen.toSpace first UnalignedChunk: ").hex((WordBase)oldGen.getToSpace().getFirstUnalignedHeapChunk()).newline();
                witness.string("    oldGen.toSpace last  UnalignedChunk: ").hex((WordBase)oldGen.getToSpace().getLastUnalignedHeapChunk()).newline();
                oldGen.getToSpace().report(witness, true).newline();
                oldGen.getFromSpace().report(witness, true).newline();
                witness.string("  verifying the heap:");
                heap.verifyAfterGC("because oldGen toSpace is not empty", this.getCollectionEpoch());
                witness.string("]").newline();
            }
        }
    }

    private UnsignedWord getChunkUsedBytesAfterCollection() {
        UnsignedWord survivorUsedBytes = HeapImpl.getHeapImpl().getYoungGeneration().getSurvivorChunkUsedBytes();
        return this.getAccounting().getOldGenerationAfterChunkBytes().add(survivorUsedBytes);
    }

    @Fold
    static boolean runtimeAssertions() {
        return SubstrateOptions.getRuntimeAssertionsForClass(GCImpl.class.getName());
    }

    @Fold
    public static GCImpl getGCImpl() {
        GCImpl gcImpl = HeapImpl.getHeapImpl().getGCImpl();
        assert (gcImpl != null);
        return gcImpl;
    }

    @Override
    public void collectCompletely(GCCause cause) {
        CollectionPolicy oldPolicy = this.getPolicy();
        try {
            this.setPolicy(this.collectOnlyCompletelyPolicy);
            this.collect(cause);
        }
        finally {
            this.setPolicy(oldPolicy);
        }
    }

    boolean isCompleteCollection() {
        return this.completeCollection;
    }

    private void scavenge(boolean fromDirtyRoots) {
        try (GreyToBlackObjRefVisitor.Counters gtborv = this.greyToBlackObjRefVisitor.openCounters();){
            Log trace = Log.noopLog().string("[GCImpl.scavenge:").string("  fromDirtyRoots: ").bool(fromDirtyRoots).newline();
            try (Timer rst = this.rootScanTimer.open();){
                trace.string("  Cheney scan: ");
                if (fromDirtyRoots) {
                    this.cheneyScanFromDirtyRoots();
                } else {
                    this.cheneyScanFromRoots();
                }
            }
            trace.string("  Discovered references: ");
            var6_8 = null;
            try (Timer drt = this.referenceObjectsTimer.open();){
                Reference<?> newlyPendingList = ReferenceObjectProcessing.processRememberedReferences();
                HeapImpl.getHeapImpl().addToReferencePendingList(newlyPendingList);
            }
            catch (Throwable throwable) {
                var6_8 = throwable;
                throw throwable;
            }
            trace.string("  Release spaces: ");
            rst = this.releaseSpacesTimer.open();
            var6_8 = null;
            try {
                this.releaseSpaces();
            }
            catch (Throwable throwable) {
                var6_8 = throwable;
                throw throwable;
            }
            finally {
                if (rst != null) {
                    if (var6_8 != null) {
                        try {
                            rst.close();
                        }
                        catch (Throwable throwable) {
                            var6_8.addSuppressed(throwable);
                        }
                    } else {
                        rst.close();
                    }
                }
            }
            trace.string("  Swap spaces: ");
            GCImpl.swapSpaces();
            trace.string("]").newline();
        }
    }

    private void walkRuntimeCodeCache() {
        try (Timer wrm = this.walkRuntimeCodeCacheTimer.open();){
            RuntimeCodeInfoMemory.singleton().walkRuntimeMethods(this.runtimeCodeCacheWalker);
        }
    }

    private void cleanRuntimeCodeCache() {
        try (Timer wrm = this.cleanRuntimeCodeCacheTimer.open();){
            RuntimeCodeInfoMemory.singleton().walkRuntimeMethods(this.runtimeCodeCacheCleaner);
        }
    }

    private void cheneyScanFromRoots() {
        Log trace = Log.noopLog().string("[GCImpl.cheneyScanFromRoots:").newline();
        try (Timer csfrt = this.cheneyScanFromRootsTimer.open();){
            GCImpl.prepareForPromotion(false);
            this.promoteIndividualPinnedObjects();
            this.blackenStackRoots();
            this.walkThreadLocals();
            this.blackenImageHeapRoots();
            this.scanGreyObjects(false);
            if (DeoptimizationSupport.enabled()) {
                this.walkRuntimeCodeCache();
                this.scanGreyObjects(false);
                this.cleanRuntimeCodeCache();
            }
            this.greyToBlackObjectVisitor.reset();
        }
        trace.string("]").newline();
    }

    private void cheneyScanFromDirtyRoots() {
        Log trace = Log.noopLog().string("[GCImpl.cheneyScanFromDirtyRoots:").newline();
        HeapImpl heap = HeapImpl.getHeapImpl();
        OldGeneration oldGen = heap.getOldGeneration();
        try (Timer csfdrt = this.cheneyScanFromDirtyRootsTimer.open();){
            oldGen.emptyFromSpaceIntoToSpace();
            GCImpl.prepareForPromotion(true);
            this.promoteIndividualPinnedObjects();
            this.blackenDirtyCardRoots();
            this.blackenStackRoots();
            this.walkThreadLocals();
            this.blackenImageHeapRoots();
            this.scanGreyObjects(true);
            if (DeoptimizationSupport.enabled()) {
                this.walkRuntimeCodeCache();
                this.scanGreyObjects(true);
                this.cleanRuntimeCodeCache();
            }
            this.greyToBlackObjectVisitor.reset();
        }
        trace.string("]").newline();
    }

    private void promoteIndividualPinnedObjects() {
        Log trace = Log.noopLog().string("[GCImpl.promoteIndividualPinnedObjects:").newline();
        try (Timer ppot = this.promotePinnedObjectsTimer.open();){
            PinnedObjectImpl oldList;
            PinnedObjectImpl rest = oldList = PinnedObjectImpl.claimPinnedObjectList();
            while (rest != null) {
                PinnedObjectImpl first = rest;
                PinnedObjectImpl next = first.getNext();
                if (first.isOpen()) {
                    GCImpl.promotePinnedObject(first);
                    PinnedObjectImpl.pushPinnedObject(first);
                }
                rest = next;
            }
        }
        trace.string("]").newline();
    }

    @NeverInline(value="Starting a stack walk in the caller frame. Note that we could start the stack frame also further down the stack, because GC stack frames must not access any objects that are processed by the GC. But we don't store stack frame information for the first frame we would need to process.")
    private void blackenStackRoots() {
        Log trace = Log.noopLog().string("[GCImpl.blackenStackRoots:").newline();
        try (Timer bsr = this.blackenStackRootsTimer.open();){
            Pointer sp = KnownIntrinsics.readCallerStackPointer();
            trace.string("[blackenStackRoots:").string("  sp: ").hex((WordBase)sp);
            CodePointer ip = KnownIntrinsics.readReturnAddress();
            trace.string("  ip: ").hex((WordBase)ip).newline();
            this.blackenCurrentStack(sp);
            if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
                IsolateThread vmThread = VMThreads.firstThread();
                while (vmThread.isNonNull()) {
                    if (vmThread != CurrentIsolate.getCurrentThread()) {
                        this.blackenStack(vmThread);
                        trace.newline();
                    }
                    vmThread = VMThreads.nextThread(vmThread);
                }
            }
            trace.string("]").newline();
        }
        trace.string("]").newline();
    }

    @Uninterruptible(reason="Avoid the virtual call to the visitor.")
    private void blackenStack(IsolateThread vmThread) {
        JavaStackWalker.walkThreadInline(vmThread, this.frameWalker);
    }

    @Uninterruptible(reason="Avoid the virtual call to the visitor.")
    private void blackenCurrentStack(Pointer sp) {
        JavaStackWalker.walkCurrentThreadInline(sp, this.frameWalker);
    }

    private void walkThreadLocals() {
        Log trace = Log.noopLog().string("[walkRegisteredObjectReferences").string(":").newline();
        if (this.threadLocalsWalker != null) {
            try (Timer wrm = this.walkThreadLocalsTimer.open();){
                trace.string("[ThreadLocalsWalker:").newline();
                this.threadLocalsWalker.walk(this.greyToBlackObjRefVisitor);
                trace.string("]").newline();
            }
        }
        trace.string("]").newline();
    }

    private void blackenImageHeapRoots() {
        Log trace = Log.noopLog().string("[blackenImageHeapRoots:").newline();
        HeapImpl.getHeapImpl().walkNativeImageHeapRegions(this.blackenImageHeapRootsVisitor);
        trace.string("]").newline();
    }

    private void blackenDirtyCardRoots() {
        Log trace = Log.noopLog().string("[GCImpl.blackenDirtyCardRoots:").newline();
        try (Timer bdcrt = this.blackenDirtyCardRootsTimer.open();){
            HeapImpl heap = HeapImpl.getHeapImpl();
            heap.getOldGeneration().walkDirtyObjects(this.greyToBlackObjectVisitor, true);
        }
        trace.string("]").newline();
    }

    private static void prepareForPromotion(boolean isIncremental) {
        Log trace = Log.noopLog().string("[GCImpl.prepareForPromotion:").newline();
        HeapImpl heap = HeapImpl.getHeapImpl();
        OldGeneration oldGen = heap.getOldGeneration();
        oldGen.prepareForPromotion();
        if (isIncremental) {
            heap.getYoungGeneration().prepareForPromotion();
        }
        trace.string("]").newline();
    }

    private void scanGreyObjects(boolean isIncremental) {
        Log trace = Log.noopLog().string("[GCImpl.scanGreyObjects").newline();
        HeapImpl heap = HeapImpl.getHeapImpl();
        OldGeneration oldGen = heap.getOldGeneration();
        try (Timer sgot = this.scanGreyObjectsTimer.open();){
            if (isIncremental) {
                GCImpl.scanGreyObjectsLoop();
            } else {
                oldGen.scanGreyObjects();
            }
        }
        trace.string("]").newline();
    }

    private static void scanGreyObjectsLoop() {
        Log trace = Log.noopLog().string("[GCImpl.scanGreyObjectsLoop").newline();
        HeapImpl heap = HeapImpl.getHeapImpl();
        YoungGeneration youngGen = heap.getYoungGeneration();
        OldGeneration oldGen = heap.getOldGeneration();
        for (boolean hasGrey = true; hasGrey; hasGrey |= oldGen.scanGreyObjects()) {
            hasGrey = youngGen.scanGreyObjects();
        }
        trace.string("]").newline();
    }

    private static void promotePinnedObject(PinnedObjectImpl pinned) {
        Log trace = Log.noopLog().string("[GCImpl.promotePinnedObject").string("  pinned: ").object(pinned);
        HeapImpl heap = HeapImpl.getHeapImpl();
        OldGeneration oldGen = heap.getOldGeneration();
        Object referent = pinned.getObject();
        if (referent != null && !heap.isInImageHeap(referent)) {
            trace.string("  referent: ").object(referent);
            oldGen.promoteObjectChunk(referent);
        }
        trace.string("]").newline();
    }

    private static void swapSpaces() {
        Log trace = Log.noopLog().string("[GCImpl.swapSpaces:");
        HeapImpl heap = HeapImpl.getHeapImpl();
        OldGeneration oldGen = heap.getOldGeneration();
        heap.getYoungGeneration().swapSpaces();
        oldGen.swapSpaces();
        trace.string("]").newline();
    }

    private void releaseSpaces() {
        Log trace = Log.noopLog().string("[GCImpl.releaseSpaces:");
        HeapImpl heap = HeapImpl.getHeapImpl();
        heap.getYoungGeneration().releaseSpaces();
        if (this.completeCollection) {
            heap.getOldGeneration().releaseSpaces();
        }
        trace.string("]").newline();
    }

    private void startCollectionOrExit() {
        CollectionInProgressError.exitIf(this.collectionInProgress.getState());
        this.collectionInProgress.open();
    }

    private void finishCollection() {
        this.collectionInProgress.close();
    }

    UnsignedWord possibleCollectionPrologue() {
        return this.getCollectionEpoch();
    }

    void possibleCollectionEpilogue(UnsignedWord requestingEpoch) {
        if (requestingEpoch.aboveOrEqual(this.getCollectionEpoch())) {
            return;
        }
        if (VMOperation.isInProgress()) {
            return;
        }
        if (!JavaThreads.currentJavaThreadInitialized()) {
            return;
        }
        Timer refsTimer = new Timer("Enqueuing pending references and invoking internal cleaners");
        try (Timer timer = refsTimer.open();){
            ReferenceHandler.maybeProcessCurrentlyPending();
        }
        if (SubstrateOptions.VerboseGC.getValue().booleanValue() && HeapOptions.PrintGCTimes.getValue().booleanValue()) {
            GCImpl.logOneTimer(Log.log(), "[GC epilogue reference processing: ", refsTimer);
            Log.log().string("]");
        }
        this.visitWatchersReport();
    }

    UnsignedWord getCollectionEpoch() {
        return this.collectionEpoch;
    }

    private void incrementCollectionEpoch() {
        this.collectionEpoch = this.collectionEpoch.add(1);
    }

    @Override
    public void registerCollectionWatcher(CollectionWatcher watcher) throws AllocationFreeList.PreviouslyRegisteredElementException {
        if (watcher.getHasBeenOnList()) {
            throw new AllocationFreeList.PreviouslyRegisteredElementException("Attempting to reuse a previously-registered CollectionWatcher.");
        }
        this.collectionWatcherList.prepend(watcher);
    }

    @Override
    public void unregisterCollectionWatcher(CollectionWatcher watcher) {
        watcher.removeElement();
    }

    private void visitWatchersBefore() {
        Log trace = Log.noopLog().string("[GCImpl.visitWatchersBefore:").newline();
        trace.string("  Watchers before: ");
        try (Timer wbt = this.watchersBeforeTimer.open();){
            for (CollectionWatcher watcher = this.collectionWatcherList.getFirst(); watcher != null; watcher = (CollectionWatcher)watcher.getNextElement()) {
                try {
                    watcher.beforeCollection();
                    continue;
                }
                catch (Throwable t) {
                    trace.string("[GCImpl.visitWatchersBefore: Caught: ").string(t.getClass().getName()).string("]").newline();
                }
            }
        }
        trace.string("]").newline();
    }

    private void visitWatchersAfter() {
        Log trace = Log.noopLog().string("[GCImpl.visitWatchersAfter:").newline();
        trace.string("  Watchers after: ");
        try (Timer wat = this.watchersAfterTimer.open();){
            for (CollectionWatcher watcher = this.collectionWatcherList.getFirst(); watcher != null; watcher = (CollectionWatcher)watcher.getNextElement()) {
                try {
                    watcher.afterCollection();
                    continue;
                }
                catch (Throwable t) {
                    trace.string("[GCImpl.visitWatchersAfter: Caught: ").string(t.getClass().getName()).string("]").newline();
                }
            }
        }
        trace.string("]").newline();
    }

    private void visitWatchersReport() {
        Log trace = Log.noopLog().string("[GCImpl.visitWatchersReport:").newline();
        JavaVMOperation.enqueueBlockingNoSafepoint("GCImpl.visitWatchersReport", () -> {
            for (CollectionWatcher watcher = this.collectionWatcherList.getFirst(); watcher != null; watcher = (CollectionWatcher)watcher.getNextElement()) {
                try {
                    watcher.report();
                    continue;
                }
                catch (Throwable t) {
                    trace.string("[GCImpl.visitWatchersReport: Caught: ").string(t.getClass().getName()).string("]").newline();
                }
            }
        });
        trace.string("]").newline();
    }

    private void scrubLists() {
        this.collectionWatcherList.scrub();
    }

    protected Accounting getAccounting() {
        return this.accounting;
    }

    private CollectionPolicy getPolicy() {
        return this.policy;
    }

    private void setPolicy(CollectionPolicy newPolicy) {
        this.policy = newPolicy;
    }

    GreyToBlackObjectVisitor getGreyToBlackObjectVisitor() {
        return this.greyToBlackObjectVisitor;
    }

    private void resetTimers() {
        Log trace = Log.noopLog();
        trace.string("[GCImpl.resetTimers:");
        this.watchersBeforeTimer.reset();
        this.verifyBeforeTimer.reset();
        this.collectionTimer.reset();
        this.rootScanTimer.reset();
        this.cheneyScanFromRootsTimer.reset();
        this.cheneyScanFromDirtyRootsTimer.reset();
        this.promotePinnedObjectsTimer.reset();
        this.blackenStackRootsTimer.reset();
        this.walkThreadLocalsTimer.reset();
        this.walkRuntimeCodeCacheTimer.reset();
        this.cleanRuntimeCodeCacheTimer.reset();
        this.blackenImageHeapRootsTimer.reset();
        this.blackenDirtyCardRootsTimer.reset();
        this.scanGreyObjectsTimer.reset();
        this.referenceObjectsTimer.reset();
        this.releaseSpacesTimer.reset();
        this.verifyAfterTimer.reset();
        this.watchersAfterTimer.reset();
        trace.string("]").newline();
    }

    private void logGCTimers(Log log) {
        if (log.isEnabled()) {
            log.newline();
            log.string("  [GC nanoseconds:");
            GCImpl.logOneTimer(log, "    ", this.watchersBeforeTimer);
            GCImpl.logOneTimer(log, "    ", this.verifyBeforeTimer);
            GCImpl.logOneTimer(log, "    ", this.collectionTimer);
            GCImpl.logOneTimer(log, "      ", this.rootScanTimer);
            GCImpl.logOneTimer(log, "        ", this.cheneyScanFromRootsTimer);
            GCImpl.logOneTimer(log, "        ", this.cheneyScanFromDirtyRootsTimer);
            GCImpl.logOneTimer(log, "          ", this.promotePinnedObjectsTimer);
            GCImpl.logOneTimer(log, "          ", this.blackenStackRootsTimer);
            GCImpl.logOneTimer(log, "          ", this.walkThreadLocalsTimer);
            GCImpl.logOneTimer(log, "          ", this.walkRuntimeCodeCacheTimer);
            GCImpl.logOneTimer(log, "          ", this.cleanRuntimeCodeCacheTimer);
            GCImpl.logOneTimer(log, "          ", this.blackenImageHeapRootsTimer);
            GCImpl.logOneTimer(log, "          ", this.blackenDirtyCardRootsTimer);
            GCImpl.logOneTimer(log, "          ", this.scanGreyObjectsTimer);
            GCImpl.logOneTimer(log, "      ", this.referenceObjectsTimer);
            GCImpl.logOneTimer(log, "      ", this.releaseSpacesTimer);
            GCImpl.logOneTimer(log, "    ", this.verifyAfterTimer);
            GCImpl.logOneTimer(log, "    ", this.watchersAfterTimer);
            GCImpl.logGCLoad(log, "    ", "GCLoad", this.collectionTimer, this.mutatorTimer);
            log.string("]");
        }
    }

    private static void logOneTimer(Log log, String prefix, Timer timer) {
        if (timer.getCollectedNanos() > 0L) {
            log.newline().string(prefix).string(timer.getName()).string(": ").signed(timer.getCollectedNanos());
        }
    }

    private static void logGCLoad(Log log, String prefix, String label, Timer cTimer, Timer mTimer) {
        long collectionNanos = cTimer.getLastIntervalNanos();
        long mutatorNanos = mTimer.getLastIntervalNanos();
        long intervalNanos = mutatorNanos + collectionNanos;
        long intervalGCPercent = (100L * collectionNanos + intervalNanos / 2L) / intervalNanos;
        log.newline().string(prefix).string(label).string(": ").signed(intervalGCPercent).string("%");
    }

    RememberedSetConstructor getRememberedSetConstructor() {
        return this.rememberedSetConstructor;
    }

    private void printGCSummary() {
        if (!HeapOptions.PrintGCSummary.getValue().booleanValue()) {
            return;
        }
        Log log = Log.log();
        String prefix = "PrintGCSummary: ";
        log.string("PrintGCSummary: ").string("YoungGenerationSize: ").unsigned((WordBase)HeapPolicy.getMaximumYoungGenerationSize()).newline();
        log.string("PrintGCSummary: ").string("MinimumHeapSize: ").unsigned((WordBase)HeapPolicy.getMinimumHeapSize()).newline();
        log.string("PrintGCSummary: ").string("MaximumHeapSize: ").unsigned((WordBase)HeapPolicy.getMaximumHeapSize()).newline();
        log.string("PrintGCSummary: ").string("AlignedChunkSize: ").unsigned((WordBase)HeapPolicy.getAlignedHeapChunkSize()).newline();
        JavaVMOperation.enqueueBlockingSafepoint("PrintGCSummaryShutdownHook", ThreadLocalAllocation::disableThreadLocalAllocation);
        HeapImpl heap = HeapImpl.getHeapImpl();
        Space edenSpace = heap.getYoungGeneration().getEden();
        UnsignedWord youngChunkBytes = edenSpace.getChunkBytes();
        UnsignedWord youngObjectBytes = edenSpace.getObjectBytes();
        UnsignedWord allocatedNormalChunkBytes = this.accounting.getNormalChunkBytes().add(youngChunkBytes);
        UnsignedWord allocatedNormalObjectBytes = this.accounting.getNormalObjectBytes().add(youngObjectBytes);
        log.string("PrintGCSummary: ").string("CollectedTotalChunkBytes: ").signed((WordBase)this.accounting.getCollectedTotalChunkBytes()).newline();
        log.string("PrintGCSummary: ").string("CollectedTotalObjectBytes: ").signed((WordBase)this.accounting.getCollectedTotalObjectBytes()).newline();
        log.string("PrintGCSummary: ").string("AllocatedNormalChunkBytes: ").signed((WordBase)allocatedNormalChunkBytes).newline();
        log.string("PrintGCSummary: ").string("AllocatedNormalObjectBytes: ").signed((WordBase)allocatedNormalObjectBytes).newline();
        long incrementalNanos = this.accounting.getIncrementalCollectionTotalNanos();
        log.string("PrintGCSummary: ").string("IncrementalGCCount: ").signed(this.accounting.getIncrementalCollectionCount()).newline();
        log.string("PrintGCSummary: ").string("IncrementalGCNanos: ").signed(incrementalNanos).newline();
        long completeNanos = this.accounting.getCompleteCollectionTotalNanos();
        log.string("PrintGCSummary: ").string("CompleteGCCount: ").signed(this.accounting.getCompleteCollectionCount()).newline();
        log.string("PrintGCSummary: ").string("CompleteGCNanos: ").signed(completeNanos).newline();
        long gcNanos = incrementalNanos + completeNanos;
        long mutatorNanos = this.mutatorTimer.getCollectedNanos();
        long totalNanos = gcNanos + mutatorNanos;
        long roundedGCLoad = 0L < totalNanos ? TimeUtils.roundedDivide(100L * gcNanos, totalNanos) : 0L;
        log.string("PrintGCSummary: ").string("GCNanos: ").signed(gcNanos).newline();
        log.string("PrintGCSummary: ").string("TotalNanos: ").signed(totalNanos).newline();
        log.string("PrintGCSummary: ").string("GCLoadPercent: ").signed(roundedGCLoad).newline();
    }

    @Override
    public List<GarbageCollectorMXBean> getGarbageCollectorMXBeanList() {
        return this.gcManagementFactory.getGCBeanList();
    }

    @RawStructure
    private static interface CollectionVMOperationData
    extends NativeVMOperationData {
        @RawField
        public int getCauseId();

        @RawField
        public void setCauseId(int var1);

        @RawField
        public UnsignedWord getRequestingEpoch();

        @RawField
        public void setRequestingEpoch(UnsignedWord var1);

        @RawField
        public boolean getOutOfMemory();

        @RawField
        public void setOutOfMemory(boolean var1);
    }

    private static class CollectionVMOperation
    extends NativeVMOperation {
        protected CollectionVMOperation() {
            super("Garbage collection", VMOperation.SystemEffect.SAFEPOINT);
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        protected boolean isGC() {
            return true;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while collecting")
        protected void operate(NativeVMOperationData data) {
            ImplicitExceptions.activateImplicitExceptionsAreFatal();
            try {
                CollectionVMOperationData d = (CollectionVMOperationData)data;
                boolean outOfMemory = HeapImpl.getHeapImpl().getGCImpl().collectOperation(GCCause.fromId(d.getCauseId()), d.getRequestingEpoch());
                d.setOutOfMemory(outOfMemory);
            }
            catch (Throwable t) {
                throw VMError.shouldNotReachHere(t);
            }
            finally {
                ImplicitExceptions.deactivateImplicitExceptionsAreFatal();
            }
        }

        @Override
        protected boolean hasWork(NativeVMOperationData data) {
            CollectionVMOperationData d = (CollectionVMOperationData)data;
            return HeapImpl.getHeapImpl().getGCImpl().getCollectionEpoch().equal(d.getRequestingEpoch());
        }
    }

    static final class CollectionInProgressError
    extends Error {
        private static final CollectionInProgressError SINGLETON = new CollectionInProgressError();
        private static final long serialVersionUID = -4473303241014559591L;

        static void exitIf(boolean state) {
            if (state) {
                Log failure = Log.log();
                failure.string("[CollectionInProgressError:");
                failure.newline();
                ThreadStackPrinter.printBacktrace();
                failure.string("]").newline();
                throw SINGLETON;
            }
        }

        private CollectionInProgressError() {
        }
    }

    protected static class RememberedSetConstructor
    implements ObjectVisitor {
        AlignedHeapChunk.AlignedHeader chunk;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        RememberedSetConstructor() {
        }

        public void initialize(AlignedHeapChunk.AlignedHeader aChunk) {
            this.chunk = aChunk;
        }

        @Override
        public boolean visitObject(Object o) {
            return this.visitObjectInline(o);
        }

        @Override
        @AlwaysInline(value="GC performance")
        public boolean visitObjectInline(Object o) {
            AlignedHeapChunk.setUpRememberedSetForObjectOfAlignedHeapChunk(this.chunk, o);
            return true;
        }

        public void reset() {
            this.chunk = (AlignedHeapChunk.AlignedHeader)WordFactory.nullPointer();
        }
    }

    public static class Timer
    implements AutoCloseable {
        final String name;
        long openNanos;
        long closeNanos;
        long collectedNanos;

        public Timer open() {
            this.openNanos = System.nanoTime();
            this.closeNanos = 0L;
            return this;
        }

        @Override
        public void close() {
            if (this.openNanos == 0L) {
                this.openNanos = HeapChunkProvider.getFirstAllocationTime();
            }
            this.closeNanos = System.nanoTime();
            this.collectedNanos += this.closeNanos - this.openNanos;
        }

        public void reset() {
            this.openNanos = 0L;
            this.closeNanos = 0L;
            this.collectedNanos = 0L;
        }

        public String getName() {
            return this.name;
        }

        public long getStart() {
            return this.openNanos;
        }

        public long getFinish() {
            assert (this.closeNanos > 0L) : "Should have closed timer";
            return this.closeNanos;
        }

        long getCollectedNanos() {
            return this.collectedNanos;
        }

        long getLastIntervalNanos() {
            assert (this.openNanos > 0L) : "Should have opened timer";
            assert (this.closeNanos > 0L) : "Should have closed timer";
            return this.closeNanos - this.openNanos;
        }

        static long getTimeSinceFirstAllocation(long nanos) {
            return nanos - HeapChunkProvider.getFirstAllocationTime();
        }

        public Timer(String name) {
            this.name = name;
        }
    }

    public static class Accounting {
        private long incrementalCollectionCount = 0L;
        private long incrementalCollectionTotalNanos = 0L;
        private long completeCollectionCount = 0L;
        private long completeCollectionTotalNanos = 0L;
        private UnsignedWord collectedTotalChunkBytes;
        private UnsignedWord normalChunkBytes = (UnsignedWord)WordFactory.zero();
        private UnsignedWord promotedTotalChunkBytes = (UnsignedWord)WordFactory.zero();
        private UnsignedWord copiedTotalChunkBytes;
        private UnsignedWord youngChunkBytesBefore;
        private UnsignedWord youngChunkBytesAfter;
        private UnsignedWord oldChunkBytesBefore;
        private UnsignedWord oldChunkBytesAfter;
        private int history = 0;
        private UnsignedWord[] promotedUnpinnedChunkBytes;
        private UnsignedWord[] copiedUnpinnedChunkBytes;
        private UnsignedWord collectedTotalObjectBytes;
        private UnsignedWord youngObjectBytesBefore;
        private UnsignedWord youngObjectBytesAfter;
        private UnsignedWord oldObjectBytesBefore;
        private UnsignedWord oldObjectBytesAfter;
        private UnsignedWord normalObjectBytes;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        Accounting() {
            this.collectedTotalChunkBytes = (UnsignedWord)WordFactory.zero();
            this.copiedTotalChunkBytes = (UnsignedWord)WordFactory.zero();
            this.youngChunkBytesBefore = (UnsignedWord)WordFactory.zero();
            this.youngChunkBytesAfter = (UnsignedWord)WordFactory.zero();
            this.oldChunkBytesBefore = (UnsignedWord)WordFactory.zero();
            this.oldChunkBytesAfter = (UnsignedWord)WordFactory.zero();
            this.promotedUnpinnedChunkBytes = this.historyFactory((UnsignedWord)WordFactory.zero());
            this.copiedUnpinnedChunkBytes = this.historyFactory((UnsignedWord)WordFactory.zero());
            this.collectedTotalObjectBytes = (UnsignedWord)WordFactory.zero();
            this.youngObjectBytesBefore = (UnsignedWord)WordFactory.zero();
            this.youngObjectBytesAfter = (UnsignedWord)WordFactory.zero();
            this.oldObjectBytesBefore = (UnsignedWord)WordFactory.zero();
            this.oldObjectBytesAfter = (UnsignedWord)WordFactory.zero();
            this.normalObjectBytes = (UnsignedWord)WordFactory.zero();
        }

        @Platforms(value={Platform.HOSTED_ONLY.class})
        public static Accounting factory() {
            return new Accounting();
        }

        long getIncrementalCollectionCount() {
            return this.incrementalCollectionCount;
        }

        long getIncrementalCollectionTotalNanos() {
            return this.incrementalCollectionTotalNanos;
        }

        UnsignedWord getNormalChunkBytes() {
            return this.normalChunkBytes;
        }

        UnsignedWord getPromotedTotalChunkBytes() {
            return this.promotedTotalChunkBytes;
        }

        long getCompleteCollectionCount() {
            return this.completeCollectionCount;
        }

        long getCompleteCollectionTotalNanos() {
            return this.completeCollectionTotalNanos;
        }

        UnsignedWord getCopiedTotalChunkBytes() {
            return this.copiedTotalChunkBytes;
        }

        UnsignedWord getCollectedTotalChunkBytes() {
            return this.collectedTotalChunkBytes;
        }

        UnsignedWord getCollectedTotalObjectBytes() {
            return this.collectedTotalObjectBytes;
        }

        UnsignedWord getNormalObjectBytes() {
            return this.normalObjectBytes;
        }

        UnsignedWord getOldGenerationAfterChunkBytes() {
            return this.oldChunkBytesAfter;
        }

        UnsignedWord getYoungChunkBytesAfter() {
            return this.youngChunkBytesAfter;
        }

        UnsignedWord averagePromotedUnpinnedChunkBytes() {
            return this.averageOfHistory(this.promotedUnpinnedChunkBytes);
        }

        void incrementHistory() {
            ++this.history;
        }

        int historyAsIndex() {
            return this.historyAsIndex(0);
        }

        int historyAsIndex(int offset) {
            return (this.history + offset) % Options.GCHistory.getValue();
        }

        UnsignedWord[] historyFactory(UnsignedWord initial) {
            assert (initial.equal((UnsignedWord)WordFactory.zero())) : "Can not initialize history to any value except WordFactory.zero().";
            UnsignedWord[] result = new UnsignedWord[Options.GCHistory.getValue().intValue()];
            return result;
        }

        UnsignedWord getHistoryOf(UnsignedWord[] array) {
            return this.getHistoryOf(array, 0);
        }

        UnsignedWord getHistoryOf(UnsignedWord[] array, int offset) {
            return array[this.historyAsIndex(offset)];
        }

        void setHistoryOf(UnsignedWord[] array, UnsignedWord value) {
            this.setHistoryOf(array, 0, value);
        }

        void setHistoryOf(UnsignedWord[] array, int offset, UnsignedWord value) {
            array[this.historyAsIndex((int)offset)] = value;
        }

        UnsignedWord averageOfHistory(UnsignedWord[] array) {
            int count = 0;
            UnsignedWord sum = (UnsignedWord)WordFactory.zero();
            UnsignedWord result = (UnsignedWord)WordFactory.zero();
            for (int offset = 0; offset < array.length; ++offset) {
                UnsignedWord element = this.getHistoryOf(array, offset);
                if (!element.aboveThan((UnsignedWord)WordFactory.zero())) continue;
                sum = sum.add(element);
                ++count;
            }
            if (count > 0) {
                result = sum.unsignedDivide(count);
            }
            return result;
        }

        void beforeCollection() {
            Log trace = Log.noopLog().string("[GCImpl.Accounting.beforeCollection:").newline();
            this.incrementHistory();
            HeapImpl heap = HeapImpl.getHeapImpl();
            YoungGeneration youngGen = heap.getYoungGeneration();
            this.youngChunkBytesBefore = youngGen.getChunkUsedBytes();
            Space oldSpace = heap.getOldGeneration().getFromSpace();
            this.oldChunkBytesBefore = oldSpace.getChunkBytes();
            this.normalChunkBytes = this.normalChunkBytes.add(this.youngChunkBytesBefore);
            if (HeapOptions.PrintGCSummary.getValue().booleanValue()) {
                this.youngObjectBytesBefore = youngGen.getObjectBytes();
                this.oldObjectBytesBefore = oldSpace.getObjectBytes();
                this.normalObjectBytes = this.normalObjectBytes.add(this.youngObjectBytesBefore);
            }
            trace.string("  youngChunkBytesBefore: ").unsigned((WordBase)this.youngChunkBytesBefore).string("  oldChunkBytesBefore: ").unsigned((WordBase)this.oldChunkBytesBefore);
            trace.string("]").newline();
        }

        void afterCollection(boolean completeCollection, Timer collectionTimer) {
            if (completeCollection) {
                this.afterCompleteCollection(collectionTimer);
            } else {
                this.afterIncrementalCollection(collectionTimer);
            }
        }

        private void afterIncrementalCollection(Timer collectionTimer) {
            Log trace = Log.noopLog().string("[GCImpl.Accounting.afterIncrementalCollection:");
            ++this.incrementalCollectionCount;
            this.afterCollectionCommon();
            this.setHistoryOf(this.promotedUnpinnedChunkBytes, this.oldChunkBytesAfter.subtract(this.oldChunkBytesBefore));
            this.promotedTotalChunkBytes = this.promotedTotalChunkBytes.add(this.getHistoryOf(this.promotedUnpinnedChunkBytes));
            this.incrementalCollectionTotalNanos += collectionTimer.getCollectedNanos();
            trace.string("  incrementalCollectionCount: ").signed(this.incrementalCollectionCount).string("  oldChunkBytesAfter: ").unsigned((WordBase)this.oldChunkBytesAfter).string("  oldChunkBytesBefore: ").unsigned((WordBase)this.oldChunkBytesBefore).string("  promotedUnpinnedChunkBytes: ").unsigned((WordBase)this.getHistoryOf(this.promotedUnpinnedChunkBytes));
            trace.string("]").newline();
        }

        private void afterCompleteCollection(Timer collectionTimer) {
            Log trace = Log.noopLog().string("[GCImpl.Accounting.afterCompleteCollection:");
            ++this.completeCollectionCount;
            this.afterCollectionCommon();
            this.setHistoryOf(this.copiedUnpinnedChunkBytes, this.oldChunkBytesAfter);
            this.copiedTotalChunkBytes = this.copiedTotalChunkBytes.add(this.oldChunkBytesAfter);
            this.completeCollectionTotalNanos += collectionTimer.getCollectedNanos();
            trace.string("  completeCollectionCount: ").signed(this.completeCollectionCount).string("  oldChunkBytesAfter: ").unsigned((WordBase)this.oldChunkBytesAfter);
            trace.string("]").newline();
        }

        void afterCollectionCommon() {
            HeapImpl heap = HeapImpl.getHeapImpl();
            YoungGeneration youngGen = heap.getYoungGeneration();
            this.youngChunkBytesAfter = youngGen.getChunkUsedBytes();
            Space oldSpace = heap.getOldGeneration().getFromSpace();
            this.oldChunkBytesAfter = oldSpace.getChunkBytes();
            UnsignedWord beforeChunkBytes = this.youngChunkBytesBefore.add(this.oldChunkBytesBefore);
            UnsignedWord afterChunkBytes = this.oldChunkBytesAfter.add(this.youngChunkBytesAfter);
            UnsignedWord collectedChunkBytes = beforeChunkBytes.subtract(afterChunkBytes);
            this.collectedTotalChunkBytes = this.collectedTotalChunkBytes.add(collectedChunkBytes);
            if (HeapOptions.PrintGCSummary.getValue().booleanValue()) {
                this.youngObjectBytesAfter = youngGen.getObjectBytes();
                this.oldObjectBytesAfter = oldSpace.getObjectBytes();
                UnsignedWord beforeObjectBytes = this.youngObjectBytesBefore.add(this.oldObjectBytesBefore);
                UnsignedWord collectedObjectBytes = beforeObjectBytes.subtract(this.oldObjectBytesAfter).subtract(this.youngObjectBytesAfter);
                this.collectedTotalObjectBytes = this.collectedTotalObjectBytes.add(collectedObjectBytes);
            }
        }
    }

    private class BlackenImageHeapRootsVisitor
    implements MemoryWalker.Visitor {
        private BlackenImageHeapRootsVisitor() {
        }

        @Override
        public <T> boolean visitNativeImageHeapRegion(T region, MemoryWalker.NativeImageHeapRegionAccess<T> access) {
            if (access.containsReferences(region) && access.isWritable(region)) {
                try (Timer timer = GCImpl.this.blackenImageHeapRootsTimer.open();){
                    ImageHeapInfo imageHeapInfo = HeapImpl.getImageHeapInfo();
                    Word cur = Word.objectToUntrackedPointer((Object)imageHeapInfo.firstWritableReferenceObject);
                    Word last = Word.objectToUntrackedPointer((Object)imageHeapInfo.lastWritableReferenceObject);
                    while (cur.belowOrEqual((UnsignedWord)last)) {
                        Object obj = cur.toObject();
                        if (obj != null) {
                            GCImpl.this.greyToBlackObjectVisitor.visitObjectInline(obj);
                        }
                        cur = LayoutEncoding.getObjectEnd(obj);
                    }
                }
            }
            return true;
        }

        @Override
        public <T extends PointerBase> boolean visitHeapChunk(T heapChunk, MemoryWalker.HeapChunkAccess<T> access) {
            throw VMError.shouldNotReachHere();
        }

        @Override
        public <T extends CodeInfo> boolean visitCode(T codeInfo, MemoryWalker.CodeAccess<T> access) {
            throw VMError.shouldNotReachHere();
        }
    }

    static final class Options {
        @Option(help={"How much history to maintain about garbage collections."})
        public static final HostedOptionKey<Integer> GCHistory = new HostedOptionKey<Integer>(1);

        Options() {
        }
    }
}

