/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.os.IsDefined;
import com.oracle.svm.core.posix.VmPrimsJVM;
import com.oracle.svm.core.posix.headers.Fcntl;
import com.oracle.svm.core.posix.headers.Socket;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CIntPointer;

final class Util_java_net_PlainSocketImpl {
    static int marker_fd = -1;

    private Util_java_net_PlainSocketImpl() {
    }

    static void SET_NONBLOCKING(int fd) {
        int flags = Fcntl.fcntl(fd, Fcntl.F_GETFL());
        Fcntl.fcntl(fd, Fcntl.F_SETFL(), flags |= Fcntl.O_NONBLOCK());
    }

    static void SET_BLOCKING(int fd) {
        int flags = Fcntl.fcntl(fd, Fcntl.F_GETFL());
        Fcntl.fcntl(fd, Fcntl.F_SETFL(), flags &= ~Fcntl.O_NONBLOCK());
    }

    static int getMarkerFD() {
        CIntPointer sv = (CIntPointer)StackValue.get((int)2, CIntPointer.class);
        if (IsDefined.socket_AF_UNIX()) {
            if (Socket.socketpair(Socket.AF_UNIX(), Socket.SOCK_STREAM(), 0, sv) == -1) {
                return -1;
            }
        } else {
            return -1;
        }
        VmPrimsJVM.JVM_SocketShutdown(sv.read(0), 2);
        VmPrimsJVM.JVM_SocketClose(sv.read(1));
        return sv.read(0);
    }
}

