/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Fcntl;
import com.oracle.svm.core.posix.headers.Unistd;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.DeprecatedPlatform;
import org.graalvm.word.SignedWord;
import org.graalvm.word.WordFactory;

@TargetClass(value=RandomAccessFile.class)
@Platforms(value={DeprecatedPlatform.LINUX_SUBSTITUTION.class, DeprecatedPlatform.DARWIN_SUBSTITUTION.class})
final class Target_java_io_RandomAccessFile {
    @Alias
    private static int O_RDONLY;
    @Alias
    private static int O_RDWR;
    @Alias
    private static int O_SYNC;
    @Alias
    private static int O_DSYNC;
    @Alias
    private FileDescriptor fd;

    Target_java_io_RandomAccessFile() {
    }

    @Substitute
    public int read() throws IOException {
        return PosixUtils.readSingle(this.fd);
    }

    @Substitute
    private int readBytes(byte[] b, int off, int len) throws IOException {
        return PosixUtils.readBytes(b, off, len, this.fd);
    }

    @Substitute
    public void write(int b) throws IOException {
        PosixUtils.writeSingle(this.fd, b, false);
    }

    @Substitute
    private void writeBytes(byte[] b, int off, int len) throws IOException {
        PosixUtils.writeBytes(this.fd, b, off, len, false);
    }

    @Substitute
    private void seek(long pos) throws IOException {
        int handle = PosixUtils.getFDHandle(this.fd);
        if (pos < 0L) {
            throw PosixUtils.newIOExceptionWithLastError("Negative seek offset");
        }
        if (Unistd.lseek(handle, WordFactory.signed((long)pos), Unistd.SEEK_SET()).equal(WordFactory.signed((int)-1))) {
            throw PosixUtils.newIOExceptionWithLastError("Seek failed");
        }
    }

    @Substitute
    public long getFilePointer() throws IOException {
        int handle = PosixUtils.getFDHandle(this.fd);
        SignedWord ret = Unistd.lseek(handle, (SignedWord)WordFactory.zero(), Unistd.SEEK_CUR());
        if (ret.equal(WordFactory.signed((int)-1))) {
            throw PosixUtils.newIOExceptionWithLastError("Seek failed");
        }
        return ret.rawValue();
    }

    @Substitute
    private void open(String name, int mode) throws FileNotFoundException {
        int flags = 0;
        if ((mode & O_RDONLY) != 0) {
            flags |= Fcntl.O_RDONLY();
        } else if ((mode & O_RDWR) != 0) {
            flags |= Fcntl.O_RDWR();
            flags |= Fcntl.O_CREAT();
            if ((mode & O_SYNC) != 0) {
                flags |= Fcntl.O_SYNC();
            } else if ((mode & O_DSYNC) != 0) {
                flags |= Fcntl.O_DSYNC();
            }
        }
        PosixUtils.fileOpen(name, this.fd, flags);
    }

    @Substitute
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private void close0() throws IOException {
        PosixUtils.fileClose(this.fd);
    }

    @Substitute
    public long length() throws IOException {
        SignedWord cur = (SignedWord)WordFactory.zero();
        SignedWord end = (SignedWord)WordFactory.zero();
        int handle = PosixUtils.getFDHandle(this.fd);
        cur = Unistd.lseek(handle, (SignedWord)WordFactory.zero(), Unistd.SEEK_CUR());
        if (cur.equal(WordFactory.signed((int)-1))) {
            throw PosixUtils.newIOExceptionWithLastError("Seek failed");
        }
        end = Unistd.lseek(handle, (SignedWord)WordFactory.zero(), Unistd.SEEK_END());
        if (end.equal(WordFactory.signed((int)-1))) {
            throw PosixUtils.newIOExceptionWithLastError("Seek failed");
        }
        if (Unistd.lseek(handle, cur, Unistd.SEEK_SET()).equal(WordFactory.signed((int)-1))) {
            throw PosixUtils.newIOExceptionWithLastError("Seek failed");
        }
        return end.rawValue();
    }

    @Substitute
    public void setLength(long newLength) throws IOException {
        int handle = PosixUtils.getFDHandle(this.fd);
        SignedWord cur = Unistd.lseek(handle, (SignedWord)WordFactory.zero(), Unistd.SEEK_CUR());
        if (cur.equal(WordFactory.signed((int)-1))) {
            throw PosixUtils.newIOExceptionWithLastError("setLength failed");
        }
        if (Unistd.ftruncate(handle, newLength) == -1) {
            throw PosixUtils.newIOExceptionWithLastError("setLength failed");
        }
        if (cur.greaterThan(WordFactory.signed((long)newLength)) ? Unistd.lseek(handle, (SignedWord)WordFactory.zero(), Unistd.SEEK_END()).equal(WordFactory.signed((int)-1)) : Unistd.lseek(handle, cur, Unistd.SEEK_SET()).equal(WordFactory.signed((int)-1))) {
            throw PosixUtils.newIOExceptionWithLastError("setLength failed");
        }
    }
}

