/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.dataframe.evaluation.classification;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.client.ml.dataframe.evaluation.EvaluationMetric;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class AucRocMetric
implements EvaluationMetric {
    public static final String NAME = "auc_roc";
    public static final ParseField CLASS_NAME = new ParseField("class_name", new String[0]);
    public static final ParseField INCLUDE_CURVE = new ParseField("include_curve", new String[0]);
    public static final ConstructingObjectParser<AucRocMetric, Void> PARSER = new ConstructingObjectParser("auc_roc", true, args -> new AucRocMetric((String)args[0], (Boolean)args[1]));
    private final String className;
    private final Boolean includeCurve;

    public static AucRocMetric fromXContent(XContentParser parser) {
        return (AucRocMetric)PARSER.apply(parser, null);
    }

    public static AucRocMetric forClass(String className) {
        return new AucRocMetric(className, false);
    }

    public static AucRocMetric forClassWithCurve(String className) {
        return new AucRocMetric(className, true);
    }

    public AucRocMetric(String className, Boolean includeCurve) {
        this.className = Objects.requireNonNull(className);
        this.includeCurve = includeCurve;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(CLASS_NAME.getPreferredName(), this.className);
        if (this.includeCurve != null) {
            builder.field(INCLUDE_CURVE.getPreferredName(), this.includeCurve);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AucRocMetric that = (AucRocMetric)o;
        return Objects.equals(this.className, that.className) && Objects.equals(this.includeCurve, that.includeCurve);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.includeCurve);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), CLASS_NAME);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), INCLUDE_CURVE);
    }
}

