/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.ssl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.InvalidParameterException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CRL;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.security.CertificateUtils;
import org.eclipse.jetty.util.security.CertificateValidator;
import org.eclipse.jetty.util.security.Password;
import org.eclipse.jetty.util.ssl.AliasedX509ExtendedKeyManager;

public class SslContextFactory
extends AbstractLifeCycle {
    public static final TrustManager[] TRUST_ALL_CERTS = new X509TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }};
    static final Logger LOG = Log.getLogger(SslContextFactory.class);
    public static final String DEFAULT_KEYMANAGERFACTORY_ALGORITHM = Security.getProperty("ssl.KeyManagerFactory.algorithm") == null ? "SunX509" : Security.getProperty("ssl.KeyManagerFactory.algorithm");
    public static final String DEFAULT_TRUSTMANAGERFACTORY_ALGORITHM = Security.getProperty("ssl.TrustManagerFactory.algorithm") == null ? "SunX509" : Security.getProperty("ssl.TrustManagerFactory.algorithm");
    public static final String DEFAULT_KEYSTORE_PATH = System.getProperty("user.home") + File.separator + ".keystore";
    public static final String KEYPASSWORD_PROPERTY = "org.eclipse.jetty.ssl.keypassword";
    public static final String PASSWORD_PROPERTY = "org.eclipse.jetty.ssl.password";
    private final Set<String> _excludeProtocols = new LinkedHashSet<String>();
    private Set<String> _includeProtocols = null;
    private final Set<String> _excludeCipherSuites = new LinkedHashSet<String>();
    private Set<String> _includeCipherSuites = null;
    private String _keyStorePath;
    private String _keyStoreProvider;
    private String _keyStoreType = "JKS";
    private InputStream _keyStoreInputStream;
    private String _certAlias;
    private String _trustStorePath;
    private String _trustStoreProvider;
    private String _trustStoreType = "JKS";
    private InputStream _trustStoreInputStream;
    private boolean _needClientAuth = false;
    private boolean _wantClientAuth = false;
    private boolean _allowRenegotiate = true;
    private transient Password _keyStorePassword;
    private transient Password _keyManagerPassword;
    private transient Password _trustStorePassword;
    private String _sslProvider;
    private String _sslProtocol = "TLS";
    private String _secureRandomAlgorithm;
    private String _keyManagerFactoryAlgorithm = DEFAULT_KEYMANAGERFACTORY_ALGORITHM;
    private String _trustManagerFactoryAlgorithm = DEFAULT_TRUSTMANAGERFACTORY_ALGORITHM;
    private boolean _validateCerts;
    private boolean _validatePeerCerts;
    private int _maxCertPathLength = -1;
    private String _crlPath;
    private boolean _enableCRLDP = false;
    private boolean _enableOCSP = false;
    private String _ocspResponderURL;
    private KeyStore _keyStore;
    private KeyStore _trustStore;
    private boolean _sessionCachingEnabled = true;
    private int _sslSessionCacheSize;
    private int _sslSessionTimeout;
    private SSLContext _context;
    private boolean _trustAll;

    public SslContextFactory() {
        this._trustAll = true;
    }

    public SslContextFactory(boolean trustAll) {
        this._trustAll = trustAll;
    }

    public SslContextFactory(String keyStorePath) {
        this._keyStorePath = keyStorePath;
    }

    @Override
    protected void doStart() throws Exception {
        if (this._context == null) {
            if (this._keyStore == null && this._keyStoreInputStream == null && this._keyStorePath == null && this._trustStore == null && this._trustStoreInputStream == null && this._trustStorePath == null) {
                TrustManager[] trust_managers = null;
                if (this._trustAll) {
                    LOG.debug("No keystore or trust store configured.  ACCEPTING UNTRUSTED CERTIFICATES!!!!!", new Object[0]);
                    trust_managers = TRUST_ALL_CERTS;
                }
                SecureRandom secureRandom = this._secureRandomAlgorithm == null ? null : SecureRandom.getInstance(this._secureRandomAlgorithm);
                SSLContext context = SSLContext.getInstance(this._sslProtocol);
                context.init(null, trust_managers, secureRandom);
                this._context = context;
            } else {
                this.checkKeyStore();
                KeyStore keyStore = this.loadKeyStore();
                KeyStore trustStore = this.loadTrustStore();
                Collection<? extends CRL> crls = this.loadCRL(this._crlPath);
                if (this._validateCerts && keyStore != null) {
                    Certificate cert;
                    if (this._certAlias == null) {
                        ArrayList<String> aliases = Collections.list(keyStore.aliases());
                        this._certAlias = aliases.size() == 1 ? (String)aliases.get(0) : null;
                    }
                    Certificate certificate = cert = this._certAlias == null ? null : keyStore.getCertificate(this._certAlias);
                    if (cert == null) {
                        throw new Exception("No certificate found in the keystore" + (this._certAlias == null ? "" : " for alias " + this._certAlias));
                    }
                    CertificateValidator validator = new CertificateValidator(trustStore, crls);
                    validator.setMaxCertPathLength(this._maxCertPathLength);
                    validator.setEnableCRLDP(this._enableCRLDP);
                    validator.setEnableOCSP(this._enableOCSP);
                    validator.setOcspResponderURL(this._ocspResponderURL);
                    validator.validate(keyStore, cert);
                }
                KeyManager[] keyManagers = this.getKeyManagers(keyStore);
                TrustManager[] trustManagers = this.getTrustManagers(trustStore, crls);
                SecureRandom secureRandom = this._secureRandomAlgorithm == null ? null : SecureRandom.getInstance(this._secureRandomAlgorithm);
                SSLContext context = this._sslProvider == null ? SSLContext.getInstance(this._sslProtocol) : SSLContext.getInstance(this._sslProtocol, this._sslProvider);
                context.init(keyManagers, trustManagers, secureRandom);
                this._context = context;
            }
            SSLEngine engine = this.newSSLEngine();
            LOG.debug("Enabled Protocols {} of {}", Arrays.asList(engine.getEnabledProtocols()), Arrays.asList(engine.getSupportedProtocols()));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Enabled Ciphers   {} of {}", Arrays.asList(engine.getEnabledCipherSuites()), Arrays.asList(engine.getSupportedCipherSuites()));
            }
        }
    }

    @Override
    protected void doStop() throws Exception {
        this._context = null;
        super.doStop();
    }

    public String[] getExcludeProtocols() {
        return this._excludeProtocols.toArray(new String[this._excludeProtocols.size()]);
    }

    public void setExcludeProtocols(String ... protocols) {
        this.checkNotStarted();
        this._excludeProtocols.clear();
        this._excludeProtocols.addAll(Arrays.asList(protocols));
    }

    public void addExcludeProtocols(String ... protocol) {
        this.checkNotStarted();
        this._excludeProtocols.addAll(Arrays.asList(protocol));
    }

    public String[] getIncludeProtocols() {
        return this._includeProtocols.toArray(new String[this._includeProtocols.size()]);
    }

    public void setIncludeProtocols(String ... protocols) {
        this.checkNotStarted();
        this._includeProtocols = new LinkedHashSet<String>(Arrays.asList(protocols));
    }

    public String[] getExcludeCipherSuites() {
        return this._excludeCipherSuites.toArray(new String[this._excludeCipherSuites.size()]);
    }

    public void setExcludeCipherSuites(String ... cipherSuites) {
        this.checkNotStarted();
        this._excludeCipherSuites.clear();
        this._excludeCipherSuites.addAll(Arrays.asList(cipherSuites));
    }

    public void addExcludeCipherSuites(String ... cipher) {
        this.checkNotStarted();
        this._excludeCipherSuites.addAll(Arrays.asList(cipher));
    }

    public String[] getIncludeCipherSuites() {
        return this._includeCipherSuites.toArray(new String[this._includeCipherSuites.size()]);
    }

    public void setIncludeCipherSuites(String ... cipherSuites) {
        this.checkNotStarted();
        this._includeCipherSuites = new LinkedHashSet<String>(Arrays.asList(cipherSuites));
    }

    public String getKeyStorePath() {
        return this._keyStorePath;
    }

    public void setKeyStorePath(String keyStorePath) {
        this.checkNotStarted();
        this._keyStorePath = keyStorePath;
    }

    public String getKeyStoreProvider() {
        return this._keyStoreProvider;
    }

    public void setKeyStoreProvider(String keyStoreProvider) {
        this.checkNotStarted();
        this._keyStoreProvider = keyStoreProvider;
    }

    public String getKeyStoreType() {
        return this._keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.checkNotStarted();
        this._keyStoreType = keyStoreType;
    }

    public String getCertAlias() {
        return this._certAlias;
    }

    public void setCertAlias(String certAlias) {
        this.checkNotStarted();
        this._certAlias = certAlias;
    }

    public String getTrustStore() {
        return this._trustStorePath;
    }

    public void setTrustStorePath(String trustStorePath) {
        this.checkNotStarted();
        this._trustStorePath = trustStorePath;
    }

    public String getTrustStoreProvider() {
        return this._trustStoreProvider;
    }

    public void setTrustStoreProvider(String trustStoreProvider) {
        this.checkNotStarted();
        this._trustStoreProvider = trustStoreProvider;
    }

    public String getTrustStoreType() {
        return this._trustStoreType;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.checkNotStarted();
        this._trustStoreType = trustStoreType;
    }

    public boolean getNeedClientAuth() {
        return this._needClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.checkNotStarted();
        this._needClientAuth = needClientAuth;
    }

    public boolean getWantClientAuth() {
        return this._wantClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.checkNotStarted();
        this._wantClientAuth = wantClientAuth;
    }

    public boolean isValidateCerts() {
        return this._validateCerts;
    }

    public void setValidateCerts(boolean validateCerts) {
        this.checkNotStarted();
        this._validateCerts = validateCerts;
    }

    public boolean isValidatePeerCerts() {
        return this._validatePeerCerts;
    }

    public void setValidatePeerCerts(boolean validatePeerCerts) {
        this.checkNotStarted();
        this._validatePeerCerts = validatePeerCerts;
    }

    public void setKeyStorePassword(String password) {
        this.checkNotStarted();
        this._keyStorePassword = Password.getPassword(PASSWORD_PROPERTY, password, null);
    }

    public void setKeyManagerPassword(String password) {
        this.checkNotStarted();
        this._keyManagerPassword = Password.getPassword(KEYPASSWORD_PROPERTY, password, null);
    }

    public void setTrustStorePassword(String password) {
        this.checkNotStarted();
        this._trustStorePassword = Password.getPassword(PASSWORD_PROPERTY, password, null);
    }

    public String getProvider() {
        return this._sslProvider;
    }

    public void setProvider(String provider) {
        this.checkNotStarted();
        this._sslProvider = provider;
    }

    public String getProtocol() {
        return this._sslProtocol;
    }

    public void setProtocol(String protocol) {
        this.checkNotStarted();
        this._sslProtocol = protocol;
    }

    public String getSecureRandomAlgorithm() {
        return this._secureRandomAlgorithm;
    }

    public void setSecureRandomAlgorithm(String algorithm) {
        this.checkNotStarted();
        this._secureRandomAlgorithm = algorithm;
    }

    public String getSslKeyManagerFactoryAlgorithm() {
        return this._keyManagerFactoryAlgorithm;
    }

    public void setSslKeyManagerFactoryAlgorithm(String algorithm) {
        this.checkNotStarted();
        this._keyManagerFactoryAlgorithm = algorithm;
    }

    public String getTrustManagerFactoryAlgorithm() {
        return this._trustManagerFactoryAlgorithm;
    }

    public boolean isTrustAll() {
        return this._trustAll;
    }

    public void setTrustAll(boolean trustAll) {
        this._trustAll = trustAll;
    }

    public void setTrustManagerFactoryAlgorithm(String algorithm) {
        this.checkNotStarted();
        this._trustManagerFactoryAlgorithm = algorithm;
    }

    public String getCrlPath() {
        return this._crlPath;
    }

    public void setCrlPath(String crlPath) {
        this.checkNotStarted();
        this._crlPath = crlPath;
    }

    public int getMaxCertPathLength() {
        return this._maxCertPathLength;
    }

    public void setMaxCertPathLength(int maxCertPathLength) {
        this.checkNotStarted();
        this._maxCertPathLength = maxCertPathLength;
    }

    public SSLContext getSslContext() {
        if (!this.isStarted()) {
            throw new IllegalStateException(this.getState());
        }
        return this._context;
    }

    public void setSslContext(SSLContext sslContext) {
        this.checkNotStarted();
        this._context = sslContext;
    }

    protected KeyStore loadKeyStore() throws Exception {
        return this._keyStore != null ? this._keyStore : this.getKeyStore(this._keyStoreInputStream, this._keyStorePath, this._keyStoreType, this._keyStoreProvider, this._keyStorePassword == null ? null : this._keyStorePassword.toString());
    }

    protected KeyStore loadTrustStore() throws Exception {
        return this._trustStore != null ? this._trustStore : this.getKeyStore(this._trustStoreInputStream, this._trustStorePath, this._trustStoreType, this._trustStoreProvider, this._trustStorePassword == null ? null : this._trustStorePassword.toString());
    }

    @Deprecated
    protected KeyStore getKeyStore(InputStream storeStream, String storePath, String storeType, String storeProvider, String storePassword) throws Exception {
        return CertificateUtils.getKeyStore(storeStream, storePath, storeType, storeProvider, storePassword);
    }

    protected Collection<? extends CRL> loadCRL(String crlPath) throws Exception {
        return CertificateUtils.loadCRL(crlPath);
    }

    protected KeyManager[] getKeyManagers(KeyStore keyStore) throws Exception {
        KeyManager[] managers = null;
        if (keyStore != null) {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(this._keyManagerFactoryAlgorithm);
            keyManagerFactory.init(keyStore, this._keyManagerPassword == null ? (this._keyStorePassword == null ? null : this._keyStorePassword.toString().toCharArray()) : this._keyManagerPassword.toString().toCharArray());
            managers = keyManagerFactory.getKeyManagers();
            if (this._certAlias != null) {
                for (int idx = 0; idx < managers.length; ++idx) {
                    if (!(managers[idx] instanceof X509KeyManager)) continue;
                    managers[idx] = new AliasedX509ExtendedKeyManager(this._certAlias, (X509KeyManager)managers[idx]);
                }
            }
        }
        return managers;
    }

    protected TrustManager[] getTrustManagers(KeyStore trustStore, Collection<? extends CRL> crls) throws Exception {
        TrustManager[] managers = null;
        if (trustStore != null) {
            if (this._validatePeerCerts && this._trustManagerFactoryAlgorithm.equalsIgnoreCase("PKIX")) {
                PKIXBuilderParameters pbParams = new PKIXBuilderParameters(trustStore, (CertSelector)new X509CertSelector());
                pbParams.setMaxPathLength(this._maxCertPathLength);
                pbParams.setRevocationEnabled(true);
                if (crls != null && !crls.isEmpty()) {
                    pbParams.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(crls)));
                }
                if (this._enableCRLDP) {
                    System.setProperty("com.sun.security.enableCRLDP", "true");
                }
                if (this._enableOCSP) {
                    Security.setProperty("ocsp.enable", "true");
                    if (this._ocspResponderURL != null) {
                        Security.setProperty("ocsp.responderURL", this._ocspResponderURL);
                    }
                }
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(this._trustManagerFactoryAlgorithm);
                trustManagerFactory.init(new CertPathTrustManagerParameters(pbParams));
                managers = trustManagerFactory.getTrustManagers();
            } else {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(this._trustManagerFactoryAlgorithm);
                trustManagerFactory.init(trustStore);
                managers = trustManagerFactory.getTrustManagers();
            }
        }
        return managers;
    }

    public void checkKeyStore() {
        if (this._context != null) {
            return;
        }
        if (this._keyStore == null && this._keyStoreInputStream == null && this._keyStorePath == null) {
            throw new IllegalStateException("SSL doesn't have a valid keystore");
        }
        if (this._trustStore == null && this._trustStoreInputStream == null && this._trustStorePath == null) {
            this._trustStore = this._keyStore;
            this._trustStorePath = this._keyStorePath;
            this._trustStoreInputStream = this._keyStoreInputStream;
            this._trustStoreType = this._keyStoreType;
            this._trustStoreProvider = this._keyStoreProvider;
            this._trustStorePassword = this._keyStorePassword;
            this._trustManagerFactoryAlgorithm = this._keyManagerFactoryAlgorithm;
        }
        if (this._keyStoreInputStream != null && this._keyStoreInputStream == this._trustStoreInputStream) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                IO.copy(this._keyStoreInputStream, baos);
                this._keyStoreInputStream.close();
                this._keyStoreInputStream = new ByteArrayInputStream(baos.toByteArray());
                this._trustStoreInputStream = new ByteArrayInputStream(baos.toByteArray());
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    public String[] selectProtocols(String[] enabledProtocols, String[] supportedProtocols) {
        LinkedHashSet<String> selected_protocols = new LinkedHashSet<String>();
        if (this._includeProtocols != null) {
            for (String protocol : this._includeProtocols) {
                if (!Arrays.asList(supportedProtocols).contains(protocol)) continue;
                selected_protocols.add(protocol);
            }
        } else {
            selected_protocols.addAll(Arrays.asList(enabledProtocols));
        }
        if (this._excludeProtocols != null) {
            selected_protocols.removeAll(this._excludeProtocols);
        }
        return selected_protocols.toArray(new String[selected_protocols.size()]);
    }

    public String[] selectCipherSuites(String[] enabledCipherSuites, String[] supportedCipherSuites) {
        LinkedHashSet<String> selected_ciphers = new LinkedHashSet<String>();
        if (this._includeCipherSuites != null) {
            for (String cipherSuite : this._includeCipherSuites) {
                if (!Arrays.asList(supportedCipherSuites).contains(cipherSuite)) continue;
                selected_ciphers.add(cipherSuite);
            }
        } else {
            selected_ciphers.addAll(Arrays.asList(enabledCipherSuites));
        }
        if (this._excludeCipherSuites != null) {
            selected_ciphers.removeAll(this._excludeCipherSuites);
        }
        return selected_ciphers.toArray(new String[selected_ciphers.size()]);
    }

    protected void checkNotStarted() {
        if (this.isStarted()) {
            throw new IllegalStateException("Cannot modify configuration when " + this.getState());
        }
    }

    public boolean isEnableCRLDP() {
        return this._enableCRLDP;
    }

    public void setEnableCRLDP(boolean enableCRLDP) {
        this.checkNotStarted();
        this._enableCRLDP = enableCRLDP;
    }

    public boolean isEnableOCSP() {
        return this._enableOCSP;
    }

    public void setEnableOCSP(boolean enableOCSP) {
        this.checkNotStarted();
        this._enableOCSP = enableOCSP;
    }

    public String getOcspResponderURL() {
        return this._ocspResponderURL;
    }

    public void setOcspResponderURL(String ocspResponderURL) {
        this.checkNotStarted();
        this._ocspResponderURL = ocspResponderURL;
    }

    public void setKeyStore(KeyStore keyStore) {
        this.checkNotStarted();
        this._keyStore = keyStore;
    }

    public void setTrustStore(KeyStore trustStore) {
        this.checkNotStarted();
        this._trustStore = trustStore;
    }

    public void setKeyStoreResource(Resource resource) {
        this.checkNotStarted();
        try {
            this._keyStoreInputStream = resource.getInputStream();
        }
        catch (IOException e) {
            throw new InvalidParameterException("Unable to get resource input stream for resource " + resource.toString());
        }
    }

    public void setTrustStoreResource(Resource resource) {
        this.checkNotStarted();
        try {
            this._trustStoreInputStream = resource.getInputStream();
        }
        catch (IOException e) {
            throw new InvalidParameterException("Unable to get resource input stream for resource " + resource.toString());
        }
    }

    public boolean isSessionCachingEnabled() {
        return this._sessionCachingEnabled;
    }

    public void setSessionCachingEnabled(boolean enableSessionCaching) {
        this._sessionCachingEnabled = enableSessionCaching;
    }

    public int getSslSessionCacheSize() {
        return this._sslSessionCacheSize;
    }

    public void setSslSessionCacheSize(int sslSessionCacheSize) {
        this._sslSessionCacheSize = sslSessionCacheSize;
    }

    public int getSslSessionTimeout() {
        return this._sslSessionTimeout;
    }

    public void setSslSessionTimeout(int sslSessionTimeout) {
        this._sslSessionTimeout = sslSessionTimeout;
    }

    public SSLServerSocket newSslServerSocket(String host, int port, int backlog) throws IOException {
        SSLServerSocketFactory factory = this._context.getServerSocketFactory();
        SSLServerSocket socket = (SSLServerSocket)(host == null ? factory.createServerSocket(port, backlog) : factory.createServerSocket(port, backlog, InetAddress.getByName(host)));
        if (this.getWantClientAuth()) {
            socket.setWantClientAuth(this.getWantClientAuth());
        }
        if (this.getNeedClientAuth()) {
            socket.setNeedClientAuth(this.getNeedClientAuth());
        }
        socket.setEnabledCipherSuites(this.selectCipherSuites(socket.getEnabledCipherSuites(), socket.getSupportedCipherSuites()));
        socket.setEnabledProtocols(this.selectProtocols(socket.getEnabledProtocols(), socket.getSupportedProtocols()));
        return socket;
    }

    public SSLSocket newSslSocket() throws IOException {
        SSLSocketFactory factory = this._context.getSocketFactory();
        SSLSocket socket = (SSLSocket)factory.createSocket();
        if (this.getWantClientAuth()) {
            socket.setWantClientAuth(this.getWantClientAuth());
        }
        if (this.getNeedClientAuth()) {
            socket.setNeedClientAuth(this.getNeedClientAuth());
        }
        socket.setEnabledCipherSuites(this.selectCipherSuites(socket.getEnabledCipherSuites(), socket.getSupportedCipherSuites()));
        socket.setEnabledProtocols(this.selectProtocols(socket.getEnabledProtocols(), socket.getSupportedProtocols()));
        return socket;
    }

    public SSLEngine newSSLEngine(String host, int port) {
        if (!this.isRunning()) {
            throw new IllegalStateException("!STARTED");
        }
        SSLContext context = this._context;
        SSLEngine sslEngine = this.isSessionCachingEnabled() ? context.createSSLEngine(host, port) : context.createSSLEngine();
        this.customize(sslEngine);
        return sslEngine;
    }

    public SSLEngine newSSLEngine() {
        if (!this.isRunning()) {
            throw new IllegalStateException("!STARTED");
        }
        SSLEngine sslEngine = this._context.createSSLEngine();
        this.customize(sslEngine);
        return sslEngine;
    }

    public void customize(SSLEngine sslEngine) {
        if (this.getWantClientAuth()) {
            sslEngine.setWantClientAuth(this.getWantClientAuth());
        }
        if (this.getNeedClientAuth()) {
            sslEngine.setNeedClientAuth(this.getNeedClientAuth());
        }
        sslEngine.setEnabledCipherSuites(this.selectCipherSuites(sslEngine.getEnabledCipherSuites(), sslEngine.getSupportedCipherSuites()));
        sslEngine.setEnabledProtocols(this.selectProtocols(sslEngine.getEnabledProtocols(), sslEngine.getSupportedProtocols()));
    }

    public SSLEngine newSSLEngine(InetSocketAddress address) {
        return address != null ? this.newSSLEngine(address.getAddress().getHostAddress(), address.getPort()) : this.newSSLEngine();
    }

    public String toString() {
        return String.format("%s@%x(%s,%s)", this.getClass().getSimpleName(), this.hashCode(), this._keyStorePath, this._trustStorePath);
    }
}

