/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions.compress;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.websocket.api.MessageTooLargeException;

public class ByteAccumulator {
    private final int maxSize;
    private int length = 0;
    private List<Buf> buffers;

    public ByteAccumulator(int maxOverallBufferSize) {
        this.maxSize = maxOverallBufferSize;
        this.buffers = new ArrayList<Buf>();
    }

    public void addBuffer(byte[] buf, int offset, int length) {
        if (this.length + length > this.maxSize) {
            throw new MessageTooLargeException("Frame is too large");
        }
        this.buffers.add(new Buf(buf, offset, length));
        this.length += length;
    }

    public int getLength() {
        return this.length;
    }

    public ByteBuffer getByteBuffer(ByteBufferPool pool) {
        ByteBuffer ret = pool.acquire(this.length, false);
        BufferUtil.clearToFill(ret);
        for (Buf buf : this.buffers) {
            ret.put(buf.buffer, buf.offset, buf.length);
        }
        BufferUtil.flipToFlush(ret, 0);
        return ret;
    }

    private static class Buf {
        byte[] buffer;
        int offset;
        int length;

        public Buf(byte[] buffer, int offset, int length) {
            this.buffer = buffer;
            this.offset = offset;
            this.length = length;
        }
    }
}

