/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpTokens;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.util.ArrayTernaryTrie;
import org.eclipse.jetty.util.ArrayTrie;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.Trie;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpParser {
    public static final Logger LOG = Log.getLogger(HttpParser.class);
    public static final boolean __STRICT = Boolean.getBoolean("org.eclipse.jetty.http.HttpParser.STRICT");
    public static final int INITIAL_URI_LENGTH = 256;
    public static final Trie<HttpField> CACHE = new ArrayTrie(2048);
    public static final Trie<HttpField> CONTENT_TYPE = new ArrayTrie(512);
    private final boolean DEBUG = LOG.isDebugEnabled();
    private final HttpHandler<ByteBuffer> _handler;
    private final RequestHandler<ByteBuffer> _requestHandler;
    private final ResponseHandler<ByteBuffer> _responseHandler;
    private final int _maxHeaderBytes;
    private final boolean _strict;
    private HttpField _field;
    private HttpHeader _header;
    private String _headerString;
    private HttpHeaderValue _value;
    private String _valueString;
    private int _responseStatus;
    private int _headerBytes;
    private boolean _host;
    private volatile State _state = State.START;
    private volatile boolean _eof;
    private volatile boolean _closed;
    private HttpMethod _method;
    private String _methodString;
    private HttpVersion _version;
    private ByteBuffer _uri = ByteBuffer.allocate(256);
    private HttpTokens.EndOfContent _endOfContent;
    private long _contentLength;
    private long _contentPosition;
    private int _chunkLength;
    private int _chunkPosition;
    private boolean _headResponse;
    private boolean _cr;
    private ByteBuffer _contentChunk;
    private Trie<HttpField> _connectionFields;
    private int _length;
    private final StringBuilder _string = new StringBuilder();

    public HttpParser(RequestHandler<ByteBuffer> handler) {
        this(handler, -1, __STRICT);
    }

    public HttpParser(ResponseHandler<ByteBuffer> handler) {
        this(handler, -1, __STRICT);
    }

    public HttpParser(RequestHandler<ByteBuffer> handler, int maxHeaderBytes) {
        this(handler, maxHeaderBytes, __STRICT);
    }

    public HttpParser(ResponseHandler<ByteBuffer> handler, int maxHeaderBytes) {
        this(handler, maxHeaderBytes, __STRICT);
    }

    public HttpParser(RequestHandler<ByteBuffer> handler, int maxHeaderBytes, boolean strict) {
        this._handler = handler;
        this._requestHandler = handler;
        this._responseHandler = null;
        this._maxHeaderBytes = maxHeaderBytes;
        this._strict = strict;
    }

    public HttpParser(ResponseHandler<ByteBuffer> handler, int maxHeaderBytes, boolean strict) {
        this._handler = handler;
        this._requestHandler = null;
        this._responseHandler = handler;
        this._maxHeaderBytes = maxHeaderBytes;
        this._strict = strict;
    }

    public long getContentLength() {
        return this._contentLength;
    }

    public long getContentRead() {
        return this._contentPosition;
    }

    public void setHeadResponse(boolean head) {
        this._headResponse = head;
    }

    protected void setResponseStatus(int status) {
        this._responseStatus = status;
    }

    public State getState() {
        return this._state;
    }

    public boolean inContentState() {
        return this._state.ordinal() >= State.CONTENT.ordinal() && this._state.ordinal() < State.END.ordinal();
    }

    public boolean inHeaderState() {
        return this._state.ordinal() < State.CONTENT.ordinal();
    }

    public boolean isChunking() {
        return this._endOfContent == HttpTokens.EndOfContent.CHUNKED_CONTENT;
    }

    public boolean isStart() {
        return this.isState(State.START);
    }

    public boolean isClosed() {
        return this.isState(State.CLOSED);
    }

    public boolean isIdle() {
        return this.isState(State.START) || this.isState(State.END) || this.isState(State.CLOSED);
    }

    public boolean isComplete() {
        return this.isState(State.END) || this.isState(State.CLOSED);
    }

    public boolean isState(State state) {
        return this._state == state;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte next(ByteBuffer buffer) {
        byte ch = buffer.get();
        if (this._cr) {
            if (ch != 10) {
                throw new BadMessage("Bad EOL");
            }
            this._cr = false;
            return ch;
        }
        if (ch < 0 || ch >= 32) return ch;
        if (ch == 13) {
            if (buffer.hasRemaining()) {
                if (this._maxHeaderBytes > 0 && this._state.ordinal() < State.END.ordinal()) {
                    ++this._headerBytes;
                }
                if ((ch = buffer.get()) == 10) return ch;
                throw new BadMessage("Bad EOL");
            }
            this._cr = true;
            return 0;
        }
        if (ch == 10 || ch == 9) return ch;
        throw new BadMessage("Illegal character");
    }

    private boolean quickStart(ByteBuffer buffer) {
        if (this._requestHandler != null) {
            this._method = HttpMethod.lookAheadGet(buffer);
            if (this._method != null) {
                this._methodString = this._method.asString();
                buffer.position(buffer.position() + this._methodString.length() + 1);
                this.setState(State.SPACE1);
                return false;
            }
        } else if (this._responseHandler != null) {
            this._version = HttpVersion.lookAheadGet(buffer);
            if (this._version != null) {
                buffer.position(buffer.position() + this._version.asString().length() + 1);
                this.setState(State.SPACE1);
                return false;
            }
        }
        while (this._state == State.START && buffer.hasRemaining()) {
            byte ch = this.next(buffer);
            if (ch > 32) {
                this._string.setLength(0);
                this._string.append((char)ch);
                this.setState(this._requestHandler != null ? State.METHOD : State.RESPONSE_VERSION);
                return false;
            }
            if (ch == 0) break;
            if (ch >= 0) continue;
            throw new BadMessage();
        }
        return false;
    }

    private void setString(String s) {
        this._string.setLength(0);
        this._string.append(s);
        this._length = s.length();
    }

    private String takeString() {
        this._string.setLength(this._length);
        String s = this._string.toString();
        this._string.setLength(0);
        this._length = -1;
        return s;
    }

    private boolean parseLine(ByteBuffer buffer) {
        byte ch;
        boolean handle = false;
        block10: while (this._state.ordinal() < State.HEADER.ordinal() && buffer.hasRemaining() && !handle && (ch = this.next(buffer)) != 0) {
            if (this._maxHeaderBytes > 0 && ++this._headerBytes > this._maxHeaderBytes) {
                if (this._state == State.URI) {
                    LOG.warn("URI is too large >" + this._maxHeaderBytes, new Object[0]);
                    throw new BadMessage(414);
                }
                if (this._requestHandler != null) {
                    LOG.warn("request is too large >" + this._maxHeaderBytes, new Object[0]);
                } else {
                    LOG.warn("response is too large >" + this._maxHeaderBytes, new Object[0]);
                }
                throw new BadMessage(413);
            }
            switch (this._state) {
                case METHOD: {
                    if (ch == 32) {
                        this._length = this._string.length();
                        this._methodString = this.takeString();
                        HttpMethod method = (HttpMethod)((Object)HttpMethod.CACHE.get(this._methodString));
                        if (method != null && !this._strict) {
                            this._methodString = method.asString();
                        }
                        this.setState(State.SPACE1);
                        break;
                    }
                    if (ch < 32) {
                        throw new BadMessage(ch < 0 ? "Illegal character" : "No URI");
                    }
                    this._string.append((char)ch);
                    break;
                }
                case RESPONSE_VERSION: {
                    if (ch == 32) {
                        this._length = this._string.length();
                        String version = this.takeString();
                        this._version = (HttpVersion)((Object)HttpVersion.CACHE.get(version));
                        if (this._version == null) {
                            throw new BadMessage(400, "Unknown Version");
                        }
                        this.setState(State.SPACE1);
                        break;
                    }
                    if (ch < 32) {
                        throw new BadMessage(ch < 0 ? "Illegal character" : "No Status");
                    }
                    this._string.append((char)ch);
                    break;
                }
                case SPACE1: {
                    if (ch > 32 || ch < 0) {
                        if (this._responseHandler != null) {
                            this.setState(State.STATUS);
                            this.setResponseStatus(ch - 48);
                            break;
                        }
                        this._uri.clear();
                        this.setState(State.URI);
                        if (buffer.hasArray()) {
                            int i;
                            byte[] array = buffer.array();
                            int p = buffer.arrayOffset() + buffer.position();
                            int l = buffer.arrayOffset() + buffer.limit();
                            for (i = p; i < l && array[i] > 32; ++i) {
                            }
                            int len = i - p;
                            this._headerBytes += len;
                            if (this._maxHeaderBytes > 0 && ++this._headerBytes > this._maxHeaderBytes) {
                                LOG.warn("URI is too large >" + this._maxHeaderBytes, new Object[0]);
                                throw new BadMessage(414);
                            }
                            if (this._uri.remaining() <= len) {
                                ByteBuffer uri = ByteBuffer.allocate(this._uri.capacity() + 2 * len);
                                this._uri.flip();
                                uri.put(this._uri);
                                this._uri = uri;
                            }
                            this._uri.put(array, p - 1, len + 1);
                            buffer.position(i - buffer.arrayOffset());
                            break;
                        }
                        this._uri.put(ch);
                        break;
                    }
                    if (ch >= 32) continue block10;
                    throw new BadMessage(400, this._requestHandler != null ? "No URI" : "No Status");
                }
                case STATUS: {
                    if (ch == 32) {
                        this.setState(State.SPACE2);
                        break;
                    }
                    if (ch >= 48 && ch <= 57) {
                        this._responseStatus = this._responseStatus * 10 + (ch - 48);
                        break;
                    }
                    if (ch < 32 && ch >= 0) {
                        handle = this._responseHandler.startResponse(this._version, this._responseStatus, null) || handle;
                        this.setState(State.HEADER);
                        break;
                    }
                    throw new BadMessage();
                }
                case URI: {
                    if (ch == 32) {
                        this.setState(State.SPACE2);
                        break;
                    }
                    if (ch < 32 && ch >= 0) {
                        this._uri.flip();
                        handle = this._requestHandler.startRequest(this._method, this._methodString, this._uri, null) || handle;
                        this.setState(State.END);
                        BufferUtil.clear((ByteBuffer)buffer);
                        handle = this._handler.headerComplete() || handle;
                        handle = this._handler.messageComplete() || handle;
                        break;
                    }
                    if (!this._uri.hasRemaining()) {
                        ByteBuffer uri = ByteBuffer.allocate(this._uri.capacity() * 2);
                        this._uri.flip();
                        uri.put(this._uri);
                        this._uri = uri;
                    }
                    this._uri.put(ch);
                    break;
                }
                case SPACE2: {
                    if (ch > 32) {
                        int pos;
                        this._string.setLength(0);
                        this._string.append((char)ch);
                        if (this._responseHandler != null) {
                            this._length = 1;
                            this.setState(State.REASON);
                            break;
                        }
                        this.setState(State.REQUEST_VERSION);
                        HttpVersion version = buffer.position() > 0 && buffer.hasArray() ? HttpVersion.lookAheadGet(buffer.array(), buffer.arrayOffset() + buffer.position() - 1, buffer.arrayOffset() + buffer.limit()) : (HttpVersion)((Object)HttpVersion.CACHE.getBest(buffer, 0, buffer.remaining()));
                        if (version == null || (pos = buffer.position() + version.asString().length() - 1) >= buffer.limit()) continue block10;
                        byte n = buffer.get(pos);
                        if (n == 13) {
                            this._cr = true;
                            this._version = version;
                            this._string.setLength(0);
                            buffer.position(pos + 1);
                            break;
                        }
                        if (n != 10) continue block10;
                        this._version = version;
                        this._string.setLength(0);
                        buffer.position(pos);
                        break;
                    }
                    if (ch == 10) {
                        if (this._responseHandler != null) {
                            handle = this._responseHandler.startResponse(this._version, this._responseStatus, null) || handle;
                            this.setState(State.HEADER);
                            break;
                        }
                        this._uri.flip();
                        handle = this._requestHandler.startRequest(this._method, this._methodString, this._uri, null) || handle;
                        this.setState(State.END);
                        BufferUtil.clear((ByteBuffer)buffer);
                        handle = this._handler.headerComplete() || handle;
                        handle = this._handler.messageComplete() || handle;
                        break;
                    }
                    if (ch >= 0) continue block10;
                    throw new BadMessage();
                }
                case REQUEST_VERSION: {
                    if (ch == 10) {
                        int header_cache;
                        if (this._version == null) {
                            this._length = this._string.length();
                            this._version = (HttpVersion)((Object)HttpVersion.CACHE.get(this.takeString()));
                        }
                        if (this._version == null) {
                            throw new BadMessage(400, "Unknown Version");
                        }
                        if (this._connectionFields == null && this._version.getVersion() >= HttpVersion.HTTP_1_1.getVersion() && (header_cache = this._handler.getHeaderCacheSize()) > 0) {
                            this._connectionFields = new ArrayTernaryTrie(header_cache);
                        }
                        this.setState(State.HEADER);
                        this._uri.flip();
                        handle = this._requestHandler.startRequest(this._method, this._methodString, this._uri, this._version) || handle;
                        continue block10;
                    }
                    if (ch >= 32) {
                        this._string.append((char)ch);
                        break;
                    }
                    throw new BadMessage();
                }
                case REASON: {
                    if (ch == 10) {
                        String reason = this.takeString();
                        this.setState(State.HEADER);
                        handle = this._responseHandler.startResponse(this._version, this._responseStatus, reason) || handle;
                        continue block10;
                    }
                    if (ch >= 32) {
                        this._string.append((char)ch);
                        if (ch == 32 || ch == 9) continue block10;
                        this._length = this._string.length();
                        break;
                    }
                    throw new BadMessage();
                }
                default: {
                    throw new IllegalStateException(this._state.toString());
                }
            }
        }
        return handle;
    }

    private boolean handleKnownHeaders(ByteBuffer buffer) {
        boolean add_to_connection_trie = false;
        switch (this._header) {
            case CONTENT_LENGTH: {
                if (this._endOfContent == HttpTokens.EndOfContent.CHUNKED_CONTENT) break;
                try {
                    this._contentLength = Long.parseLong(this._valueString);
                }
                catch (NumberFormatException e) {
                    LOG.ignore((Throwable)e);
                    throw new BadMessage(400, "Bad Content-Length");
                }
                if (this._contentLength <= 0L) {
                    this._endOfContent = HttpTokens.EndOfContent.NO_CONTENT;
                    break;
                }
                this._endOfContent = HttpTokens.EndOfContent.CONTENT_LENGTH;
                break;
            }
            case TRANSFER_ENCODING: {
                if (this._value == HttpHeaderValue.CHUNKED) {
                    this._endOfContent = HttpTokens.EndOfContent.CHUNKED_CONTENT;
                    break;
                }
                if (this._valueString.endsWith(HttpHeaderValue.CHUNKED.toString())) {
                    this._endOfContent = HttpTokens.EndOfContent.CHUNKED_CONTENT;
                    break;
                }
                if (this._valueString.indexOf(HttpHeaderValue.CHUNKED.toString()) < 0) break;
                throw new BadMessage(400, "Bad chunking");
            }
            case HOST: {
                int len;
                add_to_connection_trie = this._connectionFields != null && this._field == null;
                this._host = true;
                String host = this._valueString;
                int port = 0;
                if (host == null || host.length() == 0) {
                    throw new BadMessage(400, "Bad Host header");
                }
                int i = len = host.length();
                block15: while (i-- > 0) {
                    char c2 = (char)(0xFF & host.charAt(i));
                    switch (c2) {
                        case ']': {
                            break block15;
                        }
                        case ':': {
                            try {
                                len = i;
                                port = StringUtil.toInt((String)host.substring(i + 1));
                                break block15;
                            }
                            catch (NumberFormatException e) {
                                if (this.DEBUG) {
                                    LOG.debug((Throwable)e);
                                }
                                throw new BadMessage(400, "Bad Host header");
                            }
                        }
                        default: {
                            continue block15;
                        }
                    }
                }
                if (host.charAt(0) == '[') {
                    if (host.charAt(len - 1) != ']') {
                        throw new BadMessage(400, "Bad IPv6 Host header");
                    }
                    host = host.substring(1, len - 1);
                } else if (len != host.length()) {
                    host = host.substring(0, len);
                }
                if (this._requestHandler == null) break;
                this._requestHandler.parsedHostHeader(host, port);
                break;
            }
            case CONNECTION: {
                if (this._valueString == null || this._valueString.indexOf("close") < 0) break;
                this._closed = true;
                this._connectionFields = null;
                break;
            }
            case AUTHORIZATION: 
            case ACCEPT: 
            case ACCEPT_CHARSET: 
            case ACCEPT_ENCODING: 
            case ACCEPT_LANGUAGE: 
            case COOKIE: 
            case CACHE_CONTROL: 
            case USER_AGENT: {
                add_to_connection_trie = this._connectionFields != null && this._field == null;
                break;
            }
        }
        if (add_to_connection_trie && !this._connectionFields.isFull() && this._header != null && this._valueString != null) {
            this._field = new HttpField(this._header, this._valueString);
            this._connectionFields.put((Object)this._field);
        }
        return false;
    }

    protected boolean parseHeaders(ByteBuffer buffer) {
        byte ch;
        boolean handle = false;
        block14: while (this._state.ordinal() < State.CONTENT.ordinal() && buffer.hasRemaining() && !handle && (ch = this.next(buffer)) != 0) {
            if (this._maxHeaderBytes > 0 && ++this._headerBytes > this._maxHeaderBytes) {
                LOG.warn("Header is too large >" + this._maxHeaderBytes, new Object[0]);
                throw new BadMessage(413);
            }
            block0 : switch (this._state) {
                case HEADER: {
                    switch (ch) {
                        case 9: 
                        case 32: 
                        case 58: {
                            if (this._valueString == null) {
                                this._string.setLength(0);
                                this._length = 0;
                            } else {
                                this.setString(this._valueString);
                                this._string.append(' ');
                                ++this._length;
                                this._valueString = null;
                            }
                            this.setState(State.HEADER_VALUE);
                            break block0;
                        }
                    }
                    if (this._headerString != null || this._valueString != null) {
                        if (this._header != null && this.handleKnownHeaders(buffer)) {
                            this._valueString = null;
                            this._headerString = null;
                            this._header = null;
                            this._value = null;
                            this._field = null;
                            return true;
                        }
                        handle = this._handler.parsedHeader(this._field != null ? this._field : new HttpField(this._header, this._headerString, this._valueString)) || handle;
                    }
                    this._valueString = null;
                    this._headerString = null;
                    this._header = null;
                    this._value = null;
                    this._field = null;
                    if (ch == 10) {
                        this._contentPosition = 0L;
                        if (!this._host && this._version != HttpVersion.HTTP_1_0 && this._requestHandler != null) {
                            throw new BadMessage(400, "No Host");
                        }
                        if (this._responseHandler != null && (this._responseStatus == 304 || this._responseStatus == 204 || this._responseStatus < 200)) {
                            this._endOfContent = HttpTokens.EndOfContent.NO_CONTENT;
                        } else if (this._endOfContent == HttpTokens.EndOfContent.UNKNOWN_CONTENT) {
                            this._endOfContent = this._responseStatus == 0 || this._responseStatus == 304 || this._responseStatus == 204 || this._responseStatus < 200 ? HttpTokens.EndOfContent.NO_CONTENT : HttpTokens.EndOfContent.EOF_CONTENT;
                        }
                        switch (this._endOfContent) {
                            case EOF_CONTENT: {
                                this.setState(State.EOF_CONTENT);
                                handle = this._handler.headerComplete() || handle;
                                break block0;
                            }
                            case CHUNKED_CONTENT: {
                                this.setState(State.CHUNKED_CONTENT);
                                handle = this._handler.headerComplete() || handle;
                                break block0;
                            }
                            case NO_CONTENT: {
                                handle = this._handler.headerComplete() || handle;
                                this.setState(State.END);
                                handle = this._handler.messageComplete() || handle;
                                break block0;
                            }
                        }
                        this.setState(State.CONTENT);
                        handle = this._handler.headerComplete() || handle;
                        break;
                    }
                    if (ch <= 32) {
                        throw new BadMessage();
                    }
                    if (buffer.hasRemaining()) {
                        HttpField field;
                        HttpField httpField = field = this._connectionFields == null ? null : (HttpField)this._connectionFields.getBest(buffer, -1, buffer.remaining());
                        if (field == null) {
                            field = (HttpField)CACHE.getBest(buffer, -1, buffer.remaining());
                        }
                        if (field != null) {
                            String v;
                            String n;
                            if (this._strict) {
                                String fn = field.getName();
                                String fv = field.getValue();
                                n = BufferUtil.toString((ByteBuffer)buffer, (int)(buffer.position() - 1), (int)fn.length(), (Charset)StandardCharsets.US_ASCII);
                                if (fv == null) {
                                    v = null;
                                } else {
                                    v = BufferUtil.toString((ByteBuffer)buffer, (int)(buffer.position() + fn.length() + 1), (int)fv.length(), (Charset)StandardCharsets.ISO_8859_1);
                                    field = new HttpField(field.getHeader(), n, v);
                                }
                            } else {
                                n = field.getName();
                                v = field.getValue();
                            }
                            this._header = field.getHeader();
                            this._headerString = n;
                            if (v == null) {
                                this.setState(State.HEADER_VALUE);
                                this._string.setLength(0);
                                this._length = 0;
                                buffer.position(buffer.position() + n.length() + 1);
                                break;
                            }
                            int pos = buffer.position() + n.length() + v.length() + 1;
                            byte b = buffer.get(pos);
                            if (b == 13 || b == 10) {
                                this._field = field;
                                this._valueString = v;
                                this.setState(State.HEADER_IN_VALUE);
                                if (b == 13) {
                                    this._cr = true;
                                    buffer.position(pos + 1);
                                    break;
                                }
                                buffer.position(pos);
                                break;
                            }
                            this.setState(State.HEADER_IN_VALUE);
                            this.setString(v);
                            buffer.position(pos);
                            break;
                        }
                    }
                    this.setState(State.HEADER_IN_NAME);
                    this._string.setLength(0);
                    this._string.append((char)ch);
                    this._length = 1;
                    break;
                }
                case HEADER_IN_NAME: {
                    if (ch == 58 || ch == 10) {
                        if (this._headerString == null) {
                            this._headerString = this.takeString();
                            this._header = (HttpHeader)((Object)HttpHeader.CACHE.get(this._headerString));
                        }
                        this._length = -1;
                        this.setState(ch == 10 ? State.HEADER : State.HEADER_VALUE);
                        break;
                    }
                    if (ch >= 32 || ch == 9) {
                        if (this._header != null) {
                            this.setString(this._header.asString());
                            this._header = null;
                            this._headerString = null;
                        }
                        this._string.append((char)ch);
                        if (ch <= 32) continue block14;
                        this._length = this._string.length();
                        break;
                    }
                    throw new BadMessage("Illegal character");
                }
                case HEADER_VALUE: {
                    if (ch > 32 || ch < 0) {
                        this._string.append((char)(0xFF & ch));
                        this._length = this._string.length();
                        this.setState(State.HEADER_IN_VALUE);
                        break;
                    }
                    if (ch == 32) continue block14;
                    if (ch == 9) break;
                    if (ch == 10) {
                        if (this._length > 0) {
                            this._value = null;
                            this._valueString = this._valueString == null ? this.takeString() : this._valueString + " " + this.takeString();
                        }
                        this.setState(State.HEADER);
                        break;
                    }
                    throw new BadMessage("Illegal character");
                }
                case HEADER_IN_VALUE: {
                    if (ch >= 32 || ch < 0) {
                        if (this._valueString != null) {
                            this.setString(this._valueString);
                            this._valueString = null;
                            this._field = null;
                        }
                        this._string.append((char)(0xFF & ch));
                        if (ch <= 32 && ch >= 0) continue block14;
                        this._length = this._string.length();
                        break;
                    }
                    if (ch == 10) {
                        if (this._length > 0) {
                            this._value = null;
                            this._valueString = this.takeString();
                            this._length = -1;
                        }
                        this.setState(State.HEADER);
                        break;
                    }
                    throw new BadMessage("Illegal character");
                }
                default: {
                    throw new IllegalStateException(this._state.toString());
                }
            }
        }
        return handle;
    }

    public boolean parseNext(ByteBuffer buffer) {
        if (this.DEBUG) {
            LOG.debug("parseNext s={} {}", new Object[]{this._state, BufferUtil.toDetailString((ByteBuffer)buffer)});
        }
        try {
            boolean handle = false;
            if (this._state == State.START) {
                this._version = null;
                this._method = null;
                this._methodString = null;
                this._endOfContent = HttpTokens.EndOfContent.UNKNOWN_CONTENT;
                this._header = null;
                handle = this.quickStart(buffer);
            }
            if (!handle && this._state.ordinal() >= State.START.ordinal() && this._state.ordinal() < State.HEADER.ordinal()) {
                handle = this.parseLine(buffer);
            }
            if (!handle && this._state.ordinal() >= State.HEADER.ordinal() && this._state.ordinal() < State.CONTENT.ordinal()) {
                handle = this.parseHeaders(buffer);
            }
            if (!handle && this._state.ordinal() >= State.CONTENT.ordinal() && this._state.ordinal() < State.END.ordinal()) {
                if (this._responseStatus > 0 && this._headResponse) {
                    this.setState(State.END);
                    handle = this._handler.messageComplete();
                } else {
                    handle = this.parseContent(buffer);
                }
            }
            if (this._state == State.END) {
                while (buffer.remaining() > 0 && buffer.get(buffer.position()) <= 32) {
                    buffer.get();
                }
            } else if (this._state == State.CLOSED && BufferUtil.hasContent((ByteBuffer)buffer)) {
                this._headerBytes += buffer.remaining();
                BufferUtil.clear((ByteBuffer)buffer);
                if (this._headerBytes > this._maxHeaderBytes) {
                    throw new IllegalStateException("too much data after closed");
                }
            }
            if (this._eof && !buffer.hasRemaining()) {
                switch (this._state) {
                    case CLOSED: {
                        break;
                    }
                    case START: {
                        this._handler.earlyEOF();
                        this.setState(State.CLOSED);
                        break;
                    }
                    case END: {
                        this.setState(State.CLOSED);
                        break;
                    }
                    case EOF_CONTENT: {
                        handle = this._handler.messageComplete() || handle;
                        this.setState(State.CLOSED);
                        break;
                    }
                    case CONTENT: 
                    case CHUNKED_CONTENT: 
                    case CHUNK_SIZE: 
                    case CHUNK_PARAMS: 
                    case CHUNK: {
                        this._handler.earlyEOF();
                        this.setState(State.CLOSED);
                        break;
                    }
                    default: {
                        if (this.DEBUG) {
                            LOG.debug("{} EOF in {}", new Object[]{this, this._state});
                        }
                        this._handler.badMessage(400, null);
                        this.setState(State.CLOSED);
                    }
                }
            }
            return handle;
        }
        catch (BadMessage e) {
            BufferUtil.clear((ByteBuffer)buffer);
            LOG.warn("badMessage: " + e._code + (e._message != null ? " " + e._message : "") + " for " + this._handler, new Object[0]);
            if (this.DEBUG) {
                LOG.debug((Throwable)e);
            }
            this.setState(State.CLOSED);
            this._handler.badMessage(e._code, e._message);
            return false;
        }
        catch (Exception e) {
            BufferUtil.clear((ByteBuffer)buffer);
            LOG.warn("badMessage: " + e.toString() + " for " + this._handler, new Object[0]);
            if (this.DEBUG) {
                LOG.debug((Throwable)e);
            }
            if (this._state.ordinal() <= State.END.ordinal()) {
                this.setState(State.CLOSED);
                this._handler.badMessage(400, null);
            } else {
                this._handler.earlyEOF();
                this.setState(State.CLOSED);
            }
            return false;
        }
    }

    protected boolean parseContent(ByteBuffer buffer) {
        block9: while (this._state.ordinal() < State.END.ordinal() && buffer.hasRemaining()) {
            switch (this._state) {
                case EOF_CONTENT: {
                    this._contentChunk = buffer.asReadOnlyBuffer();
                    this._contentPosition += (long)this._contentChunk.remaining();
                    buffer.position(buffer.position() + this._contentChunk.remaining());
                    if (!this._handler.content(this._contentChunk)) continue block9;
                    return true;
                }
                case CONTENT: {
                    long remaining = this._contentLength - this._contentPosition;
                    if (remaining == 0L) {
                        this.setState(State.END);
                        if (!this._handler.messageComplete()) continue block9;
                        return true;
                    }
                    this._contentChunk = buffer.asReadOnlyBuffer();
                    if ((long)this._contentChunk.remaining() > remaining) {
                        this._contentChunk.limit(this._contentChunk.position() + (int)remaining);
                    }
                    this._contentPosition += (long)this._contentChunk.remaining();
                    buffer.position(buffer.position() + this._contentChunk.remaining());
                    boolean handle = this._handler.content(this._contentChunk);
                    if (this._contentPosition == this._contentLength) {
                        this.setState(State.END);
                        if (this._handler.messageComplete()) {
                            return true;
                        }
                    }
                    if (!handle) continue block9;
                    return true;
                }
                case CHUNKED_CONTENT: {
                    byte ch = this.next(buffer);
                    if (ch <= 32) continue block9;
                    this._chunkLength = TypeUtil.convertHexDigit((byte)ch);
                    this._chunkPosition = 0;
                    this.setState(State.CHUNK_SIZE);
                    continue block9;
                }
                case CHUNK_SIZE: {
                    byte ch = this.next(buffer);
                    if (ch == 0) continue block9;
                    if (ch == 10) {
                        if (this._chunkLength == 0) {
                            this.setState(State.END);
                            if (!this._handler.messageComplete()) continue block9;
                            return true;
                        }
                        this.setState(State.CHUNK);
                        continue block9;
                    }
                    if (ch <= 32 || ch == 59) {
                        this.setState(State.CHUNK_PARAMS);
                        continue block9;
                    }
                    this._chunkLength = this._chunkLength * 16 + TypeUtil.convertHexDigit((byte)ch);
                    continue block9;
                }
                case CHUNK_PARAMS: {
                    byte ch = this.next(buffer);
                    if (ch != 10) continue block9;
                    if (this._chunkLength == 0) {
                        this.setState(State.END);
                        if (!this._handler.messageComplete()) continue block9;
                        return true;
                    }
                    this.setState(State.CHUNK);
                    continue block9;
                }
                case CHUNK: {
                    int remaining = this._chunkLength - this._chunkPosition;
                    if (remaining == 0) {
                        this.setState(State.CHUNKED_CONTENT);
                        continue block9;
                    }
                    this._contentChunk = buffer.asReadOnlyBuffer();
                    if (this._contentChunk.remaining() > remaining) {
                        this._contentChunk.limit(this._contentChunk.position() + remaining);
                    }
                    remaining = this._contentChunk.remaining();
                    this._contentPosition += (long)remaining;
                    this._chunkPosition += remaining;
                    buffer.position(buffer.position() + remaining);
                    if (!this._handler.content(this._contentChunk)) continue block9;
                    return true;
                }
                case CLOSED: {
                    BufferUtil.clear((ByteBuffer)buffer);
                    return false;
                }
            }
        }
        return false;
    }

    public boolean isAtEOF() {
        return this._eof;
    }

    public void atEOF() {
        if (this.DEBUG) {
            LOG.debug("atEOF {}", new Object[]{this});
        }
        this._eof = true;
    }

    public void close() {
        if (this.DEBUG) {
            LOG.debug("close {}", new Object[]{this});
        }
        this.setState(State.CLOSED);
    }

    public void reset() {
        if (this.DEBUG) {
            LOG.debug("reset {}", new Object[]{this});
        }
        if (this._state == State.CLOSED) {
            return;
        }
        if (this._closed) {
            this.setState(State.CLOSED);
            return;
        }
        this.setState(State.START);
        this._endOfContent = HttpTokens.EndOfContent.UNKNOWN_CONTENT;
        this._contentLength = -1L;
        this._contentPosition = 0L;
        this._responseStatus = 0;
        this._contentChunk = null;
        this._headerBytes = 0;
        this._host = false;
    }

    protected void setState(State state) {
        if (this.DEBUG) {
            LOG.debug("{} --> {}", new Object[]{this._state, state});
        }
        this._state = state;
    }

    public String toString() {
        return String.format("%s{s=%s,%d of %d}", new Object[]{this.getClass().getSimpleName(), this._state, this._contentPosition, this._contentLength});
    }

    public Trie<HttpField> getFieldCache() {
        return this._connectionFields;
    }

    static {
        CACHE.put((Object)new HttpField(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE));
        CACHE.put((Object)new HttpField(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE));
        CACHE.put((Object)new HttpField(HttpHeader.CONNECTION, HttpHeaderValue.UPGRADE));
        CACHE.put((Object)new HttpField(HttpHeader.ACCEPT_ENCODING, "gzip"));
        CACHE.put((Object)new HttpField(HttpHeader.ACCEPT_ENCODING, "gzip, deflate"));
        CACHE.put((Object)new HttpField(HttpHeader.ACCEPT_ENCODING, "gzip,deflate,sdch"));
        CACHE.put((Object)new HttpField(HttpHeader.ACCEPT_LANGUAGE, "en-US,en;q=0.5"));
        CACHE.put((Object)new HttpField(HttpHeader.ACCEPT_LANGUAGE, "en-GB,en-US;q=0.8,en;q=0.6"));
        CACHE.put((Object)new HttpField(HttpHeader.ACCEPT_CHARSET, "ISO-8859-1,utf-8;q=0.7,*;q=0.3"));
        CACHE.put((Object)new HttpField(HttpHeader.ACCEPT, "*/*"));
        CACHE.put((Object)new HttpField(HttpHeader.ACCEPT, "image/png,image/*;q=0.8,*/*;q=0.5"));
        CACHE.put((Object)new HttpField(HttpHeader.ACCEPT, "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8"));
        CACHE.put((Object)new HttpField(HttpHeader.PRAGMA, "no-cache"));
        CACHE.put((Object)new HttpField(HttpHeader.CACHE_CONTROL, "private, no-cache, no-cache=Set-Cookie, proxy-revalidate"));
        CACHE.put((Object)new HttpField(HttpHeader.CACHE_CONTROL, "no-cache"));
        CACHE.put((Object)new HttpField(HttpHeader.CONTENT_LENGTH, "0"));
        CACHE.put((Object)new HttpField(HttpHeader.CONTENT_ENCODING, "gzip"));
        CACHE.put((Object)new HttpField(HttpHeader.CONTENT_ENCODING, "deflate"));
        CACHE.put((Object)new HttpField(HttpHeader.TRANSFER_ENCODING, "chunked"));
        CACHE.put((Object)new HttpField(HttpHeader.EXPIRES, "Fri, 01 Jan 1990 00:00:00 GMT"));
        for (String string : new String[]{"text/plain", "text/html", "text/xml", "text/json", "application/x-www-form-urlencoded"}) {
            HttpField field = new HttpField(HttpHeader.CONTENT_TYPE, string);
            CACHE.put((Object)field);
            CONTENT_TYPE.put(string, (Object)field);
            for (String charset : new String[]{"UTF-8", "ISO-8859-1"}) {
                String type_charset = string + "; charset=" + charset;
                field = new HttpField(HttpHeader.CONTENT_TYPE, type_charset);
                CACHE.put((Object)field);
                CACHE.put((Object)new HttpField(HttpHeader.CONTENT_TYPE, string + ";charset=" + charset));
                CONTENT_TYPE.put(type_charset, (Object)field);
                CONTENT_TYPE.put(string + ";charset=" + charset, (Object)field);
            }
        }
        for (HttpHeader httpHeader : HttpHeader.values()) {
            if (CACHE.put((Object)new HttpField(httpHeader, (String)null))) continue;
            throw new IllegalStateException("CACHE FULL");
        }
        CACHE.put((Object)new HttpField(HttpHeader.REFERER, (String)null));
        CACHE.put((Object)new HttpField(HttpHeader.IF_MODIFIED_SINCE, (String)null));
        CACHE.put((Object)new HttpField(HttpHeader.IF_NONE_MATCH, (String)null));
        CACHE.put((Object)new HttpField(HttpHeader.AUTHORIZATION, (String)null));
        CACHE.put((Object)new HttpField(HttpHeader.COOKIE, (String)null));
    }

    public static interface ResponseHandler<T>
    extends HttpHandler<T> {
        public boolean startResponse(HttpVersion var1, int var2, String var3);
    }

    public static interface RequestHandler<T>
    extends HttpHandler<T> {
        public boolean startRequest(HttpMethod var1, String var2, ByteBuffer var3, HttpVersion var4);

        public boolean parsedHostHeader(String var1, int var2);
    }

    public static interface HttpHandler<T> {
        public boolean content(T var1);

        public boolean headerComplete();

        public boolean messageComplete();

        public boolean parsedHeader(HttpField var1);

        public void earlyEOF();

        public void badMessage(int var1, String var2);

        public int getHeaderCacheSize();
    }

    private static class BadMessage
    extends Error {
        private static final long serialVersionUID = 1L;
        private final int _code;
        private final String _message;

        BadMessage() {
            this(400, null);
        }

        BadMessage(int code) {
            this(code, null);
        }

        BadMessage(String message) {
            this(400, message);
        }

        BadMessage(int code, String message) {
            this._code = code;
            this._message = message;
        }
    }

    public static enum State {
        START,
        METHOD,
        RESPONSE_VERSION,
        SPACE1,
        STATUS,
        URI,
        SPACE2,
        REQUEST_VERSION,
        REASON,
        HEADER,
        HEADER_IN_NAME,
        HEADER_VALUE,
        HEADER_IN_VALUE,
        CONTENT,
        EOF_CONTENT,
        CHUNKED_CONTENT,
        CHUNK_SIZE,
        CHUNK_PARAMS,
        CHUNK,
        END,
        CLOSED;

    }
}

