/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.eclipse.jetty.client.Address;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.SelectConnector;
import org.eclipse.jetty.client.SocketConnector;
import org.eclipse.jetty.client.security.Authentication;
import org.eclipse.jetty.client.security.RealmResolver;
import org.eclipse.jetty.http.HttpBuffers;
import org.eclipse.jetty.http.HttpSchemes;
import org.eclipse.jetty.http.security.Password;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.nio.DirectNIOBuffer;
import org.eclipse.jetty.io.nio.IndirectNIOBuffer;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.AttributesMap;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.util.thread.Timeout;

public class HttpClient
extends HttpBuffers
implements Attributes {
    public static final int CONNECTOR_SOCKET = 0;
    public static final int CONNECTOR_SELECT_CHANNEL = 2;
    private int _connectorType = 2;
    private boolean _useDirectBuffers = true;
    private int _maxConnectionsPerAddress = Integer.MAX_VALUE;
    private ConcurrentMap<Address, HttpDestination> _destinations = new ConcurrentHashMap<Address, HttpDestination>();
    ThreadPool _threadPool;
    Connector _connector;
    private long _idleTimeout = 20000L;
    private long _timeout = 320000L;
    private int _connectTimeout = 75000;
    private Timeout _timeoutQ = new Timeout();
    private Timeout _idleTimeoutQ = new Timeout();
    private Address _proxy;
    private Authentication _proxyAuthentication;
    private Set<String> _noProxy;
    private int _maxRetries = 3;
    private int _maxRedirects = 20;
    private LinkedList<String> _registeredListeners;
    private String _keyStoreLocation;
    private InputStream _keyStoreInputStream;
    private String _keyStoreType = "JKS";
    private String _keyStorePassword;
    private String _keyManagerAlgorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm") == null ? "SunX509" : Security.getProperty("ssl.KeyManagerFactory.algorithm");
    private String _keyManagerPassword;
    private String _trustStoreLocation;
    private InputStream _trustStoreInputStream;
    private String _trustStoreType = "JKS";
    private String _trustStorePassword;
    private String _trustManagerAlgorithm = Security.getProperty("ssl.TrustManagerFactory.algorithm") == null ? "SunX509" : Security.getProperty("ssl.TrustManagerFactory.algorithm");
    private String _protocol = "TLS";
    private String _provider;
    private String _secureRandomAlgorithm;
    private SSLContext _sslContext;
    private RealmResolver _realmResolver;
    private AttributesMap _attributes = new AttributesMap();

    public void dump() {
        try {
            for (Map.Entry entry : this._destinations.entrySet()) {
                Log.info((String)("\n" + entry.getKey() + ":"));
                ((HttpDestination)entry.getValue()).dump();
            }
        }
        catch (Exception e) {
            Log.warn((Throwable)e);
        }
    }

    public void send(HttpExchange exchange) throws IOException {
        boolean ssl = HttpSchemes.HTTPS_BUFFER.equalsIgnoreCase(exchange.getScheme());
        exchange.setStatus(1);
        HttpDestination destination = this.getDestination(exchange.getAddress(), ssl);
        destination.send(exchange);
    }

    public ThreadPool getThreadPool() {
        return this._threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this._threadPool = threadPool;
    }

    public Object getAttribute(String name) {
        return this._attributes.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this._attributes.getAttributeNames();
    }

    public void removeAttribute(String name) {
        this._attributes.removeAttribute(name);
    }

    public void setAttribute(String name, Object attribute) {
        this._attributes.setAttribute(name, attribute);
    }

    public void clearAttributes() {
        this._attributes.clearAttributes();
    }

    public HttpDestination getDestination(Address remote, boolean ssl) throws UnknownHostException, IOException {
        if (remote == null) {
            throw new UnknownHostException("Remote socket address cannot be null.");
        }
        HttpDestination destination = (HttpDestination)this._destinations.get(remote);
        if (destination == null) {
            HttpDestination other;
            destination = new HttpDestination(this, remote, ssl, this._maxConnectionsPerAddress);
            if (!(this._proxy == null || this._noProxy != null && this._noProxy.contains(remote.getHost()))) {
                destination.setProxy(this._proxy);
                if (this._proxyAuthentication != null) {
                    destination.setProxyAuthentication(this._proxyAuthentication);
                }
            }
            if ((other = this._destinations.putIfAbsent(remote, destination)) != null) {
                destination = other;
            }
        }
        return destination;
    }

    public void schedule(Timeout.Task task) {
        this._timeoutQ.schedule(task);
    }

    public void schedule(Timeout.Task task, long timeout) {
        this._timeoutQ.schedule(task, timeout);
    }

    public void scheduleIdle(Timeout.Task task) {
        this._idleTimeoutQ.schedule(task);
    }

    public void cancel(Timeout.Task task) {
        task.cancel();
    }

    public boolean getUseDirectBuffers() {
        return this._useDirectBuffers;
    }

    public void setRealmResolver(RealmResolver resolver) {
        this._realmResolver = resolver;
    }

    public RealmResolver getRealmResolver() {
        return this._realmResolver;
    }

    public boolean hasRealms() {
        return this._realmResolver != null;
    }

    public void registerListener(String listenerClass) {
        if (this._registeredListeners == null) {
            this._registeredListeners = new LinkedList();
        }
        this._registeredListeners.add(listenerClass);
    }

    public LinkedList<String> getRegisteredListeners() {
        return this._registeredListeners;
    }

    public void setUseDirectBuffers(boolean direct) {
        this._useDirectBuffers = direct;
    }

    public int getConnectorType() {
        return this._connectorType;
    }

    public void setConnectorType(int connectorType) {
        this._connectorType = connectorType;
    }

    protected Buffer newRequestBuffer(int size) {
        if (this._connectorType == 0) {
            return new ByteArrayBuffer(size);
        }
        return this._useDirectBuffers ? new DirectNIOBuffer(size) : new IndirectNIOBuffer(size);
    }

    protected Buffer newRequestHeader(int size) {
        if (this._connectorType == 0) {
            return new ByteArrayBuffer(size);
        }
        return new IndirectNIOBuffer(size);
    }

    protected Buffer newResponseBuffer(int size) {
        if (this._connectorType == 0) {
            return new ByteArrayBuffer(size);
        }
        return this._useDirectBuffers ? new DirectNIOBuffer(size) : new IndirectNIOBuffer(size);
    }

    protected Buffer newResponseHeader(int size) {
        if (this._connectorType == 0) {
            return new ByteArrayBuffer(size);
        }
        return new IndirectNIOBuffer(size);
    }

    protected boolean isRequestHeader(Buffer buffer) {
        if (this._connectorType == 0) {
            return buffer instanceof ByteArrayBuffer;
        }
        return buffer instanceof IndirectNIOBuffer;
    }

    protected boolean isResponseHeader(Buffer buffer) {
        if (this._connectorType == 0) {
            return buffer instanceof ByteArrayBuffer;
        }
        return buffer instanceof IndirectNIOBuffer;
    }

    public int getMaxConnectionsPerAddress() {
        return this._maxConnectionsPerAddress;
    }

    public void setMaxConnectionsPerAddress(int maxConnectionsPerAddress) {
        this._maxConnectionsPerAddress = maxConnectionsPerAddress;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this._timeoutQ.setDuration(this._timeout);
        this._timeoutQ.setNow();
        this._idleTimeoutQ.setDuration(this._idleTimeout);
        this._idleTimeoutQ.setNow();
        if (this._threadPool == null) {
            QueuedThreadPool pool = new QueuedThreadPool();
            pool.setMaxThreads(16);
            pool.setDaemon(true);
            pool.setName("HttpClient");
            this._threadPool = pool;
        }
        if (this._threadPool instanceof LifeCycle) {
            ((LifeCycle)this._threadPool).start();
        }
        this._connector = this._connectorType == 2 ? new SelectConnector(this) : new SocketConnector(this);
        this._connector.start();
        this._threadPool.dispatch(new Runnable(){

            @Override
            public void run() {
                while (HttpClient.this.isRunning()) {
                    HttpClient.this._timeoutQ.tick(System.currentTimeMillis());
                    HttpClient.this._idleTimeoutQ.tick(HttpClient.this._timeoutQ.getNow());
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        });
    }

    long getNow() {
        return this._timeoutQ.getNow();
    }

    protected void doStop() throws Exception {
        this._connector.stop();
        this._connector = null;
        if (this._threadPool instanceof LifeCycle) {
            ((LifeCycle)this._threadPool).stop();
        }
        for (HttpDestination destination : this._destinations.values()) {
            destination.close();
        }
        this._timeoutQ.cancelAll();
        this._idleTimeoutQ.cancelAll();
        super.doStop();
    }

    protected SSLContext getSSLContext() throws IOException {
        if (this._sslContext == null) {
            this._sslContext = this._keyStoreInputStream == null && this._keyStoreLocation == null ? this.getLooseSSLContext() : this.getStrictSSLContext();
        }
        return this._sslContext;
    }

    protected SSLContext getStrictSSLContext() throws IOException {
        try {
            if (this._trustStoreInputStream == null && this._trustStoreLocation == null) {
                this._trustStoreLocation = this._keyStoreLocation;
                this._trustStoreInputStream = this._keyStoreInputStream;
                this._trustStoreType = this._keyStoreType;
            }
            InputStream keyStoreInputStream = null;
            InputStream trustStoreInputStream = null;
            if (this._keyStoreInputStream != null && this._keyStoreInputStream == this._trustStoreInputStream) {
                int read;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((read = this._keyStoreInputStream.read(buffer)) >= 0) {
                    baos.write(buffer, 0, read);
                }
                this._keyStoreInputStream.close();
                keyStoreInputStream = new ByteArrayInputStream(baos.toByteArray());
                trustStoreInputStream = new ByteArrayInputStream(baos.toByteArray());
            }
            if (keyStoreInputStream == null) {
                keyStoreInputStream = this._keyStoreInputStream == null ? Resource.newResource((String)this._keyStoreLocation).getInputStream() : this._keyStoreInputStream;
            }
            KeyStore keyStore = KeyStore.getInstance(this._keyStoreType);
            keyStore.load(keyStoreInputStream, this._keyStorePassword == null ? null : this._keyStorePassword.toCharArray());
            keyStoreInputStream.close();
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(this._keyManagerAlgorithm);
            keyManagerFactory.init(keyStore, this._keyManagerPassword == null ? null : this._keyManagerPassword.toCharArray());
            KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
            if (trustStoreInputStream == null) {
                trustStoreInputStream = this._trustStoreInputStream == null ? Resource.newResource((String)this._trustStoreLocation).getInputStream() : this._trustStoreInputStream;
            }
            KeyStore trustStore = KeyStore.getInstance(this._trustStoreType);
            trustStore.load(trustStoreInputStream, this._trustStorePassword == null ? null : this._trustStorePassword.toCharArray());
            trustStoreInputStream.close();
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(this._trustManagerAlgorithm);
            trustManagerFactory.init(trustStore);
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
            SecureRandom secureRandom = this._secureRandomAlgorithm == null ? null : SecureRandom.getInstance(this._secureRandomAlgorithm);
            SSLContext context = this._provider == null ? SSLContext.getInstance(this._protocol) : SSLContext.getInstance(this._protocol, this._provider);
            context.init(keyManagers, trustManagers, secureRandom);
            return context;
        }
        catch (Exception x) {
            throw (IOException)new IOException("Error generating SSLContext for keystore " + this._keyStoreLocation).initCause(x);
        }
    }

    protected SSLContext getLooseSSLContext() throws IOException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sslContext = SSLContext.getInstance(this._protocol);
            sslContext.init(null, trustAllCerts, null);
            return sslContext;
        }
        catch (Exception x) {
            throw (IOException)new IOException("Error generating loose SSLContext").initCause(x);
        }
    }

    public long getIdleTimeout() {
        return this._idleTimeout;
    }

    public void setIdleTimeout(long ms) {
        this._idleTimeout = ms;
    }

    @Deprecated
    public int getSoTimeout() {
        return Long.valueOf(this.getTimeout()).intValue();
    }

    @Deprecated
    public void setSoTimeout(int timeout) {
        this.setTimeout(timeout);
    }

    public long getTimeout() {
        return this._timeout;
    }

    public void setTimeout(long timeout) {
        this._timeout = timeout;
    }

    public int getConnectTimeout() {
        return this._connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this._connectTimeout = connectTimeout;
    }

    public Address getProxy() {
        return this._proxy;
    }

    public void setProxy(Address proxy) {
        this._proxy = proxy;
    }

    public Authentication getProxyAuthentication() {
        return this._proxyAuthentication;
    }

    public void setProxyAuthentication(Authentication authentication) {
        this._proxyAuthentication = authentication;
    }

    public boolean isProxied() {
        return this._proxy != null;
    }

    public Set<String> getNoProxy() {
        return this._noProxy;
    }

    public void setNoProxy(Set<String> noProxyAddresses) {
        this._noProxy = noProxyAddresses;
    }

    public int maxRetries() {
        return this._maxRetries;
    }

    public void setMaxRetries(int retries) {
        this._maxRetries = retries;
    }

    public int maxRedirects() {
        return this._maxRedirects;
    }

    public void setMaxRedirects(int redirects) {
        this._maxRedirects = redirects;
    }

    public String getTrustStoreLocation() {
        return this._trustStoreLocation;
    }

    public void setTrustStoreLocation(String trustStoreLocation) {
        this._trustStoreLocation = trustStoreLocation;
    }

    public InputStream getTrustStoreInputStream() {
        return this._trustStoreInputStream;
    }

    public void setTrustStoreInputStream(InputStream trustStoreInputStream) {
        this._trustStoreInputStream = trustStoreInputStream;
    }

    public String getKeyStoreLocation() {
        return this._keyStoreLocation;
    }

    public void setKeyStoreLocation(String keyStoreLocation) {
        this._keyStoreLocation = keyStoreLocation;
    }

    public InputStream getKeyStoreInputStream() {
        return this._keyStoreInputStream;
    }

    public void setKeyStoreInputStream(InputStream keyStoreInputStream) {
        this._keyStoreInputStream = keyStoreInputStream;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this._keyStorePassword = new Password(keyStorePassword).toString();
    }

    public void setKeyManagerPassword(String keyManagerPassword) {
        this._keyManagerPassword = new Password(keyManagerPassword).toString();
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this._trustStorePassword = new Password(trustStorePassword).toString();
    }

    public String getKeyStoreType() {
        return this._keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this._keyStoreType = keyStoreType;
    }

    public String getTrustStoreType() {
        return this._trustStoreType;
    }

    public void setTrustStoreType(String trustStoreType) {
        this._trustStoreType = trustStoreType;
    }

    public String getKeyManagerAlgorithm() {
        return this._keyManagerAlgorithm;
    }

    public void setKeyManagerAlgorithm(String keyManagerAlgorithm) {
        this._keyManagerAlgorithm = keyManagerAlgorithm;
    }

    public String getTrustManagerAlgorithm() {
        return this._trustManagerAlgorithm;
    }

    public void setTrustManagerAlgorithm(String trustManagerAlgorithm) {
        this._trustManagerAlgorithm = trustManagerAlgorithm;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public void setProtocol(String protocol) {
        this._protocol = protocol;
    }

    public String getProvider() {
        return this._provider;
    }

    public void setProvider(String provider) {
        this._provider = provider;
    }

    public String getSecureRandomAlgorithm() {
        return this._secureRandomAlgorithm;
    }

    public void setSecureRandomAlgorithm(String secureRandomAlgorithm) {
        this._secureRandomAlgorithm = secureRandomAlgorithm;
    }

    static interface Connector
    extends LifeCycle {
        public void startConnection(HttpDestination var1) throws IOException;
    }
}

