/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.fetchers;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.datavec.api.records.reader.RecordReader;
import org.datavec.api.split.FileSplit;
import org.datavec.api.split.InputSplit;
import org.datavec.image.loader.BaseImageLoader;
import org.datavec.image.recordreader.objdetect.ObjectDetectionRecordReader;
import org.datavec.image.transform.ImageTransform;
import org.deeplearning4j.datasets.fetchers.CacheableExtractableDataSetFetcher;
import org.deeplearning4j.datasets.fetchers.DataSetType;

public class SvhnDataFetcher
extends CacheableExtractableDataSetFetcher {
    private static String BASE_URL = "http://ufldl.stanford.edu/";
    public static int NUM_LABELS = 10;

    public static void setBaseUrl(String baseUrl) {
        BASE_URL = baseUrl;
    }

    @Override
    public String remoteDataUrl(DataSetType set) {
        switch (set) {
            case TRAIN: {
                return BASE_URL + "housenumbers/train.tar.gz";
            }
            case TEST: {
                return BASE_URL + "housenumbers/test.tar.gz";
            }
            case VALIDATION: {
                return BASE_URL + "housenumbers/extra.tar.gz";
            }
        }
        throw new IllegalArgumentException("Unknown DataSetType:" + (Object)((Object)set));
    }

    @Override
    public String localCacheName() {
        return "SVHN";
    }

    @Override
    public String dataSetName(DataSetType set) {
        switch (set) {
            case TRAIN: {
                return "train";
            }
            case TEST: {
                return "test";
            }
            case VALIDATION: {
                return "extra";
            }
        }
        throw new IllegalArgumentException("Unknown DataSetType:" + (Object)((Object)set));
    }

    @Override
    public long expectedChecksum(DataSetType set) {
        switch (set) {
            case TRAIN: {
                return 979655493L;
            }
            case TEST: {
                return 1629515343L;
            }
            case VALIDATION: {
                return 132781169L;
            }
        }
        throw new IllegalArgumentException("Unknown DataSetType:" + (Object)((Object)set));
    }

    public File getDataSetPath(DataSetType set) throws IOException {
        File datasetPath;
        File localCache = this.getLocalCacheDir();
        SvhnDataFetcher.deleteIfEmpty(localCache);
        switch (set) {
            case TRAIN: {
                datasetPath = new File(localCache, "/train/");
                break;
            }
            case TEST: {
                datasetPath = new File(localCache, "/test/");
                break;
            }
            case VALIDATION: {
                datasetPath = new File(localCache, "/extra/");
                break;
            }
            default: {
                datasetPath = null;
            }
        }
        if (!datasetPath.exists()) {
            this.downloadAndExtract(set);
        }
        return datasetPath;
    }

    @Override
    public RecordReader getRecordReader(long rngSeed, int[] imgDim, DataSetType set, ImageTransform imageTransform) {
        try {
            Random rng = new Random(rngSeed);
            File datasetPath = this.getDataSetPath(set);
            FileSplit data = new FileSplit(datasetPath, BaseImageLoader.ALLOWED_FORMATS, rng);
            ObjectDetectionRecordReader recordReader = new ObjectDetectionRecordReader(imgDim[1], imgDim[0], imgDim[2], imgDim[4], imgDim[3], null);
            recordReader.initialize((InputSplit)data);
            return recordReader;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not download SVHN", e);
        }
    }
}

