/*
 * Decompiled with CFR 0.152.
 */
package org.debux.webmotion.jpa;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.debux.webmotion.jpa.GenericDAO;
import org.debux.webmotion.server.WebMotionFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Transactional
extends WebMotionFilter {
    private static final Logger log = LoggerFactory.getLogger(Transactional.class);
    public static String DEFAULT_PERSISTENCE_UNIT_NAME = "webmotion";
    public static String CURRENT_ENTITY_MANAGER = "wm_current_entity_manager";
    public static String CURRENT_ENTITY_TRANSACTION = "wm_current_entity_transaction";
    public static String CURRENT_GENERIC_DAO = "wm_current_generic_dao";
    protected Map<String, EntityManagerFactory> factories = new HashMap<String, EntityManagerFactory>();

    public void tx(HttpServletRequest request, String persistenceUnitName, org.debux.webmotion.server.mapping.Properties properties, String packageEntityName, String entityName) throws Exception {
        EntityManager manager;
        EntityManagerFactory factory;
        if (persistenceUnitName == null || persistenceUnitName.isEmpty()) {
            persistenceUnitName = DEFAULT_PERSISTENCE_UNIT_NAME;
        }
        if ((factory = this.factories.get(persistenceUnitName)) == null) {
            Configuration subset = properties.subset(persistenceUnitName);
            Properties additionalProperties = ConfigurationConverter.getProperties((Configuration)subset);
            factory = Persistence.createEntityManagerFactory((String)persistenceUnitName, (Map)additionalProperties);
            this.factories.put(persistenceUnitName, factory);
        }
        if ((manager = (EntityManager)request.getAttribute(CURRENT_ENTITY_MANAGER)) == null) {
            manager = factory.createEntityManager();
            request.setAttribute(CURRENT_ENTITY_MANAGER, (Object)manager);
        }
        if (entityName != null) {
            String fullEntityName = null;
            fullEntityName = packageEntityName != null && !packageEntityName.isEmpty() ? packageEntityName + "." + entityName : entityName;
            GenericDAO genericDAO = new GenericDAO(manager, fullEntityName);
            request.setAttribute(CURRENT_GENERIC_DAO, (Object)genericDAO);
        } else {
            request.setAttribute(CURRENT_GENERIC_DAO, null);
        }
        EntityTransaction transaction = (EntityTransaction)request.getAttribute(CURRENT_ENTITY_TRANSACTION);
        if (transaction == null) {
            transaction = manager.getTransaction();
            request.setAttribute(CURRENT_ENTITY_TRANSACTION, (Object)transaction);
            transaction.begin();
            try {
                this.doProcess();
            }
            catch (Exception e) {
                if (transaction.isActive()) {
                    transaction.rollback();
                }
                throw e;
            }
            if (transaction.isActive()) {
                transaction.commit();
            }
            manager.close();
        } else {
            this.doProcess();
        }
    }
}

