/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.sequence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.datavec.api.transform.Transform;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonInclude;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"inputSchema", "columnsToOffsetSet"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SequenceOffsetTransform
implements Transform {
    private List<String> columnsToOffset;
    private int offsetAmount;
    private OperationType operationType;
    private EdgeHandling edgeHandling;
    private Writable edgeCaseValue;
    private Set<String> columnsToOffsetSet;
    private Schema inputSchema;

    public SequenceOffsetTransform(@JsonProperty(value="columnsToOffset") List<String> columnsToOffset, @JsonProperty(value="offsetAmount") int offsetAmount, @JsonProperty(value="operationType") OperationType operationType, @JsonProperty(value="edgeHandling") EdgeHandling edgeHandling, @JsonProperty(value="edgeCaseValue") Writable edgeCaseValue) {
        if (edgeCaseValue != null && edgeHandling != EdgeHandling.SpecifiedValue) {
            throw new UnsupportedOperationException("edgeCaseValue was non-null, but EdgeHandling was not set to SpecifiedValue. edgeCaseValue can only be used with SpecifiedValue mode");
        }
        this.columnsToOffset = columnsToOffset;
        this.offsetAmount = offsetAmount;
        this.operationType = operationType;
        this.edgeHandling = edgeHandling;
        this.edgeCaseValue = edgeCaseValue;
        this.columnsToOffsetSet = new HashSet<String>(columnsToOffset);
    }

    @Override
    public Schema transform(Schema inputSchema) {
        for (String s : this.columnsToOffset) {
            if (inputSchema.hasColumn(s)) continue;
            throw new IllegalStateException("Column \"" + s + "\" is not found in input schema");
        }
        ArrayList<ColumnMetaData> newMeta = new ArrayList<ColumnMetaData>();
        for (ColumnMetaData m : inputSchema.getColumnMetaData()) {
            if (this.columnsToOffsetSet.contains(m.getName())) {
                ColumnMetaData mNew;
                if (this.operationType == OperationType.InPlace) {
                    mNew = m.clone();
                    mNew.setName(this.getNewColumnName(m));
                    continue;
                }
                newMeta.add(m);
                mNew = m.clone();
                mNew.setName(this.getNewColumnName(m));
                newMeta.add(mNew);
                continue;
            }
            newMeta.add(m);
        }
        return inputSchema.newSchema(newMeta);
    }

    private String getNewColumnName(ColumnMetaData m) {
        return "sequenceOffset(" + this.offsetAmount + "," + m.getName() + ")";
    }

    @Override
    public void setInputSchema(Schema inputSchema) {
        this.inputSchema = inputSchema;
    }

    @Override
    public String outputColumnName() {
        return this.outputColumnNames()[0];
    }

    @Override
    public String[] outputColumnNames() {
        return this.inputSchema.getColumnNames().toArray(new String[this.inputSchema.numColumns()]);
    }

    @Override
    public String[] columnNames() {
        return this.outputColumnNames();
    }

    @Override
    public String columnName() {
        return this.outputColumnName();
    }

    @Override
    public List<Writable> map(List<Writable> writables) {
        throw new UnsupportedOperationException("SequenceOffsetTransform cannot be applied to non-sequence data");
    }

    @Override
    public List<List<Writable>> mapSequence(List<List<Writable>> sequence) {
        int lastOutputStepInclusive;
        int firstOutputStepInclusive;
        if (this.offsetAmount >= sequence.size() && this.edgeHandling == EdgeHandling.TrimSequence) {
            return Collections.emptyList();
        }
        List<String> colNames = this.inputSchema.getColumnNames();
        int nIn = this.inputSchema.numColumns();
        int nOut = nIn + (this.operationType == OperationType.InPlace ? 0 : this.columnsToOffset.size());
        if (this.edgeHandling == EdgeHandling.TrimSequence) {
            if (this.offsetAmount >= 0) {
                firstOutputStepInclusive = this.offsetAmount;
                lastOutputStepInclusive = sequence.size() - 1;
            } else {
                firstOutputStepInclusive = 0;
                lastOutputStepInclusive = sequence.size() - 1 + this.offsetAmount;
            }
        } else {
            firstOutputStepInclusive = 0;
            lastOutputStepInclusive = sequence.size() - 1;
        }
        ArrayList<List<Writable>> out = new ArrayList<List<Writable>>();
        for (int step = firstOutputStepInclusive; step <= lastOutputStepInclusive; ++step) {
            List<Writable> thisStepIn = sequence.get(step);
            ArrayList<Writable> thisStepOut = new ArrayList<Writable>(nOut);
            for (int j = 0; j < nIn; ++j) {
                if (this.columnsToOffsetSet.contains(colNames.get(j))) {
                    if (this.edgeHandling == EdgeHandling.SpecifiedValue && step - this.offsetAmount < 0 || step - this.offsetAmount >= sequence.size()) {
                        if (this.operationType == OperationType.NewColumn) {
                            thisStepOut.add(thisStepIn.get(j));
                        }
                        thisStepOut.add(this.edgeCaseValue);
                        continue;
                    }
                    Writable shifted = sequence.get(step - this.offsetAmount).get(j);
                    if (this.operationType == OperationType.InPlace) {
                        thisStepOut.add(shifted);
                        continue;
                    }
                    thisStepOut.add(thisStepIn.get(j));
                    thisStepOut.add(shifted);
                    continue;
                }
                thisStepOut.add(thisStepIn.get(j));
            }
            out.add(thisStepOut);
        }
        return out;
    }

    @Override
    public Object map(Object input) {
        throw new UnsupportedOperationException("SequenceOffsetTransform cannot be applied to non-sequence data");
    }

    @Override
    public Object mapSequence(Object sequence) {
        throw new UnsupportedOperationException("Not yet implemented/supported");
    }

    public List<String> getColumnsToOffset() {
        return this.columnsToOffset;
    }

    public int getOffsetAmount() {
        return this.offsetAmount;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public EdgeHandling getEdgeHandling() {
        return this.edgeHandling;
    }

    public Writable getEdgeCaseValue() {
        return this.edgeCaseValue;
    }

    public Set<String> getColumnsToOffsetSet() {
        return this.columnsToOffsetSet;
    }

    public void setColumnsToOffset(List<String> columnsToOffset) {
        this.columnsToOffset = columnsToOffset;
    }

    public void setOffsetAmount(int offsetAmount) {
        this.offsetAmount = offsetAmount;
    }

    public void setOperationType(OperationType operationType) {
        this.operationType = operationType;
    }

    public void setEdgeHandling(EdgeHandling edgeHandling) {
        this.edgeHandling = edgeHandling;
    }

    public void setEdgeCaseValue(Writable edgeCaseValue) {
        this.edgeCaseValue = edgeCaseValue;
    }

    public void setColumnsToOffsetSet(Set<String> columnsToOffsetSet) {
        this.columnsToOffsetSet = columnsToOffsetSet;
    }

    public String toString() {
        return "SequenceOffsetTransform(columnsToOffset=" + this.getColumnsToOffset() + ", offsetAmount=" + this.getOffsetAmount() + ", operationType=" + this.getOperationType() + ", edgeHandling=" + this.getEdgeHandling() + ", edgeCaseValue=" + this.getEdgeCaseValue() + ", columnsToOffsetSet=" + this.getColumnsToOffsetSet() + ", inputSchema=" + this.getInputSchema() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SequenceOffsetTransform)) {
            return false;
        }
        SequenceOffsetTransform other = (SequenceOffsetTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOffsetAmount() != other.getOffsetAmount()) {
            return false;
        }
        List<String> this$columnsToOffset = this.getColumnsToOffset();
        List<String> other$columnsToOffset = other.getColumnsToOffset();
        if (this$columnsToOffset == null ? other$columnsToOffset != null : !((Object)this$columnsToOffset).equals(other$columnsToOffset)) {
            return false;
        }
        OperationType this$operationType = this.getOperationType();
        OperationType other$operationType = other.getOperationType();
        if (this$operationType == null ? other$operationType != null : !((Object)((Object)this$operationType)).equals((Object)other$operationType)) {
            return false;
        }
        EdgeHandling this$edgeHandling = this.getEdgeHandling();
        EdgeHandling other$edgeHandling = other.getEdgeHandling();
        if (this$edgeHandling == null ? other$edgeHandling != null : !((Object)((Object)this$edgeHandling)).equals((Object)other$edgeHandling)) {
            return false;
        }
        Writable this$edgeCaseValue = this.getEdgeCaseValue();
        Writable other$edgeCaseValue = other.getEdgeCaseValue();
        return !(this$edgeCaseValue == null ? other$edgeCaseValue != null : !this$edgeCaseValue.equals(other$edgeCaseValue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SequenceOffsetTransform;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getOffsetAmount();
        List<String> $columnsToOffset = this.getColumnsToOffset();
        result = result * 59 + ($columnsToOffset == null ? 43 : ((Object)$columnsToOffset).hashCode());
        OperationType $operationType = this.getOperationType();
        result = result * 59 + ($operationType == null ? 43 : ((Object)((Object)$operationType)).hashCode());
        EdgeHandling $edgeHandling = this.getEdgeHandling();
        result = result * 59 + ($edgeHandling == null ? 43 : ((Object)((Object)$edgeHandling)).hashCode());
        Writable $edgeCaseValue = this.getEdgeCaseValue();
        result = result * 59 + ($edgeCaseValue == null ? 43 : $edgeCaseValue.hashCode());
        return result;
    }

    @Override
    public Schema getInputSchema() {
        return this.inputSchema;
    }

    public static enum EdgeHandling {
        TrimSequence,
        SpecifiedValue;

    }

    public static enum OperationType {
        InPlace,
        NewColumn;

    }
}

