/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.ndarray;

import org.datavec.api.transform.MathFunction;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.transform.BaseColumnTransform;
import org.datavec.api.writable.NDArrayWritable;
import org.datavec.api.writable.Writable;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.ops.transforms.Transforms;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class NDArrayMathFunctionTransform
extends BaseColumnTransform {
    private static final boolean DUP = true;
    private final MathFunction mathFunction;

    public NDArrayMathFunctionTransform(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="mathFunction") MathFunction mathFunction) {
        super(columnName);
        this.mathFunction = mathFunction;
    }

    @Override
    public ColumnMetaData getNewColumnMetaData(String newName, ColumnMetaData oldColumnType) {
        ColumnMetaData m = oldColumnType.clone();
        m.setName(newName);
        return m;
    }

    @Override
    public NDArrayWritable map(Writable w) {
        NDArrayWritable o;
        NDArrayWritable n = (NDArrayWritable)w;
        INDArray i = n.get();
        if (i == null) {
            return n;
        }
        switch (this.mathFunction) {
            case ABS: {
                o = new NDArrayWritable(Transforms.abs((INDArray)i, (boolean)true));
                break;
            }
            case ACOS: {
                o = new NDArrayWritable(Transforms.acos((INDArray)i, (boolean)true));
                break;
            }
            case ASIN: {
                o = new NDArrayWritable(Transforms.asin((INDArray)i, (boolean)true));
                break;
            }
            case ATAN: {
                o = new NDArrayWritable(Transforms.atan((INDArray)i, (boolean)true));
                break;
            }
            case CEIL: {
                o = new NDArrayWritable(Transforms.ceil((INDArray)i, (boolean)true));
                break;
            }
            case COS: {
                o = new NDArrayWritable(Transforms.cos((INDArray)i, (boolean)true));
                break;
            }
            case COSH: {
                throw new UnsupportedOperationException("sinh operation not yet supported for NDArray columns");
            }
            case EXP: {
                o = new NDArrayWritable(Transforms.exp((INDArray)i, (boolean)true));
                break;
            }
            case FLOOR: {
                o = new NDArrayWritable(Transforms.floor((INDArray)i, (boolean)true));
                break;
            }
            case LOG: {
                o = new NDArrayWritable(Transforms.log((INDArray)i, (boolean)true));
                break;
            }
            case LOG10: {
                o = new NDArrayWritable(Transforms.log((INDArray)i, (double)10.0, (boolean)true));
                break;
            }
            case SIGNUM: {
                o = new NDArrayWritable(Transforms.sign((INDArray)i, (boolean)true));
                break;
            }
            case SIN: {
                o = new NDArrayWritable(Transforms.sin((INDArray)i, (boolean)true));
                break;
            }
            case SINH: {
                throw new UnsupportedOperationException("sinh operation not yet supported for NDArray columns");
            }
            case SQRT: {
                o = new NDArrayWritable(Transforms.sqrt((INDArray)i, (boolean)true));
                break;
            }
            case TAN: {
                INDArray sinx = Transforms.sin((INDArray)i, (boolean)true);
                INDArray cosx = Transforms.cos((INDArray)i, (boolean)true);
                o = new NDArrayWritable(sinx.divi(cosx));
                break;
            }
            case TANH: {
                o = new NDArrayWritable(Transforms.tanh((INDArray)i, (boolean)true));
                break;
            }
            default: {
                throw new RuntimeException("Unknown function: " + this.mathFunction);
            }
        }
        Nd4j.getExecutioner().commit();
        return o;
    }

    @Override
    public String toString() {
        return "NDArrayMathFunctionTransform(column=" + this.columnName + ",function=" + this.mathFunction + ")";
    }

    @Override
    public Object map(Object input) {
        if (input instanceof NDArrayWritable) {
            return this.map((NDArrayWritable)input);
        }
        if (input instanceof INDArray) {
            return this.map(new NDArrayWritable((INDArray)input)).get();
        }
        throw new UnsupportedOperationException("Unknown object type: " + (input == null ? null : input.getClass()));
    }

    public MathFunction getMathFunction() {
        return this.mathFunction;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NDArrayMathFunctionTransform)) {
            return false;
        }
        NDArrayMathFunctionTransform other = (NDArrayMathFunctionTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MathFunction this$mathFunction = this.getMathFunction();
        MathFunction other$mathFunction = other.getMathFunction();
        return !(this$mathFunction == null ? other$mathFunction != null : !((Object)((Object)this$mathFunction)).equals((Object)other$mathFunction));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NDArrayMathFunctionTransform;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MathFunction $mathFunction = this.getMathFunction();
        result = result * 59 + ($mathFunction == null ? 43 : ((Object)((Object)$mathFunction)).hashCode());
        return result;
    }
}

