/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.analysis.counter;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.datavec.api.transform.analysis.AnalysisCounter;
import org.datavec.api.transform.analysis.columns.NDArrayAnalysis;
import org.datavec.api.writable.NDArrayWritable;
import org.datavec.api.writable.Writable;
import org.nd4j.linalg.api.ndarray.INDArray;

public class NDArrayAnalysisCounter
implements AnalysisCounter<NDArrayAnalysisCounter> {
    private long countTotal;
    private long countNull;
    private long minLength = Long.MAX_VALUE;
    private long maxLength = -1L;
    private long totalNDArrayValues;
    private Map<Integer, Long> countsByRank = new HashMap<Integer, Long>();
    private double minValue = Double.MAX_VALUE;
    private double maxValue = -1.7976931348623157E308;

    @Override
    public NDArrayAnalysisCounter add(Writable writable) {
        NDArrayWritable n = (NDArrayWritable)writable;
        INDArray arr = n.get();
        ++this.countTotal;
        if (arr == null) {
            ++this.countNull;
        } else {
            this.minLength = Math.min(this.minLength, arr.length());
            this.maxLength = Math.max(this.maxLength, arr.length());
            int r = arr.rank();
            if (this.countsByRank.containsKey(arr.rank())) {
                this.countsByRank.put(r, this.countsByRank.get(r) + 1L);
            } else {
                this.countsByRank.put(r, 1L);
            }
            this.totalNDArrayValues += arr.length();
            this.minValue = Math.min(this.minValue, arr.minNumber().doubleValue());
            this.maxValue = Math.max(this.maxValue, arr.maxNumber().doubleValue());
        }
        return this;
    }

    @Override
    public NDArrayAnalysisCounter merge(NDArrayAnalysisCounter other) {
        this.countTotal += other.countTotal;
        this.countNull += other.countNull;
        this.minLength = Math.min(this.minLength, other.minLength);
        this.maxLength = Math.max(this.maxLength, other.maxLength);
        this.totalNDArrayValues += other.totalNDArrayValues;
        HashSet<Integer> allKeys = new HashSet<Integer>(this.countsByRank.keySet());
        allKeys.addAll(other.countsByRank.keySet());
        for (Integer i : allKeys) {
            long count = 0L;
            if (this.countsByRank.containsKey(i)) {
                count += this.countsByRank.get(i).longValue();
            }
            if (other.countsByRank.containsKey(i)) {
                count += other.countsByRank.get(i).longValue();
            }
            this.countsByRank.put(i, count);
        }
        this.minValue = Math.min(this.minValue, other.minValue);
        this.maxValue = Math.max(this.maxValue, other.maxValue);
        return this;
    }

    public NDArrayAnalysis toAnalysisObject() {
        return NDArrayAnalysis.Builder().countTotal(this.countTotal).countNull(this.countNull).minLength(this.minLength).maxLength(this.maxLength).totalNDArrayValues(this.totalNDArrayValues).countsByRank(this.countsByRank).minValue(this.minValue).maxValue(this.maxValue).build();
    }
}

