/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.jpa;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Parameter;
import javax.persistence.PersistenceException;
import javax.persistence.QueryTimeoutException;
import javax.persistence.Result;
import javax.persistence.ResultItem;
import javax.persistence.TemporalType;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.jpa.JPAQueryParameter;
import org.datanucleus.jpa.NucleusJPAHelper;
import org.datanucleus.store.query.NoQueryResultsException;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryInvalidParametersException;
import org.datanucleus.store.query.QueryNotUniqueException;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAQuery
implements javax.persistence.Query {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.jpa.Localisation", (ClassLoader)NucleusJPAHelper.class.getClassLoader());
    EntityManager em;
    String language;
    Query query;
    FlushModeType flushMode = FlushModeType.AUTO;
    LockModeType lockMode = null;
    private long startPosition = 0L;
    private long maxResults = Long.MAX_VALUE;

    public JPAQuery(EntityManager em, Query query, String language) {
        this.em = em;
        this.query = query;
        this.language = language;
        this.flushMode = em.getFlushMode();
    }

    public int executeUpdate() {
        if (this.query.getType() == 0) {
            throw new IllegalStateException(LOCALISER.msg("Query.ExecuteUpdateForSelectInvalid"));
        }
        try {
            Object result;
            if (this.flushMode == FlushModeType.AUTO && this.em.getTransaction().isActive()) {
                this.em.flush();
            }
            if ((result = this.query.executeWithMap(null)) != null) {
                return ((Long)result).intValue();
            }
            throw new NucleusException("Invalid return from query for an update/delete. Expected Long");
        }
        catch (NoQueryResultsException nqre) {
            return 0;
        }
        catch (QueryInvalidParametersException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
        catch (org.datanucleus.store.query.QueryTimeoutException qte) {
            throw new QueryTimeoutException();
        }
        catch (NucleusException jpe) {
            throw NucleusJPAHelper.getJPAExceptionForNucleusException(jpe);
        }
    }

    public List getResultList() {
        if (this.query.getType() != 0) {
            throw new IllegalStateException(LOCALISER.msg("Query.GetResultForUpdateInvalid"));
        }
        try {
            if (this.flushMode == FlushModeType.AUTO && this.em.getTransaction().isActive()) {
                this.em.flush();
            }
            return (List)this.query.executeWithMap(null);
        }
        catch (NoQueryResultsException nqre) {
            return null;
        }
        catch (QueryInvalidParametersException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
        catch (org.datanucleus.store.query.QueryTimeoutException qte) {
            throw new QueryTimeoutException();
        }
        catch (NucleusException jpe) {
            throw NucleusJPAHelper.getJPAExceptionForNucleusException(jpe);
        }
    }

    public Object getSingleResult() {
        if (this.query.getType() != 0) {
            throw new IllegalStateException(LOCALISER.msg("Query.GetResultForUpdateInvalid"));
        }
        try {
            if (this.flushMode == FlushModeType.AUTO && this.em.getTransaction().isActive()) {
                this.em.flush();
            }
            this.query.setUnique(true);
            return this.query.executeWithMap(null);
        }
        catch (NoQueryResultsException nqre) {
            throw new NoResultException("No results for query: " + this.query.toString());
        }
        catch (QueryNotUniqueException ex) {
            throw new NonUniqueResultException("Expected a single result for query: " + this.query.toString() + " : " + StringUtils.getStringFromStackTrace((Throwable)ex));
        }
        catch (QueryInvalidParametersException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
        catch (org.datanucleus.store.query.QueryTimeoutException qte) {
            throw new QueryTimeoutException();
        }
        catch (NucleusException jpe) {
            throw NucleusJPAHelper.getJPAExceptionForNucleusException(jpe);
        }
    }

    public List<Result> getTypedResultList() {
        return null;
    }

    public Result getTypedSingleResult() {
        return null;
    }

    public javax.persistence.Query setFirstResult(int startPosition) {
        if (startPosition < 0) {
            throw new IllegalArgumentException(LOCALISER.msg("Query.StartPositionInvalid"));
        }
        this.startPosition = startPosition;
        this.query.setRange(this.startPosition, this.maxResults);
        return this;
    }

    public javax.persistence.Query setMaxResults(int max) {
        if (max < 0) {
            throw new IllegalArgumentException(LOCALISER.msg("Query.MaxResultsInvalid"));
        }
        this.maxResults = max;
        this.query.setRange(this.startPosition, this.startPosition + (long)max);
        return this;
    }

    public int getMaxResults() {
        long queryMin = this.query.getRangeFromIncl();
        long queryMax = this.query.getRangeToExcl();
        long max = queryMax - queryMin;
        if (max > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)max;
    }

    public int getFirstResult() {
        return (int)this.query.getRangeFromIncl();
    }

    public javax.persistence.Query setFlushMode(FlushModeType mode) {
        this.flushMode = mode;
        return this;
    }

    public FlushModeType getFlushMode() {
        return this.flushMode;
    }

    public javax.persistence.Query setHint(String hintName, Object value) {
        this.query.addExtension(hintName, value);
        return this;
    }

    public Map getHints() {
        Map extensions = this.query.getExtensions();
        HashMap map = new HashMap();
        if (extensions != null && extensions.size() > 0) {
            map.putAll(extensions);
        }
        return map;
    }

    public Set<String> getSupportedHints() {
        return this.query.getSupportedExtensions();
    }

    public <T> javax.persistence.Query setParameter(Parameter<T> param, T value) {
        if (param.getName() != null) {
            this.setParameter(param.getName(), value);
        } else {
            this.setParameter(param.getPosition(), value);
        }
        return this;
    }

    public javax.persistence.Query setParameter(String name, Object value) {
        try {
            this.query.setImplicitParameter(name, value);
        }
        catch (QueryInvalidParametersException ipe) {
            throw new IllegalArgumentException(ipe.getMessage(), ipe);
        }
        return this;
    }

    public javax.persistence.Query setParameter(int position, Object value) {
        try {
            this.query.setImplicitParameter(position, value);
        }
        catch (QueryInvalidParametersException ipe) {
            throw new IllegalArgumentException(ipe.getMessage(), ipe);
        }
        return this;
    }

    public javax.persistence.Query setParameter(String name, Date value, TemporalType temporalType) {
        Date paramValue = value;
        if (temporalType == TemporalType.TIME && !(value instanceof Time)) {
            paramValue = new Time(value.getTime());
        } else if (temporalType == TemporalType.TIMESTAMP && !(value instanceof Timestamp)) {
            paramValue = new Timestamp(value.getTime());
        }
        try {
            this.query.setImplicitParameter(name, (Object)paramValue);
        }
        catch (QueryInvalidParametersException ipe) {
            throw new IllegalArgumentException(ipe.getMessage());
        }
        return this;
    }

    public javax.persistence.Query setParameter(String name, Calendar value, TemporalType temporalType) {
        Comparable<Calendar> paramValue = value;
        if (temporalType == TemporalType.DATE) {
            paramValue = value.getTime();
        } else if (temporalType == TemporalType.TIME) {
            paramValue = new Time(value.getTime().getTime());
        } else if (temporalType == TemporalType.TIMESTAMP) {
            paramValue = new Timestamp(value.getTime().getTime());
        }
        try {
            this.query.setImplicitParameter(name, (Object)paramValue);
        }
        catch (QueryInvalidParametersException ipe) {
            throw new IllegalArgumentException(ipe.getMessage());
        }
        return this;
    }

    public javax.persistence.Query setParameter(int position, Date value, TemporalType temporalType) {
        Date paramValue = value;
        if (temporalType == TemporalType.TIME && !(value instanceof Time)) {
            paramValue = new Time(value.getTime());
        } else if (temporalType == TemporalType.TIMESTAMP && !(value instanceof Timestamp)) {
            paramValue = new Timestamp(value.getTime());
        }
        try {
            this.query.setImplicitParameter(position, (Object)paramValue);
        }
        catch (QueryInvalidParametersException ipe) {
            throw new IllegalArgumentException(ipe.getMessage());
        }
        return this;
    }

    public javax.persistence.Query setParameter(int position, Calendar value, TemporalType temporalType) {
        Comparable<Calendar> paramValue = value;
        if (temporalType == TemporalType.DATE) {
            paramValue = value.getTime();
        } else if (temporalType == TemporalType.TIME) {
            paramValue = new Time(value.getTime().getTime());
        } else if (temporalType == TemporalType.TIMESTAMP) {
            paramValue = new Timestamp(value.getTime().getTime());
        }
        try {
            this.query.setImplicitParameter(position, (Object)paramValue);
        }
        catch (QueryInvalidParametersException ipe) {
            throw new IllegalArgumentException(ipe.getMessage());
        }
        return this;
    }

    public Query getInternalQuery() {
        return this.query;
    }

    public <T> T unwrap(Class<T> cls) {
        if (cls == Query.class) {
            return (T)this.query;
        }
        throw new PersistenceException("Not supported unwrapping of query to " + cls.getName());
    }

    public String getLanguage() {
        return this.language;
    }

    public Set<Parameter<?>> getParameters() {
        Set paramKeys = this.query.getImplicitParameters().keySet();
        HashSet parameters = new HashSet();
        for (Object paramKey : paramKeys) {
            if (paramKey instanceof String) {
                parameters.add(new JPAQueryParameter((String)paramKey));
                continue;
            }
            if (!(paramKey instanceof Integer)) continue;
            parameters.add(new JPAQueryParameter((Integer)paramKey));
        }
        return parameters;
    }

    public <T> Parameter<T> getParameter(String name, Class<T> type) {
        Set paramKeys = this.query.getImplicitParameters().keySet();
        for (Object paramKey : paramKeys) {
            Object value;
            if (!(paramKey instanceof String) || !((String)paramKey).equals(name) || (value = this.query.getImplicitParameters().get(paramKey)) == null || !type.isAssignableFrom(value.getClass())) continue;
            return new JPAQueryParameter((String)paramKey);
        }
        throw new IllegalArgumentException("No parameter with name " + name + " and type=" + type.getName());
    }

    public <T> Parameter<T> getParameter(int position, Class<T> type) {
        Set paramKeys = this.query.getImplicitParameters().keySet();
        for (Object paramKey : paramKeys) {
            Object value;
            if (!(paramKey instanceof Integer) || (Integer)paramKey != position || (value = this.query.getImplicitParameters().get(paramKey)) == null || !type.isAssignableFrom(value.getClass())) continue;
            return new JPAQueryParameter((Integer)paramKey);
        }
        throw new IllegalArgumentException("No parameter at position=" + position + " and type=" + type.getName());
    }

    public <T> T getParameterValue(Parameter<T> param) {
        if (param.getName() != null) {
            if (this.query.getImplicitParameters().containsKey(param.getName())) {
                return (T)this.query.getImplicitParameters().get(param.getName());
            }
        } else if (this.query.getImplicitParameters().containsKey(param.getPosition())) {
            return (T)this.query.getImplicitParameters().get(param.getPosition());
        }
        throw new IllegalStateException("No parameter matching " + param + " bound to this query");
    }

    public <T> ResultItem<T> getResultItem(String alias, Class<T> type) {
        return null;
    }

    public <T> ResultItem<T> getResultItem(int position, Class<T> type) {
        return null;
    }

    public List<ResultItem<?>> getResultItems() {
        return null;
    }

    public LockModeType getLockMode() {
        return this.lockMode;
    }

    public javax.persistence.Query setLockMode(LockModeType lock) {
        this.lockMode = lock;
        return this;
    }
}

