/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class PlexusCheckRoleHintsMojo
extends AbstractMojo {
    private File plexusDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File plexusXml;
        File applicationXml;
        File componentsXml = new File(this.plexusDirectory, "components.xml");
        if (componentsXml.exists()) {
            this.checkPlexusRoleHints(componentsXml);
        }
        if ((applicationXml = new File(this.plexusDirectory, "application.xml")).exists()) {
            this.checkPlexusRoleHints(applicationXml);
        }
        if ((plexusXml = new File(this.plexusDirectory, "plexus.xml")).exists()) {
            this.checkPlexusRoleHints(plexusXml);
        }
    }

    private void checkPlexusRoleHints(File componentsXml) throws MojoExecutionException, MojoFailureException {
        int violationCount = 0;
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(componentsXml);
            Element root = doc.getRootElement();
            if (!root.getName().equals("component-set")) {
                this.getLog().warn((CharSequence)"Not a plexus components.xml - doesn't start with <component-set>");
                return;
            }
            List componentsList = root.getChildren("components");
            Iterator itcomponents = componentsList.iterator();
            while (itcomponents.hasNext()) {
                Element components = (Element)itcomponents.next();
                violationCount += this.countComponentRoleHintViolations(components);
            }
            if (violationCount > 0) {
                throw new MojoFailureException(componentsXml.getAbsolutePath() + " has " + violationCount + " role-hint violation(s).");
            }
        }
        catch (JDOMException e) {
            throw new MojoExecutionException("Unable to load " + componentsXml.getAbsolutePath() + ", it is not valid.", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to load " + componentsXml.getAbsolutePath() + ": " + e.getMessage(), (Exception)e);
        }
    }

    private int countComponentRoleHintViolations(Element components) {
        int violationCount = 0;
        List componentList = components.getChildren("component");
        Iterator itcomponent = componentList.iterator();
        while (itcomponent.hasNext()) {
            Element component = (Element)itcomponent.next();
            String componentRole = component.getChildText("role");
            Element componentRoleHint = component.getChild("role-hint");
            if (componentRoleHint == null) {
                ++violationCount;
                this.getLog().error((CharSequence)("Missing <role-hint> on component definition for <role> " + componentRole));
            }
            List requirementsList = component.getChildren("requirements");
            Iterator itrequirements = requirementsList.iterator();
            while (itrequirements.hasNext()) {
                Element requirements = (Element)itrequirements.next();
                violationCount += this.countRequirementRoleHintViolations(requirements);
            }
        }
        return violationCount;
    }

    private int countRequirementRoleHintViolations(Element requirements) {
        int violationCount = 0;
        List requirementList = requirements.getChildren("requirement");
        Iterator itrequirement = requirementList.iterator();
        while (itrequirement.hasNext()) {
            Element requirement = (Element)itrequirement.next();
            String requirementRole = requirement.getChildText("role");
            Element requirementRoleHint = requirement.getChild("role-hint");
            if (requirementRoleHint != null) continue;
            ++violationCount;
            this.getLog().error((CharSequence)("Missing <role-hint> on <requirement> definition for <role> " + requirementRole));
        }
        return violationCount;
    }
}

