/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.reporting;

import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.codehaus.mojo.versions.Property;
import org.codehaus.mojo.versions.api.ArtifactAssociation;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.api.Segment;
import org.codehaus.mojo.versions.reporting.AbstractVersionsReportRenderer;
import org.codehaus.mojo.versions.reporting.OverviewStats;
import org.codehaus.mojo.versions.reporting.model.PropertyUpdatesModel;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.StringUtils;

public class PropertyUpdatesReportRenderer
extends AbstractVersionsReportRenderer<PropertyUpdatesModel> {
    public PropertyUpdatesReportRenderer(I18N i18n, Sink sink, Locale locale, String bundleName, PropertyUpdatesModel model) {
        super(i18n, sink, locale, bundleName, model);
    }

    @Override
    protected void renderManagementSummaryTable() {
    }

    @Override
    protected void renderSummaryTable() {
        this.renderTable("report.overview.property", ((PropertyUpdatesModel)this.model).getAllUpdates(), "report.overview.noProperty");
    }

    @Override
    protected void renderDetails() {
        ((PropertyUpdatesModel)this.model).getAllUpdates().forEach(this::renderPropertyDetail);
    }

    protected void renderTable(String titleKey, Map<Property, PropertyVersions> contents, String emptyKey) {
        this.sink.section2();
        this.sink.sectionTitle2();
        this.sink.text(this.getText(titleKey));
        this.sink.sectionTitle2_();
        if (contents.isEmpty()) {
            this.sink.paragraph();
            this.sink.text(this.getText(emptyKey));
            this.sink.paragraph_();
        } else {
            this.renderSummaryTable(contents);
        }
        this.sink.section2_();
    }

    protected void renderSummaryTable(Map<Property, PropertyVersions> contents) {
        this.sink.table();
        this.sink.tableRow();
        this.renderSummaryTableHeader(false, false);
        this.sink.tableRow_();
        contents.forEach(this::renderPropertySummaryTableRow);
        this.sink.tableRow();
        this.renderSummaryTableHeader(false, false);
        this.sink.tableRow_();
        this.sink.table_();
    }

    private void renderPropertySummaryTableRow(Property property, PropertyVersions details) {
        ArtifactVersion[] allUpdates = (ArtifactVersion[])this.allUpdatesCache.get(details, Optional.empty());
        boolean upToDate = allUpdates == null || allUpdates.length == 0;
        this.sink.tableRow();
        this.sink.tableCell();
        if (upToDate) {
            this.renderSuccessIcon();
        } else {
            this.renderWarningIcon();
        }
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text("${" + property.getName() + "}");
        this.sink.tableCell_();
        this.sink.tableCell();
        this.sink.text(details.getCurrentVersion().toString());
        this.sink.tableCell_();
        this.sink.tableCell();
        if (this.newestUpdateCache.get(details, Optional.of(Segment.SUBINCREMENTAL)) != null) {
            this.safeBold();
            this.sink.text(this.newestUpdateCache.get(details, Optional.of(Segment.SUBINCREMENTAL)).toString());
            this.safeBold_();
        }
        this.sink.tableCell_();
        this.sink.tableCell();
        if (this.newestUpdateCache.get(details, Optional.of(Segment.INCREMENTAL)) != null) {
            this.safeBold();
            this.sink.text(this.newestUpdateCache.get(details, Optional.of(Segment.INCREMENTAL)).toString());
            this.safeBold_();
        }
        this.sink.tableCell_();
        this.sink.tableCell();
        if (this.newestUpdateCache.get(details, Optional.of(Segment.MINOR)) != null) {
            this.safeBold();
            this.sink.text(this.newestUpdateCache.get(details, Optional.of(Segment.MINOR)).toString());
            this.safeBold_();
        }
        this.sink.tableCell_();
        this.sink.tableCell();
        if (this.newestUpdateCache.get(details, Optional.of(Segment.MAJOR)) != null) {
            this.safeBold();
            this.sink.text(this.newestUpdateCache.get(details, Optional.of(Segment.MAJOR)).toString());
            this.safeBold_();
        }
        this.sink.tableCell_();
        this.sink.tableRow_();
    }

    protected void renderPropertyDetailTable(Property property, PropertyVersions details) {
        ArtifactVersion[] allUpdates = (ArtifactVersion[])this.allUpdatesCache.get(details, Optional.empty());
        boolean upToDate = allUpdates == null || allUpdates.length == 0;
        SinkEventAttributeSet headerAttributes = new SinkEventAttributeSet();
        headerAttributes.addAttribute((Object)"width", (Object)"70%");
        SinkEventAttributeSet cellAttributes = new SinkEventAttributeSet();
        headerAttributes.addAttribute((Object)"width", (Object)"30%");
        this.sink.table();
        this.sink.tableRows(new int[]{2, 1}, false);
        this.sink.tableRow();
        this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
        this.sink.text(this.getText("report.status"));
        this.sink.tableHeaderCell_();
        this.sink.tableCell((SinkEventAttributes)cellAttributes);
        if (this.newestUpdateCache.get(details, Optional.of(Segment.SUBINCREMENTAL)) != null) {
            this.renderWarningIcon();
            this.sink.nonBreakingSpace();
            this.sink.text(this.getText("report.otherUpdatesAvailable"));
        } else if (this.newestUpdateCache.get(details, Optional.of(Segment.INCREMENTAL)) != null) {
            this.renderWarningIcon();
            this.sink.nonBreakingSpace();
            this.sink.text(this.getText("report.incrementalUpdatesAvailable"));
        } else if (this.newestUpdateCache.get(details, Optional.of(Segment.MINOR)) != null) {
            this.renderWarningIcon();
            this.sink.nonBreakingSpace();
            this.sink.text(this.getText("report.minorUpdatesAvailable"));
        } else if (this.newestUpdateCache.get(details, Optional.of(Segment.MAJOR)) != null) {
            this.renderWarningIcon();
            this.sink.nonBreakingSpace();
            this.sink.text(this.getText("report.majorUpdatesAvailable"));
        } else {
            this.renderSuccessIcon();
            this.sink.nonBreakingSpace();
            this.sink.text(this.getText("report.noUpdatesAvailable"));
        }
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
        this.sink.text(this.getText("report.property"));
        this.sink.tableHeaderCell_();
        this.sink.tableCell((SinkEventAttributes)cellAttributes);
        this.sink.text("${" + property.getName() + "}");
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
        this.sink.text(this.getText("report.associations"));
        this.sink.tableHeaderCell_();
        this.sink.tableCell((SinkEventAttributes)cellAttributes);
        ArtifactAssociation[] associations = details.getAssociations();
        for (int i = 0; i < associations.length; ++i) {
            if (i > 0) {
                this.sink.lineBreak();
            }
            this.sink.text(ArtifactUtils.versionlessKey((Artifact)associations[i].getArtifact()));
        }
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
        this.sink.text(this.getText("report.currentVersion"));
        this.sink.tableHeaderCell_();
        this.sink.tableCell((SinkEventAttributes)cellAttributes);
        this.sink.text(details.getCurrentVersion().toString());
        this.sink.tableCell_();
        this.sink.tableRow_();
        if (!upToDate) {
            Set<String> rangeVersions = this.getVersionsInRange(property, details, allUpdates);
            this.sink.tableRow();
            this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
            this.sink.text(this.getText("report.updateVersions"));
            this.sink.tableHeaderCell_();
            this.sink.tableCell((SinkEventAttributes)cellAttributes);
            boolean someNotAllowed = false;
            for (int i = 0; i < allUpdates.length; ++i) {
                if (i > 0) {
                    this.sink.lineBreak();
                }
                boolean allowed = rangeVersions.contains(allUpdates[i].toString());
                String label = this.getLabel(allUpdates[i], details);
                if (!allowed) {
                    this.sink.text("* ");
                    someNotAllowed = true;
                }
                if (allowed && label != null) {
                    this.safeBold();
                }
                this.sink.text(allUpdates[i].toString());
                if (label == null) continue;
                if (allowed) {
                    this.safeBold_();
                }
                this.sink.nonBreakingSpace();
                this.safeItalic();
                this.sink.text(label);
                this.safeItalic_();
            }
            if (someNotAllowed) {
                this.sink.lineBreak();
                this.sink.lineBreak();
                this.sink.text("* ");
                this.safeItalic();
                this.sink.text(this.getText("report.excludedVersion"));
                this.safeItalic_();
            }
            this.sink.tableCell_();
            this.sink.tableRow_();
        }
        this.sink.tableRow();
        this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
        this.sink.text(this.getText("report.versionRange"));
        this.sink.tableHeaderCell_();
        this.sink.tableCell((SinkEventAttributes)cellAttributes);
        this.sink.text(StringUtils.isEmpty((String)property.getVersion()) ? "[,)" : property.getVersion());
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
        this.sink.text(this.getText("report.autoLinkDependencies"));
        this.sink.tableHeaderCell_();
        this.sink.tableCell((SinkEventAttributes)cellAttributes);
        this.sink.text(property.isAutoLinkDependencies() ? this.getText("report.yes") : this.getText("report.no"));
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
        this.sink.text(this.getText("report.banSnapshots"));
        this.sink.tableHeaderCell_();
        this.sink.tableCell((SinkEventAttributes)cellAttributes);
        this.sink.text(property.isBanSnapshots() ? this.getText("report.yes") : this.getText("report.no"));
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
        this.sink.text(this.getText("report.searchReactor"));
        this.sink.tableHeaderCell_();
        this.sink.tableCell((SinkEventAttributes)cellAttributes);
        this.sink.text(property.isSearchReactor() ? this.getText("report.yes") : this.getText("report.no"));
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRow();
        this.sink.tableHeaderCell((SinkEventAttributes)headerAttributes);
        this.sink.text(this.getText("report.preferReactor"));
        this.sink.tableHeaderCell_();
        this.sink.tableCell((SinkEventAttributes)cellAttributes);
        this.sink.text(property.isPreferReactor() ? this.getText("report.yes") : this.getText("report.no"));
        this.sink.tableCell_();
        this.sink.tableRow_();
        this.sink.tableRows_();
        this.sink.table_();
    }

    protected Set<String> getVersionsInRange(Property property, PropertyVersions versions, ArtifactVersion[] artifactVersions) {
        ArtifactVersion[] tmp;
        HashSet<String> rangeVersions = new HashSet<String>();
        if (property.getVersion() != null) {
            try {
                VersionRange range = VersionRange.createFromVersionSpec((String)property.getVersion());
                tmp = versions.getAllUpdates(range);
            }
            catch (InvalidVersionSpecificationException e) {
                tmp = artifactVersions;
            }
        } else {
            tmp = artifactVersions;
        }
        for (ArtifactVersion artifactVersion : tmp) {
            rangeVersions.add(artifactVersion.toString());
        }
        return rangeVersions;
    }

    @Override
    protected void renderSummaryTableHeader(boolean hasScope, boolean hasType) {
        this.renderTableHeaderCells("report.status", "report.property", "report.currentVersion", "report.latestSubIncremental", "report.latestIncremental", "report.latestMinor", "report.latestMajor");
    }

    @Override
    protected OverviewStats computeOverviewStats() {
        OverviewStats stats = new OverviewStats();
        ((PropertyUpdatesModel)this.model).getAllUpdates().values().forEach(details -> {
            if (this.newestUpdateCache.get(details, Optional.of(Segment.SUBINCREMENTAL)) != null) {
                stats.incrementAny();
            } else if (this.newestUpdateCache.get(details, Optional.of(Segment.INCREMENTAL)) != null) {
                stats.incrementIncremental();
            } else if (this.newestUpdateCache.get(details, Optional.of(Segment.MINOR)) != null) {
                stats.incrementMinor();
            } else if (this.newestUpdateCache.get(details, Optional.of(Segment.MAJOR)) != null) {
                stats.incrementMajor();
            } else {
                stats.incrementUpToDate();
            }
        });
        return stats;
    }

    private void renderPropertyDetail(Property property, PropertyVersions details) {
        this.sink.section2();
        this.sink.sectionTitle2();
        this.sink.text("${" + property.getName() + "}");
        this.sink.sectionTitle2_();
        this.renderPropertyDetailTable(property, details);
        this.sink.section2_();
    }
}

