/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.sqlj;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.sqlj.AbstractSqljMojo;

public class SqljMojo
extends AbstractSqljMojo {
    private String encoding;
    private boolean status;
    private File[] sqljFiles;
    private File[] sqljDirs;
    private MavenProject mavenProject;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (StringUtils.isEmpty((String)this.encoding)) {
            this.encoding = SystemUtils.FILE_ENCODING;
            this.getLog().warn((CharSequence)("No encoding given, falling back to system default value: " + this.encoding));
        }
        try {
            FileUtils.forceMkdir((File)this.getGeneratedResourcesDirectory().getAbsoluteFile());
            FileUtils.forceMkdir((File)this.getGeneratedSourcesDirectory().getAbsoluteFile());
        }
        catch (IOException e) {
            throw new MojoFailureException(e.getMessage());
        }
        Set sqljFiles = this.getSqljFiles();
        Iterator i = sqljFiles.iterator();
        while (i.hasNext()) {
            File file = (File)i.next();
            this.generate(file);
        }
        Resource resource = new Resource();
        resource.setDirectory(this.getGeneratedResourcesDirectory().getAbsolutePath());
        this.mavenProject.addResource(resource);
        this.mavenProject.addCompileSourceRoot(this.getGeneratedSourcesDirectory().getAbsolutePath());
    }

    private void generate(File file) throws MojoFailureException, MojoExecutionException {
        Class<?> sqljClass;
        try {
            sqljClass = Class.forName("sqlj.tools.Sqlj");
        }
        catch (ClassNotFoundException e) {
            throw new MojoFailureException("Please add sqlj to the plugins classpath " + e.getMessage());
        }
        catch (Exception e) {
            throw new MojoFailureException(e.getMessage());
        }
        String[] arguments = new String[]{"-dir=" + this.getGeneratedSourcesDirectory().getAbsolutePath(), "-d=" + this.getGeneratedResourcesDirectory().getAbsolutePath(), "-encoding=" + this.encoding, this.status ? "-status" : "", "-compile=false", file.getAbsolutePath()};
        Integer returnCode = null;
        try {
            returnCode = (Integer)MethodUtils.invokeExactStaticMethod(sqljClass, (String)"statusMain", (Object[])new Object[]{arguments});
        }
        catch (Exception e) {
            throw new MojoFailureException(e.getMessage());
        }
        if (returnCode != 0) {
            throw new MojoExecutionException("Bad returncode: " + returnCode);
        }
    }

    private Set getSqljFiles() {
        HashSet<File> files = new HashSet<File>();
        String[] extensions = new String[]{"sqlj"};
        for (int i = 0; i < this.sqljDirs.length; ++i) {
            files.addAll(FileUtils.listFiles((File)this.sqljDirs[i], (String[])extensions, (boolean)true));
        }
        files.addAll(Arrays.asList(this.sqljFiles));
        return files;
    }
}

