/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.springws;

import java.io.File;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.ws.wsdl.WsdlDefinition;

public class SpringWsMojo
extends AbstractMojo {
    private String suffix;
    private String[] contextLocations;
    private File targetDirectory;
    private final Transformer transformer;

    public SpringWsMojo() throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        this.transformer = transformerFactory.newTransformer();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.targetDirectory.mkdirs();
        ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext(this.contextLocations);
        Map beanMap = applicationContext.getBeansOfType(WsdlDefinition.class);
        Iterator i = beanMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String serviceName = entry.getKey().toString();
            WsdlDefinition wsdlDefinition = (WsdlDefinition)entry.getValue();
            Source source = wsdlDefinition.getSource();
            File file = this.export(source, serviceName);
            this.getLog().debug((CharSequence)("Generated: " + file.getAbsolutePath()));
        }
    }

    private File export(Source source, String serviceName) throws MojoExecutionException {
        File file = new File(this.targetDirectory, serviceName + this.suffix);
        StreamResult result = new StreamResult(file);
        try {
            this.transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        return file;
    }
}

