/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.native2ascii;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.CharBuffer;

public final class Native2Ascii {
    private Native2Ascii() {
    }

    public static String nativeToAscii(CharSequence cs) {
        if (cs == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < cs.length(); ++i) {
            char c = cs.charAt(i);
            if (c <= '~') {
                sb.append(c);
                continue;
            }
            sb.append("\\u");
            String hex = Integer.toHexString(c);
            for (int j = hex.length(); j < 4; ++j) {
                sb.append('0');
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nativeToAscii(File src, File dst, String encoding) throws IOException {
        BufferedReader input = null;
        BufferedWriter output = null;
        try {
            int len;
            input = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(src), encoding));
            output = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(dst), "US-ASCII"));
            char[] buffer = new char[4096];
            while ((len = input.read(buffer)) != -1) {
                output.write(Native2Ascii.nativeToAscii(CharBuffer.wrap(buffer, 0, len)));
            }
        }
        catch (Throwable throwable) {
            Native2Ascii.closeQuietly(input);
            Native2Ascii.closeQuietly(output);
            throw throwable;
        }
        Native2Ascii.closeQuietly(input);
        Native2Ascii.closeQuietly(output);
    }

    private static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

