/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.make;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.codehaus.mojo.tools.cli.CommandLineManager;
import org.codehaus.mojo.tools.project.extras.ArtifactPathResolver;
import org.codehaus.mojo.tools.project.extras.DependencyPathResolver;
import org.codehaus.mojo.tools.project.extras.PathResolutionException;
import org.codehaus.mojo.tools.project.extras.PrefixPropertyPathResolver;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.plexus.util.cli.shell.BourneShell;
import org.codehaus.plexus.util.cli.shell.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMakeExecMojo
extends AbstractMojo {
    private String destDir;
    private MavenProject project;
    private File workDir;
    private Set<Artifact> artifacts;
    private String command;
    private List<String> options;
    private boolean resolveOptions;
    private String target;
    private String checkFile;
    private Properties environment;
    private List<ArtifactRepository> remoteRepositories;
    private List<ArtifactRepository> remotePluginRepositories;
    private ArtifactRepository localRepository;
    private MavenProjectBuilder projectBuilder;
    private ArtifactFactory artifactFactory;
    private CommandLineManager cliManager;
    private File executable;
    private boolean searchForExecutable = false;
    private boolean ignoreFailures = false;
    private boolean ignoreErrors = false;
    private boolean chmodUsed = false;
    private boolean skipped;
    private boolean absoluteCommandPathUsed;

    public void execute() throws MojoExecutionException {
        if (this.skipped) {
            this.getLog().info((CharSequence)"Skipping this step of the Make process.");
            return;
        }
        this.getLog().debug((CharSequence)("In AbstractMakeExecMojo.execute:: workDir= " + this.workDir));
        this.checkSanity();
        this.workDir.mkdirs();
        File check = null;
        long lastMod = 0L;
        if (this.checkFile != null) {
            check = new File(this.checkFile);
            lastMod = check.lastModified();
        }
        if (this.searchForExecutable) {
            try {
                this.findExecutable();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to canonicalize executable path.", (Exception)e);
            }
        }
        if (this.chmodUsed) {
            this.executeChmod();
        }
        Commandline cli = new Commandline();
        BourneShell shell = new BourneShell(true);
        shell.setQuotedArgumentsEnabled(false);
        cli.setShell((Shell)shell);
        cli.createArg().setLine("cd " + this.workDir.getAbsolutePath() + " && ");
        if (this.executable != null) {
            if (this.absoluteCommandPathUsed) {
                cli.createArg().setLine(this.executable.getAbsolutePath());
            } else {
                cli.createArg().setLine(this.subPath(this.executable, this.workDir));
            }
        } else {
            cli.createArg().setLine(this.command);
        }
        ArrayList<ArtifactRepository> repos = new ArrayList<ArtifactRepository>();
        repos.addAll(this.remoteRepositories);
        repos.addAll(this.remotePluginRepositories);
        PrefixPropertyPathResolver pathResolver = new PrefixPropertyPathResolver(this.projectBuilder, repos, this.localRepository, this.artifactFactory, this.getLog());
        DependencyPathResolver resolver = new DependencyPathResolver(this.artifacts, (ArtifactPathResolver)pathResolver, this.getLog());
        if (this.options != null) {
            ArrayList<String> resolvedPaths = new ArrayList<String>();
            for (String option : this.options) {
                if (this.resolveOptions) {
                    try {
                        option = resolver.resolveDependencyPaths(option);
                        resolvedPaths.add(option);
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Error resolving option: '" + option + "'. Reason: " + e.getMessage(), (Exception)e);
                    }
                    catch (PathResolutionException e) {
                        throw new MojoExecutionException("Error resolving dependency paths for: " + option + ". Reason: " + e.getMessage(), (Exception)((Object)e));
                    }
                }
                cli.createArg().setLine(option);
            }
        }
        if (this.environment != null && !this.environment.isEmpty()) {
            for (Map.Entry<Object, Object> entry : this.environment.entrySet()) {
                String key = String.valueOf(entry.getKey());
                String val = String.valueOf(entry.getValue());
                if (this.resolveOptions) {
                    try {
                        val = resolver.resolveDependencyPaths(val);
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Error resolving environment variable: '" + val + "'. Reason: " + e.getMessage(), (Exception)e);
                    }
                    catch (PathResolutionException e) {
                        throw new MojoExecutionException("Error resolving dependency paths for: " + val + ". Reason: " + e.getMessage(), (Exception)((Object)e));
                    }
                }
                cli.addEnvironment(key, val);
                this.getLog().debug((CharSequence)("Setting envar: " + key + "=" + val));
            }
        }
        if (this.target != null && this.target.trim().length() > 0) {
            cli.createArg().setLine(this.target);
        }
        this.getLog().debug((CharSequence)("Executing: " + StringUtils.join((Object[])cli.getShellCommandline(), (String)" ")));
        try {
            StreamConsumer consumer = this.cliManager.newInfoStreamConsumer();
            int result = this.cliManager.execute(cli, consumer, consumer);
            if (result != 0) {
                throw new MojoExecutionException(this.command + " returned an exit value != 0. Aborting build; see command output above for more information.");
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Failed to execute. Reason: " + e.getMessage(), (Exception)((Object)e));
        }
        if (check != null && check.lastModified() <= lastMod) {
            throw new MojoExecutionException("Check file: " + check + " not changed.");
        }
    }

    private String subPath(File exec, File workDirectory) throws MojoExecutionException {
        String workingPath;
        String path;
        try {
            path = exec.getCanonicalPath();
            workingPath = workDirectory.getCanonicalPath();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to canonicalize paths.", (Exception)e);
        }
        if (path.startsWith(workingPath)) {
            if ((path = path.substring(workingPath.length())).startsWith(File.separator)) {
                path = path.substring(1);
            }
            path = "./" + path;
        }
        return path;
    }

    private void checkSanity() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("The following usage errors were encountered:\n");
        boolean errorsOccurred = false;
        if (this.command == null) {
            buffer.append("\no Make command cannot be null.");
            errorsOccurred = true;
        }
        if (this.workDir == null) {
            buffer.append("\no working directory cannot be null.");
            errorsOccurred = true;
        }
        if (errorsOccurred) {
            throw new IllegalStateException(buffer.toString());
        }
    }

    protected final boolean isChmodUsed() {
        return this.chmodUsed;
    }

    protected final void setChmodUsed(boolean chmodUsed) {
        this.chmodUsed = chmodUsed;
    }

    protected final String getCheckFile() {
        return this.checkFile;
    }

    protected final void setCheckFile(String checkFile) {
        this.checkFile = checkFile;
    }

    protected final String getCommand() {
        return this.command;
    }

    protected final void setCommand(String command) {
        this.command = command;
    }

    protected final boolean isAbsoluteCommandPathUsed() {
        return this.absoluteCommandPathUsed;
    }

    protected final void setAbsoluteCommandPathUsed(boolean absolute) {
        this.absoluteCommandPathUsed = absolute;
    }

    protected final List<String> getOptions() {
        return this.options;
    }

    protected final void setOptions(List<String> options) {
        this.options = options;
    }

    protected final MavenProject getProject() {
        return this.project;
    }

    protected final String getTarget() {
        return this.target;
    }

    protected final void setTarget(String target) {
        this.target = target;
    }

    protected final void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }

    protected final boolean ignoreFailures() {
        return this.ignoreFailures;
    }

    protected final void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    protected final boolean ignoreErrors() {
        return this.ignoreErrors;
    }

    protected String getDestDir() {
        return this.destDir;
    }

    protected void setWorkDir(File workDir) {
        this.workDir = workDir;
    }

    protected File getWorkDir() {
        return this.workDir;
    }

    private void findExecutable() throws IOException {
        this.executable = new File(this.command);
        if (!this.executable.exists()) {
            this.getLog().debug((CharSequence)("Cannot find command executable file: '" + this.command + "'. Checking work directory."));
            this.executable = new File(this.workDir, this.command);
            if (!this.executable.exists()) {
                this.executable = null;
                this.getLog().debug((CharSequence)("Cannot find command executable file: '" + this.command + "' in work directory: '" + this.workDir + "'. We will assume this command is on the system path."));
            }
        }
    }

    private void executeChmod() throws MojoExecutionException {
        if (this.executable != null) {
            Commandline cli = new Commandline();
            cli.setExecutable("chmod");
            cli.createArg().setLine("+x");
            cli.createArg().setLine(this.executable.getAbsolutePath());
            StreamConsumer consumer = this.cliManager.newDebugStreamConsumer();
            try {
                int result = this.cliManager.execute(cli, consumer, consumer);
                if (result != 0) {
                    throw new MojoExecutionException("chmod command returned an exit value != 0. Aborting build; see debug output for more information.");
                }
            }
            catch (CommandLineException e) {
                throw new MojoExecutionException("Failed to chmod +x " + this.executable.getPath() + ". Reason: " + e.getMessage(), (Exception)((Object)e));
            }
        }
    }

    public final boolean isSkipped() {
        return this.skipped;
    }

    public final void setSkipped(boolean skipped) {
        this.skipped = skipped;
    }

    public final boolean isOptionsResolved() {
        return this.resolveOptions;
    }

    public final void setOptionsResolved(boolean resolveOpts) {
        this.resolveOptions = resolveOpts;
    }

    public boolean isSearchForExecutable() {
        return this.searchForExecutable;
    }

    public void setSearchForExecutable(boolean searchForExecutable) {
        this.searchForExecutable = searchForExecutable;
    }

    protected final void setEnvironment(Properties environment) {
        this.environment = environment;
    }

    protected final Properties getEnvironment() {
        return this.environment;
    }
}

