/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.license.AbstractLicenseMojo;
import org.codehaus.mojo.license.api.FreeMarkerHelper;
import org.codehaus.mojo.license.model.Copyright;
import org.codehaus.mojo.license.model.License;
import org.codehaus.mojo.license.model.LicenseStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLicenseNameMojo
extends AbstractLicenseMojo {
    @Parameter(property="license.licenseResolver")
    private String licenseResolver;
    @Parameter(property="license.keepBackup", defaultValue="false")
    private boolean keepBackup;
    @Parameter(property="license.licenseName")
    private String licenseName;
    @Parameter(property="license.projectName", defaultValue="${project.name}", required=true)
    protected String projectName;
    @Parameter(property="license.organizationName", defaultValue="${project.organization.name}", required=true)
    protected String organizationName;
    @Parameter(property="license.inceptionYear", defaultValue="${project.inceptionYear}", required=true)
    protected Integer inceptionYear;
    @Parameter(property="license.copyrightOwners")
    protected String copyrightOwners;
    @Parameter
    protected Map<String, String> extraTemplateParameters;
    private License license;
    private LicenseStore licenseStore;

    @Override
    protected void init() throws Exception {
        this.licenseStore = LicenseStore.createLicenseStore(this.getLog(), this.licenseResolver);
        this.license = this.getLicense(this.licenseName, true);
        if (StringUtils.isBlank((CharSequence)this.copyrightOwners)) {
            this.copyrightOwners = this.organizationName;
        }
    }

    protected License getLicense(String licenseName, boolean checkIfExists) {
        if (StringUtils.isEmpty((CharSequence)licenseName)) {
            throw new IllegalArgumentException("licenseName can not be null, nor empty");
        }
        if (this.licenseStore == null) {
            throw new IllegalStateException("No license store initialized!");
        }
        License result = this.licenseStore.getLicense(licenseName);
        if (checkIfExists && result == null) {
            throw new IllegalArgumentException("License named '" + licenseName + "' is unknown, use one of " + Arrays.toString(this.licenseStore.getLicenseNames()));
        }
        return result;
    }

    protected boolean isKeepBackup() {
        return this.keepBackup;
    }

    protected String getLicenseName() {
        return this.licenseName;
    }

    protected License getLicense() {
        return this.license;
    }

    protected String getCopyrightOwners() {
        String holder = this.copyrightOwners;
        if (holder == null) {
            holder = this.organizationName;
        }
        return holder;
    }

    protected String processLicenseContext(String licenseContent) throws IOException {
        FreeMarkerHelper licenseFreeMarkerHelper = FreeMarkerHelper.newHelperFromContent(licenseContent);
        HashMap<String, Object> templateParameters = new HashMap<String, Object>();
        this.addPropertiesToContext(System.getProperties(), "env_", templateParameters);
        this.addPropertiesToContext(this.getProject().getProperties(), "project_", templateParameters);
        templateParameters.put("project", this.getProject().getModel());
        templateParameters.put("organizationName", this.organizationName);
        templateParameters.put("inceptionYear", this.inceptionYear);
        templateParameters.put("copyright", this.getCopyright(this.getCopyrightOwners()));
        templateParameters.put("projectName", this.projectName);
        this.addPropertiesToContext(this.extraTemplateParameters, "extra_", templateParameters);
        String result = licenseFreeMarkerHelper.renderTemplate("template", templateParameters);
        return result;
    }

    protected Copyright getCopyright(String holder) {
        return Copyright.newCopyright(this.inceptionYear, holder);
    }

    private void addPropertiesToContext(Map properties, String prefix, Map<String, Object> context) {
        if (properties != null) {
            for (Object o : properties.keySet()) {
                String nextKey = (String)o;
                Object nextValue = properties.get(nextKey);
                context.put(prefix + nextKey, nextValue.toString());
            }
        }
    }
}

