/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.keytool;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:keytool-maven-plugin:1.1", 0);
        this.append(sb, "", 0);
        this.append(sb, "Keytool: Maven Plugin", 0);
        this.append(sb, "A plugin that wraps the keytool program bundled with Sun's Java SDK. Allows to manipulate keystores.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 5 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "clean".equals(this.goal)) {
            this.append(sb, "keytool:clean", 0);
            this.append(sb, "A Mojo that deletes a generated keystore file.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "keystore", 2);
                this.append(sb, "See options.", 3);
                this.append(sb, "Expression: ${keystore}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Set to true to disable the plugin.", 3);
                this.append(sb, "Expression: ${keytool.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory (Default: ${basedir})", 2);
                this.append(sb, "Where to execute the keytool command.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${keytool.workingdir}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "export".equals(this.goal)) {
            this.append(sb, "keytool:export", 0);
            this.append(sb, "Reads (from the keystore) the certificate associated with alias, and stores it in the file cert_file. Implemented as a wrapper around the SDK keytool -export command.\n-export\u00a0\u00a0\u00a0[-v]\u00a0[-protected]\n[-alias\u00a0<alias>]\n[-file\u00a0<file>]\n[-storetype\u00a0<storetype>]\n[-keystore\u00a0<keystore>]\n[-storepass\u00a0<storepass>]\nSee keystore documentation.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "alias", 2);
                this.append(sb, "See options.", 3);
                this.append(sb, "Expression: ${alias}", 3);
                this.append(sb, "", 0);
                this.append(sb, "arguments", 2);
                this.append(sb, "List of additional arguments to append to the keytool command line.", 3);
                this.append(sb, "Expression: ${keytool.arguments}", 3);
                this.append(sb, "", 0);
                this.append(sb, "file", 2);
                this.append(sb, "See options.", 3);
                this.append(sb, "Expression: ${file}", 3);
                this.append(sb, "", 0);
                this.append(sb, "keystore", 2);
                this.append(sb, "See options.", 3);
                this.append(sb, "Expression: ${keystore}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Set to true to disable the plugin.", 3);
                this.append(sb, "Expression: ${keytool.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "storepass", 2);
                this.append(sb, "See options.", 3);
                this.append(sb, "Expression: ${storepass}", 3);
                this.append(sb, "", 0);
                this.append(sb, "storetype", 2);
                this.append(sb, "See options.", 3);
                this.append(sb, "Expression: ${storetype}", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Enable verbose. See options.", 3);
                this.append(sb, "Expression: ${verbose}", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory (Default: ${basedir})", 2);
                this.append(sb, "Where to execute the keytool command.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${keytool.workingdir}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "genkey".equals(this.goal)) {
            this.append(sb, "keytool:genkey", 0);
            this.append(sb, "Generates a keystore. Implemented as a wrapper around the SDK keytool -genkey command.\n-genkey\u00a0\u00a0\u00a0[-v]\u00a0[-protected]\n[-alias\u00a0<alias>]\n[-keyalg\u00a0<keyalg>]\u00a0[-keysize\u00a0<keysize>]\n[-sigalg\u00a0<sigalg>]\u00a0[-dname\u00a0<dname>]\n[-validity\u00a0<valDays>]\u00a0[-keypass\u00a0<keypass>]\n[-keystore\u00a0<keystore>]\u00a0[-storepass\u00a0<storepass>]\n[-storetype\u00a0<storetype>]\u00a0[-providerName\u00a0<name>]\n[-providerClass\u00a0<provider_class_name>\u00a0[-providerArg\u00a0<arg>]]\u00a0...\nSee keystore documentation.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "alias", 2);
                this.append(sb, "See options.", 3);
                this.append(sb, "Expression: ${alias}", 3);
                this.append(sb, "", 0);
                this.append(sb, "arguments", 2);
                this.append(sb, "List of additional arguments to append to the keytool command line.", 3);
                this.append(sb, "Expression: ${keytool.arguments}", 3);
                this.append(sb, "", 0);
                this.append(sb, "dname", 2);
                this.append(sb, "See options.", 3);
                this.append(sb, "Expression: ${dname}", 3);
                this.append(sb, "", 0);
                this.append(sb, "keyalg", 2);
                this.append(sb, "See options.", 3);
                this.append(sb, "Expression: ${keyalg}", 3);
                this.append(sb, "", 0);
                this.append(sb, "keypass", 2);
                this.append(sb, "See options.", 3);
                this.append(sb, "Expression: ${keypass}", 3);
                this.append(sb, "", 0);
                this.append(sb, "keysize", 2);
                this.append(sb, "See options.", 3);
                this.append(sb, "Expression: ${keysize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "keystore", 2);
                this.append(sb, "See options.", 3);
                this.append(sb, "Expression: ${keystore}", 3);
                this.append(sb, "", 0);
                this.append(sb, "sigalg", 2);
                this.append(sb, "See options.", 3);
                this.append(sb, "Expression: ${sigalg}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Set to true to disable the plugin.", 3);
                this.append(sb, "Expression: ${keytool.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "storepass", 2);
                this.append(sb, "See options.", 3);
                this.append(sb, "Expression: ${storepass}", 3);
                this.append(sb, "", 0);
                this.append(sb, "storetype", 2);
                this.append(sb, "See options.", 3);
                this.append(sb, "Expression: ${storetype}", 3);
                this.append(sb, "", 0);
                this.append(sb, "validity", 2);
                this.append(sb, "See options.", 3);
                this.append(sb, "Expression: ${validity}", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Enable verbose. See options.", 3);
                this.append(sb, "Expression: ${verbose}", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory (Default: ${basedir})", 2);
                this.append(sb, "Where to execute the keytool command.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${keytool.workingdir}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "keytool:help", 0);
            this.append(sb, "Display help information on keytool-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0keytool:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "import".equals(this.goal)) {
            this.append(sb, "keytool:import", 0);
            this.append(sb, "Reads the certificate or certificate chain (where the latter is supplied in a PKCS#7 formatted reply) from the file cert_file, and stores it in the keystore entry identified by alias. Implemented as a wrapper around the SDK keytool -import command.\n-import\u00a0\u00a0\u00a0[-v]\u00a0[-protected]\n[-alias\u00a0<alias>]\n[-file\u00a0<file>]\n[-keypass\u00a0<keypass>]\n[-storepass\u00a0<storepass>]\n[-storetype\u00a0<storetype>]\n[-keystore\u00a0<keystore>]\nSee keystore documentation.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "alias", 2);
                this.append(sb, "See options.", 3);
                this.append(sb, "Expression: ${alias}", 3);
                this.append(sb, "", 0);
                this.append(sb, "arguments", 2);
                this.append(sb, "List of additional arguments to append to the keytool command line.", 3);
                this.append(sb, "Expression: ${keytool.arguments}", 3);
                this.append(sb, "", 0);
                this.append(sb, "file", 2);
                this.append(sb, "See options.", 3);
                this.append(sb, "Expression: ${file}", 3);
                this.append(sb, "", 0);
                this.append(sb, "keypass", 2);
                this.append(sb, "See options.", 3);
                this.append(sb, "Expression: ${keypass}", 3);
                this.append(sb, "", 0);
                this.append(sb, "keystore", 2);
                this.append(sb, "See options.", 3);
                this.append(sb, "Expression: ${keystore}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Set to true to disable the plugin.", 3);
                this.append(sb, "Expression: ${keytool.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "storepass", 2);
                this.append(sb, "See options.", 3);
                this.append(sb, "Expression: ${storepass}", 3);
                this.append(sb, "", 0);
                this.append(sb, "storetype", 2);
                this.append(sb, "See options.", 3);
                this.append(sb, "Expression: ${storetype}", 3);
                this.append(sb, "", 0);
                this.append(sb, "useJREcacerts (Default: false)", 2);
                this.append(sb, "Imports Cert in current Java Runtime lib/security/cacerts.", 3);
                this.append(sb, "Expression: ${useJREcacerts}", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Enable verbose. See options.", 3);
                this.append(sb, "Expression: ${verbose}", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory (Default: ${basedir})", 2);
                this.append(sb, "Where to execute the keytool command.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${keytool.workingdir}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

