/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dita;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:dita-maven-plugin:1.0-beta-2", 0);
        this.append(sb, "", 0);
        this.append(sb, "DITA Open Toolkit Maven Plugin", 0);
        this.append(sb, "The DITA Open Toolkit is an implementation of the OASIS DITA XML Specification. The Toolkit transforms DITA content into many deliverable formats.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 6 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "chm2web".equals(this.goal)) {
            this.append(sb, "dita:chm2web", 0);
            this.append(sb, "Convert DITA Open Toolkit's Microsoft CHM output file, produced by htmlhelp transtype, to pure HTML set of files. Require commercial chm2web utility from A!K Research Labs", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "attach (Default: false)", 2);
                this.append(sb, "Controls whether this plugin tries to archive the output directory and attach archive to the project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "attachClassifier", 2);
                this.append(sb, "Output file classifier to be attached to the project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "attachType (Default: jar)", 2);
                this.append(sb, "Output file extension to be attached to the project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "chm2webExe (Default: c:\\Program Files\\A!K Research Labs\\chm2web\\chm2web.exe)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "descriptor (Default: ${basedir}/src/main/chm2web/${project.artifactId}.chm2web)", 2);
                this.append(sb, "Chm2Web configuration file", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignoreIfChm2WebNotExist (Default: false)", 2);
                this.append(sb, "Allow skipping the conversion when chm2web is not available.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory}/chm2web)", 2);
                this.append(sb, "Chm2Web output directory. Must match with the output directory found in your chm2web's descriptor file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip the execution", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "eclipse".equals(this.goal)) {
            this.append(sb, "dita:eclipse", 0);
            this.append(sb, "Generate http://www.dita-op.org's Eclipse configuration to allow editing, previewing DITA under Eclipse IDE.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "projectName (Default: ${project.artifactId})", 2);
                this.append(sb, "If given, will be added to Ant command line", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip the execution", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "dita:help", 0);
            this.append(sb, "Display help information on dita-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0dita:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "print-help".equals(this.goal)) {
            this.append(sb, "dita:print-help", 0);
            this.append(sb, "Display DITA Open Toolkit's common Ant properties usage. This can be used a reference for antProperties used by dita:run goal.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "antProperties", 2);
                this.append(sb, "Ant key/value pair properties. Default properties for all dita's goals\n-\tdita.dir=${env.DITA_HOME}\nDefault properties for dita:run goal\n-\tbasedir=${project.basedir}\n-\toutput.dir=${project.build.directory}/dita/out\n-\tdita.temp.dir=${project.build.directory}/dita/temp\n-\targs.logdir=${project.build.directory}/dita/log\n-\targs.input=${project.basedir}/src/main/dita/${artifactId}.ditamap\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "classpathElements", 2);
                this.append(sb, "Internal. Compile time project dependencies to be add ed to Ant's classpath", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip the execution", 3);
                this.append(sb, "", 0);
                this.append(sb, "useDitaClasspath (Default: true)", 2);
                this.append(sb, "Add jar files under DITA Open Toolkit's lib directory to execution classpath", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "run".equals(this.goal)) {
            this.append(sb, "dita:run", 0);
            this.append(sb, "Execute DITA Open Toolkit's Ant command line to transform DITA files to desired output format.\n\nBehind the scene, antProperties are temporarily stored under ${dita.temp.dir}/properties.temp to be used with\n\nant -f ${dita.dir}/build.xml -propertyFile ${dita.temp.dir}/properties.temp\n", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "antArguments", 2);
                this.append(sb, "If given, will be added to Ant command line. Use this for trouble shooting purpose", 3);
                this.append(sb, "", 0);
                this.append(sb, "antHome", 2);
                this.append(sb, "Point to Ant installation directory. If given, it will override useDitaAnt and ${env.ANT_HOME}", 3);
                this.append(sb, "", 0);
                this.append(sb, "antOpts", 2);
                this.append(sb, "Equivalent with ANT_OPTS environment. This parameter overrides the current env.ANT_OPTS if given. Typical usage is to setup JVM's heap space ( example -Xmx500m )", 3);
                this.append(sb, "", 0);
                this.append(sb, "antProperties", 2);
                this.append(sb, "Ant key/value pair properties. Default properties for all dita's goals\n-\tdita.dir=${env.DITA_HOME}\nDefault properties for dita:run goal\n-\tbasedir=${project.basedir}\n-\toutput.dir=${project.build.directory}/dita/out\n-\tdita.temp.dir=${project.build.directory}/dita/temp\n-\targs.logdir=${project.build.directory}/dita/log\n-\targs.input=${project.basedir}/src/main/dita/${artifactId}.ditamap\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "attach (Default: false)", 2);
                this.append(sb, "Controls whether this goal tries to compress the output directory and attach compressed output file to the project for install and deploy purposes.", 3);
                this.append(sb, "", 0);
                this.append(sb, "attachClassifier", 2);
                this.append(sb, "Output file classifier to be attached to the project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "attachType (Default: jar)", 2);
                this.append(sb, "Output file extension to be attached to the project. When transtype is one of the pdf types or htmlhelp, the attachType will be hard coded to pdf and chm respectively.", 3);
                this.append(sb, "", 0);
                this.append(sb, "classpathElements", 2);
                this.append(sb, "Internal. Compile time project dependencies to be add ed to Ant's classpath", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip the execution", 3);
                this.append(sb, "", 0);
                this.append(sb, "useDitaAnt (Default: true)", 2);
                this.append(sb, "Use DITA Open Toolkit's tools/ant", 3);
                this.append(sb, "", 0);
                this.append(sb, "useDitaClasspath (Default: true)", 2);
                this.append(sb, "Add jar files under DITA Open Toolkit's lib directory to execution classpath", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "version".equals(this.goal)) {
            this.append(sb, "dita:version", 0);
            this.append(sb, "Display DITA Open Toolkit's built-in version, with option to insert a custom version found under ${dita.dir}/ditaotVersionPath, via version property to Maven's ${versionName}. It is mainly used with maven-enforcer-plugin for build validation purpose.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "antProperties", 2);
                this.append(sb, "Ant key/value pair properties. Default properties for all dita's goals\n-\tdita.dir=${env.DITA_HOME}\nDefault properties for dita:run goal\n-\tbasedir=${project.basedir}\n-\toutput.dir=${project.build.directory}/dita/out\n-\tdita.temp.dir=${project.build.directory}/dita/temp\n-\targs.logdir=${project.build.directory}/dita/log\n-\targs.input=${project.basedir}/src/main/dita/${artifactId}.ditamap\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "classpathElements", 2);
                this.append(sb, "Internal. Compile time project dependencies to be add ed to Ant's classpath", 3);
                this.append(sb, "", 0);
                this.append(sb, "displayDitaOTVersion (Default: true)", 2);
                this.append(sb, "Display DITA Open Toolkit's built-in version", 3);
                this.append(sb, "", 0);
                this.append(sb, "ditaotVersionPath (Default: custom.version.properties)", 2);
                this.append(sb, "Relative path to DITA-OT custom version properties file path", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip the execution", 3);
                this.append(sb, "", 0);
                this.append(sb, "useDitaClasspath (Default: true)", 2);
                this.append(sb, "Add jar files under DITA Open Toolkit's lib directory to execution classpath", 3);
                this.append(sb, "", 0);
                this.append(sb, "versionName (Default: dita.custom.version)", 2);
                this.append(sb, "Maven project property name to store custom version value", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

