/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.common.model;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.mojo.chronos.common.model.GCSample;
import org.codehaus.mojo.chronos.common.model.ModelUtil;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;

public class GCSamples
implements Serializable {
    private final List samples = new ArrayList();

    public final void add(GCSample sample) {
        this.samples.add(sample);
    }

    public final int getSampleCount() {
        return this.samples.size();
    }

    public final double getTimeStampForSampleAt(int index) {
        return ((GCSample)this.samples.get(index)).getTimestamp();
    }

    public final void extractHeapBefore(TimeSeries heapBeforeSeries) {
        for (GCSample sample : this.samples) {
            heapBeforeSeries.addOrUpdate((RegularTimePeriod)this.getTimestamp(sample), (double)sample.getHeapBefore());
        }
    }

    public final void extractHeapAfter(TimeSeries heapAfterSeries) {
        for (GCSample sample : this.samples) {
            heapAfterSeries.addOrUpdate((RegularTimePeriod)this.getTimestamp(sample), (double)sample.getHeapAfter());
        }
    }

    public final void extractHeapTotal(TimeSeries heapTotalSeries) {
        for (GCSample sample : this.samples) {
            heapTotalSeries.addOrUpdate((RegularTimePeriod)this.getTimestamp(sample), (double)sample.getHeapTotal());
        }
    }

    public final void extractProcessingTime(TimeSeries series) {
        for (GCSample sample : this.samples) {
            series.addOrUpdate((RegularTimePeriod)this.getTimestamp(sample), sample.getProcessingTime());
        }
    }

    public final double getGarbageCollectionRatio(long totalTime) {
        double totalProcessing = 0.0;
        for (GCSample sample : this.samples) {
            totalProcessing += sample.getProcessingTime();
        }
        return totalProcessing / (double)totalTime;
    }

    public final double getCollectedKBPerSecond(long totalTime) {
        double totalCollected = 0.0;
        for (GCSample sample : this.samples) {
            totalCollected += (double)(sample.getHeapBefore() - sample.getHeapAfter());
        }
        return totalCollected / 1000.0 / (double)totalTime;
    }

    private Millisecond getTimestamp(GCSample sample) {
        int milliseconds = (int)(sample.getTimestamp() * 1000.0);
        return ModelUtil.createMillis(milliseconds);
    }

    public void addAll(GCSamples tmp) {
        this.samples.addAll(tmp.samples);
    }

    public static GCSamples fromXML(File file) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document document = builder.build(file);
        GCSamples gcsamples = new GCSamples();
        List gcSampleXMLs = document.getRootElement().getChildren();
        Iterator iterator = gcSampleXMLs.iterator();
        while (iterator.hasNext()) {
            gcsamples.add(GCSample.fromXML((Element)iterator.next()));
        }
        return gcsamples;
    }
}

