/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class IOUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyDTDToDir(String dtdFileName, File targetDir) throws IOException {
        InputStream dtdInput = IOUtil.class.getResourceAsStream(dtdFileName);
        File dtdTmp = new File(targetDir, dtdFileName);
        try {
            IOUtil.copyContent(dtdInput, dtdTmp);
        }
        finally {
            dtdInput.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyContent(InputStream in, File output) throws IOException {
        FileOutputStream out = new FileOutputStream(output);
        try {
            IOUtil.copy(in, out);
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        out.flush();
    }

    public static File ensureDir(File directory) {
        if (!directory.exists()) {
            IOUtil.ensureDir(directory.getParentFile());
            directory.mkdir();
        }
        return directory;
    }

    public static void writeXmlToFile(File targetFile, Element xml, DocType doctype) throws IOException {
        File targetDir = targetFile.getParentFile();
        IOUtil.ensureDir(targetDir);
        Document doc = new Document(xml);
        doc.setDocType(doctype);
        IOUtil.copyDTDToDir(doctype.getSystemID(), targetDir);
        Format format = Format.getCompactFormat();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile), "UTF-8");
        new XMLOutputter(format).output(doc, (Writer)writer);
        writer.flush();
        writer.close();
    }

    public static String removeExtension(String fileName) {
        int separatorIndex = fileName.lastIndexOf(46);
        if (separatorIndex == -1) {
            return fileName;
        }
        return fileName.substring(0, separatorIndex);
    }

    public static String getAdjustedFileName(String shortName, String prefix, String extension) {
        return new StringBuffer().append(prefix).append('-').append(shortName).append('.').append(extension).toString();
    }

    public static File[] listFilesWithExtension(File dir, final String extension) {
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith("." + extension);
            }
        };
        return IOUtil.listFiles(dir, filenameFilter);
    }

    public static File[] listFiles(File dir, FilenameFilter filenameFilter) {
        if (!dir.exists()) {
            throw new IllegalArgumentException("Unknown directory " + dir + " Maybe the performancetests have not yet been run");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dir + " is not a directory. This may be caused by a configuration error.");
        }
        return dir.listFiles(filenameFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File input, File output) throws IOException {
        if (output.exists()) {
            output.delete();
        }
        FileInputStream in = new FileInputStream(input);
        try {
            IOUtil.copyContent(in, output);
        }
        finally {
            ((InputStream)in).close();
        }
    }
}

