/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.common;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.codehaus.mojo.chronos.common.IOUtil;
import org.codehaus.mojo.chronos.common.model.HistoricSample;
import org.codehaus.mojo.chronos.common.model.HistoricSamples;
import org.jdom.DocType;
import org.jdom.JDOMException;

public class HistoricDataDirectory {
    private static final String HISTORYSAMPLE_FILE_PREFIX = "history-";
    private File dataDirectory;

    public HistoricDataDirectory(File chronosDir, String dataId) {
        this.dataDirectory = new File(chronosDir, dataId);
    }

    public HistoricSamples readHistoricSamples() throws JDOMException, IOException {
        HistoricSamples samples = new HistoricSamples();
        Object[] historyFiles = this.dataDirectory.listFiles();
        if (historyFiles != null) {
            Arrays.sort(historyFiles);
            for (int i = 0; i < historyFiles.length; ++i) {
                if (!((File)historyFiles[i]).isFile() || !((File)historyFiles[i]).getName().startsWith(HISTORYSAMPLE_FILE_PREFIX)) continue;
                HistoricSample sample = HistoricSample.fromXML((File)historyFiles[i]);
                samples.addHistoricSample(sample);
            }
        }
        return samples;
    }

    public void writeHistorySample(HistoricSample sample) throws IOException {
        String fileName = HISTORYSAMPLE_FILE_PREFIX + sample.getTimestamp() + '.' + "xml";
        File historyFile = new File(this.dataDirectory, fileName);
        if (historyFile.exists()) {
            historyFile.delete();
        }
        IOUtil.writeXmlToFile(historyFile, sample.toXML(), new DocType("historysamples", "SYSTEM", "chronos-history.dtd"));
    }
}

