/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.apt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionUtils {
    private CollectionUtils() {
        throw new AssertionError();
    }

    public static <T> Set<T> defaultSet(Set<T> set) {
        return CollectionUtils.defaultSet(set, Collections.emptySet());
    }

    public static <T> Set<T> defaultSet(Set<T> set, Set<T> defaultSet) {
        return CollectionUtils.isEmpty(set) ? defaultSet : set;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <E> Set<E> genericSet(Set<?> set, Class<E> elementType) {
        return CollectionUtils.genericCollection(set, elementType, new HashSet());
    }

    public static <E> List<E> genericList(List<?> list, Class<E> elementType) {
        return CollectionUtils.genericCollection(list, elementType, new ArrayList());
    }

    private static <T extends Collection<E>, E> T genericCollection(Collection<?> collection, Class<E> elementType, T genericCollection) {
        for (Object element : collection) {
            genericCollection.add(elementType.cast(element));
        }
        return genericCollection;
    }
}

