/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.animal_sniffer;

import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public final class Clazz
implements Serializable {
    private final String name;
    private final Set<String> signatures;
    private final String superClass;
    private final String[] superInterfaces;
    private static final long serialVersionUID = 1L;

    private Clazz(String name, Set<String> signatures, String superClass, String[] superInterfaces, Void dummy) {
        this.name = name;
        this.signatures = signatures;
        this.superClass = superClass;
        this.superInterfaces = superInterfaces;
    }

    public Clazz(String name, String superClass, String[] superInterfaces) {
        this(name, new LinkedHashSet<String>(), superClass, (String[])superInterfaces.clone(), null);
    }

    public Clazz(String name, Set<String> signatures, String superClass, String[] superInterfaces) {
        this(name, new LinkedHashSet<String>(signatures), superClass, (String[])superInterfaces.clone(), null);
    }

    public Clazz(Clazz defA, Clazz defB) {
        if (!Objects.equals(defA.name, defB.name)) {
            throw new ClassCastException("Cannot merge different classes: " + defA.name + " and " + defB.name);
        }
        if (!Objects.equals(defA.superClass, defB.superClass)) {
            throw new ClassCastException("Cannot merge class " + defB.name + " as it has changed superclass:");
        }
        LinkedHashSet<String> superInterfaces = new LinkedHashSet<String>();
        if (defA.superInterfaces != null) {
            superInterfaces.addAll(Arrays.asList(defA.superInterfaces));
        }
        if (defB.superInterfaces != null) {
            superInterfaces.addAll(Arrays.asList(defB.superInterfaces));
        }
        LinkedHashSet<String> signatures = new LinkedHashSet<String>();
        signatures.addAll(defA.signatures);
        signatures.addAll(defB.signatures);
        this.name = defA.getName();
        this.signatures = signatures;
        this.superClass = defA.superClass;
        this.superInterfaces = superInterfaces.toArray(new String[0]);
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getSignatures() {
        return this.signatures;
    }

    public String getSuperClass() {
        return this.superClass;
    }

    public String[] getSuperInterfaces() {
        return this.superInterfaces;
    }
}

