/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.xpp3;

import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.plugin.java.JavaFieldMetadata;
import org.codehaus.modello.plugin.java.javasource.JClass;
import org.codehaus.modello.plugin.java.javasource.JField;
import org.codehaus.modello.plugin.java.javasource.JMethod;
import org.codehaus.modello.plugin.java.javasource.JParameter;
import org.codehaus.modello.plugin.java.javasource.JSourceCode;
import org.codehaus.modello.plugin.java.javasource.JSourceWriter;
import org.codehaus.modello.plugin.java.javasource.JType;
import org.codehaus.modello.plugin.model.ModelClassMetadata;
import org.codehaus.modello.plugin.xpp3.AbstractXpp3Generator;
import org.codehaus.modello.plugins.xml.XmlAssociationMetadata;
import org.codehaus.modello.plugins.xml.XmlFieldMetadata;

public class Xpp3WriterGenerator
extends AbstractXpp3Generator {
    public void generate(Model model, Properties parameters) throws ModelloException {
        this.initialize(model, parameters);
        try {
            this.generateXpp3Writer();
        }
        catch (IOException ex) {
            throw new ModelloException("Exception while generating XPP3 Writer.", (Throwable)ex);
        }
    }

    private void generateXpp3Writer() throws ModelloException, IOException {
        Model objectModel = this.getModel();
        String packageName = this.isPackageWithVersion() ? objectModel.getDefaultPackageName(true, this.getGeneratedVersion()) : objectModel.getDefaultPackageName(false, null);
        packageName = packageName + ".io.xpp3";
        String marshallerName = this.getFileName("Xpp3Writer");
        JSourceWriter sourceWriter = this.newJSourceWriter(packageName, marshallerName);
        JClass jClass = new JClass(marshallerName);
        jClass.setPackageName(packageName);
        jClass.addImport("org.codehaus.plexus.util.xml.pull.XmlSerializer");
        jClass.addImport("org.codehaus.plexus.util.xml.pull.MXSerializer");
        jClass.addImport("java.io.Writer");
        jClass.addImport("java.text.DateFormat");
        jClass.addImport("java.util.Iterator");
        jClass.addImport("java.util.Locale");
        jClass.addField(new JField((JType)new JClass("String"), "NAMESPACE"));
        this.addModelImports(jClass, null);
        String root = objectModel.getRoot(this.getGeneratedVersion());
        ModelClass rootClass = objectModel.getClass(root, this.getGeneratedVersion());
        ModelClassMetadata metadata = (ModelClassMetadata)rootClass.getMetadata(ModelClassMetadata.ID);
        String rootElement = metadata == null || metadata.getTagName() == null ? Xpp3WriterGenerator.uncapitalise((String)root) : metadata.getTagName();
        JMethod marshall = new JMethod(null, "write");
        marshall.addParameter(new JParameter((JType)new JClass("Writer"), "writer"));
        String rootElementParameterName = Xpp3WriterGenerator.uncapitalise((String)root);
        marshall.addParameter(new JParameter((JType)new JClass(root), rootElementParameterName));
        marshall.addException(new JClass("java.io.IOException"));
        JSourceCode sc = marshall.getSourceCode();
        sc.add("XmlSerializer serializer = new MXSerializer();");
        sc.add("serializer.setProperty( \"http://xmlpull.org/v1/doc/properties.html#serializer-indentation\", \"  \" );");
        sc.add("serializer.setProperty( \"http://xmlpull.org/v1/doc/properties.html#serializer-line-separator\", \"\\n\" );");
        sc.add("serializer.setOutput( writer );");
        sc.add("serializer.startDocument( " + rootElementParameterName + ".getModelEncoding(), null );");
        sc.add("write" + root + "( " + rootElementParameterName + ", \"" + rootElement + "\", serializer );");
        sc.add("serializer.endDocument();");
        jClass.addMethod(marshall);
        this.writeAllClasses(objectModel, jClass);
        jClass.print(sourceWriter);
        sourceWriter.close();
    }

    private void writeAllClasses(Model objectModel, JClass jClass) {
        Iterator i = objectModel.getClasses(this.getGeneratedVersion()).iterator();
        while (i.hasNext()) {
            ModelClass clazz = (ModelClass)i.next();
            this.writeClass(clazz, jClass);
        }
    }

    private void writeClass(ModelClass modelClass, JClass jClass) {
        String fieldTagName;
        JavaFieldMetadata javaFieldMetadata;
        XmlFieldMetadata fieldMetadata;
        ModelField field;
        String className = modelClass.getName();
        String uncapClassName = Xpp3WriterGenerator.uncapitalise((String)className);
        JMethod marshall = new JMethod(null, "write" + className);
        marshall.addParameter(new JParameter((JType)new JClass(className), uncapClassName));
        marshall.addParameter(new JParameter((JType)new JClass("String"), "tagName"));
        marshall.addParameter(new JParameter((JType)new JClass("XmlSerializer"), "serializer"));
        marshall.addException(new JClass("java.io.IOException"));
        marshall.getModifiers().makePrivate();
        JSourceCode sc = marshall.getSourceCode();
        sc.add("if ( " + uncapClassName + " != null )");
        sc.add("{");
        sc.indent();
        sc.add("serializer.startTag( NAMESPACE, tagName );");
        ModelField contentField = null;
        String contentValue = null;
        Iterator i = modelClass.getAllFields(this.getGeneratedVersion(), true).iterator();
        while (i.hasNext()) {
            field = (ModelField)i.next();
            fieldMetadata = (XmlFieldMetadata)field.getMetadata(XmlFieldMetadata.ID);
            javaFieldMetadata = (JavaFieldMetadata)field.getMetadata(JavaFieldMetadata.ID);
            fieldTagName = fieldMetadata.getTagName();
            if (fieldTagName == null) {
                fieldTagName = field.getName();
            }
            String type = field.getType();
            String value = uncapClassName + "." + this.getPrefix(javaFieldMetadata) + this.capitalise(field.getName()) + "()";
            if ("Content".equals(field.getType())) {
                contentField = field;
                contentValue = value;
                continue;
            }
            if (!fieldMetadata.isAttribute()) continue;
            sc.add(this.getValueChecker(type, value, field));
            sc.add("{");
            sc.indent();
            sc.add("serializer.attribute( NAMESPACE, \"" + fieldTagName + "\", " + this.getValue(field.getType(), value, fieldMetadata) + " );");
            sc.unindent();
            sc.add("}");
        }
        if (contentField != null) {
            XmlFieldMetadata fieldMetadata2 = (XmlFieldMetadata)contentField.getMetadata(XmlFieldMetadata.ID);
            sc.add("serializer.text( " + this.getValue(contentField.getType(), contentValue, fieldMetadata2) + ");");
        }
        Iterator fieldIterator = modelClass.getAllFields(this.getGeneratedVersion(), true).iterator();
        while (fieldIterator.hasNext()) {
            String singularTagName;
            field = (ModelField)fieldIterator.next();
            if ("Content".equals(field.getType())) continue;
            fieldMetadata = (XmlFieldMetadata)field.getMetadata(XmlFieldMetadata.ID);
            javaFieldMetadata = (JavaFieldMetadata)field.getMetadata(JavaFieldMetadata.ID);
            fieldTagName = fieldMetadata.getTagName();
            if (fieldTagName == null) {
                fieldTagName = field.getName();
            }
            if ((singularTagName = fieldMetadata.getAssociationTagName()) == null) {
                singularTagName = this.singular(fieldTagName);
            }
            boolean wrappedList = "wrapped".equals(fieldMetadata.getListStyle());
            String type = field.getType();
            String value = uncapClassName + "." + this.getPrefix(javaFieldMetadata) + this.capitalise(field.getName()) + "()";
            if (fieldMetadata.isAttribute()) continue;
            if (field instanceof ModelAssociation) {
                ModelAssociation association = (ModelAssociation)field;
                String associationName = association.getName();
                if ("1".equals(association.getMultiplicity())) {
                    sc.add(this.getValueChecker(type, value, (ModelField)association));
                    sc.add("{");
                    sc.indent();
                    sc.add("write" + association.getTo() + "( (" + association.getTo() + ") " + value + ", \"" + fieldTagName + "\", serializer );");
                    sc.unindent();
                    sc.add("}");
                    continue;
                }
                type = association.getType();
                String toType = association.getTo();
                if ("java.util.List".equals(type) || "java.util.Set".equals(type)) {
                    sc.add(this.getValueChecker(type, value, (ModelField)association));
                    sc.add("{");
                    sc.indent();
                    if (wrappedList) {
                        sc.add("serializer.startTag( NAMESPACE, \"" + fieldTagName + "\" );");
                    }
                    sc.add("for ( Iterator iter = " + value + ".iterator(); iter.hasNext(); )");
                    sc.add("{");
                    sc.indent();
                    if (this.isClassInModel(association.getTo(), modelClass.getModel())) {
                        sc.add(toType + " o = (" + toType + ") iter.next();");
                        sc.add("write" + toType + "( o, \"" + singularTagName + "\", serializer );");
                    } else {
                        sc.add(toType + " " + this.singular(Xpp3WriterGenerator.uncapitalise((String)field.getName())) + " = (" + toType + ") iter.next();");
                        sc.add("serializer.startTag( NAMESPACE, \"" + singularTagName + "\" ).text( " + this.singular(Xpp3WriterGenerator.uncapitalise((String)field.getName())) + " ).endTag( NAMESPACE, " + "\"" + singularTagName + "\" );");
                    }
                    sc.unindent();
                    sc.add("}");
                    if (wrappedList) {
                        sc.add("serializer.endTag( NAMESPACE, \"" + fieldTagName + "\" );");
                    }
                    sc.unindent();
                    sc.add("}");
                    continue;
                }
                XmlAssociationMetadata xmlAssociationMetadata = (XmlAssociationMetadata)association.getAssociationMetadata(XmlAssociationMetadata.ID);
                sc.add(this.getValueChecker(type, value, field));
                sc.add("{");
                sc.indent();
                if (wrappedList) {
                    sc.add("serializer.startTag( NAMESPACE, \"" + fieldTagName + "\" );");
                }
                sc.add("for ( Iterator iter = " + value + ".keySet().iterator(); iter.hasNext(); )");
                sc.add("{");
                sc.indent();
                sc.add("String key = (String) iter.next();");
                sc.add("String value = (String) " + value + ".get( key );");
                if ("explode".equals(xmlAssociationMetadata.getMapStyle())) {
                    sc.add("serializer.startTag( NAMESPACE, \"" + this.singular(associationName) + "\" );");
                    sc.add("serializer.startTag( NAMESPACE, \"key\" ).text( key ).endTag( NAMESPACE, \"key\" );");
                    sc.add("serializer.startTag( NAMESPACE, \"value\" ).text( value ).endTag( NAMESPACE, \"value\" );");
                    sc.add("serializer.endTag( NAMESPACE, \"" + this.singular(associationName) + "\" );");
                } else {
                    sc.add("serializer.startTag( NAMESPACE, \"\" + key + \"\" ).text( value ).endTag( NAMESPACE, \"\" + key + \"\" );");
                }
                sc.unindent();
                sc.add("}");
                if (wrappedList) {
                    sc.add("serializer.endTag( NAMESPACE, \"" + fieldTagName + "\" );");
                }
                sc.unindent();
                sc.add("}");
                continue;
            }
            sc.add(this.getValueChecker(type, value, field));
            sc.add("{");
            sc.indent();
            if ("DOM".equals(field.getType())) {
                jClass.addImport("org.codehaus.plexus.util.xml.Xpp3Dom");
                sc.add("((Xpp3Dom) " + value + ").writeToSerializer( NAMESPACE, serializer );");
            } else {
                sc.add("serializer.startTag( NAMESPACE, \"" + fieldTagName + "\" ).text( " + this.getValue(field.getType(), value, fieldMetadata) + " ).endTag( NAMESPACE, " + "\"" + fieldTagName + "\" );");
            }
            sc.unindent();
            sc.add("}");
        }
        sc.add("serializer.endTag( NAMESPACE, tagName );");
        sc.unindent();
        sc.add("}");
        jClass.addMethod(marshall);
    }

    private String getValue(String type, String initialValue, XmlFieldMetadata fieldMetadata) {
        String textValue = initialValue;
        if ("Date".equals(type)) {
            textValue = fieldMetadata.getFormat() == null ? "Long.toString( " + textValue + ".getTime() )" : "new java.text.SimpleDateFormat( \"" + fieldMetadata.getFormat() + "\", Locale.US ).format( " + textValue + " )";
        } else if (!"String".equals(type)) {
            textValue = "String.valueOf( " + textValue + " )";
        }
        return textValue;
    }

    private String getValueChecker(String type, String value, ModelField field) {
        String retVal = "boolean".equals(type) || "double".equals(type) || "float".equals(type) || "int".equals(type) || "long".equals(type) || "short".equals(type) || "byte".equals(type) ? "if ( " + value + " != " + field.getDefaultValue() + " )" : ("char".equals(type) ? "if ( " + value + " != '" + field.getDefaultValue() + "' )" : ("java.util.List".equals(type) || "java.util.Set".equals(type) || "java.util.Map".equals(type) || "java.util.Properties".equals(type) ? "if ( " + value + " != null && " + value + ".size() > 0 )" : ("String".equals(type) && field.getDefaultValue() != null ? "if ( " + value + " != null && !" + value + ".equals( \"" + field.getDefaultValue() + "\" ) )" : ("Date".equals(type) && field.getDefaultValue() != null ? "if ( " + value + " != null && !" + value + ".equals( \"" + field.getDefaultValue() + "\" ) )" : "if ( " + value + " != null )"))));
        return retVal;
    }
}

