/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.stax;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.plugin.AbstractModelloGenerator;
import org.codehaus.modello.plugin.stax.DummyIdModelField;
import org.codehaus.modello.plugins.xml.XmlAssociationMetadata;
import org.codehaus.modello.plugins.xml.XmlFieldMetadata;

public abstract class AbstractStaxGenerator
extends AbstractModelloGenerator {
    private Set parts;

    protected void initialize(Model model, Properties parameters) throws ModelloException {
        super.initialize(model, parameters);
        this.parts = null;
    }

    protected String getFileName(String suffix) throws ModelloException {
        String name = this.getModel().getName();
        return name + suffix;
    }

    protected ModelField getReferenceIdentifierField(ModelAssociation association) throws ModelloException {
        XmlAssociationMetadata assocMetadata = (XmlAssociationMetadata)association.getAssociationMetadata(XmlAssociationMetadata.ID);
        DummyIdModelField referenceIdentifierField = null;
        if (assocMetadata.isReference()) {
            String associationName = association.getName();
            ModelClass modelClass = association.getModelClass();
            if (!this.isClassInModel(association.getTo(), modelClass.getModel())) {
                throw new ModelloException("Can't use xml.reference on the '" + associationName + "' association of '" + modelClass.getName() + "' because the target class '" + association.getTo() + "' is not in the model");
            }
            List identifierFields = association.getToClass().getIdentifierFields(this.getGeneratedVersion());
            if (identifierFields.size() == 1) {
                referenceIdentifierField = (ModelField)identifierFields.get(0);
            } else {
                referenceIdentifierField = new DummyIdModelField();
                referenceIdentifierField.setName("modello.refid");
            }
        }
        return referenceIdentifierField;
    }

    protected boolean isAssociationPartToClass(ModelClass modelClass) {
        if (this.parts == null) {
            this.parts = new HashSet();
            Iterator i = modelClass.getModel().getClasses(this.getGeneratedVersion()).iterator();
            while (i.hasNext()) {
                ModelClass clazz = (ModelClass)i.next();
                Iterator j = clazz.getFields(this.getGeneratedVersion()).iterator();
                while (j.hasNext()) {
                    ModelAssociation assoc;
                    XmlAssociationMetadata assocMetadata;
                    ModelField modelField = (ModelField)j.next();
                    if (!(modelField instanceof ModelAssociation) || !(assocMetadata = (XmlAssociationMetadata)(assoc = (ModelAssociation)modelField).getAssociationMetadata(XmlAssociationMetadata.ID)).isReference()) continue;
                    this.parts.add(assoc.getToClass());
                }
            }
        }
        return this.parts.contains(modelClass);
    }

    protected static String getValue(String type, String initialValue, XmlFieldMetadata fieldMetadata) {
        String textValue = initialValue;
        if ("Date".equals(type)) {
            textValue = fieldMetadata.getFormat() == null ? "Long.toString( " + textValue + ".getTime() )" : "new java.text.SimpleDateFormat( \"" + fieldMetadata.getFormat() + "\", Locale.US ).format( " + textValue + " )";
        } else if (!"String".equals(type)) {
            textValue = "String.valueOf( " + textValue + " )";
        }
        return textValue;
    }
}

