/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.java.javasource;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.codehaus.modello.plugin.java.javasource.JAnnotations;
import org.codehaus.modello.plugin.java.javasource.JClass;
import org.codehaus.modello.plugin.java.javasource.JDocComment;
import org.codehaus.modello.plugin.java.javasource.JField;
import org.codehaus.modello.plugin.java.javasource.JMember;
import org.codehaus.modello.plugin.java.javasource.JMethodSignature;
import org.codehaus.modello.plugin.java.javasource.JModifiers;
import org.codehaus.modello.plugin.java.javasource.JNamedMap;
import org.codehaus.modello.plugin.java.javasource.JSourceWriter;
import org.codehaus.modello.plugin.java.javasource.JStructure;
import org.codehaus.modello.plugin.java.javasource.JType;

public final class JInterface
extends JStructure {
    private JNamedMap fields = null;
    private Vector methods = null;
    private List sourceCodeEntries = new ArrayList();

    public JInterface(String name) throws IllegalArgumentException {
        super(name);
        this.methods = new Vector();
        this.getJDocComment().appendComment("Interface " + this.getLocalName() + ".");
    }

    public void addField(JField jField) throws IllegalArgumentException {
        if (jField == null) {
            throw new IllegalArgumentException("argument 'jField' cannot be null");
        }
        String name = jField.getName();
        if (this.fields != null && this.fields.get(name) != null) {
            String err = "duplicate name found: " + name;
            throw new IllegalArgumentException(err);
        }
        JModifiers modifiers = jField.getModifiers();
        if (!modifiers.isStatic()) {
            throw new IllegalArgumentException("Fields added to a JInterface must be static.");
        }
        if (modifiers.isPrivate()) {
            throw new IllegalArgumentException("Fields added to a JInterface must not be private.");
        }
        if (this.fields == null) {
            this.fields = new JNamedMap(3);
        }
        this.fields.put(name, jField);
    }

    public void addMember(JMember jMember) throws IllegalArgumentException {
        if (jMember == null) {
            throw new IllegalArgumentException("argument 'jMember' may not be null.");
        }
        if (!(jMember instanceof JField)) {
            throw new IllegalArgumentException("invalid member for JInterface: " + jMember.toString());
        }
        this.addField((JField)jMember);
    }

    public void addMethod(JMethodSignature jMethodSig) throws IllegalArgumentException {
        JType jType;
        if (jMethodSig == null) {
            String err = "The JMethodSignature cannot be null.";
            throw new IllegalArgumentException(err);
        }
        boolean added = false;
        JModifiers modifiers = jMethodSig.getModifiers();
        for (int i = 0; i < this.methods.size(); ++i) {
            JMethodSignature tmp = (JMethodSignature)this.methods.elementAt(i);
            if (tmp.getModifiers().isProtected() && !modifiers.isProtected()) {
                this.methods.insertElementAt(jMethodSig, i);
                added = true;
                break;
            }
            if (jMethodSig.getName().compareTo(tmp.getName()) >= 0) continue;
            this.methods.insertElementAt(jMethodSig, i);
            added = true;
            break;
        }
        if (!added) {
            this.methods.addElement(jMethodSig);
        }
        if ((jType = jMethodSig.getReturnType()) != null) {
            while (jType.isArray()) {
                jType = jType.getComponentType();
            }
            if (!jType.isPrimitive()) {
                this.addImport(jType.getName());
            }
        }
        JClass[] exceptions = jMethodSig.getExceptions();
        for (int i = 0; i < exceptions.length; ++i) {
            this.addImport(exceptions[i].getName());
        }
    }

    public JField getField(String name) {
        if (this.fields == null) {
            return null;
        }
        return (JField)this.fields.get(name);
    }

    public JField[] getFields() {
        if (this.fields == null) {
            return new JField[0];
        }
        int size = this.fields.size();
        JField[] farray = new JField[size];
        for (int i = 0; i < size; ++i) {
            farray[i] = (JField)this.fields.get(i);
        }
        return farray;
    }

    public JMethodSignature[] getMethods() {
        Object[] marray = new JMethodSignature[this.methods.size()];
        this.methods.copyInto(marray);
        return marray;
    }

    public JMethodSignature getMethod(String name, int startIndex) {
        for (int i = startIndex; i < this.methods.size(); ++i) {
            JMethodSignature jMethod = (JMethodSignature)this.methods.elementAt(i);
            if (!jMethod.getName().equals(name)) continue;
            return jMethod;
        }
        return null;
    }

    public JMethodSignature getMethod(int index) {
        return (JMethodSignature)this.methods.elementAt(index);
    }

    public void print(JSourceWriter jsw) {
        this.print(jsw, false);
    }

    public void print(JSourceWriter jsw, boolean classOnly) {
        if (jsw == null) {
            throw new IllegalArgumentException("argument 'jsw' should not be null.");
        }
        StringBuffer buffer = new StringBuffer();
        if (!classOnly) {
            this.printHeader(jsw);
            this.printPackageDeclaration(jsw);
            this.printImportDeclarations(jsw);
        }
        this.getJDocComment().print(jsw);
        JAnnotations annotations = this.getAnnotations();
        if (annotations != null) {
            annotations.print(jsw);
        }
        buffer.setLength(0);
        JModifiers modifiers = this.getModifiers();
        if (modifiers.isPrivate()) {
            buffer.append("private ");
        } else if (modifiers.isPublic()) {
            buffer.append("public ");
        }
        if (modifiers.isAbstract()) {
            buffer.append("abstract ");
        }
        buffer.append("interface ");
        buffer.append(this.getLocalName());
        jsw.writeln(buffer.toString());
        buffer.setLength(0);
        jsw.indent();
        if (this.getInterfaceCount() > 0) {
            Enumeration e = this.getInterfaces();
            buffer.append("extends ");
            while (e.hasMoreElements()) {
                buffer.append(e.nextElement());
                if (!e.hasMoreElements()) continue;
                buffer.append(", ");
            }
            jsw.writeln(buffer.toString());
            buffer.setLength(0);
        }
        jsw.unindent();
        jsw.writeln('{');
        jsw.indent();
        if (this.fields != null) {
            if (this.fields.size() > 0) {
                jsw.writeln();
                jsw.writeln("  //--------------------------/");
                jsw.writeln(" //- Class/Member Variables -/");
                jsw.writeln("//--------------------------/");
                jsw.writeln();
            }
            for (int i = 0; i < this.fields.size(); ++i) {
                JField jField = (JField)this.fields.get(i);
                JDocComment comment = jField.getComment();
                if (comment != null) {
                    comment.print(jsw);
                }
                jsw.write(jField.getModifiers().toString());
                jsw.write(32);
                JType type = jField.getType();
                String typeName = type.toString();
                if (typeName.equals(this.toString())) {
                    typeName = type.getLocalName();
                }
                jsw.write(typeName);
                jsw.write(32);
                jsw.write(jField.getName());
                String init = jField.getInitString();
                if (init != null) {
                    jsw.write(" = ");
                    jsw.write(init);
                }
                jsw.writeln(';');
                jsw.writeln();
            }
        }
        if (this.methods.size() > 0) {
            jsw.writeln();
            jsw.writeln("  //-----------/");
            jsw.writeln(" //- Methods -/");
            jsw.writeln("//-----------/");
            jsw.writeln();
        }
        for (int i = 0; i < this.methods.size(); ++i) {
            JMethodSignature signature = (JMethodSignature)this.methods.elementAt(i);
            signature.print(jsw);
            jsw.writeln(';');
        }
        Iterator iterator = this.sourceCodeEntries.iterator();
        while (iterator.hasNext()) {
            jsw.writeln((String)iterator.next());
        }
        jsw.unindent();
        jsw.writeln('}');
        jsw.flush();
        jsw.close();
    }

    public void addSourceCode(String sourceCode) {
        this.sourceCodeEntries.add(sourceCode);
    }
}

