/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.java;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.model.BaseElement;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.model.ModelInterface;
import org.codehaus.modello.plugin.AbstractModelloGenerator;
import org.codehaus.modello.plugin.java.javasource.JClass;
import org.codehaus.modello.plugin.java.javasource.JComment;
import org.codehaus.modello.plugin.java.javasource.JInterface;
import org.codehaus.modello.plugin.java.javasource.JSourceWriter;
import org.codehaus.modello.plugin.java.javasource.JStructure;
import org.codehaus.modello.plugin.java.metadata.JavaClassMetadata;
import org.codehaus.modello.plugin.java.metadata.JavaFieldMetadata;
import org.codehaus.modello.plugin.java.metadata.JavaModelMetadata;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;

public abstract class AbstractJavaModelloGenerator
extends AbstractModelloGenerator {
    protected boolean useJava5 = false;
    protected static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";

    protected void initialize(Model model, Properties parameters) throws ModelloException {
        super.initialize(model, parameters);
        this.useJava5 = Boolean.valueOf(this.getParameter(parameters, "modello.output.useJava5", "false"));
    }

    protected JSourceWriter newJSourceWriter(String packageName, String className) throws IOException {
        String directory = packageName.replace('.', File.separatorChar);
        File f = new File(new File(this.getOutputDirectory(), directory), className + ".java");
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        OutputStream os = this.getBuildContext().newFileOutputStream(f);
        Writer writer = this.getEncoding() == null ? WriterFactory.newPlatformWriter((OutputStream)os) : WriterFactory.newWriter((OutputStream)os, (String)this.getEncoding());
        return new JSourceWriter(writer);
    }

    private JComment getHeaderComment() {
        JComment comment = new JComment();
        comment.setComment(this.getHeader());
        return comment;
    }

    protected void initHeader(JClass clazz) {
        clazz.setHeader(this.getHeaderComment());
    }

    protected void initHeader(JInterface interfaze) {
        interfaze.setHeader(this.getHeaderComment());
    }

    protected void suppressAllWarnings(Model objectModel, JStructure structure) {
        JavaModelMetadata javaModelMetadata = (JavaModelMetadata)objectModel.getMetadata(JavaModelMetadata.ID);
        if (this.useJava5 && javaModelMetadata.isSuppressAllWarnings()) {
            structure.appendAnnotation("@SuppressWarnings( \"all\" )");
        }
    }

    protected void addModelImports(JClass jClass, BaseElement baseElem) throws ModelloException {
        String packageName;
        String basePackageName = null;
        if (baseElem != null) {
            if (baseElem instanceof ModelInterface) {
                basePackageName = ((ModelInterface)baseElem).getPackageName(this.isPackageWithVersion(), this.getGeneratedVersion());
            } else if (baseElem instanceof ModelClass) {
                basePackageName = ((ModelClass)baseElem).getPackageName(this.isPackageWithVersion(), this.getGeneratedVersion());
            }
        }
        Iterator i = this.getModel().getInterfaces(this.getGeneratedVersion()).iterator();
        while (i.hasNext()) {
            ModelInterface modelInterface = (ModelInterface)i.next();
            packageName = modelInterface.getPackageName(this.isPackageWithVersion(), this.getGeneratedVersion());
            if (packageName.equals(basePackageName)) continue;
            jClass.addImport(packageName + '.' + modelInterface.getName());
        }
        i = this.getModel().getClasses(this.getGeneratedVersion()).iterator();
        while (i.hasNext()) {
            JavaClassMetadata javaClassMetadata;
            ModelClass modelClass = (ModelClass)i.next();
            packageName = modelClass.getPackageName(this.isPackageWithVersion(), this.getGeneratedVersion());
            if (packageName.equals(basePackageName) || !(javaClassMetadata = (JavaClassMetadata)modelClass.getMetadata(JavaClassMetadata.ID)).isEnabled()) continue;
            jClass.addImport(packageName + '.' + modelClass.getName());
        }
    }

    protected String getPrefix(JavaFieldMetadata javaFieldMetadata) {
        return javaFieldMetadata.isBooleanGetter() ? "is" : "get";
    }

    protected String getDefaultValue(ModelAssociation association) {
        String value = association.getDefaultValue();
        if (this.useJava5) {
            value = StringUtils.replaceOnce((String)StringUtils.replaceOnce((String)value, (String)"/*", (String)""), (String)"*/", (String)"");
        }
        return value;
    }

    protected String getJavaDefaultValue(ModelField modelField) throws ModelloException {
        if (modelField.getType().equals("String")) {
            return '\"' + modelField.getDefaultValue() + '\"';
        }
        if (modelField.getType().equals("char")) {
            return '\'' + modelField.getDefaultValue() + '\'';
        }
        if (modelField.getType().equals("long")) {
            return modelField.getDefaultValue() + 'L';
        }
        if (modelField.getType().equals("float")) {
            return modelField.getDefaultValue() + 'f';
        }
        if (modelField.getType().equals("Date")) {
            SimpleDateFormat format = new SimpleDateFormat(DEFAULT_DATE_FORMAT, Locale.US);
            try {
                Date date = format.parse(modelField.getDefaultValue());
                return "new java.util.Date( " + date.getTime() + "L )";
            }
            catch (ParseException pe) {
                throw new ModelloException("Unparseable default date: " + modelField.getDefaultValue(), (Throwable)pe);
            }
        }
        return modelField.getDefaultValue();
    }

    protected String getValueChecker(String type, String value, ModelField field) throws ModelloException {
        String retVal = "boolean".equals(type) || "double".equals(type) || "float".equals(type) || "int".equals(type) || "long".equals(type) || "short".equals(type) || "byte".equals(type) || "char".equals(type) ? "if ( " + value + " != " + this.getJavaDefaultValue(field) + " )" : ("java.util.List".equals(type) || "java.util.Set".equals(type) || "java.util.Map".equals(type) || "java.util.Properties".equals(type) ? "if ( ( " + value + " != null ) && ( " + value + ".size() > 0 ) )" : ("String".equals(type) && field.getDefaultValue() != null ? "if ( ( " + value + " != null ) && !" + value + ".equals( \"" + field.getDefaultValue() + "\" ) )" : ("Date".equals(type) && field.getDefaultValue() != null ? "if ( ( " + value + " != null ) && !" + value + ".equals( " + this.getJavaDefaultValue(field) + " ) )" : "if ( " + value + " != null )")));
        return retVal;
    }
}

