/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven3.util;

import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.internal.util.JdkUtils;
import org.codehaus.cargo.container.internal.util.ResourceUtils;

public class EmbeddedContainerArtifactResolver {
    private ArtifactResolver artifactResolver;
    private ProjectBuildingRequest projectBuildingRequest;
    private Map<String, List<Dependency>> containerDependencies = new HashMap<String, List<Dependency>>();

    public EmbeddedContainerArtifactResolver(ArtifactResolver artifactResolver, ProjectBuildingRequest projectBuildingRequest) {
        this.artifactResolver = artifactResolver;
        this.projectBuildingRequest = projectBuildingRequest;
        ArrayList<Dependency> jetty5xDependencies = new ArrayList<Dependency>();
        jetty5xDependencies.add(new Dependency("jetty", "org.mortbay.jetty", "5.1.12"));
        jetty5xDependencies.add(new Dependency("javax.servlet", "servlet-api", "2.4"));
        jetty5xDependencies.add(new Dependency("javax.servlet", "jsp-api", "2.0"));
        jetty5xDependencies.add(new Dependency("ant", "ant", "1.6.4"));
        jetty5xDependencies.add(new Dependency("xerces", "xercesImpl", "2.6.2"));
        jetty5xDependencies.add(new Dependency("xerces", "xmlParserAPIs", "2.6.2"));
        jetty5xDependencies.add(new Dependency("tomcat", "jasper-compiler", "5.5.12"));
        jetty5xDependencies.add(new Dependency("tomcat", "jasper-runtime", "5.5.12"));
        jetty5xDependencies.add(new Dependency("commons-el", "commons-el", "1.0"));
        jetty5xDependencies.add(new Dependency("commons-logging", "commons-logging", "1.0.4"));
        this.containerDependencies.put("jetty5x", jetty5xDependencies);
        ArrayList<Dependency> jetty6xDependencies = new ArrayList<Dependency>();
        jetty6xDependencies.add(new Dependency("org.mortbay.jetty", "jsp-api-2.0", "6.1.26"));
        jetty6xDependencies.add(new Dependency("org.mortbay.jetty", "servlet-api-2.5", "6.1.14"));
        jetty6xDependencies.add(new Dependency("org.mortbay.jetty", "jetty", "6.1.26"));
        jetty6xDependencies.add(new Dependency("org.mortbay.jetty", "jetty-util", "6.1.26"));
        jetty6xDependencies.add(new Dependency("org.mortbay.jetty", "jetty-naming", "6.1.26"));
        jetty6xDependencies.add(new Dependency("org.mortbay.jetty", "jetty-plus", "6.1.26"));
        jetty6xDependencies.add(new Dependency("ant", "ant", "1.6.5"));
        jetty6xDependencies.add(new Dependency("commons-el", "commons-el", "1.0"));
        jetty6xDependencies.add(new Dependency("tomcat", "jasper-compiler", "5.5.15"));
        jetty6xDependencies.add(new Dependency("tomcat", "jasper-runtime", "5.5.15"));
        jetty6xDependencies.add(new Dependency("tomcat", "jasper-compiler-jdt", "5.5.15"));
        jetty6xDependencies.add(new Dependency("javax.mail", "mail", "1.4"));
        jetty6xDependencies.add(new Dependency("javax.activation", "activation", "1.1"));
        jetty6xDependencies.add(new Dependency("geronimo-spec", "geronimo-spec-jta", "1.0.1B-rc4"));
        jetty6xDependencies.add(new Dependency("xerces", "xercesImpl", "2.6.2"));
        jetty6xDependencies.add(new Dependency("xerces", "xmlParserAPIs", "2.6.2"));
        jetty6xDependencies.add(new Dependency("commons-logging", "commons-logging", "1.0.4"));
        jetty6xDependencies.add(new Dependency("log4j", "log4j", "1.2.14"));
        this.containerDependencies.put("jetty6x", jetty6xDependencies);
        ArrayList<Dependency> jetty7xDependencies = new ArrayList<Dependency>();
        jetty7xDependencies.add(new Dependency("javax.servlet", "servlet-api", "2.5"));
        jetty7xDependencies.add(new Dependency("org.eclipse.jdt", "org.eclipse.jdt.core", "3.7.1"));
        jetty7xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-continuation", "7.6.21.v20160908"));
        jetty7xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-http", "7.6.21.v20160908"));
        jetty7xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-io", "7.6.21.v20160908"));
        jetty7xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-jsp", "7.6.21.v20160908"));
        jetty7xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-util", "7.6.21.v20160908"));
        jetty7xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-security", "7.6.21.v20160908"));
        jetty7xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-server", "7.6.21.v20160908"));
        jetty7xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-servlet", "7.6.21.v20160908"));
        jetty7xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-webapp", "7.6.21.v20160908"));
        jetty7xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-xml", "7.6.21.v20160908"));
        jetty7xDependencies.add(new Dependency("org.mortbay.jetty", "jsp-api-2.1-glassfish", "2.1.v20100127"));
        jetty7xDependencies.add(new Dependency("org.mortbay.jetty", "jsp-2.1-glassfish", "2.1.v20100127"));
        this.containerDependencies.put("jetty7x", jetty7xDependencies);
        ArrayList<Dependency> jetty8xDependencies = new ArrayList<Dependency>();
        jetty8xDependencies.add(new Dependency("org.mortbay.jetty", "servlet-api", "3.0.20100224"));
        jetty8xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-annotations", "8.1.22.v20160922"));
        jetty8xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-continuation", "8.1.22.v20160922"));
        jetty8xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-http", "8.1.22.v20160922"));
        jetty8xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-io", "8.1.22.v20160922"));
        jetty8xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-jndi", "8.1.22.v20160922"));
        jetty8xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-plus", "8.1.22.v20160922"));
        jetty8xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-util", "8.1.22.v20160922"));
        jetty8xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-security", "8.1.22.v20160922"));
        jetty8xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-server", "8.1.22.v20160922"));
        jetty8xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-servlet", "8.1.22.v20160922"));
        jetty8xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-webapp", "8.1.22.v20160922"));
        jetty8xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-xml", "8.1.22.v20160922"));
        jetty8xDependencies.add(new Dependency("org.eclipse.jetty.orbit", "org.objectweb.asm", "3.1.0.v200803061910"));
        jetty8xDependencies.add(new Dependency("org.eclipse.jetty.orbit", "javax.mail.glassfish", "1.4.1.v201005082020"));
        jetty8xDependencies.add(new Dependency("org.eclipse.jetty.orbit", "javax.activation", "1.1.0.v201105071233"));
        jetty8xDependencies.add(new Dependency("org.eclipse.jetty.orbit", "javax.annotation", "1.1.0.v201108011116"));
        jetty8xDependencies.add(new Dependency("org.eclipse.jetty.orbit", "javax.el", "2.2.0.v201108011116"));
        jetty8xDependencies.add(new Dependency("org.eclipse.jetty.orbit", "javax.servlet.jsp", "2.2.0.v201112011158"));
        jetty8xDependencies.add(new Dependency("org.eclipse.jetty.orbit", "org.apache.jasper.glassfish", "2.2.2.v201112011158"));
        this.containerDependencies.put("jetty8x", jetty8xDependencies);
        ArrayList<Dependency> jetty9xDependencies = new ArrayList<Dependency>();
        jetty9xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-annotations", "9.4.57.v20241219"));
        jetty9xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-continuation", "9.4.57.v20241219"));
        jetty9xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-http", "9.4.57.v20241219"));
        jetty9xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-io", "9.4.57.v20241219"));
        jetty9xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-jndi", "9.4.57.v20241219"));
        jetty9xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-plus", "9.4.57.v20241219"));
        jetty9xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-util", "9.4.57.v20241219"));
        jetty9xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-security", "9.4.57.v20241219"));
        jetty9xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-server", "9.4.57.v20241219"));
        jetty9xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-servlet", "9.4.57.v20241219"));
        jetty9xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-webapp", "9.4.57.v20241219"));
        jetty9xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-xml", "9.4.57.v20241219"));
        jetty9xDependencies.add(new Dependency("javax.servlet", "javax.servlet-api", "3.1.0"));
        jetty9xDependencies.add(new Dependency("org.eclipse.jetty.toolchain", "jetty-schemas", "3.1"));
        jetty9xDependencies.add(new Dependency("org.ow2.asm", "asm", "9.7.1"));
        jetty9xDependencies.add(new Dependency("org.ow2.asm", "asm-commons", "9.7.1"));
        jetty9xDependencies.add(new Dependency("javax.annotation", "javax.annotation-api", "1.3.2"));
        jetty9xDependencies.add(new Dependency("org.eclipse.jetty.orbit", "javax.mail.glassfish", "1.4.1.v201005082020"));
        jetty9xDependencies.add(new Dependency("javax.transaction", "javax.transaction-api", "1.3"));
        jetty9xDependencies.add(new Dependency("org.eclipse.jdt", "ecj", "3.26.0"));
        jetty9xDependencies.add(new Dependency("org.eclipse.jetty", "apache-jsp", "9.4.57.v20241219"));
        jetty9xDependencies.add(new Dependency("org.mortbay.jasper", "apache-el", "8.5.100"));
        jetty9xDependencies.add(new Dependency("org.mortbay.jasper", "apache-jsp", "8.5.100"));
        this.containerDependencies.put("jetty9x", jetty9xDependencies);
        ArrayList<Dependency> jetty10xDependencies = new ArrayList<Dependency>();
        jetty10xDependencies.add(new Dependency("org.eclipse.jetty.toolchain", "jetty-servlet-api", "4.0.6"));
        jetty10xDependencies.add(new Dependency("org.slf4j", "slf4j-api", "2.0.13"));
        jetty10xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-slf4j-impl", "10.0.25"));
        jetty10xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-annotations", "10.0.25"));
        jetty10xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-http", "10.0.25"));
        jetty10xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-io", "10.0.25"));
        jetty10xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-jndi", "10.0.25"));
        jetty10xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-plus", "10.0.25"));
        jetty10xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-util", "10.0.25"));
        jetty10xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-security", "10.0.25"));
        jetty10xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-server", "10.0.25"));
        jetty10xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-servlet", "10.0.25"));
        jetty10xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-webapp", "10.0.25"));
        jetty10xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-xml", "10.0.25"));
        jetty10xDependencies.add(new Dependency("org.eclipse.jdt", "ecj", "3.33.0"));
        jetty10xDependencies.add(new Dependency("org.eclipse.jetty", "apache-jsp", "10.0.25"));
        jetty10xDependencies.add(new Dependency("org.mortbay.jasper", "apache-el", "9.0.90"));
        jetty10xDependencies.add(new Dependency("org.mortbay.jasper", "apache-jsp", "9.0.90"));
        this.containerDependencies.put("jetty10x", jetty10xDependencies);
        ArrayList<Dependency> jetty11xDependencies = new ArrayList<Dependency>();
        jetty11xDependencies.add(new Dependency("org.eclipse.jetty.toolchain", "jetty-jakarta-servlet-api", "5.0.2"));
        jetty11xDependencies.add(new Dependency("org.slf4j", "slf4j-api", "2.0.13"));
        jetty11xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-slf4j-impl", "11.0.25"));
        jetty11xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-annotations", "11.0.25"));
        jetty11xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-http", "11.0.25"));
        jetty11xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-io", "11.0.25"));
        jetty11xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-jndi", "11.0.25"));
        jetty11xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-plus", "11.0.25"));
        jetty11xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-util", "11.0.25"));
        jetty11xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-security", "11.0.25"));
        jetty11xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-server", "11.0.25"));
        jetty11xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-servlet", "11.0.25"));
        jetty11xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-webapp", "11.0.25"));
        jetty11xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-xml", "11.0.25"));
        jetty11xDependencies.add(new Dependency("org.eclipse.jdt", "ecj", "3.33.0"));
        jetty11xDependencies.add(new Dependency("org.eclipse.jetty", "apache-jsp", "11.0.25"));
        jetty11xDependencies.add(new Dependency("org.mortbay.jasper", "apache-el", "10.0.27"));
        jetty11xDependencies.add(new Dependency("org.mortbay.jasper", "apache-jsp", "10.0.27"));
        this.containerDependencies.put("jetty11x", jetty11xDependencies);
        ArrayList<Dependency> jetty12xDependencies = new ArrayList<Dependency>();
        jetty12xDependencies.add(new Dependency("org.slf4j", "slf4j-api", "2.0.17"));
        jetty12xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-slf4j-impl", "12.0.24"));
        jetty12xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-ee", "12.0.24"));
        jetty12xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-http", "12.0.24"));
        jetty12xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-io", "12.0.24"));
        jetty12xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-jndi", "12.0.24"));
        jetty12xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-plus", "12.0.24"));
        jetty12xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-util", "12.0.24"));
        jetty12xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-security", "12.0.24"));
        jetty12xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-server", "12.0.24"));
        jetty12xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-session", "12.0.24"));
        jetty12xDependencies.add(new Dependency("org.eclipse.jetty", "jetty-xml", "12.0.24"));
        jetty12xDependencies.add(new Dependency("org.eclipse.jdt", "ecj", "3.38.0"));
        this.containerDependencies.put("jetty12x", jetty12xDependencies);
        ArrayList<Dependency> jetty12xee8Dependencies = new ArrayList<Dependency>();
        jetty12xee8Dependencies.add(new Dependency("org.eclipse.jetty.toolchain", "jetty-servlet-api", "4.0.6"));
        jetty12xee8Dependencies.add(new Dependency("org.eclipse.jetty.ee8", "jetty-ee8-annotations", "12.0.24"));
        jetty12xee8Dependencies.add(new Dependency("org.eclipse.jetty.ee8", "jetty-ee8-jndi", "12.0.24"));
        jetty12xee8Dependencies.add(new Dependency("org.eclipse.jetty.ee8", "jetty-ee8-nested", "12.0.24"));
        jetty12xee8Dependencies.add(new Dependency("org.eclipse.jetty.ee8", "jetty-ee8-plus", "12.0.24"));
        jetty12xee8Dependencies.add(new Dependency("org.eclipse.jetty.ee8", "jetty-ee8-security", "12.0.24"));
        jetty12xee8Dependencies.add(new Dependency("org.eclipse.jetty.ee8", "jetty-ee8-servlet", "12.0.24"));
        jetty12xee8Dependencies.add(new Dependency("org.eclipse.jetty.ee8", "jetty-ee8-webapp", "12.0.24"));
        jetty12xee8Dependencies.add(new Dependency("org.eclipse.jetty.ee8", "jetty-ee8-apache-jsp", "12.0.24"));
        jetty12xee8Dependencies.add(new Dependency("org.mortbay.jasper", "apache-el", "9.0.107"));
        jetty12xee8Dependencies.add(new Dependency("org.mortbay.jasper", "apache-jsp", "9.0.107"));
        this.containerDependencies.put("jetty12x_ee8", jetty12xee8Dependencies);
        ArrayList<Dependency> jetty12xee9Dependencies = new ArrayList<Dependency>();
        jetty12xee9Dependencies.add(new Dependency("org.eclipse.jetty.toolchain", "jetty-jakarta-servlet-api", "5.0.2"));
        jetty12xee9Dependencies.add(new Dependency("org.eclipse.jetty.ee9", "jetty-ee9-annotations", "12.0.24"));
        jetty12xee9Dependencies.add(new Dependency("org.eclipse.jetty.ee9", "jetty-ee9-jndi", "12.0.24"));
        jetty12xee9Dependencies.add(new Dependency("org.eclipse.jetty.ee9", "jetty-ee9-nested", "12.0.24"));
        jetty12xee9Dependencies.add(new Dependency("org.eclipse.jetty.ee9", "jetty-ee9-plus", "12.0.24"));
        jetty12xee9Dependencies.add(new Dependency("org.eclipse.jetty.ee9", "jetty-ee9-security", "12.0.24"));
        jetty12xee9Dependencies.add(new Dependency("org.eclipse.jetty.ee9", "jetty-ee9-servlet", "12.0.24"));
        jetty12xee9Dependencies.add(new Dependency("org.eclipse.jetty.ee9", "jetty-ee9-webapp", "12.0.24"));
        jetty12xee9Dependencies.add(new Dependency("org.eclipse.jetty.ee9", "jetty-ee9-apache-jsp", "12.0.24"));
        jetty12xee9Dependencies.add(new Dependency("org.mortbay.jasper", "apache-el", "10.0.27"));
        jetty12xee9Dependencies.add(new Dependency("org.mortbay.jasper", "apache-jsp", "10.0.27"));
        this.containerDependencies.put("jetty12x_ee9", jetty12xee9Dependencies);
        ArrayList<Dependency> jetty12xee10Dependencies = new ArrayList<Dependency>();
        jetty12xee10Dependencies.add(new Dependency("jakarta.servlet", "jakarta.servlet-api", "6.0.0"));
        jetty12xee10Dependencies.add(new Dependency("org.eclipse.jetty.ee10", "jetty-ee10-annotations", "12.0.24"));
        jetty12xee10Dependencies.add(new Dependency("org.eclipse.jetty.ee10", "jetty-ee10-jndi", "12.0.24"));
        jetty12xee10Dependencies.add(new Dependency("org.eclipse.jetty.ee10", "jetty-ee10-plus", "12.0.24"));
        jetty12xee10Dependencies.add(new Dependency("org.eclipse.jetty.ee10", "jetty-ee10-servlet", "12.0.24"));
        jetty12xee10Dependencies.add(new Dependency("org.eclipse.jetty.ee10", "jetty-ee10-webapp", "12.0.24"));
        jetty12xee10Dependencies.add(new Dependency("jakarta.el", "jakarta.el-api", "5.0.1"));
        jetty12xee10Dependencies.add(new Dependency("jakarta.servlet.jsp", "jakarta.servlet.jsp-api", "3.1.1"));
        jetty12xee10Dependencies.add(new Dependency("org.eclipse.jetty.ee10", "jetty-ee10-apache-jsp", "12.0.24"));
        jetty12xee10Dependencies.add(new Dependency("org.mortbay.jasper", "apache-el", "10.1.43"));
        jetty12xee10Dependencies.add(new Dependency("org.mortbay.jasper", "apache-jsp", "10.1.43"));
        this.containerDependencies.put("jetty12x_ee10", jetty12xee10Dependencies);
        ArrayList<Dependency> tomcat6xDependencies = new ArrayList<Dependency>();
        tomcat6xDependencies.add(new Dependency("org.apache.tomcat", "servlet-api", "6.0.44"));
        tomcat6xDependencies.add(new Dependency("org.apache.tomcat", "annotations-api", "6.0.44"));
        tomcat6xDependencies.add(new Dependency("org.apache.tomcat", "el-api", "6.0.44"));
        tomcat6xDependencies.add(new Dependency("org.apache.tomcat", "jsp-api", "6.0.44"));
        tomcat6xDependencies.add(new Dependency("org.apache.tomcat", "juli", "6.0.44"));
        tomcat6xDependencies.add(new Dependency("org.apache.tomcat", "catalina", "6.0.44"));
        tomcat6xDependencies.add(new Dependency("org.apache.tomcat", "coyote", "6.0.44"));
        tomcat6xDependencies.add(new Dependency("org.apache.tomcat", "jasper", "6.0.44"));
        tomcat6xDependencies.add(new Dependency("org.apache.tomcat", "jasper-el", "6.0.44"));
        tomcat6xDependencies.add(new Dependency("org.eclipse.jdt.core.compiler", "ecj", "4.3.1"));
        this.containerDependencies.put("tomcat6x", tomcat6xDependencies);
        ArrayList<Dependency> tomcat7xDependencies = new ArrayList<Dependency>();
        tomcat7xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-servlet-api", "7.0.109"));
        tomcat7xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-annotations-api", "7.0.109"));
        tomcat7xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-dbcp", "7.0.109"));
        tomcat7xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-el-api", "7.0.109"));
        tomcat7xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-jsp-api", "7.0.109"));
        tomcat7xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-juli", "7.0.109"));
        tomcat7xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-api", "7.0.109"));
        tomcat7xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-util", "7.0.109"));
        tomcat7xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-catalina", "7.0.109"));
        tomcat7xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-coyote", "7.0.109"));
        tomcat7xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-jasper", "7.0.109"));
        tomcat7xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-jasper-el", "7.0.109"));
        tomcat7xDependencies.add(new Dependency("org.eclipse.jdt.core.compiler", "ecj", "4.4.2"));
        this.containerDependencies.put("tomcat7x", tomcat7xDependencies);
        ArrayList<Dependency> tomcat8xDependencies = new ArrayList<Dependency>();
        tomcat8xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-jaspic-api", "8.5.100"));
        tomcat8xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-servlet-api", "8.5.100"));
        tomcat8xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-annotations-api", "8.5.100"));
        tomcat8xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-dbcp", "8.5.100"));
        tomcat8xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-el-api", "8.5.100"));
        tomcat8xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-jsp-api", "8.5.100"));
        tomcat8xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-juli", "8.5.100"));
        tomcat8xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-api", "8.5.100"));
        tomcat8xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-jni", "8.5.100"));
        tomcat8xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-util", "8.5.100"));
        tomcat8xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-util-scan", "8.5.100"));
        tomcat8xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-catalina", "8.5.100"));
        tomcat8xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-coyote", "8.5.100"));
        tomcat8xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-websocket-api", "8.5.100"));
        tomcat8xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-websocket", "8.5.100"));
        tomcat8xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-jasper", "8.5.100"));
        tomcat8xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-jasper-el", "8.5.100"));
        tomcat8xDependencies.add(new Dependency("org.eclipse.jdt", "ecj", "3.12.3"));
        this.containerDependencies.put("tomcat8x", tomcat8xDependencies);
        ArrayList<Dependency> tomcat9xDependencies = new ArrayList<Dependency>();
        tomcat9xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-jaspic-api", "9.0.108"));
        tomcat9xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-servlet-api", "9.0.108"));
        tomcat9xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-annotations-api", "9.0.108"));
        tomcat9xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-dbcp", "9.0.108"));
        tomcat9xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-el-api", "9.0.108"));
        tomcat9xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-jsp-api", "9.0.108"));
        tomcat9xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-juli", "9.0.108"));
        tomcat9xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-api", "9.0.108"));
        tomcat9xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-jni", "9.0.108"));
        tomcat9xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-util", "9.0.108"));
        tomcat9xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-util-scan", "9.0.108"));
        tomcat9xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-catalina", "9.0.108"));
        tomcat9xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-coyote", "9.0.108"));
        tomcat9xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-websocket-api", "9.0.108"));
        tomcat9xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-websocket", "9.0.108"));
        tomcat9xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-jasper", "9.0.108"));
        tomcat9xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-jasper-el", "9.0.108"));
        tomcat9xDependencies.add(new Dependency("org.eclipse.jdt", "ecj", "3.26.0"));
        this.containerDependencies.put("tomcat9x", tomcat9xDependencies);
        ArrayList<Dependency> tomcat10xDependencies = new ArrayList<Dependency>();
        tomcat10xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-jaspic-api", "10.1.43"));
        tomcat10xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-servlet-api", "10.1.43"));
        tomcat10xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-annotations-api", "10.1.43"));
        tomcat10xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-dbcp", "10.1.43"));
        tomcat10xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-el-api", "10.1.43"));
        tomcat10xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-jsp-api", "10.1.43"));
        tomcat10xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-juli", "10.1.43"));
        tomcat10xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-api", "10.1.43"));
        tomcat10xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-jni", "10.1.43"));
        tomcat10xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-util", "10.1.43"));
        tomcat10xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-util-scan", "10.1.43"));
        tomcat10xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-catalina", "10.1.43"));
        tomcat10xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-coyote", "10.1.43"));
        tomcat10xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-websocket-api", "10.1.43"));
        tomcat10xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-websocket-client-api", "10.1.43"));
        tomcat10xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-websocket", "10.1.43"));
        tomcat10xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-jasper", "10.1.43"));
        tomcat10xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-jasper-el", "10.1.43"));
        tomcat10xDependencies.add(new Dependency("org.eclipse.jdt", "ecj", "3.33.0"));
        this.containerDependencies.put("tomcat10x", tomcat10xDependencies);
        ArrayList<Dependency> tomcat11xDependencies = new ArrayList<Dependency>();
        tomcat11xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-jaspic-api", "11.0.10"));
        tomcat11xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-servlet-api", "11.0.10"));
        tomcat11xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-annotations-api", "11.0.10"));
        tomcat11xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-dbcp", "11.0.10"));
        tomcat11xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-el-api", "11.0.10"));
        tomcat11xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-jsp-api", "11.0.10"));
        tomcat11xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-juli", "11.0.10"));
        tomcat11xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-api", "11.0.10"));
        tomcat11xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-jni", "11.0.10"));
        tomcat11xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-util", "11.0.10"));
        tomcat11xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-util-scan", "11.0.10"));
        tomcat11xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-catalina", "11.0.10"));
        tomcat11xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-coyote", "11.0.10"));
        tomcat11xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-websocket-api", "11.0.10"));
        tomcat11xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-websocket-client-api", "11.0.10"));
        tomcat11xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-websocket", "11.0.10"));
        tomcat11xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-jasper", "11.0.10"));
        tomcat11xDependencies.add(new Dependency("org.apache.tomcat", "tomcat-jasper-el", "11.0.10"));
        tomcat11xDependencies.add(new Dependency("org.eclipse.jdt", "ecj", "3.42.0"));
        this.containerDependencies.put("tomcat11x", tomcat11xDependencies);
    }

    public ClassLoader resolveDependencies(String containerId, Configuration configuration, ClassLoader parent) throws MojoExecutionException {
        URLClassLoader classloader;
        List<Dependency> dependencies = this.containerDependencies.get(containerId);
        if (dependencies == null) {
            return null;
        }
        if ("jetty12x".equals(containerId)) {
            String eeVersion;
            try {
                Class<?> jettyPropertySet = ResourceUtils.getResourceLoader().loadClass("org.codehaus.cargo.container.jetty.JettyPropertySet");
                Field jettyDeployerEeVersion = jettyPropertySet.getDeclaredField("DEPLOYER_EE_VERSION");
                eeVersion = configuration.getPropertyValue((String)jettyDeployerEeVersion.get(null));
            }
            catch (Exception e) {
                throw new MojoExecutionException("Cannot load Jetty container properties", e);
            }
            List<Dependency> eeDependencies = this.containerDependencies.get(containerId + "_" + eeVersion);
            if (eeDependencies == null) {
                throw new MojoExecutionException("No Jetty 12.x EE version found for: " + eeVersion);
            }
            dependencies = new ArrayList<Dependency>(dependencies);
            dependencies.addAll((Collection<Dependency>)eeDependencies);
        }
        try {
            ArrayList<URL> urls = new ArrayList<URL>(dependencies.size() + 1);
            for (Dependency dependency : dependencies) {
                DefaultArtifactCoordinate coordinate = new DefaultArtifactCoordinate();
                coordinate.setGroupId(dependency.groupId);
                coordinate.setArtifactId(dependency.artifactId);
                coordinate.setVersion(dependency.version);
                if (dependency.classifier != null) {
                    coordinate.setClassifier(dependency.classifier);
                }
                coordinate.setExtension("jar");
                Artifact artifact = this.artifactResolver.resolveArtifact(this.projectBuildingRequest, (ArtifactCoordinate)coordinate).getArtifact();
                urls.add(artifact.getFile().toURI().toURL());
            }
            if (!JdkUtils.isOSX() && JdkUtils.getMajorJavaVersion() < 9) {
                urls.add(JdkUtils.getToolsJar().toURI().toURL());
            }
            URL[] urlArray = urls.toArray(new URL[urls.size()]);
            classloader = parent == null ? new URLClassLoader(urlArray) : new URLClassLoader(urlArray, parent);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to resolve dependency", e);
        }
        return classloader;
    }

    private class Dependency {
        public String groupId;
        public String artifactId;
        public String version;
        public String classifier;

        public Dependency(String groupId, String artifactId, String version) {
            this(groupId, artifactId, null, version);
        }

        public Dependency(String groupId, String artifactId, String classifier, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.classifier = classifier;
        }
    }
}

