/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.services;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.common.ChoiceType;
import org.chorem.pollen.common.PollType;
import org.chorem.pollen.common.VoteCountingType;
import org.chorem.pollen.votecounting.dto.ChoiceDTO;
import org.chorem.pollen.votecounting.dto.CommentDTO;
import org.chorem.pollen.votecounting.dto.PollChoiceDTO;
import org.chorem.pollen.votecounting.dto.PollDTO;
import org.chorem.pollen.votecounting.dto.PollExportDTO;
import org.chorem.pollen.votecounting.dto.VoteCountingResultDTO;
import org.chorem.pollen.votecounting.dto.VoteToChoiceDTO;
import org.chorem.pollen.votecounting.dto.VotingGroupDTO;
import org.chorem.pollen.votecounting.dto.VotingPersonDTO;
import org.chorem.pollen.votecounting.services.ServiceExport;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class ServiceExportImpl
implements ServiceExport {
    private PollDTO poll;
    private List<VoteCountingResultDTO> voteCountingResults;
    private static Element racine;
    private static Document document;
    private static final Log log;

    @Override
    public String executeExport(PollExportDTO pollExport) {
        this.poll = pollExport.getPoll();
        this.voteCountingResults = pollExport.getVoteCountingResults();
        String filePath = "export/" + this.poll.getPollId() + ".xml";
        this.savePoll(filePath);
        return filePath;
    }

    @Override
    public File executeFileExport(PollExportDTO pollExport) {
        String filePath = this.executeExport(pollExport);
        return new File(filePath);
    }

    @Override
    public PollExportDTO executeImport(String filePath) {
        SAXBuilder sxb = new SAXBuilder();
        try {
            document = sxb.build(new File(filePath));
        }
        catch (Exception e) {
            log.error((Object)("Erreur lors de l'analyse du document : " + filePath), (Throwable)e);
        }
        racine = document.getRootElement();
        if (racine == null && log.isErrorEnabled()) {
            log.error((Object)"racine null");
        }
        return this.loadPoll();
    }

    private void savePoll(String filePath) {
        racine = new Element("pollExport");
        document = new Document(racine);
        Element pollElm = new Element("poll");
        pollElm.setAttribute("pollId", this.poll.getPollId());
        pollElm.setAttribute("pollType", this.poll.getPollType().name());
        pollElm.setAttribute("choiceType", this.poll.getChoiceType().name());
        pollElm.setAttribute("voteCounting", this.poll.getVoteCounting().name());
        pollElm.setAttribute("closed", this.poll.isClosed() ? "true" : "false");
        pollElm.setAttribute("choiceAddAllowed", this.poll.isChoiceAddAllowed() ? "true" : "false");
        pollElm.setAttribute("anonymousVoteAllowed", this.poll.isAnonymousVoteAllowed() ? "true" : "false");
        pollElm.setAttribute("anonymous", this.poll.isAnonymous() ? "true" : "false");
        pollElm.setAttribute("publicResults", this.poll.isPublicResults() ? "true" : "false");
        pollElm.setAttribute("continuousResults", this.poll.isContinuousResults() ? "true" : "false");
        Element titleElm = new Element("title");
        titleElm.setText(this.poll.getTitle());
        pollElm.addContent((Content)titleElm);
        Element descriptionElm = new Element("description");
        descriptionElm.setText(this.poll.getDescription());
        pollElm.addContent((Content)descriptionElm);
        Element creatorIdElm = new Element("creatorId");
        creatorIdElm.setText(this.poll.getCreatorId());
        pollElm.addContent((Content)creatorIdElm);
        Element creatorEmailElm = new Element("creatorEmail");
        creatorEmailElm.setText(this.poll.getCreatorEmail());
        pollElm.addContent((Content)creatorEmailElm);
        Element maxChoiceNbElm = new Element("maxChoiceNb");
        maxChoiceNbElm.setText(Integer.toString(this.poll.getMaxChoiceNb()));
        pollElm.addContent((Content)maxChoiceNbElm);
        Element commentsElm = new Element("comments");
        ListIterator<CommentDTO> iteratorComment = this.poll.getComments().listIterator();
        while (iteratorComment.hasNext()) {
            Element commentElm = this.save((CommentDTO)iteratorComment.next());
            commentsElm.addContent((Content)commentElm);
        }
        pollElm.addContent((Content)commentsElm);
        Element groupsElm = new Element("groups");
        ListIterator<VotingGroupDTO> iteratorGroup = this.poll.getVotingGroups().listIterator();
        while (iteratorGroup.hasNext()) {
            Element groupElm = this.save((VotingGroupDTO)iteratorGroup.next());
            groupsElm.addContent((Content)groupElm);
        }
        pollElm.addContent((Content)groupsElm);
        Element pollChoicesElm = new Element("pollChoices");
        ListIterator<PollChoiceDTO> itPollChoices = this.poll.getChoices().listIterator();
        while (itPollChoices.hasNext()) {
            Element pollChoiceElm = this.save((PollChoiceDTO)itPollChoices.next());
            pollChoicesElm.addContent((Content)pollChoiceElm);
        }
        pollElm.addContent((Content)pollChoicesElm);
        Element voteCountingResultsElm = new Element("voteCountingResults");
        ListIterator<VoteCountingResultDTO> iteratorvoteCountingResults = this.voteCountingResults.listIterator();
        while (iteratorvoteCountingResults.hasNext()) {
            Element voteCountingResult = this.save((VoteCountingResultDTO)iteratorvoteCountingResults.next());
            voteCountingResultsElm.addContent((Content)voteCountingResult);
        }
        racine.addContent((Content)pollElm);
        racine.addContent((Content)voteCountingResultsElm);
        if (log.isDebugEnabled()) {
            log.debug((Object)this.displayDom());
        }
        this.saveDom(filePath);
    }

    private Element save(CommentDTO comment) {
        Element commentElm = new Element("comment");
        commentElm.setAttribute("votingId", comment.getVotingID());
        commentElm.setText(comment.getText());
        return commentElm;
    }

    private Element save(VotingGroupDTO group) {
        Element groupElm = new Element("group");
        groupElm.setAttribute("idGroup", group.getIdGroup());
        groupElm.setAttribute("name", group.getName());
        groupElm.setAttribute("weight", Double.toString(group.getWeight()));
        Element votingPersonsElm = new Element("votingPersons");
        ListIterator<VotingPersonDTO> iteratorVotingPersons = group.getVotingPersons().listIterator();
        while (iteratorVotingPersons.hasNext()) {
            Element votingPersonElm = this.save((VotingPersonDTO)iteratorVotingPersons.next());
            votingPersonsElm.addContent((Content)votingPersonElm);
        }
        groupElm.addContent((Content)votingPersonsElm);
        return groupElm;
    }

    private Element save(VotingPersonDTO votingPerson) {
        Element votingPersonElm = new Element("votingPerson");
        votingPersonElm.setAttribute("votingId", votingPerson.getVotingId());
        votingPersonElm.setAttribute("weight", Double.toString(votingPerson.getWeight()));
        Element emailElm = new Element("email");
        emailElm.setText(votingPerson.getEmail());
        votingPersonElm.addContent((Content)emailElm);
        Element commentElm = new Element("comment");
        commentElm.setText(votingPerson.getComment());
        votingPersonElm.addContent((Content)commentElm);
        Element choicesElm = new Element("choices");
        ListIterator<VoteToChoiceDTO> iteratorChoices = votingPerson.getChoices().listIterator();
        while (iteratorChoices.hasNext()) {
            VoteToChoiceDTO voteToChoice = (VoteToChoiceDTO)iteratorChoices.next();
            Element choiceElm = new Element("choice");
            choiceElm.setAttribute("idChoice", voteToChoice.getIdChoice());
            choiceElm.setAttribute("value", Double.toString(voteToChoice.getValue()));
            choicesElm.addContent((Content)choiceElm);
        }
        votingPersonElm.addContent((Content)choicesElm);
        return votingPersonElm;
    }

    private Element save(PollChoiceDTO pollChoice) {
        Element pollChoiceElm = new Element("pollChoice");
        pollChoiceElm.setAttribute("idChoice", pollChoice.getIdChoice());
        Element nameElm = new Element("name");
        nameElm.setText(pollChoice.getName());
        pollChoiceElm.addContent((Content)nameElm);
        Element descriptionElm = new Element("description");
        descriptionElm.setText(pollChoice.getDescription());
        pollChoiceElm.addContent((Content)descriptionElm);
        return pollChoiceElm;
    }

    private Element save(VoteCountingResultDTO voteCountingResults) {
        Element voteCountingResultElm = new Element("voteCountingResult");
        voteCountingResultElm.setAttribute("idPoll", voteCountingResults.getIdPoll());
        Element nbVotesElm = new Element("nbVotes");
        nbVotesElm.setText(Integer.toString(voteCountingResults.getNbVotes()));
        voteCountingResultElm.addContent((Content)nbVotesElm);
        Element choiceResultElm = new Element("choiceResult");
        choiceResultElm.setText(voteCountingResults.getChoiceResult());
        voteCountingResultElm.addContent((Content)choiceResultElm);
        Element isByGroupElm = new Element("isByGroup");
        isByGroupElm.setText(Boolean.toString(voteCountingResults.isByGroup()));
        voteCountingResultElm.addContent((Content)isByGroupElm);
        Element choicesElm = new Element("choices");
        ListIterator<ChoiceDTO> iteratorChoices = voteCountingResults.getChoices().listIterator();
        while (iteratorChoices.hasNext()) {
            Element choiceElm = this.save((ChoiceDTO)iteratorChoices.next());
            choicesElm.addContent((Content)choiceElm);
        }
        voteCountingResultElm.addContent((Content)choicesElm);
        return voteCountingResultElm;
    }

    private Element save(ChoiceDTO choice) {
        Element choiceElm = new Element("choice");
        choiceElm.setAttribute("idChoice", choice.getIdChoice());
        choiceElm.setAttribute("value", Double.toString(choice.getValue()));
        Element percentageElm = new Element("percentage");
        percentageElm.setText(Double.toString(choice.getPercentage()));
        choiceElm.addContent((Content)percentageElm);
        Element nbVotesElm = new Element("nbVotes");
        nbVotesElm.setText(Integer.toString(choice.getNbVotes()));
        choiceElm.addContent((Content)nbVotesElm);
        return choiceElm;
    }

    private String displayDom() {
        XMLOutputter sortie = new XMLOutputter(Format.getPrettyFormat());
        return sortie.outputString(document);
    }

    private void saveDom(String filePath) {
        try {
            File file = new File(filePath);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            XMLOutputter sortie = new XMLOutputter(Format.getPrettyFormat());
            sortie.output(document, (OutputStream)new FileOutputStream(file));
        }
        catch (IOException e) {
            log.error((Object)("Erreur lors de l'enregistrement du document : " + filePath), (Throwable)e);
        }
    }

    private PollExportDTO loadPoll() {
        Element pollElm = racine.getChild("poll");
        PollDTO poll = new PollDTO(pollElm.getAttributeValue("pollId"));
        poll.setTitle(pollElm.getChild("title").getText());
        poll.setDescription(pollElm.getChild("description").getText());
        poll.setCreatorId(pollElm.getChild("creatorId").getText());
        poll.setCreatorEmail(pollElm.getChild("creatorEmail").getText());
        poll.setMaxChoiceNb(Integer.parseInt(pollElm.getChild("maxChoiceNb").getText()));
        poll.setPollType(PollType.valueOf(pollElm.getAttributeValue("pollType")));
        poll.setChoiceType(ChoiceType.valueOf(pollElm.getAttributeValue("choiceType")));
        poll.setVoteCounting(VoteCountingType.valueOf(pollElm.getAttributeValue("voteCounting")));
        poll.setClosed(Boolean.valueOf(pollElm.getAttributeValue("closed")));
        poll.setChoiceAddAllowed(Boolean.valueOf(pollElm.getAttributeValue("choiceAddAllowed")));
        poll.setAnonymousVoteAllowed(Boolean.valueOf(pollElm.getAttributeValue("anonymousVoteAllowed")));
        poll.setAnonymous(Boolean.valueOf(pollElm.getAttributeValue("anonymous")));
        poll.setPublicResults(Boolean.valueOf(pollElm.getAttributeValue("publicResults")));
        poll.setContinuousResults(Boolean.valueOf(pollElm.getAttributeValue("continuousResults")));
        Element commentsElm = pollElm.getChild("comments");
        List listComments = commentsElm.getChildren("comment");
        List vectorComments = this.loadComments(listComments);
        poll.setComments(vectorComments);
        Element groupsElm = pollElm.getChild("groups");
        List listGroups = groupsElm.getChildren("group");
        List vectorGroups = this.loadGroups(listGroups);
        poll.setVotingGroups(vectorGroups);
        Element pollChoicesElm = pollElm.getChild("pollChoices");
        List listPollChoices = pollChoicesElm.getChildren("pollChoice");
        List vectorPollChoices = this.loadPollChoices(listPollChoices);
        poll.setChoices(vectorPollChoices);
        Element voteCountingResultsElm = racine.getChild("voteCountingResults");
        List listVoteCountingResults = voteCountingResultsElm.getChildren("voteCountingResult");
        List vectorVoteCountingResults = this.loadVoteCountingResults(listVoteCountingResults);
        PollExportDTO pollExport = new PollExportDTO();
        pollExport.setPollId(poll.getPollId());
        pollExport.setPoll(poll);
        pollExport.setVoteCountingResults(vectorVoteCountingResults);
        return pollExport;
    }

    private List loadComments(List<Element> listComments) {
        ArrayList<CommentDTO> vectorComments = new ArrayList<CommentDTO>();
        ListIterator<Element> i = listComments.listIterator();
        while (i.hasNext()) {
            Element commentElm = (Element)i.next();
            CommentDTO comment = new CommentDTO(commentElm.getAttributeValue("votingId"), commentElm.getText());
            vectorComments.add(comment);
        }
        return vectorComments;
    }

    private List loadGroups(List<Element> listGroups) {
        ArrayList<VotingGroupDTO> vectorGroups = new ArrayList<VotingGroupDTO>();
        ListIterator<Element> i = listGroups.listIterator();
        while (i.hasNext()) {
            Element groupElm = (Element)i.next();
            VotingGroupDTO group = new VotingGroupDTO(groupElm.getAttributeValue("idGroup"), Double.parseDouble(groupElm.getAttributeValue("weight")));
            group.setName(groupElm.getAttributeValue("name"));
            Element votingPersonsElm = groupElm.getChild("votingPersons");
            List listVotingPersons = votingPersonsElm.getChildren("votingPerson");
            List vectorVotingPersons = this.loadVotingPersons(listVotingPersons);
            group.setVotingPersons(vectorVotingPersons);
            vectorGroups.add(group);
        }
        return vectorGroups;
    }

    private List loadVotingPersons(List<Element> listVotingPersons) {
        ArrayList<VotingPersonDTO> vectorVotingPersons = new ArrayList<VotingPersonDTO>();
        ListIterator<Element> i = listVotingPersons.listIterator();
        while (i.hasNext()) {
            Element votingPersonElm = (Element)i.next();
            VotingPersonDTO votingPerson = new VotingPersonDTO(votingPersonElm.getAttributeValue("votingId"), Double.parseDouble(votingPersonElm.getAttributeValue("weight")));
            votingPerson.setEmail(votingPersonElm.getChild("email").getValue());
            votingPerson.setComment(votingPersonElm.getChild("comment").getValue());
            Element choicesElm = votingPersonElm.getChild("choices");
            List listVoteToChoices = choicesElm.getChildren("choice");
            List vectorVoteToChoices = this.loadVoteToChoices(listVoteToChoices);
            votingPerson.setChoices(vectorVoteToChoices);
            vectorVotingPersons.add(votingPerson);
        }
        return vectorVotingPersons;
    }

    private List loadVoteToChoices(List<Element> listVoteToChoices) {
        ArrayList<VoteToChoiceDTO> vectorVoteToChoices = new ArrayList<VoteToChoiceDTO>();
        ListIterator<Element> i = listVoteToChoices.listIterator();
        while (i.hasNext()) {
            Element voteToChoiceElm = (Element)i.next();
            VoteToChoiceDTO voteToChoice = new VoteToChoiceDTO(voteToChoiceElm.getAttributeValue("idChoice"), Double.parseDouble(voteToChoiceElm.getAttributeValue("value")));
            vectorVoteToChoices.add(voteToChoice);
        }
        return vectorVoteToChoices;
    }

    private List loadPollChoices(List<Element> listPollChoices) {
        ArrayList<PollChoiceDTO> vectorPollChoices = new ArrayList<PollChoiceDTO>();
        ListIterator<Element> i = listPollChoices.listIterator();
        while (i.hasNext()) {
            Element pollChoiceElm = (Element)i.next();
            PollChoiceDTO pollChoice = new PollChoiceDTO(pollChoiceElm.getAttributeValue("idChoice"));
            pollChoice.setName(pollChoiceElm.getChild("name").getValue());
            pollChoice.setDescription(pollChoiceElm.getChild("description").getValue());
            vectorPollChoices.add(pollChoice);
        }
        return vectorPollChoices;
    }

    private List loadVoteCountingResults(List<Element> listVoteCountingResults) {
        ArrayList<VoteCountingResultDTO> vectorVoteCountingResults = new ArrayList<VoteCountingResultDTO>();
        ListIterator<Element> i = listVoteCountingResults.listIterator();
        while (i.hasNext()) {
            Element voteCountingResultElm = (Element)i.next();
            VoteCountingResultDTO voteCountingResult = new VoteCountingResultDTO();
            voteCountingResult.setIdPoll(voteCountingResultElm.getAttributeValue("idPoll"));
            voteCountingResult.setNbVotes(Integer.parseInt(voteCountingResultElm.getChild("nbVotes").getValue()));
            voteCountingResult.setChoiceResult(voteCountingResultElm.getChild("choiceResult").getValue());
            voteCountingResult.setByGroup(Boolean.parseBoolean(voteCountingResultElm.getChild("isByGroup").getValue()));
            Element choicesElm = voteCountingResultElm.getChild("choices");
            List listChoices = choicesElm.getChildren("choice");
            List vectorChoices = this.loadChoices(listChoices);
            voteCountingResult.setChoices(vectorChoices);
            vectorVoteCountingResults.add(voteCountingResult);
        }
        return vectorVoteCountingResults;
    }

    private List loadChoices(List<Element> listChoices) {
        ArrayList<ChoiceDTO> vectorChoices = new ArrayList<ChoiceDTO>();
        ListIterator<Element> i = listChoices.listIterator();
        while (i.hasNext()) {
            Element choiceElm = (Element)i.next();
            ChoiceDTO choice = new ChoiceDTO(choiceElm.getAttribute("idChoice").getName(), Double.parseDouble(choiceElm.getAttribute("value").getValue()), Double.parseDouble(choiceElm.getChild("percentage").getValue()), Integer.parseInt(choiceElm.getChild("nbVotes").getValue()));
            vectorChoices.add(choice);
        }
        return vectorChoices;
    }

    static {
        log = LogFactory.getLog(ServiceExportImpl.class);
    }
}

