/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.business;

import java.util.List;
import org.chorem.pollen.votecounting.business.Choice;
import org.chorem.pollen.votecounting.business.Group;
import org.chorem.pollen.votecounting.business.Method;
import org.chorem.pollen.votecounting.business.Vote;
import org.chorem.pollen.votecounting.dto.ChoiceDTO;

public class NumberMethod
implements Method {
    @Override
    public void executeCounting(List<Choice> choices, boolean byGroup) {
        for (Choice choice : choices) {
            double totalChoice = 0.0;
            for (Group group : choice.getGroups()) {
                double totalGroup = 0.0;
                for (Vote vote : group.getVotes()) {
                    double value = vote.getValue();
                    if (!(value >= 0.0)) continue;
                    if (byGroup) {
                        totalGroup += vote.getValue() * vote.getWeight() * group.getWeight();
                        continue;
                    }
                    totalGroup += vote.getValue() * vote.getWeight();
                }
                group.setValue(totalGroup);
                totalChoice += totalGroup;
            }
            choice.setValue(totalChoice);
        }
    }

    @Override
    public void executeStats(List<Choice> choices, boolean groupCounting, Choice choice, ChoiceDTO choiceDTO) {
        int nbBlankVotes = 0;
        double average = 0.0;
        int nbVotes = 0;
        for (Group group : choice.getGroups()) {
            for (Vote vote : group.getVotes()) {
                ++nbVotes;
                if (!(vote.getValue() < 0.0)) continue;
                ++nbBlankVotes;
            }
        }
        if (nbVotes - nbBlankVotes > 0) {
            average = choice.value() / (double)(nbVotes - nbBlankVotes);
        }
        choiceDTO.setAverage(average);
        choiceDTO.setNbBlankVotes(nbBlankVotes);
    }
}

