/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services;

public enum UnitHuman {
    UNIT("", 0),
    KILO("k", 3),
    MEGA("M", 6),
    GIGA("G", 9),
    TERA("T", 12),
    PETA("P", 15),
    EXA("E", 18),
    ZETTA("Z", 21),
    YOTTA("Y", 24);

    private final String prefix;
    private final int decimalPower;

    private UnitHuman(String prefix, int decimalPower) {
        this.prefix = prefix;
        this.decimalPower = decimalPower;
    }

    public static UnitHuman getUnitHuman(double value) {
        int ordinal = (int)Math.floor(Math.log10(value) / 3.0);
        ordinal = Math.max(Math.min(ordinal, UnitHuman.values().length - 1), 0);
        return UnitHuman.values()[ordinal];
    }

    public double getUnitValue(double value) {
        return value / Math.pow(10.0, this.decimalPower);
    }

    public String getUnit(String unit) {
        return this.prefix + unit;
    }

    public static String toHumanString(double value, String unit) {
        UnitHuman unitHuman = UnitHuman.getUnitHuman(value);
        return String.format("%4.2f %s", unitHuman.getUnitValue(value), unitHuman.getUnit(unit));
    }
}

