/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.service;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.persistence.PollenEntity;
import org.chorem.pollen.persistence.entity.Choice;
import org.chorem.pollen.persistence.entity.Comment;
import org.chorem.pollen.persistence.entity.FavoriteList;
import org.chorem.pollen.persistence.entity.Poll;
import org.chorem.pollen.persistence.entity.PollenPrincipal;
import org.chorem.pollen.persistence.entity.PollenUser;
import org.chorem.pollen.persistence.entity.PollenUserEmailAddress;
import org.chorem.pollen.persistence.entity.Question;
import org.chorem.pollen.persistence.entity.Report;
import org.chorem.pollen.persistence.entity.UserCredential;
import org.chorem.pollen.persistence.entity.Vote;
import org.chorem.pollen.persistence.entity.VoterListMember;
import org.chorem.pollen.services.service.PollenServiceSupport;
import org.chorem.pollen.services.service.mail.ChoiceAddedEmail;
import org.chorem.pollen.services.service.mail.ChoiceReportEmail;
import org.chorem.pollen.services.service.mail.ChoiceReportForAdminEmail;
import org.chorem.pollen.services.service.mail.CommentAddedEmail;
import org.chorem.pollen.services.service.mail.CommentDeletedEmail;
import org.chorem.pollen.services.service.mail.CommentEditedEmail;
import org.chorem.pollen.services.service.mail.CommentReportEmail;
import org.chorem.pollen.services.service.mail.CommentReportForAdminEmail;
import org.chorem.pollen.services.service.mail.EmailService;
import org.chorem.pollen.services.service.mail.ExceedingMaxVotersEmail;
import org.chorem.pollen.services.service.mail.LostPasswordEmail;
import org.chorem.pollen.services.service.mail.PollClosedEmail;
import org.chorem.pollen.services.service.mail.PollCreatedEmail;
import org.chorem.pollen.services.service.mail.PollEndReminderEmail;
import org.chorem.pollen.services.service.mail.PollReportEmail;
import org.chorem.pollen.services.service.mail.PollReportForAdminEmail;
import org.chorem.pollen.services.service.mail.ResendValidationEmail;
import org.chorem.pollen.services.service.mail.RestrictedPollInvitationEmail;
import org.chorem.pollen.services.service.mail.UserAccountCreatedEmail;
import org.chorem.pollen.services.service.mail.UserAccountCreatedFromProviderEmail;
import org.chorem.pollen.services.service.mail.UserAccountDeletedEmail;
import org.chorem.pollen.services.service.mail.UserAccountEditedEmail;
import org.chorem.pollen.services.service.mail.UserAccountEmailAddressAddedEmail;
import org.chorem.pollen.services.service.mail.UserAccountEmailValidatedEmail;
import org.chorem.pollen.services.service.mail.UserAccountPasswordChangedEmail;
import org.chorem.pollen.services.service.mail.VoteAddedEmail;
import org.chorem.pollen.services.service.mail.VoteDeletedEmail;
import org.chorem.pollen.services.service.mail.VoteEditedEmail;

public class NotificationService
extends PollenServiceSupport {
    public void onUserCreated(PollenUser user, String token) {
        if (user.getDefaultEmailAddress() != null) {
            EmailService emailService = this.getEmailService();
            UserAccountCreatedEmail email = emailService.newUserAccountCreatedEmail(user, token);
            email.addTo(user.getDefaultEmailAddress().getEmailAddress());
            emailService.send(email);
            this.commit();
        }
    }

    public void onUserCreatedFromProvider(PollenUser user, UserCredential credential) {
        if (user.getDefaultEmailAddress() != null) {
            EmailService emailService = this.getEmailService();
            UserAccountCreatedFromProviderEmail email = emailService.newUserAccountCreatedFromProviderEmail(user, credential);
            email.addTo(user.getDefaultEmailAddress().getEmailAddress());
            emailService.send(email);
            this.commit();
        }
    }

    public void onResendValidation(PollenUser user, PollenUserEmailAddress emailAddress, String token) {
        EmailService emailService = this.getEmailService();
        ResendValidationEmail email = emailService.newUserResendValidationEmail(user, token);
        email.addTo(emailAddress.getEmailAddress());
        emailService.send(email);
        this.commit();
    }

    public void onUserEdited(PollenUser user) {
        if (user.getDefaultEmailAddress() != null) {
            EmailService emailService = this.getEmailService();
            UserAccountEditedEmail email = emailService.newUserAccountEditedEmail(user);
            email.addTo(user.getDefaultEmailAddress().getEmailAddress());
            emailService.send(email);
            this.commit();
        }
    }

    public void onUserDeleted(PollenUser user) {
        if (user.getDefaultEmailAddress() != null) {
            EmailService emailService = this.getEmailService();
            UserAccountDeletedEmail email = emailService.newUserAccountDeletedEmail(user);
            email.addTo(user.getDefaultEmailAddress().getEmailAddress());
            emailService.send(email);
            this.commit();
        }
    }

    public void onUserPasswordChanged(PollenUser user) {
        if (user.getDefaultEmailAddress() != null) {
            EmailService emailService = this.getEmailService();
            UserAccountPasswordChangedEmail email = emailService.newUserAccountPasswordChangedEmail(user);
            email.addTo(user.getDefaultEmailAddress().getEmailAddress());
            emailService.send(email);
            this.commit();
        }
    }

    public void onUserEmailAddressAdded(PollenUser user, PollenUserEmailAddress emailAddress, String token) {
        EmailService emailService = this.getEmailService();
        UserAccountEmailAddressAddedEmail email = emailService.newUserAccountEmailAddressAddedEmail(user, token);
        email.addTo(emailAddress.getEmailAddress());
        emailService.send(email);
        this.commit();
    }

    public void onUserEmailValidated(PollenUser user, PollenUserEmailAddress emailAddress) {
        EmailService emailService = this.getEmailService();
        UserAccountEmailValidatedEmail email = emailService.newUserAccountEmailValidatedEmail(user);
        email.addTo(emailAddress.getEmailAddress());
        emailService.send(email);
        this.commit();
    }

    public void onUserLostPasswordAsked(PollenUser user, String newPassword) {
        if (user.getDefaultEmailAddress() != null) {
            EmailService emailService = this.getEmailService();
            String emailAddress = user.getDefaultEmailAddress().getEmailAddress();
            LostPasswordEmail email = emailService.newLostPasswordEmail(user, newPassword, emailAddress);
            email.addTo(emailAddress);
            emailService.send(email);
            this.commit();
        }
    }

    public void onFavoriteListAdded(PollenUser user, FavoriteList favoriteList) {
    }

    public void onFavoriteListEdited(PollenUser user, FavoriteList favoriteList) {
    }

    public void onFavoriteListDeleted(PollenUser user, FavoriteList favoriteList) {
    }

    public void onPollCreated(Poll poll) {
        EmailService emailService = this.getEmailService();
        if (StringUtils.isNotBlank((CharSequence)poll.getCreator().getEmail())) {
            PollCreatedEmail email = emailService.newPollCreatedEmail(poll);
            email.addTo(poll.getCreator().getEmail());
            emailService.send(email);
        }
        this.commit();
    }

    public void onPollEdited(Poll poll) {
    }

    public void onPollDeleted(Poll poll) {
    }

    public void onPollClosed(Poll poll) {
        EmailService emailService = this.getEmailService();
        PollClosedEmail email = emailService.newPollClosedEmail(poll);
        emailService.send(email);
        this.commit();
    }

    public void onPollReopened(Poll poll) {
    }

    public void onChoiceAdded(Question question, Choice choice) {
        if (question.getPoll().isNewChoiceNotification()) {
            EmailService emailService = this.getEmailService();
            ChoiceAddedEmail email = emailService.newChoiceAddedEmail(question, choice);
            email.addTo(question.getPoll().getCreator().getEmail());
            emailService.send(email);
            this.commit();
        }
    }

    public void onChoiceEdited(Question question, Choice choice) {
    }

    public void onChoiceDeleted(Question question, Choice choice) {
    }

    public void onCommentAdded(Poll poll, Comment comment) {
        if (poll.isCommentNotification()) {
            EmailService emailService = this.getEmailService();
            CommentAddedEmail email = emailService.newCommentAddedEmail(poll, comment);
            email.addTo(poll.getCreator().getEmail());
            emailService.send(email);
            this.commit();
        }
    }

    public void onCommentEdited(Poll poll, Comment comment) {
        if (poll.isCommentNotification()) {
            EmailService emailService = this.getEmailService();
            CommentEditedEmail email = emailService.newCommentEditedEmail(poll, comment);
            email.addTo(poll.getCreator().getEmail());
            emailService.send(email);
            this.commit();
        }
    }

    public void onCommentDeleted(Poll poll, Comment comment) {
        if (poll.isCommentNotification()) {
            EmailService emailService = this.getEmailService();
            CommentDeletedEmail email = emailService.newCommentDeletedEmail(poll, comment);
            email.addTo(poll.getCreator().getEmail());
            emailService.send(email);
            this.commit();
        }
    }

    public void onCommentAdded(Question question, Comment comment) {
        if (question.getPoll().isCommentNotification()) {
            EmailService emailService = this.getEmailService();
            CommentAddedEmail email = emailService.newCommentAddedEmail(question, comment);
            email.addTo(question.getPoll().getCreator().getEmail());
            emailService.send(email);
            this.commit();
        }
    }

    public void onCommentEdited(Question question, Comment comment) {
        if (question.getPoll().isCommentNotification()) {
            EmailService emailService = this.getEmailService();
            CommentEditedEmail email = emailService.newCommentEditedEmail(question, comment);
            email.addTo(question.getPoll().getCreator().getEmail());
            emailService.send(email);
            this.commit();
        }
    }

    public void onVoteAdded(Question question, Vote vote) {
        if (question.getPoll().isVoteNotification()) {
            EmailService emailService = this.getEmailService();
            VoteAddedEmail voteAddedEmail = emailService.newVoteAddedEmail(question, vote);
            voteAddedEmail.addTo(question.getPoll().getCreator().getEmail());
            emailService.send(voteAddedEmail);
            this.commit();
        }
    }

    public void onVoteEdited(Question question, Vote vote) {
        if (question.getPoll().isVoteNotification()) {
            EmailService emailService = this.getEmailService();
            VoteEditedEmail voteEditedEmail = emailService.newVoteEditedEmail(question, vote);
            voteEditedEmail.addTo(question.getPoll().getCreator().getEmail());
            emailService.send(voteEditedEmail);
            this.commit();
        }
    }

    public void onVoteDeleted(Question question, Vote vote) {
        if (question.getPoll().isVoteNotification()) {
            EmailService emailService = this.getEmailService();
            VoteDeletedEmail voteDeletedEmail = emailService.newVoteDeletedEmail(question, vote);
            voteDeletedEmail.addTo(question.getPoll().getCreator().getEmail());
            emailService.send(voteDeletedEmail);
            this.commit();
        }
    }

    public void sendInvitation(Poll poll, List<VoterListMember> voterListMembers) {
        EmailService emailService = this.getEmailService();
        voterListMembers.stream().map(VoterListMember::getMember).distinct().forEach(pollenPrincipal -> {
            RestrictedPollInvitationEmail email = emailService.newRestrictedPollInvitationEmail(poll, (PollenPrincipal)pollenPrincipal);
            email.addTo(pollenPrincipal.getEmail());
            emailService.send(email);
        });
        this.commit();
    }

    public void sendPollEndReminder(Poll poll, Locale locale) {
        EmailService emailService = this.getEmailService();
        PollEndReminderEmail pollEndReminderEmail = emailService.newPollEndReminderEmail(poll, locale);
        pollEndReminderEmail.addTo(poll.getCreator().getEmail());
        emailService.send(pollEndReminderEmail);
        this.commit();
    }

    public void onAddCommentReport(Poll poll, Comment comment, Report report) {
        EmailService emailService = this.getEmailService();
        if (StringUtils.isNotBlank((CharSequence)poll.getCreator().getEmail())) {
            CommentReportEmail commentReportEmail = emailService.newCommentReportEmail(poll, comment, report);
            commentReportEmail.addTo(poll.getCreator().getEmail());
            emailService.send(commentReportEmail);
        }
        this.getAdminsToSentReport(poll, (PollenEntity)comment).forEach(admin -> {
            CommentReportForAdminEmail commentReportForAdminEmail = emailService.newCommentReportForAdminEmail(poll, comment, report, (PollenUser)admin);
            commentReportForAdminEmail.addTo(admin.getDefaultEmailAddress().getEmailAddress());
            emailService.send(commentReportForAdminEmail);
        });
        this.commit();
    }

    public void onAddQuestionCommentReport(Question question, Comment comment, Report report) {
        EmailService emailService = this.getEmailService();
        if (StringUtils.isNotBlank((CharSequence)question.getPoll().getCreator().getEmail())) {
            CommentReportEmail commentReportEmail = emailService.newCommentReportEmail(question.getPoll(), comment, report);
            commentReportEmail.addTo(question.getPoll().getCreator().getEmail());
            emailService.send(commentReportEmail);
        }
        this.getAdminsToSentReport(question.getPoll(), (PollenEntity)comment).forEach(admin -> {
            CommentReportForAdminEmail commentReportForAdminEmail = emailService.newCommentReportForAdminEmail(question.getPoll(), comment, report, (PollenUser)admin);
            commentReportForAdminEmail.addTo(admin.getDefaultEmailAddress().getEmailAddress());
            emailService.send(commentReportForAdminEmail);
        });
        this.commit();
    }

    protected List<PollenUser> getAdminsToSentReport(Poll poll, PollenEntity target) {
        long score = this.getReportService().getScore(target);
        List admins = Collections.emptyList();
        if (StringUtils.isBlank((CharSequence)poll.getCreator().getEmail()) || score >= this.getPollenServiceConfig().getReportMaxScore()) {
            admins = this.getPollenUserDao().forAdministratorEquals(true).findAll();
        }
        return admins;
    }

    public void onAddChoiceReport(Question question, Choice choice, Report report) {
        EmailService emailService = this.getEmailService();
        if (StringUtils.isNotBlank((CharSequence)question.getPoll().getCreator().getEmail())) {
            ChoiceReportEmail choiceReportEmail = emailService.newChoiceReportEmail(question.getPoll(), choice, report);
            choiceReportEmail.addTo(question.getPoll().getCreator().getEmail());
            emailService.send(choiceReportEmail);
        }
        this.getAdminsToSentReport(question.getPoll(), (PollenEntity)choice).forEach(admin -> {
            ChoiceReportForAdminEmail choiceReportForAdminEmail = emailService.newChoiceReportForAdminEmail(question.getPoll(), choice, report, (PollenUser)admin);
            choiceReportForAdminEmail.addTo(admin.getDefaultEmailAddress().getEmailAddress());
            emailService.send(choiceReportForAdminEmail);
        });
        this.commit();
    }

    public void onAddPollReport(Poll poll, Report report) {
        EmailService emailService = this.getEmailService();
        if (StringUtils.isNotBlank((CharSequence)poll.getCreator().getEmail())) {
            PollReportEmail pollReportEmail = emailService.newPollReportEmail(poll, report);
            pollReportEmail.addTo(poll.getCreator().getEmail());
            emailService.send(pollReportEmail);
        }
        this.getAdminsToSentReport(poll, (PollenEntity)poll).forEach(admin -> {
            PollReportForAdminEmail pollReportForAdminEmail = emailService.newPollReportForAdminEmail(poll, report, (PollenUser)admin);
            pollReportForAdminEmail.addTo(admin.getDefaultEmailAddress().getEmailAddress());
            emailService.send(pollReportForAdminEmail);
        });
        this.commit();
    }

    public void onAddQuestionReport(Question question, Report report) {
        EmailService emailService = this.getEmailService();
        if (StringUtils.isNotBlank((CharSequence)question.getPoll().getCreator().getEmail())) {
            PollReportEmail pollReportEmail = emailService.newPollReportEmail(question.getPoll(), report);
            pollReportEmail.addTo(question.getPoll().getCreator().getEmail());
            emailService.send(pollReportEmail);
        }
        this.getAdminsToSentReport(question.getPoll(), (PollenEntity)question.getPoll()).forEach(admin -> {
            PollReportForAdminEmail pollReportForAdminEmail = emailService.newPollReportForAdminEmail(question.getPoll(), report, (PollenUser)admin);
            pollReportForAdminEmail.addTo(admin.getDefaultEmailAddress().getEmailAddress());
            emailService.send(pollReportForAdminEmail);
        });
        this.commit();
    }

    public void onExceedingMaxVoters(Poll poll, int maxVoters) {
        EmailService emailService = this.getEmailService();
        ExceedingMaxVotersEmail email = emailService.newExceedingMaxVotersEmail(poll, maxVoters);
        email.addTo(poll.getCreator().getEmail());
        emailService.send(email);
        this.commit();
    }
}

